/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common;

import ai.platon.pulsar.common.DateTimes;
import java.text.ParseException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.YearMonth;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;

public class DateTimeDetector {
    public static final int MIN_DATE_TIME_STR_LENGTH = "2015-01-01 12:00".length();
    public static final int MIN_YEAR_MONTH_STR_LENGTH = "201501".length();
    public static final int MIN_DATE_STR_LENGTH = "20150101".length();
    public static final int MAX_META_STR_LENGTH = 200;
    public static final int MAX_DATE_TIME_STR_LENGTH = "EEE, dd MMM yyyy HH:mm:ss zzz".length();
    public static final int MAX_TITLE_LENGTH = 350;
    public static final String[] BAD_DATE_TIME_STRING_CONTAINS = new String[]{"GMT+8", "UTC+8", "Processed", "\u8bbf\u95ee", "\u5237\u65b0", "visit"};
    public static final int OLD_DATE_DAYS = 30;
    public static final LocalDate CURRENT_DATE = LocalDate.now();
    public static final long CURRENT_DATE_EPOCH_DAYS = CURRENT_DATE.toEpochDay();
    public static final int CURRENT_YEAR = CURRENT_DATE.getYear();
    public static final String CURRENT_YEAR_STR = String.valueOf(CURRENT_YEAR);
    public static final int CURRENT_MONTH = CURRENT_DATE.getMonthValue();
    public static final int YEAR_LOWER_BOUND = 1990;
    public static final List<String> VALID_WORK_YEARS = IntStream.range(2010, 2030).mapToObj(String::valueOf).collect(Collectors.toList());
    public static final List<String> VALID_WORK_YEARS_SHORT = IntStream.range(10, 30).mapToObj(String::valueOf).collect(Collectors.toList());
    public static final String[] VALID_WORK_YEARS_ARRAY = VALID_WORK_YEARS.toArray(new String[0]);
    public static final String[] VALID_WORK_YEARS_SHORT_ARRAY = VALID_WORK_YEARS_SHORT.toArray(new String[0]);
    public static Set<String> OLD_YEARS;
    public static Set<String> OLD_MONTH;
    public static Pattern OLD_MONTH_URL_DATE_PATTERN;
    public static String[] COMMON_DATE_FORMATS;
    public static String[] COMMON_DATE_TIME_FORMATS;
    private final String[] dateFormats;
    private final String[] dateTimeFormats;
    private ZoneId zoneId;

    public DateTimeDetector() {
        this(COMMON_DATE_FORMATS, COMMON_DATE_TIME_FORMATS);
    }

    public DateTimeDetector(ZoneId zoneId) {
        this(COMMON_DATE_FORMATS, COMMON_DATE_TIME_FORMATS, zoneId);
    }

    public DateTimeDetector(String[] dateFormats, String[] dateTimeFormats) {
        this(dateFormats, dateTimeFormats, ZoneId.systemDefault());
    }

    public DateTimeDetector(String[] dateFormats, String[] dateTimeFormats, ZoneId zoneId) {
        this.dateFormats = dateFormats;
        this.dateTimeFormats = dateTimeFormats;
        this.zoneId = zoneId;
        if (CURRENT_YEAR > 2030) {
            System.out.println("This program must be refined after 2030");
            System.exit(2030);
        }
    }

    public ZoneId getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(ZoneId zoneId) {
        this.zoneId = zoneId;
    }

    public String detectPossibleDateTimeString(String text) {
        Object possibleDate = StringUtils.substringBefore((String)text, (String)"\n");
        int dateStart = StringUtils.indexOfAny((CharSequence)possibleDate, (CharSequence[])VALID_WORK_YEARS_ARRAY);
        if (dateStart == -1 && (dateStart = StringUtils.indexOfAny((CharSequence)possibleDate, (CharSequence[])VALID_WORK_YEARS_SHORT_ARRAY)) != -1 && ((String)(possibleDate = "20" + ((String)possibleDate).substring(dateStart))).matches("20[0-9][0-9][\\-\\./\u5e74]?\\d+.+")) {
            dateStart = 0;
        }
        if (dateStart < 0 || dateStart >= ((String)possibleDate).length()) {
            return null;
        }
        int dateEnd = Math.min(((String)possibleDate).length(), dateStart + MAX_DATE_TIME_STR_LENGTH);
        possibleDate = ((String)possibleDate).substring(dateStart, dateEnd);
        possibleDate = ((String)possibleDate).replaceAll("[\\./\u5e74\u6708]", "-").trim();
        return possibleDate;
    }

    public OffsetDateTime detectDateTimeLeniently(String text) {
        OffsetDateTime dateTime = this.detectDateTime(text);
        if (dateTime == null) {
            dateTime = this.detectDate(text);
        }
        return dateTime;
    }

    public OffsetDateTime detectDateTime(String text) {
        int timeStart;
        Character ch;
        int pos;
        if (text == null || text.length() < MIN_DATE_TIME_STR_LENGTH) {
            return null;
        }
        String finalText = text = text.replaceAll("\\p{Zs}", " ").trim();
        if (Stream.of(BAD_DATE_TIME_STRING_CONTAINS).anyMatch(finalText::contains)) {
            return null;
        }
        int dateTimeStart = StringUtils.indexOfAny((CharSequence)text, (CharSequence[])VALID_WORK_YEARS_ARRAY);
        if (dateTimeStart == -1) {
            return null;
        }
        int dateEnd = StringUtils.indexOf((CharSequence)text, (CharSequence)" ", (int)dateTimeStart);
        if (dateEnd < 0) {
            // empty if block
        }
        for (pos = timeStart = dateEnd + 1; pos < text.length() && (Character.isDigit((ch = Character.valueOf(text.charAt(pos))).charValue()) || ch.charValue() == ':'); ++pos) {
        }
        int dateTimeEnd = pos;
        String possibleDate = StringUtils.substring((String)text, (int)dateTimeStart, (int)dateTimeEnd);
        OffsetDateTime dateTime = null;
        if (possibleDate.length() >= MIN_DATE_TIME_STR_LENGTH) {
            dateTime = this.parseDateTimeStrictly(possibleDate);
        }
        return dateTime;
    }

    public YearMonth detectYearMonth(String text) {
        String possibleYearMonth = this.detectPossibleDateTimeString(text);
        return possibleYearMonth != null ? this.tryParseYearMonthStrictly(possibleYearMonth) : null;
    }

    public YearMonth tryParseYearMonthStrictly(String possibleYearMonth) {
        try {
            String[] parts;
            Pattern pattern = Pattern.compile("20[0-9][0-9][0-1][0-9].+");
            Pattern pattern2 = Pattern.compile("20[0-9][0-9]-[0-1]?[0-9].+");
            if (pattern.matcher((CharSequence)possibleYearMonth).matches()) {
                possibleYearMonth = ((String)possibleYearMonth).substring(0, 4) + "-" + ((String)possibleYearMonth).substring(4, 6);
                return YearMonth.parse((CharSequence)possibleYearMonth);
            }
            if (pattern2.matcher((CharSequence)possibleYearMonth).matches() && (parts = ((String)possibleYearMonth).split("-")).length >= 2 && parts[0].length() == 4) {
                if (parts[1].length() == 1) {
                    parts[1] = "0" + parts[1];
                }
                possibleYearMonth = parts[0] + "-" + parts[1];
                return YearMonth.parse((CharSequence)possibleYearMonth);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public OffsetDateTime detectDate(String text) {
        String possibleDate = this.detectPossibleDateTimeString(text);
        return possibleDate != null ? this.tryParseDateTimeStrictly(possibleDate) : null;
    }

    public OffsetDateTime tryParseDateTimeStrictly(String possibleDate) {
        try {
            Pattern pattern = Pattern.compile("20[0-9][0-9][0-1][0-9][0-3][0-9].+");
            Pattern pattern2 = Pattern.compile("20[0-9][0-9]-[0-1]?[0-9]-[0-3]?[0-9].+");
            if (pattern.matcher((CharSequence)possibleDate).matches()) {
                possibleDate = StringUtils.substring((String)possibleDate, (int)0, (int)"yyyyMMdd".length());
            } else if (pattern2.matcher((CharSequence)possibleDate).matches()) {
                String[] parts = ((String)possibleDate).split("-");
                if (parts.length >= 3 && parts[0].length() == 4) {
                    if (parts[1].length() == 1) {
                        parts[1] = "0" + parts[1];
                    }
                    if (parts[2].length() == 1) {
                        parts[2] = "0" + parts[2];
                    }
                    if (parts[2].length() > 2) {
                        parts[2] = parts[2].substring(0, 2);
                    }
                    possibleDate = parts[0] + "-" + parts[1] + "-" + parts[2];
                }
            } else {
                possibleDate = null;
            }
            return possibleDate == null ? null : this.parseDateStrictly((String)possibleDate, this.dateFormats);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public OffsetDateTime parseDateStrictly(String dateStr) {
        return this.parseDateStrictly(dateStr, this.dateFormats);
    }

    public OffsetDateTime parseDateTimeStrictly(String dateStr) {
        return this.parseDateStrictly(dateStr, this.dateTimeFormats);
    }

    public OffsetDateTime parseDateStrictly(String dateStr, String ... formats) {
        Date parsedDate = null;
        try {
            parsedDate = DateUtils.parseDateStrictly((String)dateStr, (String[])formats);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return parsedDate == null ? null : OffsetDateTime.ofInstant(parsedDate.toInstant(), this.zoneId);
    }

    public Instant parseDateTimeStrictly(String dateStr, Instant defaultValue) {
        try {
            return DateUtils.parseDateStrictly((String)dateStr, (String[])this.dateTimeFormats).toInstant();
        }
        catch (Throwable throwable) {
            return defaultValue;
        }
    }

    public boolean containsOldDate(String text, int days, ZoneId zoneId) {
        if (text == null) {
            return false;
        }
        YearMonth yearMonth = this.detectYearMonth(text);
        if (yearMonth == null) {
            return false;
        }
        OffsetDateTime dateTime = yearMonth.atEndOfMonth().atTime(0, 0).atZone(zoneId).toOffsetDateTime();
        if (DateTimes.isDaysBefore(dateTime, days)) {
            return true;
        }
        dateTime = this.detectDate(text);
        return dateTime != null && DateTimes.isDaysBefore(dateTime, days);
    }

    static {
        COMMON_DATE_FORMATS = new String[]{"yyyyMMdd", "yyyy.MM.dd", "yyyy-MM-dd", "yyyy\u5e74MM\u6708dd\u65e5", "yyyy/MM/dd"};
        COMMON_DATE_TIME_FORMATS = new String[]{"yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HH:mm:ss", "yyyy.MM.dd HH:mm:ss", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd hh:mm:ss", "yyyy-MM-dd HH:mm", "yyyy-MM-dd hh:mm", "yyyy-MM-dd'T'HH:mm:ss'Z'", "yyyy\u5e74MM\u6708dd\u65e5 HH:mm", "yyyy\u5e74MM\u6708dd\u65e5 hh:mm", "yyyy\u5e74MM\u6708dd\u65e5 HH:mm:ss", "yyyy\u5e74MM\u6708dd\u65e5 hh:mm:ss", "yyyy/MM/dd HH:mm", "yyyy/MM/dd hh:mm", "yyyy/MM/dd HH:mm:ss", "yyyy/MM/dd hh:mm:ss", "yyyy/MM/dd HH:mm:ss.SSS zzz", "yyyy/MM/dd HH:mm:ss.SSS", "yyyy/MM/dd HH:mm:ss zzz", "MMM dd yyyy HH:mm:ss. zzz", "MMM dd yyyy HH:mm:ss zzz", "dd.MM.yyyy HH:mm:ss zzz", "dd MM yyyy HH:mm:ss zzz", "dd.MM.yyyy zzz", "dd.MM.yyyy; HH:mm:ss", "dd.MM.yyyy HH:mm:ss", "EEE MMM dd HH:mm:ss yyyy", "EEE MMM dd HH:mm:ss yyyy zzz", "EEE MMM dd HH:mm:ss zzz yyyy", "EEE, dd MMM yyyy HH:mm:ss zzz", "EEE,dd MMM yyyy HH:mm:ss zzz", "EEE, dd MMM yyyy HH:mm:sszzz", "EEE, dd MMM yyyy HH:mm:ss", "EEE, dd-MMM-yy HH:mm:ss zzz"};
        OLD_YEARS = IntStream.range(1990, CURRENT_YEAR).mapToObj(String::valueOf).collect(Collectors.toSet());
        OLD_MONTH = IntStream.range(1, CURRENT_MONTH - 1).mapToObj(m -> String.format("%02d", m)).collect(Collectors.toSet());
        String monthPattern = StringUtils.join(OLD_MONTH, (String)"|");
        if (CURRENT_MONTH <= 2) {
            monthPattern = "\\d{2}";
        }
        OLD_MONTH_URL_DATE_PATTERN = Pattern.compile(".+" + CURRENT_YEAR + "[/\\.-]?(" + monthPattern + ").+");
    }
}

