/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common;

import ai.platon.pulsar.common.SParser;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.math.NumberUtils;
import org.jetbrains.annotations.NotNull;

public final class Strings {
    public static final String[] emptyStringArray = new String[0];
    public static final char COMMA = ',';
    public static final String COMMA_STR = ",";
    public static final char ESCAPE_CHAR = '\\';
    public static final Pattern HTML_CHARSET_PATTERN = Pattern.compile("^<meta.+charset\\s*=[\\s\"']*([a-zA-Z0-9\\-]{3,8})[\\s\"'/>]*", 2);
    public static final Pattern PRICE_PATTERN = Pattern.compile("[1-9](,{0,1}\\d+){0,8}(\\.\\d{1,2})|[1-9](,{0,1}\\d+){0,8}");
    public static final String DEFAULT_KEEP_CHARS = "~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./' \n\r\t";
    public static final String HTML_TAG_REGEX = "<(\"[^\"]*\"|'[^']*'|[^'\">])*>";
    public static final String FLOAT_REGEX = "^([+-]?(\\d+\\.)?\\d+)$";
    public static Pattern FLOAT_PATTERN = Pattern.compile("^([+-]?(\\d+\\.)?\\d+)$");
    public static Pattern HTML_TAG_PATTERN = Pattern.compile("<(\"[^\"]*\"|'[^']*'|[^'\">])*>");
    public static final String NUMERIC_LIKE_REGEX = "^.{0,2}[-+]?[0-9]*\\.?[0-9]+.{0,2}$";
    public static Pattern NUMERIC_LIKE_PATTERN = Pattern.compile("^.{0,2}[-+]?[0-9]*\\.?[0-9]+.{0,2}$");
    public static final String MONEY_LIKE_REGEX = "^[\u00a5\uffe5$]?[0-9]+(\\.[0-9]{1,2})?$";
    public static Pattern MONEY_LIKE_PATTERN = Pattern.compile("^[\u00a5\uffe5$]?[0-9]+(\\.[0-9]{1,2})?$");
    public static final String CHINESE_PHONE_NUMBER_LIKE_REGEX = "^((13[0-9])|(14[5|7])|(15([0-3]|[5-9]))|(18[0,1,2,5-9])|(177))\\d{8}$";
    public static Pattern CHINESE_PHONE_NUMBER_LIKE_PATTERN = Pattern.compile("^((13[0-9])|(14[5|7])|(15([0-3]|[5-9]))|(18[0,1,2,5-9])|(177))\\d{8}$");
    public static final String IP_PORT_REGEX = "^(((?!-)[A-Za-z0-9-]{1,63}(?<!-)\\.)+[A-Za-z]{2,6}|localhost|(([0-9]{1,3}\\.){3})[0-9]{1,3}):[0-9]{1,5}$";
    public static final Pattern IP_PORT_PATTERN = Pattern.compile("^(((?!-)[A-Za-z0-9-]{1,63}(?<!-)\\.)+[A-Za-z]{2,6}|localhost|(([0-9]{1,3}\\.){3})[0-9]{1,3}):[0-9]{1,5}$");
    public static final int CODE_KEYBOARD_WHITESPACE = 32;
    public static final int CODE_NBSP = 160;
    public static final String KEYBOARD_WHITESPACE = String.valueOf(32);
    public static final String NBSP = String.valueOf(160);
    public static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    public static final String[] padding = new String[]{"", " ", "  ", "   ", "    ", "     ", "      ", "       ", "        ", "         ", "          "};
    public static final Comparator<String> LongerFirstComparator = (s2, s22) -> {
        int result = Integer.compare(s22.length(), s2.length());
        if (result == 0) {
            return s2.compareTo((String)s22);
        }
        return result;
    };
    public static final Comparator<String> ShorterFirstComparator = (s2, s22) -> LongerFirstComparator.compare((String)s22, (String)s2);
    public static final Pattern PatternTime = Pattern.compile("[0-2][0-3]:[0-5][0-9]");

    public static int countTimeString(String text) {
        Matcher matcher = PatternTime.matcher(text);
        int count = 0;
        while (matcher.find()) {
            ++count;
        }
        return count;
    }

    public static boolean isActuallyWhitespace(int c) {
        return c == 32 || c == 9 || c == 10 || c == 12 || c == 13 || c == 160;
    }

    public static String toHexString(ByteBuffer buf) {
        return Strings.toHexString(buf, null, Integer.MAX_VALUE);
    }

    public static String toHexString(ByteBuffer buf, String sep, int lineLen) {
        return Strings.toHexString(buf.array(), buf.arrayOffset() + buf.position(), buf.remaining(), sep, lineLen);
    }

    public static String toHexString(byte[] buf) {
        return Strings.toHexString(buf, null, Integer.MAX_VALUE);
    }

    public static String toHexString(byte[] buf, String sep, int lineLen) {
        return Strings.toHexString(buf, 0, buf.length, sep, lineLen);
    }

    public static String toHexString(byte[] buf, int of, int cb, String sep, int lineLen) {
        if (buf == null) {
            return null;
        }
        if (lineLen <= 0) {
            lineLen = Integer.MAX_VALUE;
        }
        StringBuffer res = new StringBuffer(cb * 2);
        for (int c = 0; c < cb; ++c) {
            byte b = buf[of++];
            res.append(HEX_DIGITS[b >> 4 & 0xF]);
            res.append(HEX_DIGITS[b & 0xF]);
            if (c > 0 && c % lineLen == 0) {
                res.append('\n');
                continue;
            }
            if (sep == null || c >= lineLen - 1) continue;
            res.append(sep);
        }
        return res.toString();
    }

    public static boolean isChinese(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION;
    }

    public static boolean isChinese(String text) {
        char[] ch = text.toCharArray();
        for (int i = 0; i < ch.length; ++i) {
            char c = ch[i];
            if (!Strings.isChinese(c)) continue;
            return true;
        }
        return false;
    }

    public static boolean isMainlyChinese(String text, double percentage) {
        if ("".equals(text)) {
            return false;
        }
        return 1.0 * (double)Strings.countChinese(text) / (double)text.length() >= percentage;
    }

    public static int countChinese(String text) {
        if ("".equals(text)) {
            return 0;
        }
        int count = 0;
        char[] ch = text.toCharArray();
        for (int i = 0; i < ch.length; ++i) {
            if (!Strings.isChinese(ch[i])) continue;
            ++count;
        }
        return count;
    }

    public static boolean isChineseByREG(String str) {
        if (str == null) {
            return false;
        }
        Pattern pattern = Pattern.compile("[\\u4E00-\\u9FBF]+");
        return pattern.matcher(str.trim()).find();
    }

    public static boolean isChineseCharByREG(char ch) {
        return ch >= '\u4e00' && ch <= '\u9fbf';
    }

    public static boolean isChineseByName(String str) {
        if (str == null) {
            return false;
        }
        String reg = "\\p{InCJK Unified Ideographs}&&\\P{Cn}";
        Pattern pattern = Pattern.compile(reg);
        return pattern.matcher(str.trim()).find();
    }

    public static String stripNonChar(String text) {
        return Strings.stripNonChar(text, null);
    }

    public static String stripNonChar(String text, String keeps) {
        StringBuilder builder = new StringBuilder();
        if (keeps == null) {
            keeps = "";
        }
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (Character.isLetterOrDigit(ch) || Strings.isChineseCharByREG(ch)) {
                builder.append(ch);
                continue;
            }
            if (keeps.equals("") || keeps.indexOf(ch) == -1) continue;
            builder.append(ch);
        }
        return builder.toString();
    }

    public static String trimNonChar(String text) {
        return Strings.trimNonChar(text, null);
    }

    public static String trimNonChar(String text, String keeps) {
        char ch;
        int i;
        int start2 = 0;
        int end = text.length();
        if (keeps == null) {
            keeps = "";
        }
        for (i = 0; i < text.length(); ++i) {
            ch = text.charAt(i);
            if (!Character.isLetterOrDigit(ch) && !Strings.isChineseCharByREG(ch) && keeps.indexOf(ch) == -1) continue;
            start2 = i;
            break;
        }
        for (i = text.length() - 1; i >= 0; --i) {
            ch = text.charAt(i);
            if (!Character.isLetterOrDigit(ch) && !Strings.isChineseCharByREG(ch) && keeps.indexOf(ch) == -1) continue;
            end = i + 1;
            break;
        }
        return text.substring(start2, end);
    }

    public static boolean isCJK(char ch) {
        return Character.UnicodeBlock.of(ch) == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS;
    }

    public static String stripNonCJKChar(String text) {
        return Strings.stripNonCJKChar(text, null);
    }

    public static String stripNonCJKChar(String text, String keeps) {
        StringBuilder builder = new StringBuilder();
        if (keeps == null) {
            keeps = "";
        }
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (Character.isLetterOrDigit(ch) || Strings.isCJK(ch)) {
                builder.append(ch);
                continue;
            }
            if (keeps.equals("") || keeps.indexOf(ch) == -1) continue;
            builder.append(ch);
        }
        return builder.toString();
    }

    public static String trimNonCJKChar(String text) {
        return Strings.trimNonCJKChar(text, null);
    }

    public static String trimNonCJKChar(String text, String keeps) {
        char ch;
        int i;
        int start2 = 0;
        int end = text.length();
        if (keeps == null) {
            keeps = "";
        }
        for (i = 0; i < text.length(); ++i) {
            ch = text.charAt(i);
            if (!Character.isLetterOrDigit(ch) && !Strings.isCJK(ch) && keeps.indexOf(ch) == -1) continue;
            start2 = i;
            break;
        }
        for (i = text.length() - 1; i >= 0; --i) {
            ch = text.charAt(i);
            if (!Character.isLetterOrDigit(ch) && !Strings.isCJK(ch) && keeps.indexOf(ch) == -1) continue;
            end = i + 1;
            break;
        }
        return text.substring(start2, end);
    }

    public static String stripNonPrintableChar(String text) {
        if (text == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        int len = text.length();
        for (int i = 0; i < len; ++i) {
            char ch = text.charAt(i);
            if (Strings.isActuallyWhitespace(ch)) {
                int j;
                if (i > 0 && i < len - 1) {
                    builder.append(' ');
                }
                for (j = i + 1; j < len && Strings.isActuallyWhitespace(text.charAt(j)); ++j) {
                }
                i = j - 1;
                continue;
            }
            if (!Strings.isPrintableUnicodeChar(ch)) continue;
            builder.append(ch);
        }
        return builder.toString();
    }

    public static boolean isPrintableUnicodeChar(char ch) {
        Character.UnicodeBlock block = Character.UnicodeBlock.of(ch);
        return !Character.isISOControl(ch) && ch != '\uffff' && block != null && block != Character.UnicodeBlock.SPECIALS;
    }

    public static String cleanField(String value) {
        value = value.replaceAll("\ufffd", "");
        return value;
    }

    public static String getLongestPart(String text, Pattern pattern) {
        String[] parts = pattern.split(text);
        if (parts.length == 1) {
            return "";
        }
        String longestPart = "";
        for (int i = 0; i < parts.length; ++i) {
            String p = parts[i];
            if (p.length() <= longestPart.length()) continue;
            longestPart = p;
        }
        if (longestPart.length() == 0) {
            return "";
        }
        return longestPart.trim();
    }

    public static String getLongestPart(String text, String regex) {
        return Strings.getLongestPart(text, Pattern.compile(regex));
    }

    public static String csslize(String text) {
        text = StringUtils.uncapitalize((String)text).trim();
        text = StringUtils.join((Object[])text.split("(?=\\p{Upper})"), (String)"-").toLowerCase();
        text = text.replaceAll("[-_]+", "-");
        text = text.replaceAll("\\s+", "-");
        return text;
    }

    public static String humanize(String text) {
        text = StringUtils.join((Object[])text.split("(?=\\p{Upper})"), (String)" ");
        text = text.replaceAll("[-_]", " ").toLowerCase().trim();
        return text;
    }

    public static String humanize(String text, String seperator) {
        text = StringUtils.join((Object[])text.split("(?=\\p{Upper})"), (String)seperator);
        text = text.replaceAll("[-_]", seperator).toLowerCase().trim();
        return text;
    }

    public static String humanize(String text, String suffix, String seperator) {
        text = StringUtils.join((Object[])text.split("(?=\\p{Upper})"), (String)seperator);
        text = text.replaceAll("[-_]", seperator).toLowerCase().trim();
        return text + seperator + suffix;
    }

    public static String humanize(Class clazz, String suffix, String seperator) {
        String text = StringUtils.join((Object[])clazz.getSimpleName().split("(?=\\p{Upper})"), (String)seperator);
        text = text.replaceAll("[-_]", seperator).toLowerCase().trim();
        return text + seperator + suffix;
    }

    public static int getLeadingInteger(String s2, int defaultValue) {
        int numberEnd = StringUtils.lastIndexOfAny((CharSequence)s2, (CharSequence[])new CharSequence[]{"123456789"});
        if (numberEnd == -1) {
            return defaultValue;
        }
        return NumberUtils.toInt((String)s2.substring(0, numberEnd), (int)defaultValue);
    }

    public static int getTailingInteger(String s2, int defaultValue) {
        int numberStart = StringUtils.indexOfAny((CharSequence)s2, (String)"123456789");
        if (numberStart == -1) {
            return defaultValue;
        }
        return NumberUtils.toInt((String)s2.substring(numberStart), (int)defaultValue);
    }

    public static int getFirstInteger(String s2, int defaultValue) {
        int numberStart = StringUtils.indexOfAny((CharSequence)s2, (String)"123456789");
        if (numberStart == -1) {
            return defaultValue;
        }
        StringBuilder sb = new StringBuilder(s2.length() - numberStart);
        boolean j = false;
        for (int i = numberStart; i < s2.length(); ++i) {
            char c = s2.charAt(i);
            if (Character.isDigit(c)) {
                sb.append(c);
                continue;
            }
            if (c != ',' && c != '_') break;
        }
        return NumberUtils.toInt((String)sb.toString(), (int)defaultValue);
    }

    public static int getLastInteger(String s2, int defaultValue) {
        s2 = s2.replaceAll("[,_]", "");
        s2 = StringUtils.reverse((String)s2);
        Pattern pattern = Pattern.compile("[0-9]+");
        Matcher m = pattern.matcher(s2);
        if (m.find()) {
            return NumberUtils.toInt((String)StringUtils.reverse((String)m.group()));
        }
        return defaultValue;
    }

    public static float getFirstFloatNumber(String s2, float defaultValue) {
        s2 = s2.replaceAll("[,_]", "");
        Pattern pattern = Pattern.compile("[+-]?[0-9]*\\.?,?[0-9]+");
        Matcher m = pattern.matcher(s2);
        if (m.find()) {
            return NumberUtils.toFloat((String)m.group());
        }
        return defaultValue;
    }

    public static float getLastFloatNumber(String s2, float defaultValue) {
        s2 = s2.replaceAll("[,_]", "");
        Pattern pattern = Pattern.compile("[+-]?[0-9]*\\.?,?[0-9]+");
        Matcher m = pattern.matcher(s2);
        if (m.find()) {
            return NumberUtils.toFloat((String)m.group(m.groupCount()));
        }
        return defaultValue;
    }

    public static boolean contains(String text, CharSequence ... searchCharSequences) {
        Validate.notNull((Object)searchCharSequences);
        for (CharSequence search : searchCharSequences) {
            if (text.contains(search)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAny(String text, CharSequence ... searchCharSequences) {
        Validate.notNull((Object)searchCharSequences);
        for (CharSequence search : searchCharSequences) {
            if (!text.contains(search)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsNone(String text, CharSequence ... searchCharSequences) {
        Validate.notNull((Object)searchCharSequences);
        for (CharSequence search : searchCharSequences) {
            if (!text.contains(search)) continue;
            return false;
        }
        return true;
    }

    public static String stringifyException(Throwable e) {
        Objects.requireNonNull(e);
        StringWriter stm = new StringWriter();
        PrintWriter wrt = new PrintWriter(stm);
        e.printStackTrace(wrt);
        wrt.close();
        return stm.toString();
    }

    public static String simplifyException(@NotNull Throwable e) {
        List lines;
        int n;
        String message = e.getMessage();
        if (message == null) {
            message = e.toString();
        }
        if ((n = (lines = Arrays.stream(message.split("\n")).filter(StringUtils::isNotBlank).collect(Collectors.toList())).size()) == 0) {
            return "";
        }
        if (n == 1) {
            return (String)lines.get(0);
        }
        if (n == 2) {
            return (String)lines.get(0) + "\t" + (String)lines.get(1);
        }
        return (String)lines.get(0) + "\t" + (String)lines.get(1) + " ...";
    }

    public static String reverse(String s2) {
        if (s2 == null || s2.isEmpty()) {
            return s2;
        }
        StringBuilder sb = new StringBuilder(s2);
        return sb.reverse().toString();
    }

    public static String doubleQuoteIfContainsWhitespace(String s2) {
        if (StringUtils.containsWhitespace((CharSequence)s2)) {
            return "\"" + s2 + "\"";
        }
        return s2;
    }

    public static String readableBytes(int bytes) {
        return Strings.readableBytes(bytes, -1, false);
    }

    public static String readableBytes(long bytes) {
        return Strings.readableBytes(bytes, -1, false);
    }

    public static String readableBytes(int bytes, boolean si) {
        return Strings.readableBytes(bytes, -1, si);
    }

    public static String readableBytes(long bytes, boolean si) {
        return Strings.readableBytes(bytes, -1, si);
    }

    public static String readableBytes(int bytes, int scale, boolean si) {
        return Strings.readableBytes((long)bytes, scale, si);
    }

    public static String readableBytes(long bytes, int scale, boolean si) {
        int unit;
        int n = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
        Object format = scale > 0 ? "%," + scale + ".2f %sB" : "%,.2f %sB";
        return String.format((String)format, (double)bytes / Math.pow(unit, exp), pre);
    }

    public static Map<String, String> parseKvs(String line) {
        return Strings.parseKvs(line, "=");
    }

    public static Map<String, String> parseKvs(String line, String delimiter) {
        return SParser.wrap(line).getKvs(delimiter);
    }

    public static List<String> getUnslashedLines(String allLines) {
        return Strings.mergeSlashedLines(Arrays.asList(allLines.split("\n")));
    }

    public static List<String> getUnslashedLines(String allLines, String EOL) {
        return Strings.mergeSlashedLines(Arrays.asList(allLines.split(EOL)));
    }

    public static String mergeSlashedLine(String slashedLine) {
        slashedLine = slashedLine.replaceAll("\n", "");
        slashedLine = slashedLine.replaceAll("\\\\", "");
        return slashedLine;
    }

    public static List<String> mergeSlashedLines(Iterable<String> linesWithSlash) {
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder mergedLine = new StringBuilder();
        for (String line : linesWithSlash) {
            boolean merging;
            if ((line = line.trim()).isEmpty()) continue;
            if (line.endsWith("\\")) {
                merging = true;
                mergedLine.append(StringUtils.removeEnd((String)line, (String)"\\"));
            } else {
                mergedLine.append(line);
                merging = false;
            }
            if (merging || mergedLine.length() <= 0) continue;
            lines.add(mergedLine.toString());
            mergedLine = new StringBuilder();
        }
        return lines;
    }

    public static int getLongestCommonSubstring(String a, String b) {
        int m = a.length();
        int n = b.length();
        int max = 0;
        int[][] dp = new int[m][n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                if (a.charAt(i) != b.charAt(j)) continue;
                dp[i][j] = i == 0 || j == 0 ? 1 : dp[i - 1][j - 1] + 1;
                if (max >= dp[i][j]) continue;
                max = dp[i][j];
            }
        }
        return max;
    }

    public static String replaceCharsetInHtml(String html, String charset) {
        Matcher matcher = HTML_CHARSET_PATTERN.matcher(html);
        if (matcher.find()) {
            html = html.replaceAll(matcher.group(1), charset);
        }
        return html;
    }

    public static String[] getStrings(String str) {
        Collection<String> values = Strings.getStringCollection(str);
        if (values.size() == 0) {
            return null;
        }
        return values.toArray(new String[0]);
    }

    public static String arrayToString(String[] strs) {
        if (strs.length == 0) {
            return "";
        }
        StringBuilder sbuf = new StringBuilder();
        sbuf.append(strs[0]);
        for (int idx = 1; idx < strs.length; ++idx) {
            sbuf.append(COMMA_STR);
            sbuf.append(strs[idx]);
        }
        return sbuf.toString();
    }

    public static Collection<String> getStringCollection(String str) {
        String delim = COMMA_STR;
        return Strings.getStringCollection(str, delim);
    }

    public static Collection<String> getStringCollection(String str, String delim) {
        ArrayList<String> values = new ArrayList<String>();
        if (str == null) {
            return values;
        }
        StringTokenizer tokenizer = new StringTokenizer(str, delim);
        while (tokenizer.hasMoreTokens()) {
            values.add(tokenizer.nextToken());
        }
        return values;
    }

    public static Collection<String> getTrimmedStringCollection(String str) {
        LinkedHashSet<String> set = new LinkedHashSet<String>(Arrays.asList(Strings.getTrimmedStrings(str)));
        set.remove("");
        return set;
    }

    public static String[] getTrimmedStrings(String str) {
        if (null == str || str.trim().isEmpty()) {
            return emptyStringArray;
        }
        return str.trim().split("\\s*,\\s*");
    }

    public static boolean hasHTMLTags(String text) {
        Matcher matcher = HTML_TAG_PATTERN.matcher(text);
        return matcher.find();
    }

    public static boolean isFloat(String text) {
        return FLOAT_PATTERN.matcher(text).matches();
    }

    public static boolean isNumericLike(String text) {
        return NUMERIC_LIKE_PATTERN.matcher(text).matches();
    }

    public static boolean isMoneyLike(String text) {
        return MONEY_LIKE_PATTERN.matcher(text).matches();
    }

    public static boolean isIpPortLike(String text) {
        return IP_PORT_PATTERN.matcher(text).matches();
    }

    public static boolean isIpLike(String text) {
        return text.matches("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}");
    }
}

