/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.collect;

import ai.platon.pulsar.common.collect.AbstractExternalUrlLoader;
import ai.platon.pulsar.common.collect.UrlTopic;
import ai.platon.pulsar.common.concurrent.ConcurrentExpiringLRUCache;
import ai.platon.pulsar.common.urls.UrlAware;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0019\u001a\u00020\u000bH\u0016J\u0010\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u000bH&J\u0010\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001bH&J\b\u0010\u001d\u001a\u00020\u000bH\u0016J\u0010\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u000fH\u0016J\u0010\u0010 \u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J@\u0010!\u001a\u00020\u001f\"\u0004\b\u0000\u0010\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H\"0$2\u0006\u0010%\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u0002H\"0'H\u0016J\b\u0010)\u001a\u00020\u001fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R \u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010R\"\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0007\u00a8\u0006*"}, d2={"Lai/platon/pulsar/common/collect/DelayExternalUrlLoader;", "Lai/platon/pulsar/common/collect/AbstractExternalUrlLoader;", "countDelay", "Ljava/time/Duration;", "loadDelay", "(Ljava/time/Duration;Ljava/time/Duration;)V", "getCountDelay", "()Ljava/time/Duration;", "counts", "Lai/platon/pulsar/common/concurrent/ConcurrentExpiringLRUCache;", "", "", "getCounts", "()Lai/platon/pulsar/common/concurrent/ConcurrentExpiringLRUCache;", "isExpired", "", "()Z", "lastLoadTime", "Ljava/time/Instant;", "kotlin.jvm.PlatformType", "getLastLoadTime", "()Ljava/time/Instant;", "setLastLoadTime", "(Ljava/time/Instant;)V", "getLoadDelay", "countRemaining", "topic", "Lai/platon/pulsar/common/collect/UrlTopic;", "doCountRemaining", "estimateRemaining", "expire", "", "hasMore", "loadTo", "T", "sink", "", "size", "transformer", "Lkotlin/Function1;", "Lai/platon/pulsar/common/urls/UrlAware;", "reset", "pulsar-common"})
public abstract class DelayExternalUrlLoader
extends AbstractExternalUrlLoader {
    @NotNull
    private final Duration countDelay;
    @NotNull
    private final Duration loadDelay;
    @NotNull
    private final ConcurrentExpiringLRUCache<String, Integer> counts;
    private volatile Instant lastLoadTime;

    public DelayExternalUrlLoader(@NotNull Duration countDelay, @NotNull Duration loadDelay) {
        Intrinsics.checkNotNullParameter((Object)countDelay, (String)"countDelay");
        Intrinsics.checkNotNullParameter((Object)loadDelay, (String)"loadDelay");
        this.countDelay = countDelay;
        this.loadDelay = loadDelay;
        this.counts = new ConcurrentExpiringLRUCache(this.countDelay, 1000);
        this.lastLoadTime = Instant.EPOCH;
    }

    public /* synthetic */ DelayExternalUrlLoader(Duration duration, Duration duration2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        Duration duration3;
        if ((n & 1) != 0) {
            duration3 = Duration.ofSeconds(1L);
            Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"ofSeconds(1)");
            duration = duration3;
        }
        if ((n & 2) != 0) {
            duration3 = Duration.ofSeconds(5L);
            Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"ofSeconds(5)");
            duration2 = duration3;
        }
        this(duration, duration2);
    }

    @NotNull
    public final Duration getCountDelay() {
        return this.countDelay;
    }

    @NotNull
    public final Duration getLoadDelay() {
        return this.loadDelay;
    }

    @NotNull
    protected final ConcurrentExpiringLRUCache<String, Integer> getCounts() {
        return this.counts;
    }

    protected final Instant getLastLoadTime() {
        return this.lastLoadTime;
    }

    protected final void setLastLoadTime(Instant instant) {
        this.lastLoadTime = instant;
    }

    public final boolean isExpired() {
        return this.lastLoadTime.plus(this.loadDelay).compareTo(Instant.now()) < 0;
    }

    public void expire() {
        this.lastLoadTime = Instant.EPOCH;
        this.counts.clear();
    }

    @Override
    public void reset() {
        this.expire();
    }

    @Override
    public boolean hasMore() {
        return this.estimateRemaining() > 0;
    }

    @Override
    public boolean hasMore(@NotNull UrlTopic topic) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        return this.estimateRemaining(topic) > 0;
    }

    public abstract int doCountRemaining();

    public abstract int doCountRemaining(@NotNull UrlTopic var1);

    @Override
    public int estimateRemaining() {
        return ((Number)this.counts.computeIfAbsent("", (Function1<String, Integer>)((Function1)new Function1<String, Integer>(this){
            final /* synthetic */ DelayExternalUrlLoader this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Integer invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.this$0.countRemaining();
            }
        }))).intValue();
    }

    @Override
    public int estimateRemaining(@NotNull UrlTopic topic) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        return ((Number)this.counts.computeIfAbsent(topic.toString(), (Function1<String, Integer>)((Function1)new Function1<String, Integer>(this, topic){
            final /* synthetic */ DelayExternalUrlLoader this$0;
            final /* synthetic */ UrlTopic $topic;
            {
                this.this$0 = $receiver;
                this.$topic = $topic;
                super(1);
            }

            @NotNull
            public final Integer invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.this$0.countRemaining(this.$topic);
            }
        }))).intValue();
    }

    @Override
    public int countRemaining() {
        int count = this.doCountRemaining();
        ConcurrentExpiringLRUCache.putDatum$default(this.counts, "", count, 0L, 4, null);
        return count;
    }

    @Override
    public int countRemaining(@NotNull UrlTopic topic) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        int count = this.doCountRemaining(topic);
        String key = topic.toString();
        ConcurrentExpiringLRUCache.putDatum$default(this.counts, key, count, 0L, 4, null);
        return count;
    }

    @Override
    public <T> void loadTo(@NotNull Collection<T> sink, int size, @NotNull UrlTopic topic, @NotNull Function1<? super UrlAware, ? extends T> transformer) {
        Intrinsics.checkNotNullParameter(sink, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter(transformer, (String)"transformer");
        if (!this.isExpired()) {
            return;
        }
        this.lastLoadTime = Instant.now();
        this.loadToNow(sink, size, topic, transformer);
    }

    public DelayExternalUrlLoader() {
        this(null, null, 3, null);
    }
}

