/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.collect;

import ai.platon.pulsar.common.UrlExtractor;
import ai.platon.pulsar.common.collect.OneLoadExternalUrlLoader;
import ai.platon.pulsar.common.collect.UrlTopic;
import ai.platon.pulsar.common.urls.Hyperlink;
import ai.platon.pulsar.common.urls.HyperlinkDatum;
import ai.platon.pulsar.common.urls.UrlAware;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016JF\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0015\"\u0004\b\u0000\u0010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00160\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u0002H\u00160\u001cH\u0016J,\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u0006H\u0002J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001d2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \t*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lai/platon/pulsar/common/collect/LocalFileUrlLoader;", "Lai/platon/pulsar/common/collect/OneLoadExternalUrlLoader;", "path", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "delimiter", "", "gson", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "log", "Lorg/slf4j/Logger;", "getPath", "()Ljava/nio/file/Path;", "urlExtractor", "Lai/platon/pulsar/common/UrlExtractor;", "deleteAll", "", "topic", "Lai/platon/pulsar/common/collect/UrlTopic;", "loadToNow", "", "T", "sink", "", "size", "", "transformer", "Lkotlin/Function1;", "Lai/platon/pulsar/common/urls/UrlAware;", "parse", "Lai/platon/pulsar/common/urls/Hyperlink;", "line", "group", "save", "", "url", "pulsar-common"})
public class LocalFileUrlLoader
extends OneLoadExternalUrlLoader {
    @NotNull
    private final Path path;
    private final Logger log;
    @NotNull
    private final String delimiter;
    private final Gson gson;
    @NotNull
    private final UrlExtractor urlExtractor;

    public LocalFileUrlLoader(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.path = path;
        this.log = LoggerFactory.getLogger(LocalFileUrlLoader.class);
        this.delimiter = "\t";
        this.gson = new GsonBuilder().create();
        this.urlExtractor = new UrlExtractor();
    }

    @NotNull
    public final Path getPath() {
        return this.path;
    }

    @Override
    public void save(@NotNull UrlAware url, @NotNull UrlTopic topic) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Hyperlink hyperlink = url instanceof Hyperlink ? (Hyperlink)url : new Hyperlink(url);
        String json = this.gson.toJson((Object)hyperlink.data());
        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.APPEND};
        Files.writeString(this.path, (CharSequence)(topic.getGroup() + this.delimiter + json + "\n"), openOptionArray);
    }

    @Override
    @NotNull
    public Collection<UrlAware> loadToNow(@NotNull Collection<UrlAware> sink, int size, @NotNull UrlTopic topic) {
        block4: {
            Object object;
            Intrinsics.checkNotNullParameter(sink, (String)"sink");
            Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
            if (!Files.exists(this.path, new LinkOption[0])) {
                boolean bl = false;
                return CollectionsKt.emptyList();
            }
            String g = String.valueOf(topic.getGroup());
            LocalFileUrlLoader localFileUrlLoader = this;
            boolean bl = false;
            try {
                object = Result.Companion;
                LocalFileUrlLoader $this$loadToNow_u24lambda_u2d1 = localFileUrlLoader;
                boolean bl2 = false;
                List<String> list = Files.readAllLines($this$loadToNow_u24lambda_u2d1.getPath());
                Intrinsics.checkNotNullExpressionValue(list, (String)"readAllLines(path)");
                Iterable $this$mapNotNullTo$iv = list;
                boolean $i$f$mapNotNullTo = false;
                Iterable $this$forEach$iv$iv = $this$mapNotNullTo$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Hyperlink hyperlink;
                    Object element$iv$iv;
                    Object element$iv = element$iv$iv = iterator.next();
                    boolean bl3 = false;
                    String it = (String)element$iv;
                    boolean bl4 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    if ($this$loadToNow_u24lambda_u2d1.parse(it, g) == null) continue;
                    boolean bl5 = false;
                    boolean bl6 = false;
                    Hyperlink it$iv = hyperlink;
                    boolean bl7 = false;
                    sink.add(it$iv);
                }
                Collection<UrlAware> collection = sink;
                boolean bl8 = false;
                object = Result.constructor-impl(collection);
            }
            catch (Throwable throwable) {
                Result.Companion companion = Result.Companion;
                boolean bl9 = false;
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            localFileUrlLoader = object;
            bl = false;
            boolean bl10 = false;
            Throwable throwable = Result.exceptionOrNull-impl((Object)localFileUrlLoader);
            if (throwable == null) break block4;
            Throwable throwable2 = throwable;
            boolean bl11 = false;
            boolean bl12 = false;
            Throwable throwable3 = throwable2;
            boolean bl13 = false;
            Throwable it = throwable3;
            boolean bl14 = false;
            this.log.warn("Failed to load urls from " + this.getPath(), it);
        }
        return sink;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public <T> Collection<T> loadToNow(@NotNull Collection<T> sink, int size, @NotNull UrlTopic topic, @NotNull Function1<? super UrlAware, ? extends T> transformer) {
        block5: {
            Object object;
            Intrinsics.checkNotNullParameter(sink, (String)"sink");
            Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
            Intrinsics.checkNotNullParameter(transformer, (String)"transformer");
            if (!Files.exists(this.path, new LinkOption[0])) {
                boolean bl = false;
                return CollectionsKt.emptyList();
            }
            String g = String.valueOf(topic.getGroup());
            LocalFileUrlLoader localFileUrlLoader = this;
            boolean bl = false;
            try {
                void $this$mapTo$iv;
                Iterator $this$mapNotNullTo$iv$iv;
                object = Result.Companion;
                LocalFileUrlLoader $this$loadToNow_u24lambda_u2d5 = localFileUrlLoader;
                boolean bl2 = false;
                List<String> list = Files.readAllLines($this$loadToNow_u24lambda_u2d5.getPath());
                Intrinsics.checkNotNullExpressionValue(list, (String)"readAllLines(path)");
                Iterable $this$mapNotNull$iv = list;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo2 = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Hyperlink hyperlink;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl3 = false;
                    String it = (String)element$iv$iv;
                    boolean bl4 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    if ($this$loadToNow_u24lambda_u2d5.parse(it, g) == null) continue;
                    boolean bl5 = false;
                    boolean bl6 = false;
                    Hyperlink it$iv$iv = hyperlink;
                    boolean bl7 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                $this$mapNotNull$iv = (List)destination$iv$iv;
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    void it;
                    Hyperlink $i$f$mapNotNullTo2 = (Hyperlink)item$iv;
                    Collection<T> collection = sink;
                    boolean bl8 = false;
                    Object object2 = transformer.invoke((Object)it);
                    collection.add(object2);
                }
                Collection<T> collection = sink;
                boolean bl9 = false;
                object = Result.constructor-impl(collection);
            }
            catch (Throwable throwable) {
                Result.Companion companion = Result.Companion;
                boolean bl10 = false;
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            localFileUrlLoader = object;
            bl = false;
            boolean bl11 = false;
            Throwable throwable = Result.exceptionOrNull-impl((Object)localFileUrlLoader);
            if (throwable == null) break block5;
            Throwable throwable2 = throwable;
            boolean bl12 = false;
            boolean bl13 = false;
            Throwable throwable3 = throwable2;
            boolean bl14 = false;
            Throwable it = throwable3;
            boolean bl15 = false;
            this.log.warn("Failed to load urls from " + this.getPath(), it);
        }
        return sink;
    }

    @Override
    public long deleteAll(@NotNull UrlTopic topic) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        return 0L;
    }

    private final Hyperlink parse(String line, String group) {
        Hyperlink hyperlink;
        Object object = new String[]{this.delimiter};
        List parts = StringsKt.split$default((CharSequence)line, (String[])object, (boolean)false, (int)0, (int)6, null);
        if (parts.size() == 2 && Intrinsics.areEqual(parts.get(0), (Object)group)) {
            HyperlinkDatum data = (HyperlinkDatum)this.gson.fromJson((String)parts.get(1), HyperlinkDatum.class);
            Intrinsics.checkNotNullExpressionValue((Object)data, (String)"data");
            hyperlink = new Hyperlink(data);
        } else {
            object = this.urlExtractor.extract(line);
            if (object == null) {
                hyperlink = null;
            } else {
                Object object2 = object;
                boolean bl = false;
                boolean bl2 = false;
                Object it = object2;
                boolean bl3 = false;
                hyperlink = new Hyperlink((String)it, null, 0, null, null, null, 62, null);
            }
        }
        return hyperlink;
    }
}

