/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.collect.queue;

import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.collect.ExternalUrlLoader;
import ai.platon.pulsar.common.collect.UrlTopic;
import ai.platon.pulsar.common.collect.queue.AbstractLoadingQueue;
import ai.platon.pulsar.common.urls.UrlAware;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ\b\u00103\u001a\u00020\u0000H\u0002J\b\u00104\u001a\u000205H\u0002J\u0006\u00106\u001a\u000205J\u000e\u0010\u001d\u001a\u00020\u001b2\u0006\u00107\u001a\u00020\u0007J\b\u00108\u001a\u000205H\u0016J\u000e\u00108\u001a\u0002052\u0006\u00107\u001a\u00020\u0007J\u000e\u00109\u001a\b\u0012\u0004\u0012\u00020\u000b0:H\u0016J\n\u0010;\u001a\u0004\u0018\u00010\u000bH\u0016J\n\u0010<\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010=\u001a\u00020\u0000H\u0002R\u0019\u0010\r\u001a\n \u000e*\u0004\u0018\u00010\u00070\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\b\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0010\"\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0019\u0010\u0018\u001a\n \u000e*\u0004\u0018\u00010\u00070\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0010R\u0011\u0010\u001a\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001cR\u0011\u0010\u001e\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001cR\"\u0010\u001f\u001a\n \u000e*\u0004\u0018\u00010 0 X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001a\u0010%\u001a\u00020\u0015X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0017\"\u0004\b'\u0010(R\"\u0010)\u001a\n \u000e*\u0004\u0018\u00010 0 X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\"\"\u0004\b+\u0010$R\"\u0010,\u001a\n \u000e*\u0004\u0018\u00010 0 X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\"\"\u0004\b.\u0010$R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\u0010\"\u0004\b0\u0010\u0013R\u0016\u00101\u001a\n \u000e*\u0004\u0018\u00010202X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lai/platon/pulsar/common/collect/queue/DelayLoadingQueue;", "Lai/platon/pulsar/common/collect/queue/AbstractLoadingQueue;", "loader", "Lai/platon/pulsar/common/collect/ExternalUrlLoader;", "topic", "Lai/platon/pulsar/common/collect/UrlTopic;", "loadDelay", "Ljava/time/Duration;", "estimateDelay", "transformer", "Lkotlin/Function1;", "Lai/platon/pulsar/common/urls/UrlAware;", "(Lai/platon/pulsar/common/collect/ExternalUrlLoader;Lai/platon/pulsar/common/collect/UrlTopic;Ljava/time/Duration;Ljava/time/Duration;Lkotlin/jvm/functions/Function1;)V", "adjustedEstimateDelay", "kotlin.jvm.PlatformType", "getAdjustedEstimateDelay", "()Ljava/time/Duration;", "getEstimateDelay", "setEstimateDelay", "(Ljava/time/Duration;)V", "estimatedExternalSize", "", "getEstimatedExternalSize", "()I", "idleTime", "getIdleTime", "isBusy", "", "()Z", "isExpired", "isIdle", "lastEstimateTime", "Ljava/time/Instant;", "getLastEstimateTime", "()Ljava/time/Instant;", "setLastEstimateTime", "(Ljava/time/Instant;)V", "lastEstimatedExternalSize", "getLastEstimatedExternalSize", "setLastEstimatedExternalSize", "(I)V", "lastLoadTime", "getLastLoadTime", "setLastLoadTime", "lastReapedTime", "getLastReapedTime", "setLastReapedTime", "getLoadDelay", "setLoadDelay", "logger", "Lorg/slf4j/Logger;", "estimateIfExpired", "estimateNow", "", "expire", "delay", "load", "loadNow", "", "peek", "poll", "refreshIfNecessary", "pulsar-common"})
public class DelayLoadingQueue
extends AbstractLoadingQueue {
    @NotNull
    private Duration loadDelay;
    @NotNull
    private Duration estimateDelay;
    private final Logger logger;
    private volatile int lastEstimatedExternalSize;
    private volatile Instant lastEstimateTime;
    private volatile Instant lastLoadTime;
    private volatile Instant lastReapedTime;

    public DelayLoadingQueue(@NotNull ExternalUrlLoader loader, @NotNull UrlTopic topic, @NotNull Duration loadDelay, @NotNull Duration estimateDelay, @NotNull Function1<? super UrlAware, ? extends UrlAware> transformer) {
        Intrinsics.checkNotNullParameter((Object)loader, (String)"loader");
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)loadDelay, (String)"loadDelay");
        Intrinsics.checkNotNullParameter((Object)estimateDelay, (String)"estimateDelay");
        Intrinsics.checkNotNullParameter(transformer, (String)"transformer");
        super(loader, topic, transformer);
        this.loadDelay = loadDelay;
        this.estimateDelay = estimateDelay;
        this.logger = LogsKt.getLogger(Reflection.getOrCreateKotlinClass(DelayLoadingQueue.class));
        this.lastEstimatedExternalSize = -1;
        this.lastEstimateTime = Instant.EPOCH;
        this.lastLoadTime = Instant.EPOCH;
        this.lastReapedTime = Instant.now();
    }

    public /* synthetic */ DelayLoadingQueue(ExternalUrlLoader externalUrlLoader, UrlTopic urlTopic, Duration duration, Duration duration2, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        Duration duration3;
        if ((n & 4) != 0) {
            duration3 = Duration.ofSeconds(3L);
            Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"ofSeconds(3)");
            duration = duration3;
        }
        if ((n & 8) != 0) {
            duration3 = Duration.ofSeconds(3L);
            Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"ofSeconds(3)");
            duration2 = duration3;
        }
        this(externalUrlLoader, urlTopic, duration, duration2, (Function1<? super UrlAware, ? extends UrlAware>)function1);
    }

    @NotNull
    public final Duration getLoadDelay() {
        return this.loadDelay;
    }

    public final void setLoadDelay(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"<set-?>");
        this.loadDelay = duration;
    }

    @NotNull
    public final Duration getEstimateDelay() {
        return this.estimateDelay;
    }

    public final void setEstimateDelay(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"<set-?>");
        this.estimateDelay = duration;
    }

    protected final int getLastEstimatedExternalSize() {
        return this.lastEstimatedExternalSize;
    }

    protected final void setLastEstimatedExternalSize(int n) {
        this.lastEstimatedExternalSize = n;
    }

    protected final Instant getLastEstimateTime() {
        return this.lastEstimateTime;
    }

    protected final void setLastEstimateTime(Instant instant) {
        this.lastEstimateTime = instant;
    }

    protected final Instant getLastLoadTime() {
        return this.lastLoadTime;
    }

    protected final void setLastLoadTime(Instant instant) {
        this.lastLoadTime = instant;
    }

    protected final Instant getLastReapedTime() {
        return this.lastReapedTime;
    }

    protected final void setLastReapedTime(Instant instant) {
        this.lastReapedTime = instant;
    }

    public final Duration getIdleTime() {
        return Duration.between(this.lastReapedTime, Instant.now());
    }

    public final boolean isIdle() {
        return this.getIdleTime().getSeconds() > 60L;
    }

    public final boolean isBusy() {
        return !this.isIdle();
    }

    public final Duration getAdjustedEstimateDelay() {
        return this.isIdle() ? Duration.ofSeconds(15L) : this.estimateDelay;
    }

    public final boolean isExpired() {
        return this.isExpired(this.loadDelay);
    }

    @Override
    public synchronized int getEstimatedExternalSize() {
        return RangesKt.coerceAtLeast((int)this.estimateIfExpired().lastEstimatedExternalSize, (int)0);
    }

    public final boolean isExpired(@NotNull Duration delay) {
        Intrinsics.checkNotNullParameter((Object)delay, (String)"delay");
        return this.lastLoadTime.plus(delay).compareTo(Instant.now()) < 0;
    }

    public final void expire() {
        this.lastLoadTime = Instant.EPOCH;
        this.lastEstimateTime = Instant.EPOCH;
        this.lastReapedTime = Instant.now();
    }

    @Override
    public synchronized void load() {
        if (this.getCacheImplementation().isEmpty() && this.getEstimatedExternalSize() > 0) {
            this.loadNow();
        } else if (this.getFreeSlots() > 0 && this.isExpired()) {
            this.loadNow();
        }
    }

    public final synchronized void load(@NotNull Duration delay) {
        Intrinsics.checkNotNullParameter((Object)delay, (String)"delay");
        if (this.getFreeSlots() > 0 && this.isExpired(delay)) {
            this.loadNow();
        }
    }

    @Override
    @NotNull
    public synchronized Collection<UrlAware> loadNow() {
        Collection<UrlAware> urls;
        Collection<UrlAware> collection;
        if (this.getFreeSlots() <= 0) {
            boolean bl = false;
            return CollectionsKt.emptyList();
        }
        this.lastLoadTime = Instant.now();
        try {
            collection = this;
            ((AbstractLoadingQueue)collection).setLoadCount(((AbstractLoadingQueue)collection).getLoadCount() + 1);
            ((AbstractLoadingQueue)collection).getLoadCount();
            collection = this.getLoader().loadToNow((Collection)this.getCacheImplementation(), this.getFreeSlots(), this.getTopic(), this.getTransformer());
        }
        catch (Exception e) {
            this.logger.warn("Failed to load", (Throwable)e);
            boolean bl = false;
            collection = CollectionsKt.emptyList();
        }
        collection = urls = collection;
        boolean bl = false;
        if (!collection.isEmpty()) {
            this.lastReapedTime = Instant.now();
            this.estimateNow();
        }
        return urls;
    }

    @Override
    @Nullable
    public synchronized UrlAware peek() {
        this.refreshIfNecessary();
        return this.getCacheImplementation().peek();
    }

    @Override
    @Nullable
    public synchronized UrlAware poll() {
        this.refreshIfNecessary();
        return this.getCacheImplementation().poll();
    }

    private final DelayLoadingQueue estimateIfExpired() {
        if (this.lastEstimateTime.plus(this.getAdjustedEstimateDelay()).compareTo(Instant.now()) < 0) {
            this.estimateNow();
        }
        return this;
    }

    private final void estimateNow() {
        this.lastEstimatedExternalSize = this.getExternalSize();
        this.lastEstimateTime = Instant.now();
    }

    private final DelayLoadingQueue refreshIfNecessary() {
        this.estimateIfExpired();
        if (this.getCacheImplementation().isEmpty()) {
            this.load();
        }
        return this;
    }
}

