/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.config;

import ai.platon.pulsar.common.AppContext;
import ai.platon.pulsar.common.measure.ByteUnit;
import java.awt.Dimension;
import java.time.Duration;
import java.time.Instant;

public interface AppConstants {
    public static final String PULSAR_CONTEXT_CONFIG_LOCATION = "classpath*:/pulsar-beans/app-context.xml";
    public static final String SCENT_CONTEXT_CONFIG_LOCATION = "classpath*:/scent-beans/app-context.xml";
    public static final String MAPR_CONTEXT_CONFIG_LOCATION = "classpath*:/mapr/mapr-beans/mapr-context.xml";
    public static final String YES_STRING = "y";
    public static final String CACHING_FORBIDDEN_CONTENT = "content";
    public static final String ALL_BATCHES = "all";
    public static final String ALL_BATCH_ID_STR = "-all";
    public static final Character UNICODE_FIRST_CODE_POINT = Character.valueOf('\u0001');
    public static final Character UNICODE_LAST_CODE_POINT = Character.valueOf('\uffff');
    public static final String SHORTEST_VALID_URL = "ftp://t.tt";
    public static final int SHORTEST_VALID_URL_LENGTH = "ftp://t.tt".length();
    public static final String EXAMPLE_URL = "http://example.com";
    public static final String PSEUDO_URL_BASE = "http://www.pseudo.com";
    public static final String INTERNAL_URL_PREFIX = "http://internal.pulsar.platon.ai";
    public static final String EMPTY_PAGE_URL = "http://internal.pulsar.platon.ai/empty";
    public static final String NIL_PAGE_URL = "http://internal.pulsar.platon.ai/nil";
    public static final String SEED_HOME_URL = "http://internal.pulsar.platon.ai/seeds";
    public static final String SEED_PAGE_1_URL = "http://internal.pulsar.platon.ai/seeds/1";
    public static final String TOP_PAGE_HOME_URL = "http://internal.pulsar.platon.ai/top";
    public static final String TOP_PAGE_PAGE_1_URL = "http://internal.pulsar.platon.ai/top/1";
    public static final String BACKGROUND_TASK_PAGE_HOME_URL = "http://internal.pulsar.platon.ai/tmp/tasks";
    public static final String BACKGROUND_TASK_PAGE_PAGE_1_URL = "http://internal.pulsar.platon.ai/tmp/tasks/1";
    public static final String URL_TRACKER_HOME_URL = "http://internal.pulsar.platon.ai/url/tracker";
    public static final String URL_TRACKER_PAGE_1_URL = "http://internal.pulsar.platon.ai/url/tracker/1";
    public static final String METRICS_HOME_URL = "http://internal.pulsar.platon.ai/metrics";
    public static final String METRICS_PAGE_1_URL = "http://internal.pulsar.platon.ai/metrics/1";
    public static final String CRAWL_LOG_HOME_URL = "http://internal.pulsar.platon.ai/metrics";
    public static final String CRAWL_LOG_INDEX_URL = "http://internal.pulsar.platon.ai/metrics";
    public static final String CRAWL_LOG_PAGE_1_URL = "http://internal.pulsar.platon.ai/metrics/1";
    public static final String MEM_STORE_CLASS = "org.apache.gora.memory.store.MemStore";
    public static final String FILE_BACKEND_STORE_CLASS = "ai.platon.pulsar.persist.gora.FileBackendPageStore";
    public static final String MONGO_STORE_CLASS = "org.apache.gora.mongodb.store.MongoStore";
    public static final String HBASE_STORE_CLASS = "org.apache.gora.hbase.store.HBaseStore";
    public static final int DISTANCE_INFINITE = 10000;
    public static final int FETCH_TASK_REMAINDER_NUMBER = 5;
    public static final int FETCH_PRIORITY_MIN = -100000;
    public static final int FETCH_PRIORITY_ANY = -1;
    public static final int FETCH_PRIORITY_DEFAULT = 10000;
    public static final int FETCH_PRIORITY_DEPTH_BASE = 20000;
    public static final int FETCH_PRIORITY_DEPTH_0 = 20000;
    public static final int FETCH_PRIORITY_DEPTH_1 = 19999;
    public static final int FETCH_PRIORITY_DEPTH_2 = 19998;
    public static final int FETCH_PRIORITY_DEPTH_3 = 19997;
    public static final int FETCH_PRIORITY_EMERGENT_INJECT = 30000;
    public static final int FETCH_PRIORITY_MAX = 100000;
    public static final int FETCH_THREADS = AppContext.INSTANCE.getNCPU();
    public static final String CRAWL_DEPTH_FIRST = "depthFirst";
    public static final String CRAWL_STRICT_DEPTH_FIRST = "strictDepthFirst";
    public static final int PERM_REFRESH_TIME = 5;
    public static final float SCORE_DEFAULT = 1.0f;
    public static final float SCORE_INDEX_PAGE = 1.0f;
    public static final float SCORE_SEED = 1.0f;
    public static final float SCORE_INJECTED = 3.4028234E35f;
    public static final float SCORE_DETAIL_PAGE = 10000.0f;
    public static final float SCORE_PAGES_FROM_SEED = 10000.0f;
    public static final Instant TCP_IP_STANDARDIZED_TIME = Instant.parse("1982-01-01T00:00:00Z");
    public static final Instant MIN_ARTICLE_PUBLISH_TIME = Instant.parse("1995-01-01T00:00:00Z");
    public static final Duration DEFAULT_MAX_PARSE_TIME = Duration.ofSeconds(60L);
    public static final String SCENT_PSEUDO_CSS_ID_MENU = "#scent-pseudo-id-menu";
    public static final String SCENT_PSEUDO_CSS_ID_TITLE = "#scent-pseudo-id-title";
    public static final String DEFAULT_NODE_FEATURE_CALCULATOR = "ai.platon.pulsar.dom.features.NodeFeatureCalculator";
    public static final int MAX_LIVE_LINK_PER_PAGE = 1000;
    public static final int MAX_LINK_PER_PAGE = 4000;
    public static final String CMD_FORCE_GENERATE_SEEDS = "force-generate-seeds";
    public static final String CMD_PROXY_POOL_DUMP = "dump-proxy-pool";
    public static final String CMD_PROXY_FORCE_IDLE = "IPS-force-idle";
    public static final String CMD_PROXY_RECONNECT = "IPS-reconnect";
    public static final String CMD_PROXY_DISCONNECT = "IPS-disconnect";
    public static final String CMD_WEB_DRIVER_CLOSE_ALL = "close-all-web-drivers";
    public static final String CMD_WEB_DRIVER_DELETE_ALL_COOKIES = "delete-all-cookies";
    public static final int BANDWIDTH_INFINITE_M = 10000;
    public static final String INDEXER_WRITE_COMMIT_SIZE = "indexer.write.commit.size";
    public static final String DEFAULT_PULSAR_MASTER_HOST = "0.0.0.0";
    public static final int DEFAULT_PULSAR_MASTER_PORT = 8182;
    public static final String DEFAULT_INDEX_SERVER_HOSTNAME = "master";
    public static final int DEFAULT_INDEX_SERVER_PORT = 8183;
    public static final double BROWSER_TAB_REQUIRED_MEMORY = ByteUnit.GIB.toBytes(1.0);
    public static final double DEFAULT_BROWSER_RESERVED_MEMORY = ByteUnit.GIB.toBytes(5.0);
    public static final double DEFAULT_BROWSER_RESERVED_MEMORY_MIB = ByteUnit.BYTE.toMiB(DEFAULT_BROWSER_RESERVED_MEMORY);
    public static final Dimension DEFAULT_VIEW_PORT = new Dimension(1920, 1080);
    public static final String PULSAR_META_INFORMATION_ID = "PulsarMetaInformation";
    public static final String PULSAR_SCRIPT_SECTION_ID = "PulsarScriptSection";
    public static final String PULSAR_ATTR_HIDDEN = "_h";
    public static final String PULSAR_ATTR_OVERFLOW_HIDDEN = "_oh";
    public static final String PULSAR_ATTR_OVERFLOW_VISIBLE = "_visible";
    public static final String PULSAR_ATTR_ELEMENT_NODE_VI = "vi";
    public static final String PULSAR_ATTR_TEXT_NODE_VI = "tv";
    public static final String PULSAR_ATTR_ELEMENT_NODE_STYLE = "st";
    public static final String CLIENT_JS_PROPERTY_NAMES = "font-size, color, background-color";
    public static final int PROXY_SERVER_PORT_BASE = 8584;
    public static final String DEFAULT_METRICS_NAME = "pulsar";
    public static final String H2_SESSION_FACTORY = "ai.platon.pulsar.ql.h2.H2SessionFactory";
}

