/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common;

import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 /2\u00020\u0001:\u0001/B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001dH\u0002J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020 H\u0002J\u0014\u0010#\u001a\u00020\u001d2\n\u0010$\u001a\u00060%j\u0002`&H\u0002J\n\u0010'\u001a\u0004\u0018\u00010\u0019H\u0002J*\u0010(\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020\u00052\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020 2\n\b\u0002\u0010*\u001a\u0004\u0018\u00010+J.\u0010(\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020\u00052\n\u0010,\u001a\u0006\u0012\u0002\b\u00030-2\u0006\u0010\"\u001a\u00020 2\n\b\u0002\u0010*\u001a\u0004\u0018\u00010+J\u000e\u0010(\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020 J\u001c\u0010.\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020 2\n\b\u0002\u0010*\u001a\u0004\u0018\u00010+H\u0002R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lai/platon/pulsar/common/MessageWriter;", "Ljava/lang/AutoCloseable;", "path", "Ljava/nio/file/Path;", "levelFile", "", "(Ljava/nio/file/Path;I)V", "checkSize", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "dateFormat", "Ljava/text/SimpleDateFormat;", "fileWriter", "Ljava/io/Writer;", "getLevelFile", "()I", "setLevelFile", "(I)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "maxFileSize", "getPath", "()Ljava/nio/file/Path;", "printWriter", "Ljava/io/PrintWriter;", "writingError", "", "close", "", "closeWriter", "format", "", "module", "s", "logWritingError", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "openWriter", "write", "level", "t", "", "clazz", "Lkotlin/reflect/KClass;", "writeFile", "Companion", "pulsar-common"})
public final class MessageWriter
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path path;
    private int levelFile;
    private final Logger log;
    private int maxFileSize;
    @NotNull
    private SimpleDateFormat dateFormat;
    @Nullable
    private Writer fileWriter;
    @Nullable
    private PrintWriter printWriter;
    private int checkSize;
    @NotNull
    private final AtomicBoolean closed;
    private boolean writingError;
    public static final int OFF = 0;
    public static final int ERROR = 1;
    public static final int WARN = 2;
    public static final int INFO = 3;
    public static final int DEBUG = 4;
    private static final int DEFAULT_LOG_LEVEL = 3;
    private static final int DEFAULT_MAX_FILE_SIZE = 0x4000000;
    private static final int CHECK_SIZE_EACH_WRITES = 4096;

    public MessageWriter(@NotNull Path path, int levelFile) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.path = path;
        this.levelFile = levelFile;
        this.log = LoggerFactory.getLogger(MessageWriter.class);
        this.maxFileSize = DEFAULT_MAX_FILE_SIZE;
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss ");
        this.closed = new AtomicBoolean();
    }

    public /* synthetic */ MessageWriter(Path path, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = DEFAULT_LOG_LEVEL;
        }
        this(path, n);
    }

    @NotNull
    public final Path getPath() {
        return this.path;
    }

    public final int getLevelFile() {
        return this.levelFile;
    }

    public final void setLevelFile(int n) {
        this.levelFile = n;
    }

    public final void write(@NotNull String s2) {
        Intrinsics.checkNotNullParameter((Object)s2, (String)"s");
        MessageWriter.writeFile$default(this, s2, null, 2, null);
    }

    public final void write(int level, @NotNull KClass<?> clazz, @NotNull String s2, @Nullable Throwable t) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)s2, (String)"s");
        if (level > this.levelFile) {
            return;
        }
        String string = clazz.getSimpleName();
        this.write(level, string == null ? "" : string, s2, t);
    }

    public static /* synthetic */ void write$default(MessageWriter messageWriter, int n, KClass kClass, String string, Throwable throwable, int n2, Object object) {
        if ((n2 & 8) != 0) {
            throwable = null;
        }
        messageWriter.write(n, kClass, string, throwable);
    }

    public final void write(int level, @NotNull String module, @NotNull String s2, @Nullable Throwable t) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)s2, (String)"s");
        if (level > this.levelFile) {
            return;
        }
        this.writeFile(this.format(module, s2), t);
    }

    public static /* synthetic */ void write$default(MessageWriter messageWriter, int n, String string, String string2, Throwable throwable, int n2, Object object) {
        if ((n2 & 8) != 0) {
            throwable = null;
        }
        messageWriter.write(n, string, string2, throwable);
    }

    private final synchronized String format(String module, String s2) {
        return this.dateFormat.format(System.currentTimeMillis()) + module + ": " + s2;
    }

    private final synchronized void writeFile(String s2, Throwable t) {
        try {
            Object old;
            MessageWriter messageWriter = this;
            int n = messageWriter.checkSize;
            messageWriter.checkSize = n + 1;
            if (n >= CHECK_SIZE_EACH_WRITES) {
                this.checkSize = 0;
                this.closeWriter();
                if (this.maxFileSize > 0 && Files.size(this.path) > (long)this.maxFileSize) {
                    old = Paths.get(this.path + ".old", new String[0]);
                    CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                    Files.move(this.path, (Path)old, copyOptionArray);
                }
            }
            if ((old = this.openWriter()) != null) {
                PrintWriter printWriter = old;
                boolean bl = false;
                boolean bl2 = false;
                PrintWriter it = printWriter;
                boolean bl3 = false;
                it.println(s2);
                Throwable throwable = t;
                if (throwable != null) {
                    throwable.printStackTrace(it);
                }
            }
        }
        catch (Exception e) {
            this.logWritingError(e);
        }
    }

    static /* synthetic */ void writeFile$default(MessageWriter messageWriter, String string, Throwable throwable, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        messageWriter.writeFile(string, throwable);
    }

    private final void logWritingError(Exception e) {
        if (this.writingError) {
            return;
        }
        this.writingError = true;
        e.printStackTrace();
        this.writingError = false;
    }

    private final PrintWriter openWriter() {
        if (this.printWriter == null) {
            try {
                Files.createDirectories(this.path.getParent(), new FileAttribute[0]);
                OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.APPEND};
                Writer writer = this.fileWriter = (Writer)Files.newBufferedWriter(this.path, openOptionArray);
                Intrinsics.checkNotNull((Object)writer);
                this.printWriter = new PrintWriter(writer, true);
            }
            catch (Exception e) {
                this.logWritingError(e);
                return null;
            }
        }
        return this.printWriter;
    }

    private final synchronized void closeWriter() {
        this.log.info("Closing writer | " + this.path);
        Writer writer = this.printWriter;
        if (writer != null) {
            ((PrintWriter)writer).flush();
        }
        writer = this.printWriter;
        if (writer != null) {
            ((PrintWriter)writer).close();
        }
        writer = this.fileWriter;
        if (writer != null) {
            writer.close();
        }
        this.printWriter = null;
        this.fileWriter = null;
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.closeWriter();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lai/platon/pulsar/common/MessageWriter$Companion;", "", "()V", "CHECK_SIZE_EACH_WRITES", "", "DEBUG", "DEFAULT_LOG_LEVEL", "getDEFAULT_LOG_LEVEL", "()I", "DEFAULT_MAX_FILE_SIZE", "ERROR", "INFO", "OFF", "WARN", "pulsar-common"})
    public static final class Companion {
        private Companion() {
        }

        public final int getDEFAULT_LOG_LEVEL() {
            return DEFAULT_LOG_LEVEL;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

