/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common;

import ai.platon.pulsar.common.TrieStringMatcher;
import java.util.Collection;
import java.util.Iterator;

public class SuffixStringMatcher
extends TrieStringMatcher {
    public SuffixStringMatcher(String[] suffixes) {
        for (int i = 0; i < suffixes.length; ++i) {
            this.addPatternBackward(suffixes[i]);
        }
    }

    public SuffixStringMatcher(Collection<String> suffixes) {
        Iterator<String> iter = suffixes.iterator();
        while (iter.hasNext()) {
            this.addPatternBackward(iter.next());
        }
    }

    public static final void main(String[] argv) {
        SuffixStringMatcher matcher = new SuffixStringMatcher(new String[]{"a", "abcd", "bcd", "bcdefg", "defg", "aac", "baz", "foo", "foobar"});
        String[] tests = new String[]{"a", "ac", "abcd", "abcdefg", "apple", "aa", "aac", "aaccca", "abaz", "baz", "bazooka", "fo", "foobar", "kite"};
        for (int i = 0; i < tests.length; ++i) {
            System.out.println("testing: " + tests[i]);
            System.out.println("   matches: " + matcher.matches(tests[i]));
            System.out.println("  shortest: " + matcher.shortestMatch(tests[i]));
            System.out.println("   longest: " + matcher.longestMatch(tests[i]));
        }
    }

    @Override
    public boolean matches(String input) {
        TrieStringMatcher.TrieNode node = this.root;
        for (int i = input.length() - 1; i >= 0; --i) {
            if ((node = node.getChild(input.charAt(i))) == null) {
                return false;
            }
            if (!node.isTerminal()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String shortestMatch(String input) {
        TrieStringMatcher.TrieNode node = this.root;
        for (int i = input.length() - 1; i >= 0; --i) {
            if ((node = node.getChild(input.charAt(i))) == null) {
                return null;
            }
            if (!node.isTerminal()) continue;
            return input.substring(i);
        }
        return null;
    }

    @Override
    public String longestMatch(String input) {
        TrieStringMatcher.TrieNode node = this.root;
        String result = null;
        for (int i = input.length() - 1; i >= 0 && (node = node.getChild(input.charAt(i))) != null; --i) {
            if (!node.isTerminal()) continue;
            result = input.substring(i);
        }
        return result;
    }
}

