/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.collect;

import ai.platon.pulsar.common.collect.AbstractUrlCache;
import ai.platon.pulsar.common.collect.ExternalUrlLoader;
import ai.platon.pulsar.common.collect.Loadable;
import ai.platon.pulsar.common.collect.UrlTopic;
import ai.platon.pulsar.common.collect.queue.ConcurrentLoadingQueue;
import ai.platon.pulsar.common.collect.queue.ConcurrentNEntrantLoadingQueue;
import ai.platon.pulsar.common.collect.queue.ConcurrentNonReentrantLoadingQueue;
import ai.platon.pulsar.common.collect.queue.DelayLoadingQueue;
import ai.platon.pulsar.common.collect.queue.LoadingQueue;
import ai.platon.pulsar.common.urls.UrlAware;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 -2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0001-B'\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bJ\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020&H\u0016J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00030)H\u0016J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u0007H\u0002R\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0010\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\rR\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R \u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u001c0\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020 X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\u00a8\u0006."}, d2={"Lai/platon/pulsar/common/collect/LoadingUrlCache;", "Lai/platon/pulsar/common/collect/AbstractUrlCache;", "Lai/platon/pulsar/common/collect/Loadable;", "Lai/platon/pulsar/common/urls/UrlAware;", "name", "", "priority", "", "urlLoader", "Lai/platon/pulsar/common/collect/ExternalUrlLoader;", "capacity", "(Ljava/lang/String;ILai/platon/pulsar/common/collect/ExternalUrlLoader;I)V", "getCapacity", "()I", "estimatedExternalSize", "getEstimatedExternalSize", "externalSize", "getExternalSize", "nReentrantQueue", "Lai/platon/pulsar/common/collect/queue/ConcurrentNEntrantLoadingQueue;", "getNReentrantQueue", "()Lai/platon/pulsar/common/collect/queue/ConcurrentNEntrantLoadingQueue;", "nonReentrantQueue", "Lai/platon/pulsar/common/collect/queue/ConcurrentNonReentrantLoadingQueue;", "getNonReentrantQueue", "()Lai/platon/pulsar/common/collect/queue/ConcurrentNonReentrantLoadingQueue;", "queues", "", "Ljava/util/Queue;", "getQueues", "()Ljava/util/List;", "reentrantQueue", "Lai/platon/pulsar/common/collect/queue/ConcurrentLoadingQueue;", "getReentrantQueue", "()Lai/platon/pulsar/common/collect/queue/ConcurrentLoadingQueue;", "getUrlLoader", "()Lai/platon/pulsar/common/collect/ExternalUrlLoader;", "deepClear", "", "load", "loadNow", "", "topic", "Lai/platon/pulsar/common/collect/UrlTopic;", "group", "Companion", "pulsar-common"})
public final class LoadingUrlCache
extends AbstractUrlCache
implements Loadable<UrlAware> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExternalUrlLoader urlLoader;
    private final int capacity;
    @NotNull
    private final ConcurrentNonReentrantLoadingQueue nonReentrantQueue;
    @NotNull
    private final ConcurrentNEntrantLoadingQueue nReentrantQueue;
    @NotNull
    private final ConcurrentLoadingQueue reentrantQueue;
    public static final int G_NON_REENTRANT = 1;
    public static final int G_N_ENTRANT = 2;
    public static final int G_REENTRANT = 3;

    public LoadingUrlCache(@NotNull String name, int priority, @NotNull ExternalUrlLoader urlLoader, int capacity) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)urlLoader, (String)"urlLoader");
        super(name, priority);
        this.urlLoader = urlLoader;
        this.capacity = capacity;
        this.nonReentrantQueue = new ConcurrentNonReentrantLoadingQueue(this.urlLoader, this.topic(1), null, null, 12, null);
        this.nReentrantQueue = new ConcurrentNEntrantLoadingQueue(this.urlLoader, this.topic(2), 3, null, null, 24, null);
        this.reentrantQueue = new ConcurrentLoadingQueue(this.urlLoader, this.topic(3), null, 4, null);
    }

    public /* synthetic */ LoadingUrlCache(String string, int n, ExternalUrlLoader externalUrlLoader, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 8) != 0) {
            n2 = 200;
        }
        this(string, n, externalUrlLoader, n2);
    }

    @NotNull
    public final ExternalUrlLoader getUrlLoader() {
        return this.urlLoader;
    }

    public final int getCapacity() {
        return this.capacity;
    }

    @NotNull
    public ConcurrentNonReentrantLoadingQueue getNonReentrantQueue() {
        return this.nonReentrantQueue;
    }

    @NotNull
    public ConcurrentNEntrantLoadingQueue getNReentrantQueue() {
        return this.nReentrantQueue;
    }

    @NotNull
    public ConcurrentLoadingQueue getReentrantQueue() {
        return this.reentrantQueue;
    }

    @Override
    @NotNull
    public List<Queue<UrlAware>> getQueues() {
        Object[] objectArray = new DelayLoadingQueue[]{this.getNonReentrantQueue(), this.getNReentrantQueue(), this.getReentrantQueue()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getExternalSize() {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = this.getQueues();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof LoadingQueue)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable iterable2 = (List)destination$iv$iv;
        boolean bl = false;
        int n = 0;
        for (Object t : iterable2) {
            void it;
            LoadingQueue loadingQueue = (LoadingQueue)t;
            int n2 = n;
            boolean bl2 = false;
            int n3 = it.getExternalSize();
            n = n2 + n3;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getEstimatedExternalSize() {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = this.getQueues();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof LoadingQueue)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable iterable2 = (List)destination$iv$iv;
        boolean bl = false;
        int n = 0;
        for (Object t : iterable2) {
            void it;
            LoadingQueue loadingQueue = (LoadingQueue)t;
            int n2 = n;
            boolean bl2 = false;
            int n3 = it.getEstimatedExternalSize();
            n = n2 + n3;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void load() {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = this.getQueues();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof Loadable)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Loadable it = (Loadable)element$iv;
            boolean bl = false;
            it.load();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<UrlAware> loadNow() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = this.getQueues();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof Loadable)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterIsInstanceTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Loadable it = (Loadable)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.loadNow();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void deepClear() {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = this.getQueues();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof LoadingQueue)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LoadingQueue it = (LoadingQueue)element$iv;
            boolean bl = false;
            it.deepClear();
        }
    }

    private final UrlTopic topic(int group) {
        return new UrlTopic(this.getName(), group, this.getPriority(), this.capacity);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lai/platon/pulsar/common/collect/LoadingUrlCache$Companion;", "", "()V", "G_NON_REENTRANT", "", "G_N_ENTRANT", "G_REENTRANT", "pulsar-common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

