/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.concurrent;

import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0017\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0005J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\b2\b\b\u0002\u0010\u0013\u001a\u00020\bR\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lai/platon/pulsar/common/concurrent/ExpiringItem;", "T", "", "datum", "instant", "Ljava/time/Instant;", "(Ljava/lang/Object;Ljava/time/Instant;)V", "timestamp", "", "(Ljava/lang/Object;J)V", "getDatum", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getTimestamp", "()J", "isExpired", "", "expires", "Ljava/time/Duration;", "now", "expireMillis", "pulsar-common"})
public final class ExpiringItem<T> {
    private final T datum;
    private final long timestamp;

    public ExpiringItem(T datum, long timestamp) {
        this.datum = datum;
        this.timestamp = timestamp;
    }

    public /* synthetic */ ExpiringItem(Object object, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            l = System.currentTimeMillis();
        }
        this(object, l);
    }

    public final T getDatum() {
        return this.datum;
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    public ExpiringItem(T datum, @NotNull Instant instant) {
        Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
        this(datum, instant.toEpochMilli());
    }

    public final boolean isExpired(@NotNull Duration expires, @NotNull Instant now) {
        Intrinsics.checkNotNullParameter((Object)expires, (String)"expires");
        Intrinsics.checkNotNullParameter((Object)now, (String)"now");
        return this.timestamp + expires.toMillis() < now.toEpochMilli();
    }

    public static /* synthetic */ boolean isExpired$default(ExpiringItem expiringItem, Duration duration, Instant instant, int n, Object object) {
        if ((n & 2) != 0) {
            Instant instant2 = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"now()");
            instant = instant2;
        }
        return expiringItem.isExpired(duration, instant);
    }

    public final boolean isExpired(long expireMillis, long now) {
        return this.timestamp + expireMillis < now;
    }

    public static /* synthetic */ boolean isExpired$default(ExpiringItem expiringItem, long l, long l2, int n, Object object) {
        if ((n & 2) != 0) {
            l2 = System.currentTimeMillis();
        }
        return expiringItem.isExpired(l, l2);
    }
}

