/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.config;

import ai.platon.pulsar.common.config.AbstractConfiguration;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.config.MutableConfig;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 42\u00020\u0001:\u00014B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B+\b\u0016\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t\u00a2\u0006\u0002\u0010\nB\u000f\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0019\u001a\u00020\u0007H\u0096\u0002J\u0019\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0007H\u0096\u0002J \u0010\u001b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0013J!\u0010\u001e\u001a\u0004\u0018\u0001H\u001f\"\u0004\b\u0000\u0010\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u001f0!\u00a2\u0006\u0002\u0010\"J)\u0010\u001e\u001a\u0004\u0018\u0001H\u001f\"\u0004\b\u0000\u0010\u001f2\u0006\u0010\u0019\u001a\u00020\u00072\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u001f0!\u00a2\u0006\u0002\u0010#J-\u0010\u001e\u001a\u0004\u0018\u0001H\u001f\"\b\b\u0000\u0010\u001f*\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u00072\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u001f0$\u00a2\u0006\u0002\u0010%J%\u0010\u001e\u001a\u0004\u0018\u0001H\u001f\"\b\b\u0000\u0010\u001f*\u00020\u00152\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u001f0$\u00a2\u0006\u0002\u0010&J\u000e\u0010'\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0007J\u0012\u0010(\u001a\u0004\u0018\u00010\u00152\b\u0010\u0019\u001a\u0004\u0018\u00010\u0007J\u0010\u0010)\u001a\u00020\u00042\u0006\u0010*\u001a\u00020\u0007H\u0016J\u001f\u0010+\u001a\u0004\u0018\u00010\u0015\"\b\b\u0000\u0010\u001f*\u00020\u00152\u0006\u0010 \u001a\u0002H\u001f\u00a2\u0006\u0002\u0010,J'\u0010+\u001a\u0004\u0018\u00010\u0015\"\b\b\u0000\u0010\u001f*\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010 \u001a\u0002H\u001f\u00a2\u0006\u0002\u0010-J\u001f\u0010.\u001a\u0004\u0018\u00010\u0015\"\b\b\u0000\u0010\u001f*\u00020\u00152\u0006\u0010 \u001a\u0002H\u001f\u00a2\u0006\u0002\u0010,J\u001a\u0010.\u001a\u0004\u0018\u00010\u0015\"\b\b\u0000\u0010\u001f*\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0007J\u0006\u0010/\u001a\u000200J!\u00101\u001a\u0002002\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0013H\u0086\u0002J\u0018\u00102\u001a\u0002002\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0013H\u0016J\u0016\u00103\u001a\u0002002\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0015R\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\rR\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00150\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u00065"}, d2={"Lai/platon/pulsar/common/config/VolatileConfig;", "Lai/platon/pulsar/common/config/MutableConfig;", "()V", "loadDefaults", "", "(Z)V", "profile", "", "resources", "", "(Ljava/lang/String;ZLjava/lang/Iterable;)V", "fallbackConfig", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/common/config/ImmutableConfig;)V", "getFallbackConfig", "()Lai/platon/pulsar/common/config/ImmutableConfig;", "setFallbackConfig", "ttls", "", "", "variables", "", "getVariables", "()Ljava/util/Map;", "get", "name", "defaultValue", "getAndSet", "value", "ttl", "getBean", "T", "bean", "Ljava/lang/Class;", "(Ljava/lang/Class;)Ljava/lang/Object;", "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "Lkotlin/reflect/KClass;", "(Ljava/lang/String;Lkotlin/reflect/KClass;)Ljava/lang/Object;", "(Lkotlin/reflect/KClass;)Ljava/lang/Object;", "getTTL", "getVariable", "isExpired", "key", "putBean", "(Ljava/lang/Object;)Ljava/lang/Object;", "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", "removeBean", "reset", "", "set", "setTTL", "setVariable", "Companion", "pulsar-common"})
public class VolatileConfig
extends MutableConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private ImmutableConfig fallbackConfig;
    @NotNull
    private final Map<String, Integer> ttls;
    @NotNull
    private final Map<String, Object> variables;
    @NotNull
    private static final VolatileConfig EMPTY = new VolatileConfig();
    @NotNull
    private static final VolatileConfig UNSAFE = new VolatileConfig();

    @Nullable
    public final ImmutableConfig getFallbackConfig() {
        return this.fallbackConfig;
    }

    public final void setFallbackConfig(@Nullable ImmutableConfig immutableConfig) {
        this.fallbackConfig = immutableConfig;
    }

    @NotNull
    public final Map<String, Object> getVariables() {
        return this.variables;
    }

    public VolatileConfig() {
        boolean bl = false;
        this("", false, CollectionsKt.emptyList());
    }

    public VolatileConfig(boolean loadDefaults) {
        String string = System.getProperty("legacy.config.profile", "");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(CapabilityTy\u2026EGACY_CONFIG_PROFILE, \"\")");
        this(string, loadDefaults, null, 4, null);
    }

    public VolatileConfig(@NotNull String profile, boolean loadDefaults, @NotNull Iterable<String> resources) {
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        Intrinsics.checkNotNullParameter(resources, (String)"resources");
        super(profile, loadDefaults, resources);
        this.ttls = new ConcurrentHashMap();
        this.variables = new ConcurrentHashMap();
    }

    public /* synthetic */ VolatileConfig(String string, boolean bl, Iterable iterable, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            String string2 = System.getProperty("legacy.config.profile", "");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProperty(CapabilityTy\u2026EGACY_CONFIG_PROFILE, \"\")");
            string = string2;
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            iterable = AbstractConfiguration.Companion.getDEFAULT_RESOURCES();
        }
        this(string, bl, iterable);
    }

    public VolatileConfig(@NotNull ImmutableConfig fallbackConfig) {
        Intrinsics.checkNotNullParameter((Object)fallbackConfig, (String)"fallbackConfig");
        this("", false, null, 4, null);
        this.fallbackConfig = fallbackConfig;
        if (fallbackConfig instanceof VolatileConfig) {
            this.ttls.putAll(((VolatileConfig)fallbackConfig).ttls);
            this.variables.putAll(((VolatileConfig)fallbackConfig).variables);
        }
    }

    public final void reset() {
        this.ttls.clear();
        this.variables.clear();
        super.clear();
    }

    @Override
    @NotNull
    public String get(@NotNull String name, @NotNull String defaultValue) {
        String string;
        ImmutableConfig immutableConfig;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
        String value = super.get(name);
        if (value != null) {
            if (!this.isExpired(name)) {
                return super.get(name, defaultValue);
            }
            if (this.getLogger().isTraceEnabled()) {
                this.getLogger().trace("Session config (with default) {} is expired", (Object)name);
            }
            this.ttls.remove(name);
            super.unset(name);
        }
        return (immutableConfig = this.fallbackConfig) == null ? defaultValue : ((string = immutableConfig.get(name, defaultValue)) == null ? defaultValue : string);
    }

    @Override
    @Nullable
    public String get(@NotNull String name) {
        ImmutableConfig immutableConfig;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String value = super.get(name);
        if (value != null) {
            if (!this.isExpired(name)) {
                return value;
            }
            if (this.getLogger().isTraceEnabled()) {
                this.getLogger().trace("Session config {} is expired", (Object)name);
            }
            this.ttls.remove(name);
            super.unset(name);
        }
        return (immutableConfig = this.fallbackConfig) == null ? null : immutableConfig.get(name);
    }

    public final void set(@NotNull String name, @NotNull String value, int ttl) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.setTTL(name, ttl);
        super.set(name, value);
    }

    @Nullable
    public final String getAndSet(@NotNull String name, @NotNull String value, int ttl) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String old = this.get(name);
        if (old != null) {
            this.set(name, value, ttl);
        }
        return old;
    }

    public final int getTTL(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return ((Number)this.ttls.getOrDefault(name, Integer.MAX_VALUE)).intValue();
    }

    public void setTTL(@NotNull String name, int ttl) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (ttl > 0) {
            Map<String, Integer> map = this.ttls;
            Integer n = ttl;
            boolean bl = false;
            map.put(name, n);
        } else {
            this.ttls.remove(name);
            super.unset(name);
        }
    }

    @Nullable
    public final <T> Object putBean(@NotNull T bean) {
        Intrinsics.checkNotNullParameter(bean, (String)"bean");
        String string = bean.getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"bean.javaClass.name");
        return this.putBean(string, bean);
    }

    @Nullable
    public final <T> Object putBean(@NotNull String name, @NotNull T bean) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(bean, (String)"bean");
        return this.variables.put(name, bean);
    }

    @Nullable
    public final <T> T getBean(@NotNull Class<T> bean) {
        T obj;
        block2: {
            T t;
            Intrinsics.checkNotNullParameter(bean, (String)"bean");
            Iterable $this$firstOrNull$iv = this.variables.values();
            boolean $i$f$firstOrNull = false;
            Iterator iterator = $this$firstOrNull$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator.next();
                boolean bl = false;
                if (!bean.isAssignableFrom(it.getClass())) continue;
                t = element$iv;
                break block2;
            }
            t = obj = null;
        }
        if (obj == null) {
            // empty if block
        }
        return obj;
    }

    @Nullable
    public final <T> T getBean(@NotNull KClass<T> bean) {
        T t;
        block1: {
            Intrinsics.checkNotNullParameter(bean, (String)"bean");
            Iterable $this$firstOrNull$iv = this.variables.values();
            boolean $i$f$firstOrNull = false;
            Iterator iterator = $this$firstOrNull$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator.next();
                boolean bl = false;
                if (!JvmClassMappingKt.getJavaClass(bean).isAssignableFrom(it.getClass())) continue;
                t = element$iv;
                break block1;
            }
            t = null;
        }
        T obj = t;
        return obj != null ? obj : null;
    }

    @Nullable
    public final <T> T getBean(@NotNull String name, @NotNull Class<T> bean) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(bean, (String)"bean");
        Object obj = this.variables.get(name);
        return (T)(obj != null && bean.isAssignableFrom(obj.getClass()) ? obj : null);
    }

    @Nullable
    public final <T> T getBean(@NotNull String name, @NotNull KClass<T> bean) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(bean, (String)"bean");
        return this.getBean(name, JvmClassMappingKt.getJavaClass(bean));
    }

    @Nullable
    public final <T> Object removeBean(@NotNull T bean) {
        Intrinsics.checkNotNullParameter(bean, (String)"bean");
        return this.variables.remove(bean.getClass().getName());
    }

    @Nullable
    public final <T> Object removeBean(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.variables.remove(name);
    }

    @Nullable
    public final Object getVariable(@Nullable String name) {
        Map<String, Object> map = this.variables;
        boolean bl = false;
        return map.get(name);
    }

    public final void setVariable(@NotNull String name, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Map<String, Object> map = this.variables;
        boolean bl = false;
        map.put(name, value);
    }

    public boolean isExpired(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return false;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lai/platon/pulsar/common/config/VolatileConfig$Companion;", "", "()V", "EMPTY", "Lai/platon/pulsar/common/config/VolatileConfig;", "getEMPTY", "()Lai/platon/pulsar/common/config/VolatileConfig;", "UNSAFE", "getUNSAFE", "pulsar-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VolatileConfig getEMPTY() {
            return EMPTY;
        }

        @NotNull
        public final VolatileConfig getUNSAFE() {
            return UNSAFE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

