/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class CommandRunner {
    private static final int BUF = 4096;
    private boolean waitForExit = true;
    private String command;
    private int timeout = 10;
    private InputStream stdin;
    private OutputStream stdout;
    private OutputStream stderr;
    private int xit;
    private Throwable _thrownError;
    private CyclicBarrier barrier;

    public int getExitValue() {
        return this.xit;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String s2) {
        this.command = s2;
    }

    public void setInputStream(InputStream is) {
        this.stdin = is;
    }

    public void setStdOutputStream(OutputStream os) {
        this.stdout = os;
    }

    public void setStdErrorStream(OutputStream os) {
        this.stderr = os;
    }

    public void evaluate() throws IOException {
        this.exec();
    }

    public int exec() throws IOException {
        Process proc = Runtime.getRuntime().exec(this.command);
        this.barrier = new CyclicBarrier(3 + (this.stdin != null ? 1 : 0));
        PullerThread so = new PullerThread("STDOUT", proc.getInputStream(), this.stdout);
        so.setDaemon(true);
        so.start();
        PullerThread se = new PullerThread("STDERR", proc.getErrorStream(), this.stderr);
        se.setDaemon(true);
        se.start();
        PusherThread si = null;
        if (this.stdin != null) {
            si = new PusherThread("STDIN", this.stdin, proc.getOutputStream());
            si.setDaemon(true);
            si.start();
        }
        boolean timedout = false;
        long end = System.currentTimeMillis() + (long)(this.timeout * 1000);
        try {
            if (this.timeout == 0) {
                this.barrier.await();
            } else {
                this.barrier.await(this.timeout, TimeUnit.SECONDS);
            }
        }
        catch (TimeoutException ex) {
            timedout = true;
        }
        catch (InterruptedException | BrokenBarrierException ex) {
            // empty catch block
        }
        if (si != null) {
            si.interrupt();
        }
        so.interrupt();
        se.interrupt();
        this.xit = -1;
        if (!timedout) {
            if (this.waitForExit) {
                do {
                    try {
                        Thread.sleep(1000L);
                        this.xit = proc.exitValue();
                        break;
                    }
                    catch (InterruptedException ie) {
                        if (!Thread.interrupted()) continue;
                        break;
                    }
                    catch (IllegalThreadStateException iltse) {
                        // empty catch block
                    }
                } while (!(timedout = System.currentTimeMillis() > end));
            } else {
                try {
                    this.xit = proc.exitValue();
                }
                catch (IllegalThreadStateException iltse) {
                    timedout = true;
                }
            }
        }
        if (this.waitForExit) {
            proc.destroy();
        }
        return this.xit;
    }

    public Throwable getThrownError() {
        return this._thrownError;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public boolean getWaitForExit() {
        return this.waitForExit;
    }

    public void setWaitForExit(boolean waitForExit) {
        this.waitForExit = waitForExit;
    }

    public static void main(String[] args) throws Exception {
        String commandPath = null;
        String filePath = null;
        int timeout = 10;
        String usage = "Usage: CommandRunner [-timeout timeoutSecs] commandPath filePath";
        if (args.length < 2) {
            System.err.println(usage);
            System.exit(-1);
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-timeout")) {
                timeout = Integer.parseInt(args[++i]);
                continue;
            }
            if (i != args.length - 2) {
                System.err.println(usage);
                System.exit(-1);
                continue;
            }
            commandPath = args[i];
            filePath = args[++i];
        }
        CommandRunner cr = new CommandRunner();
        cr.setCommand(commandPath);
        cr.setInputStream(new FileInputStream(filePath));
        cr.setStdErrorStream(System.err);
        cr.setStdOutputStream(System.out);
        cr.setTimeout(timeout);
        cr.evaluate();
        System.err.println("output value: " + cr.getExitValue());
    }

    private class PullerThread
    extends PumperThread {
        PullerThread(String name, InputStream is, OutputStream os) {
            super(name, is, os, true);
        }
    }

    private class PusherThread
    extends PumperThread {
        PusherThread(String name, InputStream is, OutputStream os) {
            super(name, is, os, false);
        }
    }

    private class PumperThread
    extends Thread {
        private OutputStream _os;
        private InputStream _is;
        private boolean _closeInput;

        protected PumperThread(String name, InputStream is, OutputStream os, boolean closeInput) {
            super(name);
            this._is = is;
            this._os = os;
            this._closeInput = closeInput;
        }

        @Override
        public void run() {
            try {
                byte[] buf = new byte[4096];
                int read = 0;
                while (!this.isInterrupted() && (read = this._is.read(buf)) != -1) {
                    if (read == 0) continue;
                    this._os.write(buf, 0, read);
                    this._os.flush();
                }
            }
            catch (InterruptedIOException buf) {
            }
            catch (Throwable t) {
                CommandRunner.this._thrownError = t;
            }
            finally {
                try {
                    if (this._closeInput) {
                        this._is.close();
                    } else {
                        this._os.close();
                    }
                }
                catch (IOException buf) {}
            }
            try {
                CommandRunner.this.barrier.await();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (BrokenBarrierException brokenBarrierException) {
                // empty catch block
            }
        }
    }
}

