/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common;

import ai.platon.pulsar.common.BinaryTreeNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0005\u001a\u00020\u0004\"\f\b\u0000\u0010\u0006*\u0006\u0012\u0002\b\u00030\u00072\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u0002H\u0006\u0018\u00010\tH\u0002J\"\u0010\n\u001a\u00020\u000b\"\f\b\u0000\u0010\u0006*\u0006\u0012\u0002\b\u00030\u00072\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00060\tJ<\u0010\r\u001a\u00020\u000b\"\f\b\u0000\u0010\u0006*\u0006\u0012\u0002\b\u00030\u00072\u0014\u0010\u000e\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u0002H\u0006\u0018\u00010\t0\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0002J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lai/platon/pulsar/common/BTreePrinter;", "", "()V", "maxFloor", "", "depthOf", "T", "", "node", "Lai/platon/pulsar/common/BinaryTreeNode;", "print", "", "root", "printBinaryTreeNodeInternal", "nodes", "", "level", "depth", "printWhitespaces", "count", "pulsar-common"})
public final class BTreePrinter {
    @NotNull
    public static final BTreePrinter INSTANCE = new BTreePrinter();
    public static final int maxFloor = 1;

    private BTreePrinter() {
    }

    public final <T extends Comparable<?>> void print(@NotNull BinaryTreeNode<T> root) {
        Intrinsics.checkNotNullParameter(root, (String)"root");
        INSTANCE.printBinaryTreeNodeInternal(CollectionsKt.listOf(root), 1, INSTANCE.depthOf(root));
    }

    private final <T extends Comparable<?>> void printBinaryTreeNodeInternal(List<BinaryTreeNode<T>> nodes, int level, int depth) {
        block16: {
            block15: {
                boolean bl;
                block14: {
                    if (nodes.isEmpty()) break block15;
                    Iterable $this$all$iv = nodes;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            BinaryTreeNode it = (BinaryTreeNode)element$iv;
                            boolean bl2 = false;
                            if (it == null) continue;
                            bl = false;
                            break block14;
                        }
                        bl = true;
                    }
                }
                if (!bl) break block16;
            }
            return;
        }
        int floor = depth - level;
        boolean edgeLines = true;
        int firstSpaces = 1;
        boolean betweenSpaces = true;
        INSTANCE.printWhitespaces(firstSpaces);
        ArrayList<BinaryTreeNode<T>> newBinaryTreeNodes = new ArrayList<BinaryTreeNode<T>>();
        for (BinaryTreeNode<T> node : nodes) {
            if (node != null) {
                System.out.print((Object)node.getData().toString());
                INSTANCE.printWhitespaces(2);
                newBinaryTreeNodes.add(node.getLeft());
                newBinaryTreeNodes.add(node.getRight());
                continue;
            }
            newBinaryTreeNodes.add(null);
            newBinaryTreeNodes.add(null);
        }
        int i = 1;
        while (true) {
            int n = nodes.size();
            for (int j = 0; j < n; ++j) {
                if (nodes.get(j) == null) continue;
                BinaryTreeNode<T> binaryTreeNode = nodes.get(j);
                if ((binaryTreeNode != null ? binaryTreeNode.getLeft() : null) != null) {
                    System.out.print((Object)"/");
                } else {
                    INSTANCE.printWhitespaces(1);
                }
                BinaryTreeNode<T> binaryTreeNode2 = nodes.get(j);
                if ((binaryTreeNode2 != null ? binaryTreeNode2.getRight() : null) != null) {
                    System.out.print((Object)"\\");
                    continue;
                }
                INSTANCE.printWhitespaces(1);
            }
            if (i == edgeLines) break;
            ++i;
        }
        INSTANCE.printBinaryTreeNodeInternal((List)newBinaryTreeNodes, level + 1, depth);
    }

    private final void printWhitespaces(int count) {
        if (count > 0) {
            System.out.print((Object)StringsKt.repeat((CharSequence)" ", (int)count));
        }
    }

    private final <T extends Comparable<?>> int depthOf(BinaryTreeNode<T> node) {
        BinaryTreeNode<T> binaryTreeNode = node;
        return binaryTreeNode == null ? 0 : Math.max(INSTANCE.depthOf(binaryTreeNode.getLeft()), INSTANCE.depthOf(node.getRight())) + 1;
    }
}

