/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common;

import ai.platon.pulsar.common.BlackWhiteResourceConfig;
import ai.platon.pulsar.common.SingleFiledLines;
import com.google.common.collect.Multiset;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001'B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B-\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\u0006\u0012\b\b\u0002\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0018\u001a\u00020\u0006J\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020\u0000J\b\u0010#\u001a\u00020 H\u0002J\u0006\u0010$\u001a\u00020\u0006J\u000e\u0010%\u001a\u00020&2\u0006\u0010\u0018\u001a\u00020\u0006R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000fR\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0013R\u001d\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006("}, d2={"Lai/platon/pulsar/common/BlackWhiteList;", "", "conf", "Lai/platon/pulsar/common/BlackWhiteResourceConfig;", "(Lai/platon/pulsar/common/BlackWhiteResourceConfig;)V", "blackWordsFile", "", "whiteWordsFile", "blackRegexFile", "whiteRegexFile", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "blackPatterns", "Ljava/util/HashSet;", "Ljava/util/regex/Pattern;", "getBlackPatterns", "()Ljava/util/HashSet;", "blackWords", "Lcom/google/common/collect/Multiset;", "getBlackWords", "()Lcom/google/common/collect/Multiset;", "whitePatterns", "getWhitePatterns", "whiteWords", "getWhiteWords", "words", "Ljava/util/EnumMap;", "Lai/platon/pulsar/common/BlackWhiteList$ListType;", "Lai/platon/pulsar/common/SingleFiledLines;", "getWords", "()Ljava/util/EnumMap;", "filter", "load", "", "merge", "other", "rebuildPatterns", "report", "validate", "", "ListType", "pulsar-common"})
public final class BlackWhiteList {
    @NotNull
    private final EnumMap<ListType, SingleFiledLines> words;
    @NotNull
    private final HashSet<Pattern> whitePatterns;
    @NotNull
    private final HashSet<Pattern> blackPatterns;

    public BlackWhiteList(@NotNull String blackWordsFile, @NotNull String whiteWordsFile, @NotNull String blackRegexFile, @NotNull String whiteRegexFile) {
        Intrinsics.checkNotNullParameter((Object)blackWordsFile, (String)"blackWordsFile");
        Intrinsics.checkNotNullParameter((Object)whiteWordsFile, (String)"whiteWordsFile");
        Intrinsics.checkNotNullParameter((Object)blackRegexFile, (String)"blackRegexFile");
        Intrinsics.checkNotNullParameter((Object)whiteRegexFile, (String)"whiteRegexFile");
        this.words = new EnumMap(ListType.class);
        this.whitePatterns = new HashSet();
        this.blackPatterns = new HashSet();
        ((Map)this.words).put(ListType.BlackWords, new SingleFiledLines(blackWordsFile, null, null, 6, null));
        ((Map)this.words).put(ListType.WhiteWords, new SingleFiledLines(whiteWordsFile, null, null, 6, null));
        ((Map)this.words).put(ListType.BlackRegex, new SingleFiledLines(blackRegexFile, new SingleFiledLines.RegexPreprocessor(), null, 4, null));
        ((Map)this.words).put(ListType.WhiteRegex, new SingleFiledLines(whiteRegexFile, new SingleFiledLines.RegexPreprocessor(), null, 4, null));
        this.load();
    }

    public /* synthetic */ BlackWhiteList(String string, String string2, String string3, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            string2 = "";
        }
        if ((n & 4) != 0) {
            string3 = "";
        }
        if ((n & 8) != 0) {
            string4 = "";
        }
        this(string, string2, string3, string4);
    }

    @NotNull
    public final EnumMap<ListType, SingleFiledLines> getWords() {
        return this.words;
    }

    @NotNull
    public final HashSet<Pattern> getWhitePatterns() {
        return this.whitePatterns;
    }

    @NotNull
    public final HashSet<Pattern> getBlackPatterns() {
        return this.blackPatterns;
    }

    public BlackWhiteList(@NotNull BlackWhiteResourceConfig conf) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this(conf.getBlackWordsFile(), conf.getWhiteWordsFile(), conf.getBlackRegexFile(), conf.getWhiteRegexFile());
    }

    @NotNull
    public final Multiset<String> getWhiteWords() {
        SingleFiledLines singleFiledLines = this.words.get((Object)ListType.WhiteWords);
        Intrinsics.checkNotNull((Object)singleFiledLines);
        return singleFiledLines.lines();
    }

    @NotNull
    public final Multiset<String> getBlackWords() {
        SingleFiledLines singleFiledLines = this.words.get((Object)ListType.BlackWords);
        Intrinsics.checkNotNull((Object)singleFiledLines);
        return singleFiledLines.lines();
    }

    public final void merge(@NotNull BlackWhiteList other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        for (ListType type : this.words.keySet()) {
            SingleFiledLines singleFiledLines = this.words.get((Object)type);
            if (singleFiledLines == null) continue;
            SingleFiledLines singleFiledLines2 = other.words.get((Object)type);
            Intrinsics.checkNotNull((Object)singleFiledLines2);
            singleFiledLines.merge(singleFiledLines2);
        }
        this.rebuildPatterns();
    }

    public final boolean validate(@NotNull String words) {
        Intrinsics.checkNotNullParameter((Object)words, (String)"words");
        return this.filter(words) != null;
    }

    @Nullable
    public final String filter(@NotNull String words) {
        Intrinsics.checkNotNullParameter((Object)words, (String)"words");
        if (this.getWhiteWords().contains((Object)words)) {
            return words;
        }
        for (Pattern pattern : this.whitePatterns) {
            if (!pattern.matcher(words).matches()) continue;
            return words;
        }
        if (this.getBlackWords().contains((Object)words)) {
            return null;
        }
        for (Pattern pattern : this.blackPatterns) {
            if (!pattern.matcher(words).matches()) continue;
            return null;
        }
        return words;
    }

    @NotNull
    public final String report() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (ListType type : this.words.keySet()) {
            if (i++ > 0) {
                sb.append(", ");
            }
            sb.append((Object)type);
            sb.append(" : ");
            SingleFiledLines singleFiledLines = this.words.get((Object)type);
            Intrinsics.checkNotNull((Object)singleFiledLines);
            sb.append(singleFiledLines.getSize());
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    public final void load() {
        Collection<SingleFiledLines> collection = this.words.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"words.values");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SingleFiledLines it = (SingleFiledLines)element$iv;
            boolean bl = false;
            it.load();
        }
        this.rebuildPatterns();
    }

    private final void rebuildPatterns() {
        this.whitePatterns.clear();
        SingleFiledLines singleFiledLines = this.words.get((Object)ListType.WhiteRegex);
        Intrinsics.checkNotNull((Object)singleFiledLines);
        for (String regex : singleFiledLines.lines()) {
            this.whitePatterns.add(Pattern.compile(regex));
        }
        this.blackPatterns.clear();
        SingleFiledLines singleFiledLines2 = this.words.get((Object)ListType.BlackRegex);
        Intrinsics.checkNotNull((Object)singleFiledLines2);
        for (String regex : singleFiledLines2.lines()) {
            this.blackPatterns.add(Pattern.compile(regex));
        }
    }

    public BlackWhiteList() {
        this(null, null, null, null, 15, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lai/platon/pulsar/common/BlackWhiteList$ListType;", "", "(Ljava/lang/String;I)V", "WhiteWords", "BlackWords", "WhiteRegex", "BlackRegex", "pulsar-common"})
    public static final class ListType
    extends Enum<ListType> {
        public static final /* enum */ ListType WhiteWords = new ListType();
        public static final /* enum */ ListType BlackWords = new ListType();
        public static final /* enum */ ListType WhiteRegex = new ListType();
        public static final /* enum */ ListType BlackRegex = new ListType();
        private static final /* synthetic */ ListType[] $VALUES;

        public static ListType[] values() {
            return (ListType[])$VALUES.clone();
        }

        public static ListType valueOf(String value) {
            return Enum.valueOf(ListType.class, value);
        }

        static {
            $VALUES = listTypeArray = new ListType[]{ListType.WhiteWords, ListType.BlackWords, ListType.WhiteRegex, ListType.BlackRegex};
        }
    }
}

