/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common;

import ai.platon.pulsar.common.SingleFiledLines;
import com.google.common.collect.Multiset;
import com.google.common.collect.TreeMultiset;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B-\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0004J\u001c\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00042\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00040\u001eJ\u0006\u0010\u001f\u001a\u00020 J\u0016\u0010!\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0004J\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00040#J\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00040#2\u0006\u0010\u001a\u001a\u00020\u0004J\u0006\u0010%\u001a\u00020 J\u0016\u0010&\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0004J\u000e\u0010'\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\u0004J\u0006\u0010(\u001a\u00020 R\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\"\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0013\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006)"}, d2={"Lai/platon/pulsar/common/MultipleFiledLines;", "", "files", "", "", "preprocessor", "Lai/platon/pulsar/common/SingleFiledLines$Preprocessor;", "wordsComparator", "Ljava/util/Comparator;", "([Ljava/lang/String;Lai/platon/pulsar/common/SingleFiledLines$Preprocessor;Ljava/util/Comparator;)V", "filedLines", "Ljava/util/HashMap;", "Lai/platon/pulsar/common/SingleFiledLines;", "getFiledLines", "()Ljava/util/HashMap;", "getFiles", "()[Ljava/lang/String;", "setFiles", "([Ljava/lang/String;)V", "[Ljava/lang/String;", "getPreprocessor", "()Lai/platon/pulsar/common/SingleFiledLines$Preprocessor;", "getWordsComparator", "()Ljava/util/Comparator;", "add", "", "file", "text", "addAll", "texts", "", "clear", "", "contains", "firstFileLines", "Lcom/google/common/collect/Multiset;", "lines", "load", "remove", "save", "saveAll", "pulsar-common"})
public final class MultipleFiledLines {
    @NotNull
    private String[] files;
    @NotNull
    private final SingleFiledLines.Preprocessor preprocessor;
    @NotNull
    private final Comparator<String> wordsComparator;
    @NotNull
    private final HashMap<String, SingleFiledLines> filedLines;

    public MultipleFiledLines(@NotNull String[] files, @NotNull SingleFiledLines.Preprocessor preprocessor, @NotNull Comparator<String> wordsComparator) {
        Intrinsics.checkNotNullParameter((Object)files, (String)"files");
        Intrinsics.checkNotNullParameter((Object)preprocessor, (String)"preprocessor");
        Intrinsics.checkNotNullParameter(wordsComparator, (String)"wordsComparator");
        this.files = files;
        this.preprocessor = preprocessor;
        this.wordsComparator = wordsComparator;
        this.filedLines = new HashMap();
        this.load();
    }

    public /* synthetic */ MultipleFiledLines(String[] stringArray, SingleFiledLines.Preprocessor preprocessor, Comparator comparator, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            preprocessor = new SingleFiledLines.TextPreprocessor();
        }
        if ((n & 4) != 0) {
            comparator = MultipleFiledLines::_init_$lambda-0;
        }
        this(stringArray, preprocessor, comparator);
    }

    @NotNull
    public final String[] getFiles() {
        return this.files;
    }

    public final void setFiles(@NotNull String[] stringArray) {
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"<set-?>");
        this.files = stringArray;
    }

    @NotNull
    public final SingleFiledLines.Preprocessor getPreprocessor() {
        return this.preprocessor;
    }

    @NotNull
    public final Comparator<String> getWordsComparator() {
        return this.wordsComparator;
    }

    @NotNull
    public final HashMap<String, SingleFiledLines> getFiledLines() {
        return this.filedLines;
    }

    @NotNull
    public final Multiset<String> lines(@NotNull String file) {
        Multiset<String> multiset;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (this.filedLines.isEmpty() || !this.filedLines.containsKey(file)) {
            TreeMultiset treeMultiset = TreeMultiset.create();
            Intrinsics.checkNotNullExpressionValue((Object)treeMultiset, (String)"create()");
            multiset = (Multiset<String>)treeMultiset;
        } else {
            SingleFiledLines singleFiledLines = this.filedLines.get(file);
            Intrinsics.checkNotNull((Object)singleFiledLines);
            multiset = singleFiledLines.lines();
        }
        return multiset;
    }

    @NotNull
    public final Multiset<String> firstFileLines() {
        Multiset<String> multiset;
        if (this.filedLines.isEmpty()) {
            TreeMultiset treeMultiset = TreeMultiset.create();
            Intrinsics.checkNotNullExpressionValue((Object)treeMultiset, (String)"create()");
            multiset = (Multiset<String>)treeMultiset;
        } else {
            multiset = this.filedLines.values().iterator().next().lines();
        }
        return multiset;
    }

    public final boolean add(@NotNull String file, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Multiset<String> multiset = this.lines(file);
        if (multiset == null) {
            return false;
        }
        Multiset<String> ls = multiset;
        return ls.add((Object)text);
    }

    public final boolean addAll(@NotNull String file, @NotNull Collection<String> texts) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(texts, (String)"texts");
        Multiset<String> multiset = this.lines(file);
        if (multiset == null) {
            return false;
        }
        Multiset<String> ls = multiset;
        return ls.addAll(texts);
    }

    public final boolean remove(@NotNull String file, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Multiset<String> multiset = this.lines(file);
        if (multiset == null) {
            return false;
        }
        Multiset<String> ls = multiset;
        return ls.remove((Object)text);
    }

    public final void clear() {
        this.filedLines.clear();
    }

    public final boolean contains(@NotNull String file, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Multiset<String> conf = this.lines(file);
        return conf.contains((Object)text);
    }

    public final void load() {
        for (String file : this.files) {
            ((Map)this.filedLines).put(file, new SingleFiledLines(file, this.preprocessor, this.wordsComparator));
        }
    }

    public final void save(@NotNull String file) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            SingleFiledLines singleFiledLines = this.filedLines.get(file);
            if (singleFiledLines == null) break block0;
            singleFiledLines.save();
        }
    }

    public final void saveAll() {
        for (String file : this.filedLines.keySet()) {
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
            this.save(file);
        }
    }

    private static final int _init_$lambda-0(String t, String t2) {
        Intrinsics.checkNotNullExpressionValue((Object)t2, (String)"t2");
        return t.compareTo(t2);
    }
}

