/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.time.Duration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006J\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0006J\u001e\u0010\u0011\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004\u00a8\u0006\u0013"}, d2={"Lai/platon/pulsar/common/Ping;", "", "()V", "getCheckResult", "", "line", "", "getTimes", "", "ping", "", "ipAddress", "pingTimes", "timeout", "Ljava/time/Duration;", "ping02", "", "pingNeedTime", "timeOut", "pulsar-common"})
public final class Ping {
    @NotNull
    public static final Ping INSTANCE = new Ping();

    private Ping() {
    }

    public final boolean ping(@NotNull String ipAddress) {
        Intrinsics.checkNotNullParameter((Object)ipAddress, (String)"ipAddress");
        int timeOut = 3000;
        return InetAddress.getByName(ipAddress).isReachable(timeOut);
    }

    public final void ping02(@NotNull String ipAddress) {
        Intrinsics.checkNotNullParameter((Object)ipAddress, (String)"ipAddress");
        try {
            Process pro = Runtime.getRuntime().exec("ping " + ipAddress);
            BufferedReader buf = new BufferedReader(new InputStreamReader(pro.getInputStream()));
            String line = buf.readLine();
            while (line != null) {
                System.out.println((Object)line);
                line = buf.readLine();
            }
        }
        catch (Exception ex) {
            System.out.println((Object)ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean ping(@NotNull String ipAddress, int pingTimes, @NotNull Duration timeout) {
        Intrinsics.checkNotNullParameter((Object)ipAddress, (String)"ipAddress");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        reader = null;
        r = Runtime.getRuntime();
        pingCommand = SystemUtils.IS_OS_WINDOWS != false ? "ping " + ipAddress + " /n " + pingTimes + " /w " + timeout.toMillis() : "ping -c " + pingTimes + " -w " + timeout.getSeconds() + " " + ipAddress;
        try {
            System.out.println((Object)pingCommand);
            var8_7 = r.exec(pingCommand);
            if (var8_7 == null) {
                var9_11 = false;
                ** try [egrp 1[TRYBLOCK] [0 : 80->84)] { 
lbl14:
                // 1 sources

                return var9_11;
            }
            p = var8_7;
            reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            connectedCount = 0;
            line = reader.readLine();
            while (line != null) {
                System.out.println((Object)line);
                connectedCount += this.getCheckResult(line);
                line = reader.readLine();
            }
            var10_15 = connectedCount == pingTimes;
            ** try [egrp 3[TRYBLOCK] [1 : 179->188)] { 
lbl26:
            // 1 sources

            ** GOTO lbl-1000
        }
        catch (Exception ex) {
            ex.printStackTrace();
            connectedCount = false;
            return connectedCount;
        }
lbl34:
        // 1 sources

        catch (IOException e) {
            e.printStackTrace();
        }
        return var9_11;
lbl-1000:
        // 1 sources

        {
            reader.close();
            return var10_15;
        }
lbl39:
        // 1 sources

        catch (IOException e) {
            e.printStackTrace();
        }
        return var10_15;
        finally {
            try {
                v0 = reader;
                if (v0 != null) {
                    v0.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final float pingNeedTime(@NotNull String ipAddress, int pingTimes, int timeOut) {
        Intrinsics.checkNotNullParameter((Object)ipAddress, (String)"ipAddress");
        reader = null;
        time = 10000.0f;
        r = Runtime.getRuntime();
        pingCommand = SystemUtils.IS_OS_WINDOWS != false ? "ping " + ipAddress + " -n " + pingTimes + " -w " + timeOut : "ping -c " + pingTimes + " -w " + timeOut / 1000 + " " + ipAddress;
        try {
            var9_8 = r.exec(pingCommand);
            if (var9_8 == null) {
                var10_12 = time;
                ** try [egrp 1[TRYBLOCK] [0 : 69->73)] { 
lbl13:
                // 1 sources

                return var10_12;
            }
            p = var9_8;
            reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            connectedCount = 0;
            timeTotal = 0.0f;
            spendTime = 0.0f;
            line = reader.readLine();
            while (line != null) {
                spendTime = this.getTimes(line);
                if (spendTime > 0.0f) {
                    timeTotal += spendTime;
                    ++connectedCount;
                }
                line = reader.readLine();
            }
            var13_21 = timeTotal / (float)connectedCount;
            ** try [egrp 3[TRYBLOCK] [1 : 175->184)] { 
lbl29:
            // 1 sources

            ** GOTO lbl-1000
        }
        catch (Exception ex) {
            ex.printStackTrace();
            connectedCount = time;
            return connectedCount;
        }
lbl37:
        // 1 sources

        catch (IOException e) {
            e.printStackTrace();
        }
        return var10_12;
lbl-1000:
        // 1 sources

        {
            reader.close();
            return var13_21;
        }
lbl42:
        // 1 sources

        catch (IOException e) {
            e.printStackTrace();
        }
        return var13_21;
        finally {
            try {
                v0 = reader;
                if (v0 != null) {
                    v0.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public final float getTimes(@NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        if (this.getCheckResult(line) == 0) {
            return 0.0f;
        }
        Pattern pattern = SystemUtils.IS_OS_WINDOWS ? Pattern.compile("(\\d+)ms") : Pattern.compile("(\\d+.?\\d+)\\s+ms");
        Matcher matcher = pattern.matcher(line);
        if (matcher.find()) {
            String string = matcher.group();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"matcher.group()");
            String str = ((Object)StringsKt.trim((CharSequence)StringsKt.substringBefore$default((String)string, (String)"ms", null, (int)2, null))).toString();
            return NumberUtils.toFloat((String)str);
        }
        return 10000.0f;
    }

    private final int getCheckResult(String line) {
        Pattern pattern = SystemUtils.IS_OS_WINDOWS ? Pattern.compile("(\\d+ms)(\\s+)(TTL=\\d+)", 2) : Pattern.compile("(ttl=\\d+)(\\s+)(.+)=(\\d+.?\\d+ ms)", 2);
        Matcher matcher = pattern.matcher(line);
        if (matcher.find()) {
            return 1;
        }
        return 0;
    }
}

