/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common;

import ai.platon.pulsar.common.ResourceLoader;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00017B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0019\u001a\u00020\u0015J\"\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u0015J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0014\u001a\u00020\u0015J$\u0010\u001c\u001a\u0004\u0018\u00010\u001d\"\u0004\b\u0000\u0010\u001e2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001e0 J)\u0010!\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0019\u001a\u00020\u00152\u0012\u0010\"\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150#\"\u00020\u0015\u00a2\u0006\u0002\u0010$J\u0010\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010\u0014\u001a\u00020\u0015J)\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\"\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150#\"\u00020\u0015\u00a2\u0006\u0002\u0010'J\u001a\u0010(\u001a\b\u0012\u0004\u0012\u0002H)0 \"\u0004\b\u0000\u0010)2\u0006\u0010*\u001a\u00020\u0015J\u0014\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00150,2\u0006\u0010\u0019\u001a\u00020\u0015J\u001c\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00150,2\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010-\u001a\u00020\u0013J*\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00150,2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0019\u001a\u00020\u00152\b\b\u0002\u0010\u001b\u001a\u00020\u0015H\u0007J\u0014\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00150,2\u0006\u0010/\u001a\u00020\bJ\u0014\u00100\u001a\b\u0012\u0004\u0012\u00020\u00150,2\u0006\u0010\u0019\u001a\u00020\u0015J\u000e\u00101\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0015J\u001e\u00102\u001a\u000603j\u0002`42\u0006\u0010\u0019\u001a\u00020\u00152\n\u00105\u001a\u000603j\u0002`4J\u000e\u00106\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \u0005*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lai/platon/pulsar/common/ResourceLoader;", "", "()V", "classLoader", "Ljava/lang/ClassLoader;", "kotlin.jvm.PlatformType", "lastModifiedTimes", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/nio/file/Path;", "Ljava/time/Instant;", "log", "Lorg/slf4j/Logger;", "userClassFactories", "Ljava/util/concurrent/ConcurrentLinkedDeque;", "Lai/platon/pulsar/common/ResourceLoader$ClassFactory;", "addClassFactory", "", "classFactory", "exists", "", "name", "", "getMultiSourceReader", "Ljava/io/Reader;", "stringResource", "fileResource", "namedResource", "resourcePrefix", "getResource", "Ljava/net/URL;", "T", "preferredClassLoader", "Ljava/lang/Class;", "getResourceAsReader", "resourcePrefixes", "", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/io/Reader;", "getResourceAsStream", "Ljava/io/InputStream;", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/io/InputStream;", "loadUserClass", "Z", "className", "readAllLines", "", "filter", "readAllLinesIfModified", "path", "readAllLinesNoFilter", "readString", "readStringTo", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "sb", "removeClassFactory", "ClassFactory", "pulsar-common"})
public final class ResourceLoader {
    @NotNull
    public static final ResourceLoader INSTANCE = new ResourceLoader();
    private static final Logger log = LoggerFactory.getLogger(ResourceLoader.class);
    @NotNull
    private static final ConcurrentHashMap<Path, Instant> lastModifiedTimes = new ConcurrentHashMap();
    @NotNull
    private static final ConcurrentLinkedDeque<ClassFactory> userClassFactories = new ConcurrentLinkedDeque();
    private static final ClassLoader classLoader;

    private ResourceLoader() {
    }

    public final void addClassFactory(@NotNull ClassFactory classFactory) {
        Intrinsics.checkNotNullParameter((Object)classFactory, (String)"classFactory");
        userClassFactories.add(classFactory);
    }

    public final void removeClassFactory(@NotNull ClassFactory classFactory) {
        Intrinsics.checkNotNullParameter((Object)classFactory, (String)"classFactory");
        userClassFactories.remove(classFactory);
    }

    @NotNull
    public final <Z> Class<Z> loadUserClass(@NotNull String className) throws ClassNotFoundException {
        Class<?> clazz;
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        for (ClassFactory classFactory : userClassFactories) {
            if (!classFactory.match(className)) continue;
            try {
                Class<?> userClass = classFactory.loadClass(className);
                if (userClass == null) continue;
                return userClass;
            }
            catch (ClassNotFoundException userClass) {
            }
            catch (Exception e) {
                throw e;
            }
        }
        try {
            Class<?> clazz2 = Class.forName(className);
            if (clazz2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<Z of ai.platon.pulsar.common.ResourceLoader.loadUserClass>");
            }
            clazz = clazz2;
        }
        catch (ClassNotFoundException e) {
            Class<?> clazz3 = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
            if (clazz3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<Z of ai.platon.pulsar.common.ResourceLoader.loadUserClass>");
            }
            Class<?> clazz4 = clazz3;
            clazz = clazz4;
        }
        catch (Error e) {
            throw e;
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    @NotNull
    public final List<String> readAllLines(@Nullable String stringResource, @NotNull String fileResource, @NotNull String resourcePrefix) {
        Object object;
        block9: {
            block8: {
                List list;
                Intrinsics.checkNotNullParameter((Object)fileResource, (String)"fileResource");
                Intrinsics.checkNotNullParameter((Object)resourcePrefix, (String)"resourcePrefix");
                object = this.getMultiSourceReader(stringResource, fileResource, resourcePrefix);
                if (object == null) break block8;
                Reader $this$useLines$iv = object;
                boolean $i$f$useLines = false;
                Closeable closeable = $this$useLines$iv;
                int n = 8192;
                closeable = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n);
                Throwable throwable = null;
                try {
                    BufferedReader it$iv = (BufferedReader)closeable;
                    boolean bl = false;
                    Sequence it = TextStreamsKt.lineSequence((BufferedReader)it$iv);
                    boolean bl2 = false;
                    List list2 = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)it, (Function1)readAllLines.1.1.INSTANCE), (Function1)readAllLines.1.2.INSTANCE));
                    list = list2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                object = list;
                if (list != null) break block9;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    public static /* synthetic */ List readAllLines$default(ResourceLoader resourceLoader, String string, String string2, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = "";
        }
        return resourceLoader.readAllLines(string, string2, string3);
    }

    @NotNull
    public final List<String> readAllLines(@NotNull String fileResource) {
        Intrinsics.checkNotNullParameter((Object)fileResource, (String)"fileResource");
        return this.readAllLines(fileResource, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<String> readAllLines(@NotNull String fileResource, boolean filter) {
        Object object;
        block11: {
            block10: {
                List list;
                Intrinsics.checkNotNullParameter((Object)fileResource, (String)"fileResource");
                if (!filter) {
                    return this.readAllLinesNoFilter(fileResource);
                }
                object = this.getResourceAsReader(fileResource, new String[0]);
                if (object == null) break block10;
                Reader $this$useLines$iv = object;
                boolean $i$f$useLines = false;
                Closeable closeable = $this$useLines$iv;
                int n = 8192;
                closeable = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n);
                Throwable throwable = null;
                try {
                    BufferedReader it$iv = (BufferedReader)closeable;
                    boolean bl = false;
                    Sequence it = TextStreamsKt.lineSequence((BufferedReader)it$iv);
                    boolean bl2 = false;
                    List list2 = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)it, (Function1)readAllLines.2.1.INSTANCE), (Function1)readAllLines.2.2.INSTANCE), (Function1)readAllLines.2.3.INSTANCE));
                    list = list2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                object = list;
                if (list != null) break block11;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<String> readAllLinesNoFilter(@NotNull String fileResource) {
        Object object;
        block9: {
            block8: {
                List list;
                Intrinsics.checkNotNullParameter((Object)fileResource, (String)"fileResource");
                object = this.getResourceAsReader(fileResource, new String[0]);
                if (object == null) break block8;
                Reader $this$useLines$iv = object;
                boolean $i$f$useLines = false;
                Closeable closeable = $this$useLines$iv;
                int n = 8192;
                closeable = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n);
                Throwable throwable = null;
                try {
                    BufferedReader it$iv = (BufferedReader)closeable;
                    boolean bl = false;
                    Sequence it = TextStreamsKt.lineSequence((BufferedReader)it$iv);
                    boolean bl2 = false;
                    List list2 = SequencesKt.toList((Sequence)it);
                    list = list2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                object = list;
                if (list != null) break block9;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @NotNull
    public final List<String> readAllLinesIfModified(@NotNull Path path) {
        List<String> list;
        ResourceLoader resourceLoader;
        ResourceLoader resourceLoader2;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Instant instant = lastModifiedTimes.getOrDefault(path, Instant.EPOCH);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"lastModifiedTimes.getOrD\u2026ault(path, Instant.EPOCH)");
        Instant lastModified = instant;
        Instant modified = Files.getLastModifiedTime(path, new LinkOption[0]).toInstant();
        ResourceLoader it = resourceLoader2 = this;
        boolean bl = false;
        ResourceLoader resourceLoader3 = resourceLoader = modified.compareTo(lastModified) > 0 ? resourceLoader2 : null;
        if (resourceLoader != null) {
            List<String> list2;
            it = resourceLoader;
            boolean bl2 = false;
            List<String> it2 = list2 = Files.readAllLines(path);
            boolean bl3 = false;
            Map map = lastModifiedTimes;
            Intrinsics.checkNotNullExpressionValue((Object)modified, (String)"modified");
            map.put(path, modified);
            list = list2;
        } else {
            list = null;
        }
        List<String> list3 = list;
        return list3 == null ? CollectionsKt.emptyList() : list3;
    }

    @NotNull
    public final String readString(@NotNull String fileResource) {
        Intrinsics.checkNotNullParameter((Object)fileResource, (String)"fileResource");
        String string = this.readStringTo(fileResource, new StringBuilder()).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readStringTo(fileResourc\u2026ringBuilder()).toString()");
        return string;
    }

    @NotNull
    public final StringBuilder readStringTo(@NotNull String fileResource, @NotNull StringBuilder sb) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)fileResource, (String)"fileResource");
            Intrinsics.checkNotNullParameter((Object)sb, (String)"sb");
            Reader reader = this.getResourceAsReader(fileResource, new String[0]);
            if (reader == null) break block0;
            TextStreamsKt.forEachLine((Reader)reader, (Function1)((Function1)new Function1<String, Unit>(sb){
                final /* synthetic */ StringBuilder $sb;
                {
                    this.$sb = $sb;
                    super(1);
                }

                public final void invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    StringBuilder stringBuilder = this.$sb.append(it);
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
                    StringsKt.appendln((StringBuilder)stringBuilder);
                }
            }));
        }
        return sb;
    }

    @Nullable
    public final InputStream getResourceAsStream(@NotNull String name) {
        InputStream inputStream;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        try {
            URL uRL = this.getResource(name);
            if (uRL == null) {
                return null;
            }
            URL url = uRL;
            log.info("Find resource " + name + " | " + url);
            inputStream = url.openStream();
        }
        catch (IOException e) {
            log.warn("Failed to read resource {} | {}", (Object)name, (Object)e.getMessage());
            inputStream = null;
        }
        return inputStream;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final InputStream getResourceAsStream(@NotNull String name, String ... resourcePrefixes) {
        void $this$onEach$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Object it;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)resourcePrefixes, (String)"resourcePrefixes");
        boolean found = false;
        Iterable $this$filter$iv = ArraysKt.asIterable((Object[])resourcePrefixes);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)((CharSequence)it));
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        it = $this$forEach$iv$iv$iv.iterator();
        while (it.hasNext()) {
            InputStream it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = it.next();
            boolean bl = false;
            String it2 = (String)element$iv$iv;
            boolean bl3 = false;
            if (INSTANCE.getResourceAsStream(it2 + "/" + name) == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$onEach = false;
        Iterable $this$onEach_u24lambda_u2d16$iv = iterable = $this$onEach$iv;
        boolean bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u2d16$iv) {
            it = (InputStream)element$iv;
            boolean bl5 = false;
            found = true;
        }
        InputStream inputStream = (InputStream)CollectionsKt.firstOrNull((List)((List)iterable));
        if (inputStream == null) {
            inputStream = this.getResourceAsStream(name);
        }
        return inputStream;
    }

    @Nullable
    public final Reader getResourceAsReader(@NotNull String fileResource, String ... resourcePrefixes) {
        InputStreamReader inputStreamReader;
        Intrinsics.checkNotNullParameter((Object)fileResource, (String)"fileResource");
        Intrinsics.checkNotNullParameter((Object)resourcePrefixes, (String)"resourcePrefixes");
        InputStream inputStream = this.getResourceAsStream(fileResource, Arrays.copyOf(resourcePrefixes, resourcePrefixes.length));
        if (inputStream != null) {
            InputStream it = inputStream;
            boolean bl = false;
            inputStreamReader = new InputStreamReader(it);
        } else {
            inputStreamReader = null;
        }
        return inputStreamReader;
    }

    public final boolean exists(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.getResource(name) != null;
    }

    @Nullable
    public final URL getResource(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        URL url = null;
        Iterator<ClassFactory> iterator = userClassFactories.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"userClassFactories.iterator()");
        Iterator<ClassFactory> it = iterator;
        while (url == null && it.hasNext()) {
            url = it.next().getClass().getResource(name);
        }
        URL uRL = url;
        if (uRL == null) {
            uRL = classLoader.getResource(name);
        }
        return uRL;
    }

    @Nullable
    public final <T> URL getResource(@NotNull String name, @NotNull Class<T> preferredClassLoader) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(preferredClassLoader, (String)"preferredClassLoader");
        URL uRL = preferredClassLoader.getResource(name);
        if (uRL == null) {
            uRL = this.getResource(name);
        }
        return uRL;
    }

    @Nullable
    public final Reader getMultiSourceReader(@Nullable String stringResource, @NotNull String fileResource) throws FileNotFoundException {
        Intrinsics.checkNotNullParameter((Object)fileResource, (String)"fileResource");
        return this.getMultiSourceReader(stringResource, fileResource, "");
    }

    @Nullable
    public final Reader getMultiSourceReader(@Nullable String stringResource, @NotNull String namedResource, @NotNull String resourcePrefix) throws FileNotFoundException {
        Intrinsics.checkNotNullParameter((Object)namedResource, (String)"namedResource");
        Intrinsics.checkNotNullParameter((Object)resourcePrefix, (String)"resourcePrefix");
        Reader reader = null;
        CharSequence charSequence = stringResource;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            reader = new StringReader(stringResource);
        } else if (Files.exists(Paths.get(namedResource, new String[0]), new LinkOption[0])) {
            reader = new FileReader(namedResource);
        } else {
            if (!StringsKt.startsWith$default((String)namedResource, (String)"/", (boolean)false, (int)2, null) && !StringsKt.isBlank((CharSequence)resourcePrefix)) {
                reader = this.getResourceAsReader(resourcePrefix + "/" + namedResource, new String[0]);
            }
            if (reader == null) {
                reader = this.getResourceAsReader(namedResource, new String[0]);
            }
        }
        return reader;
    }

    @JvmOverloads
    @NotNull
    public final List<String> readAllLines(@Nullable String stringResource, @NotNull String fileResource) {
        Intrinsics.checkNotNullParameter((Object)fileResource, (String)"fileResource");
        return ResourceLoader.readAllLines$default(this, stringResource, fileResource, null, 4, null);
    }

    static {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ResourceLoader.class.getClassLoader();
        }
        ResourceLoader.classLoader = classLoader;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\bf\u0018\u00002\u00020\u0001J\u0016\u0010\u0002\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\b"}, d2={"Lai/platon/pulsar/common/ResourceLoader$ClassFactory;", "", "loadClass", "Ljava/lang/Class;", "name", "", "match", "", "pulsar-common"})
    public static interface ClassFactory {
        public boolean match(@NotNull String var1);

        @Nullable
        public Class<?> loadClass(@NotNull String var1) throws ClassNotFoundException;
    }
}

