/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common;

import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.Arrays;
import java.util.Random;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.net.ServerSocketFactory;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\b\u001a\u00020\u00042\b\b\u0002\u0010\t\u001a\u00020\u00042\b\b\u0002\u0010\n\u001a\u00020\u0004H\u0007J*\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\f2\u0006\u0010\r\u001a\u00020\u00042\b\b\u0002\u0010\t\u001a\u00020\u00042\b\b\u0002\u0010\n\u001a\u00020\u0004H\u0007J\u001c\u0010\u000e\u001a\u00020\u00042\b\b\u0002\u0010\t\u001a\u00020\u00042\b\b\u0002\u0010\n\u001a\u00020\u0004H\u0007J*\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\f2\u0006\u0010\r\u001a\u00020\u00042\b\b\u0002\u0010\t\u001a\u00020\u00042\b\b\u0002\u0010\n\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lai/platon/pulsar/common/Sockets;", "", "()V", "PORT_RANGE_MAX", "", "PORT_RANGE_MIN", "random", "Ljava/util/Random;", "findAvailableTcpPort", "minPort", "maxPort", "findAvailableTcpPorts", "Ljava/util/SortedSet;", "numRequested", "findAvailableUdpPort", "findAvailableUdpPorts", "SocketType", "pulsar-common"})
public final class Sockets {
    @NotNull
    public static final Sockets INSTANCE = new Sockets();
    public static final int PORT_RANGE_MIN = 1024;
    public static final int PORT_RANGE_MAX = 65535;
    @NotNull
    private static final Random random = new Random(System.currentTimeMillis());

    private Sockets() {
    }

    @JvmOverloads
    public final int findAvailableTcpPort(int minPort, int maxPort) {
        return SocketType.TCP.findAvailablePort(minPort, maxPort);
    }

    public static /* synthetic */ int findAvailableTcpPort$default(Sockets sockets, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 1024;
        }
        if ((n3 & 2) != 0) {
            n2 = 65535;
        }
        return sockets.findAvailableTcpPort(n, n2);
    }

    @JvmOverloads
    @NotNull
    public final SortedSet<Integer> findAvailableTcpPorts(int numRequested, int minPort, int maxPort) {
        return SocketType.TCP.findAvailablePorts(numRequested, minPort, maxPort);
    }

    public static /* synthetic */ SortedSet findAvailableTcpPorts$default(Sockets sockets, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 2) != 0) {
            n2 = 1024;
        }
        if ((n4 & 4) != 0) {
            n3 = 65535;
        }
        return sockets.findAvailableTcpPorts(n, n2, n3);
    }

    @JvmOverloads
    public final int findAvailableUdpPort(int minPort, int maxPort) {
        return SocketType.UDP.findAvailablePort(minPort, maxPort);
    }

    public static /* synthetic */ int findAvailableUdpPort$default(Sockets sockets, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 1024;
        }
        if ((n3 & 2) != 0) {
            n2 = 65535;
        }
        return sockets.findAvailableUdpPort(n, n2);
    }

    @JvmOverloads
    @NotNull
    public final SortedSet<Integer> findAvailableUdpPorts(int numRequested, int minPort, int maxPort) {
        return SocketType.UDP.findAvailablePorts(numRequested, minPort, maxPort);
    }

    public static /* synthetic */ SortedSet findAvailableUdpPorts$default(Sockets sockets, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 2) != 0) {
            n2 = 1024;
        }
        if ((n4 & 4) != 0) {
            n3 = 65535;
        }
        return sockets.findAvailableUdpPorts(n, n2, n3);
    }

    @JvmOverloads
    public final int findAvailableTcpPort(int minPort) {
        return Sockets.findAvailableTcpPort$default(this, minPort, 0, 2, null);
    }

    @JvmOverloads
    public final int findAvailableTcpPort() {
        return Sockets.findAvailableTcpPort$default(this, 0, 0, 3, null);
    }

    @JvmOverloads
    @NotNull
    public final SortedSet<Integer> findAvailableTcpPorts(int numRequested, int minPort) {
        return Sockets.findAvailableTcpPorts$default(this, numRequested, minPort, 0, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final SortedSet<Integer> findAvailableTcpPorts(int numRequested) {
        return Sockets.findAvailableTcpPorts$default(this, numRequested, 0, 0, 6, null);
    }

    @JvmOverloads
    public final int findAvailableUdpPort(int minPort) {
        return Sockets.findAvailableUdpPort$default(this, minPort, 0, 2, null);
    }

    @JvmOverloads
    public final int findAvailableUdpPort() {
        return Sockets.findAvailableUdpPort$default(this, 0, 0, 3, null);
    }

    @JvmOverloads
    @NotNull
    public final SortedSet<Integer> findAvailableUdpPorts(int numRequested, int minPort) {
        return Sockets.findAvailableUdpPorts$default(this, numRequested, minPort, 0, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final SortedSet<Integer> findAvailableUdpPorts(int numRequested) {
        return Sockets.findAvailableUdpPorts$default(this, numRequested, 0, 0, 6, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004J$\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004J\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004H$j\u0002\b\u000ej\u0002\b\u000f\u00a8\u0006\u0010"}, d2={"Lai/platon/pulsar/common/Sockets$SocketType;", "", "(Ljava/lang/String;I)V", "findAvailablePort", "", "minPort", "maxPort", "findAvailablePorts", "Ljava/util/SortedSet;", "numRequested", "findRandomPort", "isPortAvailable", "", "port", "TCP", "UDP", "pulsar-common"})
    private static final abstract class SocketType
    extends Enum<SocketType> {
        public static final /* enum */ SocketType TCP = new TCP("TCP", 0);
        public static final /* enum */ SocketType UDP = new UDP("UDP", 1);
        private static final /* synthetic */ SocketType[] $VALUES;

        private SocketType() {
        }

        protected abstract boolean isPortAvailable(int var1);

        private final int findRandomPort(int minPort, int maxPort) {
            int portRange = maxPort - minPort;
            return minPort + random.nextInt(portRange + 1);
        }

        public final int findAvailablePort(int minPort, int maxPort) {
            if (!(minPort > 0)) {
                boolean $i$a$-require-Sockets$SocketType$findAvailablePort$42 = false;
                String $i$a$-require-Sockets$SocketType$findAvailablePort$42 = "'minPort' must be greater than 0";
                throw new IllegalArgumentException($i$a$-require-Sockets$SocketType$findAvailablePort$42.toString());
            }
            if (!(maxPort >= minPort)) {
                boolean $i$a$-require-Sockets$SocketType$findAvailablePort$52 = false;
                String $i$a$-require-Sockets$SocketType$findAvailablePort$52 = "'maxPort' must be greater than or equal to 'minPort'";
                throw new IllegalArgumentException($i$a$-require-Sockets$SocketType$findAvailablePort$52.toString());
            }
            if (!(maxPort <= 65535)) {
                boolean $i$a$-require-Sockets$SocketType$findAvailablePort$62 = false;
                String $i$a$-require-Sockets$SocketType$findAvailablePort$62 = "'maxPort' must be less than or equal to 65535";
                throw new IllegalArgumentException($i$a$-require-Sockets$SocketType$findAvailablePort$62.toString());
            }
            int portRange = maxPort - minPort;
            int candidatePort = 0;
            int searchCounter = 0;
            do {
                if (!(searchCounter <= portRange)) {
                    boolean bl = false;
                    String string = "Could not find an available %s port in the range [%d, %d] after %d attempts";
                    Object[] objectArray = new Object[]{this.name(), minPort, maxPort, searchCounter};
                    String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
                    String string3 = string2;
                    throw new IllegalStateException(string3.toString());
                }
                candidatePort = this.findRandomPort(minPort, maxPort);
                int n = searchCounter;
                searchCounter = n + 1;
            } while (!this.isPortAvailable(candidatePort));
            return candidatePort;
        }

        @NotNull
        public final SortedSet<Integer> findAvailablePorts(int numRequested, int minPort, int maxPort) {
            if (!(minPort > 0)) {
                boolean $i$a$-require-Sockets$SocketType$findAvailablePorts$62 = false;
                String $i$a$-require-Sockets$SocketType$findAvailablePorts$62 = "'minPort' must be greater than 0";
                throw new IllegalArgumentException($i$a$-require-Sockets$SocketType$findAvailablePorts$62.toString());
            }
            if (!(maxPort > minPort)) {
                boolean $i$a$-require-Sockets$SocketType$findAvailablePorts$72 = false;
                String $i$a$-require-Sockets$SocketType$findAvailablePorts$72 = "'maxPort' must be greater than 'minPort'";
                throw new IllegalArgumentException($i$a$-require-Sockets$SocketType$findAvailablePorts$72.toString());
            }
            if (!(maxPort <= 65535)) {
                boolean $i$a$-require-Sockets$SocketType$findAvailablePorts$82 = false;
                String $i$a$-require-Sockets$SocketType$findAvailablePorts$82 = "'maxPort' must be less than or equal to 65535";
                throw new IllegalArgumentException($i$a$-require-Sockets$SocketType$findAvailablePorts$82.toString());
            }
            if (!(numRequested > 0)) {
                boolean $i$a$-require-Sockets$SocketType$findAvailablePorts$92 = false;
                String $i$a$-require-Sockets$SocketType$findAvailablePorts$92 = "'numRequested' must be greater than 0";
                throw new IllegalArgumentException($i$a$-require-Sockets$SocketType$findAvailablePorts$92.toString());
            }
            if (!(maxPort - minPort >= numRequested)) {
                boolean $i$a$-require-Sockets$SocketType$findAvailablePorts$102 = false;
                String $i$a$-require-Sockets$SocketType$findAvailablePorts$102 = "'numRequested' must not be greater than 'maxPort' - 'minPort'";
                throw new IllegalArgumentException($i$a$-require-Sockets$SocketType$findAvailablePorts$102.toString());
            }
            SortedSet availablePorts = new TreeSet();
            int attemptCount = 0;
            while (++attemptCount <= numRequested + 100 && availablePorts.size() < numRequested) {
                availablePorts.add(this.findAvailablePort(minPort, maxPort));
            }
            if (!(availablePorts.size() == numRequested)) {
                boolean bl = false;
                String string = "Could not find %d available %s ports in the range [%d, %d]";
                Object[] objectArray = new Object[]{numRequested, this.name(), minPort, maxPort};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
                String string3 = string2;
                throw new IllegalStateException(string3.toString());
            }
            return availablePorts;
        }

        public static SocketType[] values() {
            return (SocketType[])$VALUES.clone();
        }

        public static SocketType valueOf(String value) {
            return Enum.valueOf(SocketType.class, value);
        }

        public /* synthetic */ SocketType(String $enum$name, int $enum$ordinal, DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            $VALUES = socketTypeArray = new SocketType[]{SocketType.TCP, SocketType.UDP};
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0014\u00a8\u0006\u0006"}, d2={"Lai/platon/pulsar/common/Sockets$SocketType$TCP;", "Lai/platon/pulsar/common/Sockets$SocketType;", "isPortAvailable", "", "port", "", "pulsar-common"})
        static final class TCP
        extends SocketType {
            /*
             * WARNING - void declaration
             */
            TCP() {
                void var1_1;
            }

            @Override
            protected boolean isPortAvailable(int port) {
                boolean bl;
                try {
                    ServerSocket serverSocket = ServerSocketFactory.getDefault().createServerSocket(port, 1, InetAddress.getByName("localhost"));
                    serverSocket.close();
                    bl = true;
                }
                catch (Exception ex) {
                    bl = false;
                }
                return bl;
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0014\u00a8\u0006\u0006"}, d2={"Lai/platon/pulsar/common/Sockets$SocketType$UDP;", "Lai/platon/pulsar/common/Sockets$SocketType;", "isPortAvailable", "", "port", "", "pulsar-common"})
        static final class UDP
        extends SocketType {
            /*
             * WARNING - void declaration
             */
            UDP() {
                void var1_1;
            }

            @Override
            protected boolean isPortAvailable(int port) {
                boolean bl;
                try {
                    DatagramSocket socket = new DatagramSocket(port, InetAddress.getByName("localhost"));
                    socket.close();
                    bl = true;
                }
                catch (Exception ex) {
                    bl = false;
                }
                return bl;
            }
        }
    }
}

