/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.collect;

import ai.platon.pulsar.common.urls.UrlAware;
import com.google.common.primitives.Ints;
import java.time.Duration;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0001H\u0096\u0002J\u0010\u0010\u0007\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lai/platon/pulsar/common/collect/DelayUrl;", "Ljava/util/concurrent/Delayed;", "url", "Lai/platon/pulsar/common/urls/UrlAware;", "delay", "Ljava/time/Duration;", "(Lai/platon/pulsar/common/urls/UrlAware;Ljava/time/Duration;)V", "getDelay", "()Ljava/time/Duration;", "startTime", "", "getStartTime", "()J", "getUrl", "()Lai/platon/pulsar/common/urls/UrlAware;", "compareTo", "", "other", "unit", "Ljava/util/concurrent/TimeUnit;", "pulsar-common"})
public class DelayUrl
implements Delayed {
    @NotNull
    private final UrlAware url;
    @NotNull
    private final Duration delay;
    private final long startTime;

    public DelayUrl(@NotNull UrlAware url, @NotNull Duration delay) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)delay, (String)"delay");
        this.url = url;
        this.delay = delay;
        this.startTime = System.currentTimeMillis() + this.delay.toMillis();
    }

    @NotNull
    public final UrlAware getUrl() {
        return this.url;
    }

    @NotNull
    public final Duration getDelay() {
        return this.delay;
    }

    public final long getStartTime() {
        return this.startTime;
    }

    @Override
    public int compareTo(@NotNull Delayed other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Ints.saturatedCast((long)(this.startTime - ((DelayUrl)other).startTime));
    }

    @Override
    public long getDelay(@NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        long diff = this.startTime - System.currentTimeMillis();
        return unit.convert(diff, TimeUnit.MILLISECONDS);
    }
}

