/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.geometric;

import java.awt.Dimension;
import java.awt.Point;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0011J\u001a\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0012\u001a\u00020\u00062\b\b\u0002\u0010\u0013\u001a\u00020\u0006J\u0011\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0000H\u0096\u0002J\t\u0010\u0016\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0006H\u00c6\u0003J\u001d\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u0015\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u0006H\u00d6\u0001J\u0006\u0010\u001d\u001a\u00020\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0007\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\n\"\u0004\b\u000e\u0010\f\u00a8\u0006 "}, d2={"Lai/platon/pulsar/common/geometric/GeoIntPoint;", "", "point", "Ljava/awt/Point;", "(Ljava/awt/Point;)V", "x", "", "y", "(II)V", "getX", "()I", "setX", "(I)V", "getY", "setY", "align", "grid", "Ljava/awt/Dimension;", "gridWidth", "gridHeight", "compareTo", "other", "component1", "component2", "copy", "equals", "", "", "hashCode", "toPoint", "toString", "", "pulsar-common"})
public final class GeoIntPoint
implements Comparable<GeoIntPoint> {
    private int x;
    private int y;

    public GeoIntPoint(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public final int getX() {
        return this.x;
    }

    public final void setX(int n) {
        this.x = n;
    }

    public final int getY() {
        return this.y;
    }

    public final void setY(int n) {
        this.y = n;
    }

    public GeoIntPoint(@NotNull Point point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        this(point.x, point.y);
    }

    @NotNull
    public final Point toPoint() {
        return new Point(this.x, this.y);
    }

    @NotNull
    public final GeoIntPoint align(int gridWidth, int gridHeight) {
        int x2 = gridWidth == 0 ? this.x : Math.round((float)this.x / (float)gridWidth) * gridWidth;
        int y2 = gridHeight == 0 ? this.y : Math.round((float)this.y / (float)gridHeight) * gridHeight;
        return new GeoIntPoint(x2, y2);
    }

    public static /* synthetic */ GeoIntPoint align$default(GeoIntPoint geoIntPoint, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        return geoIntPoint.align(n, n2);
    }

    @NotNull
    public final GeoIntPoint align(@NotNull Dimension grid) {
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        return this.align(grid.width, grid.height);
    }

    @Override
    public int compareTo(@NotNull GeoIntPoint other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int r = this.x - other.x;
        return r == 0 ? this.y - other.y : r;
    }

    public final int component1() {
        return this.x;
    }

    public final int component2() {
        return this.y;
    }

    @NotNull
    public final GeoIntPoint copy(int x, int y) {
        return new GeoIntPoint(x, y);
    }

    public static /* synthetic */ GeoIntPoint copy$default(GeoIntPoint geoIntPoint, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = geoIntPoint.x;
        }
        if ((n3 & 2) != 0) {
            n2 = geoIntPoint.y;
        }
        return geoIntPoint.copy(n, n2);
    }

    @NotNull
    public String toString() {
        return "GeoIntPoint(x=" + this.x + ", y=" + this.y + ")";
    }

    public int hashCode() {
        int result = Integer.hashCode(this.x);
        result = result * 31 + Integer.hashCode(this.y);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GeoIntPoint)) {
            return false;
        }
        GeoIntPoint geoIntPoint = (GeoIntPoint)other;
        if (this.x != geoIntPoint.x) {
            return false;
        }
        return this.y == geoIntPoint.y;
    }
}

