/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.proxy;

import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.proxy.FileProxyLoader;
import ai.platon.pulsar.common.proxy.ProxyLoader;
import java.lang.reflect.Constructor;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0006\u0010\u0010\u001a\u00020\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lai/platon/pulsar/common/proxy/ProxyLoaderFactory;", "Ljava/lang/AutoCloseable;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/common/config/ImmutableConfig;)V", "getConf", "()Lai/platon/pulsar/common/config/ImmutableConfig;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "proxyLoaderRef", "Ljava/util/concurrent/atomic/AtomicReference;", "Lai/platon/pulsar/common/proxy/ProxyLoader;", "close", "", "createIfAbsent", "get", "pulsar-common"})
public final class ProxyLoaderFactory
implements AutoCloseable {
    @NotNull
    private final ImmutableConfig conf;
    private final Logger log;
    @NotNull
    private final AtomicReference<ProxyLoader> proxyLoaderRef;

    public ProxyLoaderFactory(@NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.conf = conf;
        this.log = LoggerFactory.getLogger(ProxyLoaderFactory.class);
        this.proxyLoaderRef = new AtomicReference();
    }

    @NotNull
    public final ImmutableConfig getConf() {
        return this.conf;
    }

    @NotNull
    public final ProxyLoader get() {
        return this.createIfAbsent(this.conf);
    }

    @Override
    public void close() {
        block0: {
            ProxyLoader proxyLoader = this.proxyLoaderRef.getAndSet(null);
            if (proxyLoader == null) break block0;
            proxyLoader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final ProxyLoader createIfAbsent(ImmutableConfig conf) {
        if (this.proxyLoaderRef.get() == null) {
            KClass kClass = Reflection.getOrCreateKotlinClass(ProxyLoaderFactory.class);
            synchronized (kClass) {
                boolean bl = false;
                if (this.proxyLoaderRef.get() == null) {
                    void element$iv2;
                    AtomicReference<ProxyLoader> atomicReference;
                    block10: {
                        void $this$first$iv;
                        Class<Object> clazz;
                        Class<FileProxyLoader> defaultClazz = FileProxyLoader.class;
                        try {
                            clazz = conf.getClass("proxy.loader.class", defaultClazz);
                        }
                        catch (Exception e) {
                            Object[] objectArray = new Object[]{"proxy.loader.class", conf.get("proxy.loader.class"), defaultClazz.getSimpleName()};
                            this.log.warn("Configured proxy loader {}({}) is not found, use default ({})", objectArray);
                            clazz = defaultClazz;
                        }
                        Class<?> clazz2 = clazz;
                        Constructor<?>[] constructorArray = clazz2.getConstructors();
                        Intrinsics.checkNotNullExpressionValue(constructorArray, (String)"clazz.constructors");
                        Object[] e = constructorArray;
                        atomicReference = this.proxyLoaderRef;
                        boolean $i$f$first = false;
                        for (void element$iv2 : $this$first$iv) {
                            Constructor it = (Constructor)element$iv2;
                            boolean bl2 = false;
                            if (!(it.getParameters().length == 1)) {
                                continue;
                            }
                            break block10;
                        }
                        throw new NoSuchElementException("Array contains no element matching the predicate.");
                    }
                    Object[] objectArray = new Object[]{conf};
                    Object t = ((Constructor)element$iv2).newInstance(objectArray);
                    if (t == null) {
                        throw new NullPointerException("null cannot be cast to non-null type ai.platon.pulsar.common.proxy.ProxyLoader");
                    }
                    atomicReference.set((ProxyLoader)t);
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        ProxyLoader proxyLoader = this.proxyLoaderRef.get();
        Intrinsics.checkNotNullExpressionValue((Object)proxyLoader, (String)"proxyLoaderRef.get()");
        return proxyLoader;
    }
}

