/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.proxy;

import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.proxy.ProxyPool;
import ai.platon.pulsar.common.proxy.ProxyPoolManager;
import java.lang.reflect.Constructor;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0006\u0010\u0014\u001a\u00020\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lai/platon/pulsar/common/proxy/ProxyPoolManagerFactory;", "Ljava/lang/AutoCloseable;", "proxyPool", "Lai/platon/pulsar/common/proxy/ProxyPool;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/common/proxy/ProxyPool;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "getConf", "()Lai/platon/pulsar/common/config/ImmutableConfig;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getProxyPool", "()Lai/platon/pulsar/common/proxy/ProxyPool;", "proxyPoolMonitorRef", "Ljava/util/concurrent/atomic/AtomicReference;", "Lai/platon/pulsar/common/proxy/ProxyPoolManager;", "close", "", "createIfAbsent", "get", "pulsar-common"})
public final class ProxyPoolManagerFactory
implements AutoCloseable {
    @NotNull
    private final ProxyPool proxyPool;
    @NotNull
    private final ImmutableConfig conf;
    private final Logger log;
    @NotNull
    private final AtomicReference<ProxyPoolManager> proxyPoolMonitorRef;

    public ProxyPoolManagerFactory(@NotNull ProxyPool proxyPool, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)proxyPool, (String)"proxyPool");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.proxyPool = proxyPool;
        this.conf = conf;
        this.log = LoggerFactory.getLogger(ProxyPoolManagerFactory.class);
        this.proxyPoolMonitorRef = new AtomicReference();
    }

    @NotNull
    public final ProxyPool getProxyPool() {
        return this.proxyPool;
    }

    @NotNull
    public final ImmutableConfig getConf() {
        return this.conf;
    }

    @NotNull
    public final ProxyPoolManager get() {
        return this.createIfAbsent(this.conf);
    }

    @Override
    public void close() {
        block0: {
            ProxyPoolManager proxyPoolManager = this.proxyPoolMonitorRef.getAndSet(null);
            if (proxyPoolManager == null) break block0;
            proxyPoolManager.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ProxyPoolManager createIfAbsent(ImmutableConfig conf) {
        if (this.proxyPoolMonitorRef.get() == null) {
            KClass kClass = Reflection.getOrCreateKotlinClass(ProxyPoolManagerFactory.class);
            synchronized (kClass) {
                boolean bl = false;
                if (this.proxyPoolMonitorRef.get() == null) {
                    Object element$iv2;
                    block9: {
                        Class<Object> clazz;
                        Class<ProxyPoolManager> defaultClazz = ProxyPoolManager.class;
                        try {
                            clazz = conf.getClass("proxy.pool.monitor.class", defaultClazz);
                        }
                        catch (Exception e) {
                            Object[] objectArray = new Object[]{"proxy.pool.monitor.class", conf.get("proxy.pool.monitor.class"), defaultClazz.getName()};
                            this.log.warn("Configured proxy pool monitor {}({}) is not found, use default ({})", objectArray);
                            clazz = defaultClazz;
                        }
                        Class<?> clazz2 = clazz;
                        Constructor<?>[] constructorArray = clazz2.getConstructors();
                        Intrinsics.checkNotNullExpressionValue(constructorArray, (String)"clazz.constructors");
                        Object[] $this$first$iv = constructorArray;
                        boolean $i$f$first = false;
                        for (Object element$iv2 : $this$first$iv) {
                            Constructor it = (Constructor)element$iv2;
                            boolean bl2 = false;
                            if (!(it.getParameters().length == 2)) {
                                continue;
                            }
                            break block9;
                        }
                        throw new NoSuchElementException("Array contains no element matching the predicate.");
                    }
                    Object[] objectArray = new Object[]{this.proxyPool, conf};
                    Object ref = ((Constructor)element$iv2).newInstance(objectArray);
                    this.proxyPoolMonitorRef.set(ref instanceof ProxyPoolManager ? (ProxyPoolManager)ref : null);
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        ProxyPoolManager proxyPoolManager = this.proxyPoolMonitorRef.get();
        Intrinsics.checkNotNullExpressionValue((Object)proxyPoolManager, (String)"proxyPoolMonitorRef.get()");
        return proxyPoolManager;
    }
}

