/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.sql;

import ai.platon.pulsar.common.sql.ResultSetFormatter;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\u0018\u0000 -2\u00020\u0001:\u0001-B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\f\b\u0002\u0010\b\u001a\u00060\tj\u0002`\n\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\"\u001a\u00020#J\u0010\u0010$\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\u0015H\u0002J\b\u0010&\u001a\u00020#H\u0002J\b\u0010'\u001a\u00020#H\u0002J\b\u0010(\u001a\u00020#H\u0002J\b\u0010)\u001a\u00020#H\u0002J\u0010\u0010*\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\u0015H\u0002J\b\u0010+\u001a\u00020#H\u0002J\b\u0010,\u001a\u00020\u0010H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\b\u001a\u00060\tj\u0002`\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001e\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0019R\u001e\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0019R\u001e\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0019R\u001a\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lai/platon/pulsar/common/sql/ResultSetFormatter;", "", "rs", "Ljava/sql/ResultSet;", "asList", "", "withHeader", "textOnly", "buffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "(Ljava/sql/ResultSet;ZZZLjava/lang/StringBuilder;)V", "getBuffer", "()Ljava/lang/StringBuilder;", "columns", "", "", "meta", "Ljava/sql/ResultSetMetaData;", "kotlin.jvm.PlatformType", "numColumns", "", "<set-?>", "numFields", "getNumFields", "()I", "numNonBlankFields", "getNumNonBlankFields", "numNonNullFields", "getNumNonNullFields", "numRows", "getNumRows", "rows", "Ljava/util/ArrayList;", "format", "", "formatColumn", "columnIndex", "formatCurrentRow", "formatResultAsList", "formatResultAsTable", "formatRows", "getFloatColumnFormat", "overflow", "toString", "Companion", "pulsar-common"})
public final class ResultSetFormatter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ResultSet rs;
    private final boolean asList;
    private final boolean withHeader;
    private final boolean textOnly;
    @NotNull
    private final StringBuilder buffer;
    private final ResultSetMetaData meta;
    private final int numColumns;
    private int numRows;
    private int numNonBlankFields;
    private int numNonNullFields;
    private int numFields;
    @NotNull
    private final ArrayList<List<String>> rows;
    @NotNull
    private final List<String> columns;
    private static int MAX_ROW_BUFFER = 5000;
    private static int MAX_COLUMN_LENGTH = 1000;
    private static char BOX_VERTICAL = (char)124;

    /*
     * WARNING - void declaration
     */
    public ResultSetFormatter(@NotNull ResultSet rs, boolean asList, boolean withHeader, boolean textOnly, @NotNull StringBuilder buffer) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.rs = rs;
        this.asList = asList;
        this.withHeader = withHeader;
        this.textOnly = textOnly;
        this.buffer = buffer;
        this.meta = this.rs.getMetaData();
        this.numColumns = this.meta.getColumnCount();
        this.rows = new ArrayList();
        Iterable iterable = (Iterable)new IntRange(1, this.numColumns);
        ResultSetFormatter resultSetFormatter = this;
        boolean $i$f$map = false;
        void var8_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            void it;
            String string2;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string3 = string2 = this.meta.getColumnLabel((int)it);
            if (string3 == null) {
                string = "";
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"meta.getColumnLabel(it) ?: \"\"");
                string = string2;
            }
            collection.add(string);
        }
        resultSetFormatter.columns = (List)destination$iv$iv;
    }

    public /* synthetic */ ResultSetFormatter(ResultSet resultSet, boolean bl, boolean bl2, boolean bl3, StringBuilder stringBuilder, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        if ((n & 8) != 0) {
            bl3 = false;
        }
        if ((n & 0x10) != 0) {
            stringBuilder = new StringBuilder();
        }
        this(resultSet, bl, bl2, bl3, stringBuilder);
    }

    @NotNull
    public final StringBuilder getBuffer() {
        return this.buffer;
    }

    public final int getNumRows() {
        return this.numRows;
    }

    public final int getNumNonBlankFields() {
        return this.numNonBlankFields;
    }

    public final int getNumNonNullFields() {
        return this.numNonNullFields;
    }

    public final int getNumFields() {
        return this.numFields;
    }

    public final void format() {
        try {
            this.rs.beforeFirst();
            if (this.asList) {
                this.formatResultAsList();
            } else {
                this.formatResultAsTable();
            }
        }
        catch (SQLException e) {
            String cfr_ignored_0 = "(Exception)" + e.getMessage();
        }
    }

    @NotNull
    public String toString() {
        if (((CharSequence)this.buffer).length() == 0) {
            this.format();
        }
        String string = this.buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buffer.toString()");
        return string;
    }

    private final void formatResultAsTable() throws SQLException {
        if (this.withHeader) {
            this.rows.add(this.columns);
        }
        int i = 0;
        while (this.rs.next()) {
            if (i++ > 0 && this.rows.isEmpty()) {
                this.buffer.setLength(0);
            }
            this.formatCurrentRow();
            int n = this.numRows;
            this.numRows = n + 1;
            if (n <= MAX_ROW_BUFFER) continue;
            this.overflow();
        }
        this.formatRows();
    }

    private final void overflow() {
        this.formatRows();
        this.buffer.append("\n");
        this.rows.clear();
    }

    private final void formatResultAsList() throws SQLException {
        int i;
        int labelLength = 0;
        Object[] columns = new String[this.numColumns];
        int n = this.numColumns;
        for (i = 0; i < n; ++i) {
            String string;
            String it = string = this.meta.getColumnLabel(i + 1);
            boolean bl = false;
            columns[i] = it;
            String label = string;
            labelLength = RangesKt.coerceAtLeast((int)labelLength, (int)label.length());
        }
        while (this.rs.next()) {
            i = this.numRows;
            this.numRows = i + 1;
            Iterable $this$forEach$iv = (Iterable)new IntRange(0, this.numColumns - 1);
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                int element$iv;
                int i2 = element$iv = ((IntIterator)iterator).nextInt();
                boolean bl = false;
                if (i2 > 0) {
                    this.buffer.append('\n');
                }
                String th = StringUtils.rightPad((String)((String)columns[i2] + ":"), (int)(15 + labelLength));
                String td = this.rs.getString(i2 + 1);
                this.buffer.append(th).append(td);
                ++this.numFields;
                if (td == null) continue;
                ++this.numNonNullFields;
                if (!(!StringsKt.isBlank((CharSequence)td))) continue;
                ++this.numNonBlankFields;
            }
            this.buffer.append("\n");
        }
        if (this.numRows == 0) {
            ArraysKt.joinTo$default((Object[])columns, (Appendable)this.buffer, (CharSequence)"\n", null, null, (int)0, null, null, (int)124, null);
            this.buffer.append("\n");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void formatCurrentRow() throws SQLException {
        List list;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)new IntRange(1, this.numColumns);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StringUtils.abbreviateMiddle((String)this.formatColumn((int)it), (String)"..", (int)MAX_COLUMN_LENGTH));
        }
        List it = list = (List)destination$iv$iv;
        boolean bl = false;
        this.rows.add(it);
    }

    private final String formatColumn(int columnIndex) throws SQLException {
        String string;
        if (this.textOnly) {
            String string2 = this.rs.getString(columnIndex);
            if (string2 == null || (string2 = StringsKt.replace$default((String)string2, (String)"\n", (String)"", (boolean)false, (int)4, null)) == null) {
                string2 = "null";
            }
            return string2;
        }
        switch (this.rs.getMetaData().getColumnType(columnIndex)) {
            case 6: 
            case 7: 
            case 8: {
                String fmt = this.getFloatColumnFormat(columnIndex);
                double value = this.rs.getDouble(columnIndex);
                Object[] objectArray = new Object[]{value};
                String string3 = String.format(fmt, Arrays.copyOf(objectArray, objectArray.length));
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
                break;
            }
            case 2003: {
                Object array;
                Array array2 = this.rs.getArray(columnIndex);
                Object object = array = array2 != null ? array2.getArray() : null;
                if (array == null) {
                    string = "null";
                    break;
                }
                if (array instanceof Object[]) {
                    string = ArraysKt.joinToString$default((Object[])((Object[])array), null, null, null, (int)0, null, (Function1)formatColumn.1.INSTANCE, (int)31, null);
                    break;
                }
                string = array.toString();
                break;
            }
            default: {
                string = this.rs.getString(columnIndex);
                if (string != null && (string = StringsKt.replace$default((String)string, (String)"\n", (String)"", (boolean)false, (int)4, null)) != null) break;
                string = "null";
            }
        }
        return string;
    }

    private final String getFloatColumnFormat(int columnIndex) {
        int precision = RangesKt.coerceIn((int)this.rs.getMetaData().getPrecision(columnIndex), (int)6, (int)10);
        int scale = RangesKt.coerceIn((int)this.rs.getMetaData().getScale(columnIndex), (int)2, (int)6);
        return "%" + precision + "." + scale + "f";
    }

    /*
     * WARNING - void declaration
     */
    private final void formatRows() {
        int[] columnSizes = new int[this.numColumns];
        int n = this.numColumns;
        for (int i = 0; i < n; ++i) {
            int max = 0;
            for (List<String> list : this.rows) {
                max = RangesKt.coerceAtLeast((int)max, (int)list.get(i).length());
            }
            if (this.numColumns > 1) {
                max = RangesKt.coerceAtMost((int)MAX_COLUMN_LENGTH, (int)max);
            }
            columnSizes[i] = max;
        }
        Iterable $this$forEach$iv = this.rows;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List list = (List)element$iv;
            boolean bl = false;
            Iterable $this$forEachIndexed$iv = list;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void value;
                int n2;
                if ((n2 = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String string = (String)item$iv;
                int j = n2;
                boolean bl2 = false;
                if (j > 0) {
                    this.buffer.append(' ').append(BOX_VERTICAL).append(' ');
                }
                this.buffer.append((String)value);
                if (j < this.numColumns - 1) {
                    int n3 = columnSizes[j] - value.length();
                    int n4 = 0;
                    while (n4 < n3) {
                        int it = n4++;
                        boolean bl3 = false;
                        this.buffer.append(' ');
                    }
                }
                if (!(!StringsKt.isBlank((CharSequence)((CharSequence)value)))) continue;
                ++this.numNonBlankFields;
            }
            this.buffer.append("\n");
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lai/platon/pulsar/common/sql/ResultSetFormatter$Companion;", "", "()V", "BOX_VERTICAL", "", "getBOX_VERTICAL", "()C", "setBOX_VERTICAL", "(C)V", "MAX_COLUMN_LENGTH", "", "getMAX_COLUMN_LENGTH", "()I", "setMAX_COLUMN_LENGTH", "(I)V", "MAX_ROW_BUFFER", "getMAX_ROW_BUFFER", "setMAX_ROW_BUFFER", "pulsar-common"})
    public static final class Companion {
        private Companion() {
        }

        public final int getMAX_ROW_BUFFER() {
            return MAX_ROW_BUFFER;
        }

        public final void setMAX_ROW_BUFFER(int n) {
            MAX_ROW_BUFFER = n;
        }

        public final int getMAX_COLUMN_LENGTH() {
            return MAX_COLUMN_LENGTH;
        }

        public final void setMAX_COLUMN_LENGTH(int n) {
            MAX_COLUMN_LENGTH = n;
        }

        public final char getBOX_VERTICAL() {
            return BOX_VERTICAL;
        }

        public final void setBOX_VERTICAL(char c) {
            BOX_VERTICAL = c;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

