/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common;

import ai.platon.pulsar.common.Frequency;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.jvm.internal.markers.KMutableCollection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0002\u0010\u001f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u001e\n\u0002\b\n\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010)\n\u0000\n\u0002\u0010$\n\u0002\b\u000f\u0018\u0000 R*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001RB\u000f\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010&J\u0019\u0010'\u001a\u00020(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00000*\u00a2\u0006\u0002\u0010+J\u0016\u0010'\u001a\u00020$2\f\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00000,H\u0016J\b\u0010-\u001a\u00020(H\u0016J\u0016\u0010.\u001a\u00020$2\u0006\u0010%\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010&J\u0016\u0010/\u001a\u00020$2\f\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00000,H\u0016J\u0013\u00100\u001a\u00020\u001e2\u0006\u0010%\u001a\u00028\u0000\u00a2\u0006\u0002\u00101J\u0013\u00102\u001a\u00020\u001e2\u0006\u00103\u001a\u00028\u0000\u00a2\u0006\u0002\u00101J\u0013\u00104\u001a\u00020\u00122\u0006\u00103\u001a\u00028\u0000\u00a2\u0006\u0002\u00105J\f\u00106\u001a\b\u0012\u0004\u0012\u00028\u000007J\u0012\u00108\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000b07J\u0013\u00109\u001a\u00020$2\b\u0010:\u001a\u0004\u0018\u00010;H\u0096\u0002J\u000e\u0010<\u001a\u00020(2\u0006\u0010=\u001a\u00020>J\b\u0010?\u001a\u00020\u001eH\u0016J\b\u0010@\u001a\u00020$H\u0016J\u000f\u0010A\u001a\b\u0012\u0004\u0012\u00028\u00000BH\u0096\u0002J\u0012\u0010C\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001e0DJ\u0013\u0010E\u001a\u00020\u00122\u0006\u00103\u001a\u00028\u0000\u00a2\u0006\u0002\u00105J\u0015\u0010F\u001a\u00020$2\u0006\u0010%\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010&J\u0016\u0010G\u001a\u00020$2\f\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00000,H\u0016J\u0016\u0010H\u001a\u00020$2\f\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00000,H\u0016J&\u0010I\u001a\u00020\u00052\b\b\u0002\u0010J\u001a\u00020\u00052\b\b\u0002\u0010K\u001a\u00020\u00052\b\b\u0002\u0010L\u001a\u00020\u0005H\u0007J\u001c\u0010M\u001a\u00020\u00052\b\b\u0002\u0010J\u001a\u00020\u00052\b\b\u0002\u0010K\u001a\u00020\u0005H\u0007J\b\u0010N\u001a\u00020\u0005H\u0016J\u000e\u0010O\u001a\u00020\u001e2\u0006\u0010P\u001a\u00020\u0012J\u000e\u0010Q\u001a\u00020\u001e2\u0006\u0010P\u001a\u00020\u0012R2\u0010\u0007\u001a&\u0012\f\u0012\n \t*\u0004\u0018\u00018\u00008\u0000 \t*\u0012\u0012\f\u0012\n \t*\u0004\u0018\u00018\u00008\u0000\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00028\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010 \u00a8\u0006S"}, d2={"Lai/platon/pulsar/common/Frequency;", "T", "", "", "name", "", "(Ljava/lang/String;)V", "counter", "Lcom/google/common/collect/HashMultiset;", "kotlin.jvm.PlatformType", "leastEntry", "Lcom/google/common/collect/Multiset$Entry;", "getLeastEntry", "()Lcom/google/common/collect/Multiset$Entry;", "mode", "getMode", "()Ljava/lang/Comparable;", "modePercentage", "", "getModePercentage", "()D", "modes", "", "getModes", "()Ljava/util/List;", "mostEntry", "getMostEntry", "getName", "()Ljava/lang/String;", "size", "", "getSize", "()I", "totalFrequency", "getTotalFrequency", "add", "", "element", "(Ljava/lang/Comparable;)Z", "addAll", "", "elements", "", "([Ljava/lang/Comparable;)V", "", "clear", "contains", "containsAll", "count", "(Ljava/lang/Comparable;)I", "cumulativeFrequencyOf", "v", "cumulativePercentageOf", "(Ljava/lang/Comparable;)D", "elementSet", "", "entrySet", "equals", "other", "", "exportTo", "path", "Ljava/nio/file/Path;", "hashCode", "isEmpty", "iterator", "", "ordinalMap", "", "percentageOf", "remove", "removeAll", "retainAll", "toPString", "prefix", "postfix", "delimiter", "toReport", "toString", "trimEnd", "freqThreshold", "trimStart", "Companion", "pulsar-common"})
public final class Frequency<T extends Comparable<? super T>>
implements Collection<T>,
KMutableCollection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    private final HashMultiset<T> counter;
    @NotNull
    private static final AtomicInteger idGenerator = new AtomicInteger(0);

    public Frequency(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        this.counter = HashMultiset.create();
    }

    public /* synthetic */ Frequency(String object, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            object = "#F" + Frequency.Companion.getNextId();
        }
        this((String)object);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public int getSize() {
        return this.entrySet().size();
    }

    public final int getTotalFrequency() {
        return this.counter.size();
    }

    @NotNull
    public final Multiset.Entry<T> getMostEntry() {
        Object v0;
        Iterable $this$maxByOrNull$iv = this.entrySet();
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                Multiset.Entry it = (Multiset.Entry)maxElem$iv;
                boolean bl = false;
                int maxValue$iv = it.getCount();
                do {
                    Object e$iv = iterator$iv.next();
                    Multiset.Entry it2 = (Multiset.Entry)e$iv;
                    $i$a$-maxByOrNull-Frequency$mostEntry$1 = false;
                    int v$iv = it2.getCount();
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        Multiset.Entry entry = v0;
        if (entry == null) {
            throw new NoSuchElementException("Collection is empty.");
        }
        return entry;
    }

    @NotNull
    public final Multiset.Entry<T> getLeastEntry() {
        Object v0;
        Iterable $this$maxByOrNull$iv = this.entrySet();
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                Multiset.Entry it = (Multiset.Entry)maxElem$iv;
                boolean bl = false;
                int maxValue$iv = it.getCount();
                do {
                    Object e$iv = iterator$iv.next();
                    Multiset.Entry it2 = (Multiset.Entry)e$iv;
                    $i$a$-maxByOrNull-Frequency$leastEntry$1 = false;
                    int v$iv = it2.getCount();
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        Multiset.Entry entry = v0;
        if (entry == null) {
            throw new NoSuchElementException("Collection is empty.");
        }
        return entry;
    }

    @NotNull
    public final T getMode() {
        Object object = this.getMostEntry().getElement();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mostEntry.element");
        return (T)((Comparable)object);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<T> getModes() {
        void $this$mapTo$iv$iv;
        Iterable $this$sortedByDescending$iv = this.entrySet();
        boolean $i$f$sortedByDescending = false;
        boolean bl = false;
        Iterable $this$map$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Multiset.Entry it = (Multiset.Entry)b;
                boolean bl2 = false;
                Comparable comparable = Integer.valueOf(it.getCount());
                it = (Multiset.Entry)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                Integer n = it.getCount();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        });
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Multiset.Entry entry = (Multiset.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            Comparable comparable = (Comparable)it.getElement();
            collection.add(comparable);
        }
        return (List)destination$iv$iv;
    }

    public final double getModePercentage() {
        return (double)this.getMostEntry().getCount() / (double)this.getTotalFrequency();
    }

    @Override
    public boolean add(@NotNull T element) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        return this.counter.add(element);
    }

    @Override
    public boolean remove(@NotNull T element) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        return this.counter.remove(element);
    }

    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.counter.containsAll(elements);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends T> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.counter.addAll(elements);
    }

    public final void addAll(@NotNull T[] elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        T[] $this$forEach$iv = elements;
        boolean $i$f$forEach = false;
        T[] TArray = $this$forEach$iv;
        int n = TArray.length;
        for (int i = 0; i < n; ++i) {
            T element$iv;
            T it = element$iv = TArray[i];
            boolean bl = false;
            this.counter.add(it);
        }
    }

    @Override
    public boolean removeAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.counter.removeAll(elements);
    }

    @Override
    public boolean retainAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.counter.retainAll(elements);
    }

    @Override
    public void clear() {
        this.counter.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.counter.isEmpty();
    }

    @Override
    public boolean contains(@NotNull T element) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        return this.counter.contains(element);
    }

    public final int count(@NotNull T element) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        return this.counter.count(element);
    }

    @NotNull
    public final Set<Multiset.Entry<T>> entrySet() {
        Set set = this.counter.entrySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"counter.entrySet()");
        return set;
    }

    @NotNull
    public final Set<T> elementSet() {
        Set set = this.counter.elementSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"counter.elementSet()");
        return set;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        Iterator iterator = this.counter.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"counter.iterator()");
        return iterator;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<T, Integer> ordinalMap() {
        LinkedHashMap map = new LinkedHashMap();
        Iterable $this$forEachIndexed$iv = this.entrySet();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void e;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Multiset.Entry entry = (Multiset.Entry)item$iv;
            int i = n;
            boolean bl2 = false;
            Map map2 = map;
            Object object = e.getElement();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"e.element");
            Integer n2 = i;
            boolean bl3 = false;
            map2.put(object, n2);
        }
        return map;
    }

    public final double percentageOf(@NotNull T v) {
        Intrinsics.checkNotNullParameter(v, (String)"v");
        return this.getTotalFrequency() == 0 ? Double.NaN : (double)this.count(v) / (double)this.getTotalFrequency();
    }

    public final double cumulativePercentageOf(@NotNull T v) {
        Intrinsics.checkNotNullParameter(v, (String)"v");
        return this.getTotalFrequency() == 0 ? Double.NaN : (double)this.cumulativeFrequencyOf(v) / (double)this.getTotalFrequency();
    }

    public final int cumulativeFrequencyOf(@NotNull T v) {
        Intrinsics.checkNotNullParameter(v, (String)"v");
        if (this.getTotalFrequency() == 0) {
            return 0;
        }
        TreeSet elements = new TreeSet(this.elementSet());
        Object e = elements.first();
        Intrinsics.checkNotNullExpressionValue(e, (String)"elements.first()");
        if (v.compareTo(e) < 0) {
            return 0;
        }
        e = elements.last();
        Intrinsics.checkNotNullExpressionValue(e, (String)"elements.last()");
        if (v.compareTo(e) >= 0) {
            return this.getTotalFrequency();
        }
        int freq = 0;
        for (Comparable ele : elements) {
            if (ele.compareTo(v) <= 0) {
                Intrinsics.checkNotNullExpressionValue((Object)ele, (String)"ele");
                freq += this.count(ele);
                continue;
            }
            return freq;
        }
        return freq;
    }

    public final int trimEnd(double freqThreshold) {
        double a = freqThreshold;
        if (a <= 0.0) {
            return 0;
        }
        if (a < 1.0) {
            a *= (double)this.size();
        }
        HashSet<Object> removal = new HashSet<Object>();
        for (Multiset.Entry entry : this.counter.entrySet()) {
            if (!((double)entry.getCount() > a)) continue;
            removal.add(entry.getElement());
        }
        this.counter.removeAll((Collection)removal);
        return removal.size();
    }

    public final int trimStart(double freqThreshold) {
        double a = freqThreshold;
        if (a <= 0.0) {
            return 0;
        }
        if (a < 1.0) {
            a *= (double)this.size();
        }
        HashSet<Object> removal = new HashSet<Object>();
        for (Multiset.Entry entry : this.counter.entrySet()) {
            if (!((double)entry.getCount() < a)) continue;
            removal.add(entry.getElement());
        }
        this.counter.removeAll((Collection)removal);
        return removal.size();
    }

    public final void exportTo(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        PrintWriter pw = new PrintWriter(new FileWriter(path.toFile()));
        for (Multiset.Entry entry : this.counter.entrySet()) {
            pw.print(entry.getCount());
            pw.print('\t');
            pw.print(entry.getElement());
            pw.println();
        }
        pw.close();
    }

    @JvmOverloads
    @NotNull
    public final String toPString(@NotNull String prefix, @NotNull String postfix, @NotNull String delimiter) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)postfix, (String)"postfix");
        Intrinsics.checkNotNullParameter((Object)delimiter, (String)"delimiter");
        String string = ((StringBuilder)CollectionsKt.joinTo$default((Iterable)this.entrySet(), (Appendable)new StringBuilder(), (CharSequence)delimiter, (CharSequence)prefix, (CharSequence)postfix, (int)0, null, (Function1)new Function1<Multiset.Entry<T>, CharSequence>(this){
            final /* synthetic */ Frequency<T> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull Multiset.Entry<T> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string = "%s:%4.2f";
                Object[] objectArray = new Object[]{it.getElement(), 1.0 * (double)it.getCount() / (double)this.this$0.getTotalFrequency()};
                boolean bl = false;
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
                return string2;
            }
        }, (int)48, null)).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"@JvmOverloads\n    fun to\u2026       }.toString()\n    }");
        return string;
    }

    public static /* synthetic */ String toPString$default(Frequency frequency, String string, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            string2 = "";
        }
        if ((n & 4) != 0) {
            string3 = "\t";
        }
        return frequency.toPString(string, string2, string3);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final String toReport(@NotNull String prefix, @NotNull String postfix) {
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)postfix, (String)"postfix");
        StringBuilder sb = new StringBuilder(prefix);
        Iterable $this$map$iv = this.entrySet();
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            Multiset.Entry entry = (Multiset.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Integer n = it.getElement().toString().length();
            collection.add(n);
        }
        Object object = (Integer)CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv));
        if (object == null) {
            return "";
        }
        int maxLength = (Integer)object;
        object = StringCompanionObject.INSTANCE;
        String string = "%-10s%" + (maxLength += 2) + "s%10s%10s%10s\n";
        Object[] $i$f$map22 = new Object[]{"", "Value", "Freq", "Pct", "Cum Pct"};
        boolean $this$mapTo$iv$iv2 = false;
        String string2 = String.format(string, Arrays.copyOf($i$f$map22, $i$f$map22.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        sb.append(string2);
        object = this.entrySet().iterator();
        int n = 0;
        while (object.hasNext()) {
            int i = n++;
            Multiset.Entry e = (Multiset.Entry)object.next();
            Comparable value = (Comparable)e.getElement();
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string3 = "%-10d%" + maxLength + "s%10s%10.2f%%%10.2f%%\n";
            Object[] objectArray = new Object[5];
            objectArray[0] = i + 1;
            objectArray[1] = value;
            objectArray[2] = e.getCount();
            double d = 100;
            Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
            objectArray[3] = d * this.percentageOf(value);
            objectArray[4] = (double)100 * this.cumulativePercentageOf(value);
            boolean bl = false;
            String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.String.format(format, *args)");
            sb.append(string4);
        }
        sb.append("totalFrequency: " + this.getTotalFrequency() + "\tmode: " + this.getMode());
        sb.append(postfix);
        object = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sb.toString()");
        return object;
    }

    public static /* synthetic */ String toReport$default(Frequency frequency, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            string2 = "";
        }
        return frequency.toReport(string, string2);
    }

    @NotNull
    public String toString() {
        return CollectionsKt.joinToString$default((Iterable)this.entrySet(), null, null, null, (int)0, null, (Function1)toString.1.INSTANCE, (int)31, null);
    }

    @Override
    public int hashCode() {
        return this.counter.hashCode();
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof Frequency && Intrinsics.areEqual(this.counter, (Object)other);
    }

    @JvmOverloads
    @NotNull
    public final String toPString(@NotNull String prefix, @NotNull String postfix) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)postfix, (String)"postfix");
        return Frequency.toPString$default(this, prefix, postfix, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final String toPString(@NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        return Frequency.toPString$default(this, prefix, null, null, 6, null);
    }

    @JvmOverloads
    @NotNull
    public final String toPString() {
        return Frequency.toPString$default(this, null, null, null, 7, null);
    }

    @JvmOverloads
    @NotNull
    public final String toReport(@NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        return Frequency.toReport$default(this, prefix, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final String toReport() {
        return Frequency.toReport$default(this, null, null, 3, null);
    }

    public Frequency() {
        this(null, 1, null);
    }

    @Override
    public <T> T[] toArray(T[] array) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        return CollectionToArray.toArray((Collection)this, (Object[])array);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray((Collection)this);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lai/platon/pulsar/common/Frequency$Companion;", "", "()V", "idGenerator", "Ljava/util/concurrent/atomic/AtomicInteger;", "nextId", "", "getNextId", "()I", "pulsar-common"})
    public static final class Companion {
        private Companion() {
        }

        private final int getNextId() {
            return idGenerator.incrementAndGet();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

