/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.math.NumberUtils;

public class BlockRectangle
extends Rectangle
implements Comparable<BlockRectangle> {
    public BlockRectangle() {
    }

    public BlockRectangle(Rectangle rect) {
        super(rect);
    }

    public BlockRectangle(int left, int top) {
        super(left, top);
    }

    public BlockRectangle(int left, int top, int width, int height) {
        this.x = left;
        this.y = top;
        this.width = width;
        this.height = height;
    }

    public BlockRectangle(double left, double top, double width, double height) {
        this.x = (int)left;
        this.y = (int)top;
        this.width = (int)width;
        this.height = (int)height;
    }

    public BlockRectangle(Point pos, Dimension dim) {
        super(pos, dim);
    }

    public BlockRectangle(Point pos) {
        super(pos);
    }

    public BlockRectangle(Dimension dim) {
        super(dim);
    }

    public static BlockRectangle parse(String simpleString) {
        String[] parts = simpleString.replace(" ", "").split(",");
        Integer[] vi = new Integer[4];
        for (int i = 0; i < parts.length; ++i) {
            vi[i] = NumberUtils.toInt((String)parts[i], (int)-1);
        }
        return new BlockRectangle(vi[0], vi[1], vi[2], vi[3]);
    }

    public static int alignToGrid(int n, int windowSize) {
        if (windowSize == 1) {
            return n;
        }
        return n / windowSize * windowSize;
    }

    public double getLeft() {
        return this.getX();
    }

    public double getTop() {
        return this.getY();
    }

    public double getArea() {
        return this.width * this.height;
    }

    public void setWidth(int w) {
        this.setSize(w, this.height);
    }

    public void setHeight(int h) {
        this.setSize(this.width, h);
    }

    @Override
    public BlockRectangle clone() {
        return new BlockRectangle(this.x, this.y, this.width, this.height);
    }

    public BlockRectangle trim(int windowSize) {
        return this.trim(windowSize, 1, 1, 1);
    }

    public BlockRectangle trim(int windowSize, int windowSize2) {
        return this.trim(windowSize, windowSize2, 1, 1);
    }

    public BlockRectangle trim(int windowSize, int windowSize2, int windowSize3) {
        return this.trim(windowSize, windowSize2, windowSize3, 1);
    }

    public BlockRectangle trim(int xGrid, int yGrid, int wGrid, int hGrid) {
        int x2 = BlockRectangle.alignToGrid(this.x, xGrid);
        int y2 = BlockRectangle.alignToGrid(this.y, yGrid);
        int width2 = BlockRectangle.alignToGrid(this.width, wGrid);
        int height2 = BlockRectangle.alignToGrid(this.height, hGrid);
        return new BlockRectangle(x2, y2, width2, height2);
    }

    public BlockRectangle trim(BlockRectangle grid) {
        return this.trim(grid.x, grid.y, grid.width, grid.height);
    }

    public BlockRectangle trimAll(int windowSize) {
        return this.trim(windowSize, windowSize, windowSize, windowSize);
    }

    @Override
    public int compareTo(@Nonnull BlockRectangle blockRectangle) {
        int r = this.x - blockRectangle.x;
        if (r == 0) {
            r = this.y - blockRectangle.y;
        }
        if (r == 0) {
            r = this.width - blockRectangle.width;
        }
        if (r == 0) {
            r = this.height - blockRectangle.height;
        }
        return r;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public String format() {
        return "left:" + this.x + ", top:" + this.y + ", width:" + this.width + ", height:" + this.height;
    }

    public String toStyle() {
        return "left:" + this.x + "px; top:" + this.y + "px; width:" + this.width + "px; height:" + this.height + "px";
    }

    @Override
    public String toString() {
        return this.x + ", " + this.y + ", " + this.width + ", " + this.height;
    }
}

