/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.proxy;

import ai.platon.pulsar.common.DateTimesKt;
import ai.platon.pulsar.common.NetUtil;
import ai.platon.pulsar.common.ResourceLoader;
import ai.platon.pulsar.common.Strings;
import ai.platon.pulsar.common.proxy.ProxyEntry;
import ai.platon.pulsar.common.proxy.ProxyType;
import ai.platon.pulsar.common.urls.UrlUtils;
import com.google.common.collect.ConcurrentHashMultiset;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.math.NumberUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u000f\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0010\u0018\u0000 \u009e\u00012\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0006\u009d\u0001\u009e\u0001\u009f\u0001B\u0089\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0003\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u0012\b\b\u0002\u0010\u000e\u001a\u00020\r\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u0012\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0015J\u0013\u0010\u0088\u0001\u001a\u00020\u00052\u0007\u0010\u0089\u0001\u001a\u00020\u0000H\u0096\u0002J\u0016\u0010\u008a\u0001\u001a\u00020\u00102\n\u0010\u0089\u0001\u001a\u0005\u0018\u00010\u008b\u0001H\u0096\u0002J\t\u0010\u008c\u0001\u001a\u00020\u0003H\u0002J\t\u0010\u008d\u0001\u001a\u00020\u0003H\u0002J\t\u0010\u008e\u0001\u001a\u00020\u0005H\u0016J\b\u0010\u008f\u0001\u001a\u00030\u0090\u0001J\b\u0010\u0091\u0001\u001a\u00030\u0090\u0001J\u0007\u0010\u0092\u0001\u001a\u00020\u0003J\b\u0010\u0093\u0001\u001a\u00030\u0090\u0001J\b\u0010\u0094\u0001\u001a\u00030\u0090\u0001J\u0007\u0010\u0095\u0001\u001a\u00020\u0010J\u001b\u0010\u0095\u0001\u001a\u00020\u00102\u0007\u0010\u0096\u0001\u001a\u00020\r2\t\b\u0002\u0010\u0097\u0001\u001a\u00020)J\t\u0010\u0098\u0001\u001a\u00020\u0003H\u0016J\u0010\u0010\u0099\u0001\u001a\u00020\u00102\u0007\u0010\u009a\u0001\u001a\u00020)J\u0010\u0010\u009b\u0001\u001a\u00020\u00102\u0007\u0010\u009c\u0001\u001a\u00020\tR\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u001c\"\u0004\b \u0010\u001eR\u001a\u0010\u000e\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0019\u0010(\u001a\n **\u0004\u0018\u00010)0)8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010'\"\u0004\b.\u0010/R\u0011\u00100\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b1\u0010'R\u001a\u0010\u0007\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u0019\u00106\u001a\n **\u0004\u0018\u00010)0)8F\u00a2\u0006\u0006\u001a\u0004\b7\u0010,R\"\u00108\u001a\n **\u0004\u0018\u00010)0)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010,\"\u0004\b:\u0010;R\u0011\u0010<\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b<\u0010=R\u0011\u0010>\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b>\u0010=R\u0011\u0010?\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b?\u0010=R\u0011\u0010@\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b@\u0010=R\u0011\u0010A\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\bA\u0010=R\u0011\u0010B\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\bB\u0010=R\u0011\u0010C\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\bC\u0010=R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010=\"\u0004\bD\u0010ER\u0011\u0010F\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\bF\u0010=R\"\u0010G\u001a\n **\u0004\u0018\u00010\t0\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bH\u0010\u001c\"\u0004\bI\u0010\u001eR\u001c\u0010\n\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bJ\u0010'\"\u0004\bK\u0010/R\u0011\u0010L\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\bM\u0010'R,\u0010N\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020P\u0012\u0004\u0012\u00020\u00100OX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bQ\u0010R\"\u0004\bS\u0010TR\u0011\u0010U\u001a\u00020V\u00a2\u0006\b\n\u0000\u001a\u0004\bW\u0010XR\u0011\u0010Y\u001a\u00020V\u00a2\u0006\b\n\u0000\u001a\u0004\bZ\u0010XR\u0011\u0010[\u001a\u00020V\u00a2\u0006\b\n\u0000\u001a\u0004\b\\\u0010XR\u0011\u0010]\u001a\u00020V\u00a2\u0006\b\n\u0000\u001a\u0004\b^\u0010XR\u0011\u0010_\u001a\u00020V\u00a2\u0006\b\n\u0000\u001a\u0004\b`\u0010XR\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\ba\u0010'\"\u0004\bb\u0010/R\u0011\u0010c\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\bd\u0010'R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\be\u00103\"\u0004\bf\u00105R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bg\u0010h\"\u0004\bi\u0010jR\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bk\u0010'\"\u0004\bl\u0010/R\u0011\u0010m\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\bn\u0010'R5\u0010o\u001a&\u0012\f\u0012\n **\u0004\u0018\u00010\u00030\u0003 **\u0012\u0012\f\u0012\n **\u0004\u0018\u00010\u00030\u0003\u0018\u00010p0p\u00a2\u0006\b\n\u0000\u001a\u0004\bq\u0010rR\u0019\u0010s\u001a\n **\u0004\u0018\u00010\t0\t\u00a2\u0006\b\n\u0000\u001a\u0004\bt\u0010\u001cR\u0017\u0010u\u001a\b\u0012\u0004\u0012\u00020w0v\u00a2\u0006\b\n\u0000\u001a\u0004\bx\u0010yR\u0011\u0010z\u001a\u00020{8F\u00a2\u0006\u0006\u001a\u0004\b|\u0010}R\"\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0086\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0004\b~\u0010\u007f\"\u0006\b\u0080\u0001\u0010\u0081\u0001R\u001b\u0010\u0082\u0001\u001a\n **\u0004\u0018\u00010\t0\t8F\u00a2\u0006\u0007\u001a\u0005\b\u0083\u0001\u0010\u001cR\u0015\u0010\u0084\u0001\u001a\u0004\u0018\u00010)8F\u00a2\u0006\u0007\u001a\u0005\b\u0085\u0001\u0010,R\u001e\u0010\u0013\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u0086\u0001\u0010'\"\u0005\b\u0087\u0001\u0010/\u00a8\u0006\u00a0\u0001"}, d2={"Lai/platon/pulsar/common/proxy/ProxyEntry;", "", "host", "", "port", "", "outIp", "id", "declaredTTL", "Ljava/time/Instant;", "lastTarget", "testUrls", "", "Ljava/net/URL;", "defaultTestUrl", "isTestIp", "", "proxyType", "Lai/platon/pulsar/common/proxy/ProxyType;", "user", "pwd", "(Ljava/lang/String;ILjava/lang/String;ILjava/time/Instant;Ljava/lang/String;Ljava/util/List;Ljava/net/URL;ZLai/platon/pulsar/common/proxy/ProxyType;Ljava/lang/String;Ljava/lang/String;)V", "accumResponseMillis", "Ljava/util/concurrent/atomic/AtomicLong;", "getAccumResponseMillis", "()Ljava/util/concurrent/atomic/AtomicLong;", "availableTime", "getAvailableTime", "()Ljava/time/Instant;", "setAvailableTime", "(Ljava/time/Instant;)V", "getDeclaredTTL", "setDeclaredTTL", "getDefaultTestUrl", "()Ljava/net/URL;", "setDefaultTestUrl", "(Ljava/net/URL;)V", "display", "getDisplay", "()Ljava/lang/String;", "elapsedTime", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "getElapsedTime", "()Ljava/time/Duration;", "getHost", "setHost", "(Ljava/lang/String;)V", "hostPort", "getHostPort", "getId", "()I", "setId", "(I)V", "idleTime", "getIdleTime", "idleTimeout", "getIdleTimeout", "setIdleTimeout", "(Ljava/time/Duration;)V", "isBanned", "()Z", "isExpired", "isFailed", "isFree", "isGone", "isIdle", "isRetired", "setTestIp", "(Z)V", "isWorking", "lastActiveTime", "getLastActiveTime", "setLastActiveTime", "getLastTarget", "setLastTarget", "metadata", "getMetadata", "networkTester", "Lkotlin/Function2;", "Ljava/net/Proxy;", "getNetworkTester", "()Lkotlin/jvm/functions/Function2;", "setNetworkTester", "(Lkotlin/jvm/functions/Function2;)V", "numConnectionLosses", "Ljava/util/concurrent/atomic/AtomicInteger;", "getNumConnectionLosses", "()Ljava/util/concurrent/atomic/AtomicInteger;", "numFailedPages", "getNumFailedPages", "numRunningTasks", "getNumRunningTasks", "numSuccessPages", "getNumSuccessPages", "numTests", "getNumTests", "getOutIp", "setOutIp", "outSegment", "getOutSegment", "getPort", "setPort", "getProxyType", "()Lai/platon/pulsar/common/proxy/ProxyType;", "setProxyType", "(Lai/platon/pulsar/common/proxy/ProxyType;)V", "getPwd", "setPwd", "segment", "getSegment", "servedDomains", "Lcom/google/common/collect/ConcurrentHashMultiset;", "getServedDomains", "()Lcom/google/common/collect/ConcurrentHashMultiset;", "startTime", "getStartTime", "status", "Ljava/util/concurrent/atomic/AtomicReference;", "Lai/platon/pulsar/common/proxy/ProxyEntry$Status;", "getStatus", "()Ljava/util/concurrent/atomic/AtomicReference;", "testSpeed", "", "getTestSpeed", "()D", "getTestUrls", "()Ljava/util/List;", "setTestUrls", "(Ljava/util/List;)V", "ttl", "getTtl", "ttlDuration", "getTtlDuration", "getUser", "setUser", "compareTo", "other", "equals", "", "formatDisplay", "formatMetadata", "hashCode", "refresh", "", "retire", "serialize", "setFree", "startWork", "test", "target", "timeout", "toString", "willExpireAfter", "duration", "willExpireAt", "instant", "BanState", "Companion", "Status", "pulsar-common"})
public final class ProxyEntry
implements Comparable<ProxyEntry> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private String host;
    private int port;
    @NotNull
    private String outIp;
    private int id;
    @Nullable
    private Instant declaredTTL;
    @Nullable
    private String lastTarget;
    @NotNull
    private List<URL> testUrls;
    @NotNull
    private URL defaultTestUrl;
    private boolean isTestIp;
    @NotNull
    private ProxyType proxyType;
    @Nullable
    private String user;
    @Nullable
    private String pwd;
    private final Instant startTime;
    @NotNull
    private Function2<? super URL, ? super Proxy, Boolean> networkTester;
    @NotNull
    private final AtomicInteger numTests;
    @NotNull
    private final AtomicInteger numConnectionLosses;
    @NotNull
    private final AtomicLong accumResponseMillis;
    @NotNull
    private Instant availableTime;
    @NotNull
    private final AtomicInteger numFailedPages;
    @NotNull
    private final AtomicInteger numSuccessPages;
    private final ConcurrentHashMultiset<String> servedDomains;
    @NotNull
    private final AtomicReference<Status> status;
    @NotNull
    private final AtomicInteger numRunningTasks;
    private Instant lastActiveTime;
    private Duration idleTimeout;
    private static final Logger log;
    @NotNull
    private static final AtomicInteger instanceSequence;
    @NotNull
    private static final String META_DELIMITER = " ";
    private static final Duration PROXY_EXPIRED;
    private static final Duration MISSING_PROXY_DEAD_TIME;
    private static final int DEFAULT_PROXY_SERVER_PORT = 80;
    @NotNull
    public static final String PROXY_TEST_WEB_SITES_FILE = "proxy.test.web.sites.txt";
    @NotNull
    private static final URL DEFAULT_TEST_URL;
    @NotNull
    private static final List<URL> TEST_URLS;

    public ProxyEntry(@NotNull String host, int port, @NotNull String outIp, int id, @Nullable Instant declaredTTL, @Nullable String lastTarget, @NotNull List<URL> testUrls, @NotNull URL defaultTestUrl, boolean isTestIp, @NotNull ProxyType proxyType, @Nullable String user, @Nullable String pwd) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)outIp, (String)"outIp");
        Intrinsics.checkNotNullParameter(testUrls, (String)"testUrls");
        Intrinsics.checkNotNullParameter((Object)defaultTestUrl, (String)"defaultTestUrl");
        Intrinsics.checkNotNullParameter((Object)((Object)proxyType), (String)"proxyType");
        this.host = host;
        this.port = port;
        this.outIp = outIp;
        this.id = id;
        this.declaredTTL = declaredTTL;
        this.lastTarget = lastTarget;
        this.testUrls = testUrls;
        this.defaultTestUrl = defaultTestUrl;
        this.isTestIp = isTestIp;
        this.proxyType = proxyType;
        this.user = user;
        this.pwd = pwd;
        this.startTime = Instant.now();
        this.networkTester = networkTester.1.INSTANCE;
        this.numTests = new AtomicInteger();
        this.numConnectionLosses = new AtomicInteger();
        this.accumResponseMillis = new AtomicLong();
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
        this.availableTime = instant;
        this.numFailedPages = new AtomicInteger();
        this.numSuccessPages = new AtomicInteger();
        this.servedDomains = ConcurrentHashMultiset.create();
        this.status = new AtomicReference<Status>(Status.FREE);
        this.numRunningTasks = new AtomicInteger();
        this.lastActiveTime = Instant.now();
        this.idleTimeout = Duration.ofMinutes(10L);
    }

    public /* synthetic */ ProxyEntry(String string, int n, String string2, int n2, Instant instant, String string3, List list, URL uRL, boolean bl, ProxyType proxyType, String string4, String string5, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            string2 = "";
        }
        if ((n3 & 8) != 0) {
            n2 = instanceSequence.incrementAndGet();
        }
        if ((n3 & 0x10) != 0) {
            instant = null;
        }
        if ((n3 & 0x20) != 0) {
            string3 = null;
        }
        if ((n3 & 0x40) != 0) {
            list = CollectionsKt.toList((Iterable)TEST_URLS);
        }
        if ((n3 & 0x80) != 0) {
            uRL = DEFAULT_TEST_URL;
        }
        if ((n3 & 0x100) != 0) {
            bl = false;
        }
        if ((n3 & 0x200) != 0) {
            proxyType = ProxyType.HTTP;
        }
        if ((n3 & 0x400) != 0) {
            string4 = null;
        }
        if ((n3 & 0x800) != 0) {
            string5 = null;
        }
        this(string, n, string2, n2, instant, string3, list, uRL, bl, proxyType, string4, string5);
    }

    @NotNull
    public final String getHost() {
        return this.host;
    }

    public final void setHost(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.host = string;
    }

    public final int getPort() {
        return this.port;
    }

    public final void setPort(int n) {
        this.port = n;
    }

    @NotNull
    public final String getOutIp() {
        return this.outIp;
    }

    public final void setOutIp(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.outIp = string;
    }

    public final int getId() {
        return this.id;
    }

    public final void setId(int n) {
        this.id = n;
    }

    @Nullable
    public final Instant getDeclaredTTL() {
        return this.declaredTTL;
    }

    public final void setDeclaredTTL(@Nullable Instant instant) {
        this.declaredTTL = instant;
    }

    @Nullable
    public final String getLastTarget() {
        return this.lastTarget;
    }

    public final void setLastTarget(@Nullable String string) {
        this.lastTarget = string;
    }

    @NotNull
    public final List<URL> getTestUrls() {
        return this.testUrls;
    }

    public final void setTestUrls(@NotNull List<URL> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.testUrls = list;
    }

    @NotNull
    public final URL getDefaultTestUrl() {
        return this.defaultTestUrl;
    }

    public final void setDefaultTestUrl(@NotNull URL uRL) {
        Intrinsics.checkNotNullParameter((Object)uRL, (String)"<set-?>");
        this.defaultTestUrl = uRL;
    }

    public final boolean isTestIp() {
        return this.isTestIp;
    }

    public final void setTestIp(boolean bl) {
        this.isTestIp = bl;
    }

    @NotNull
    public final ProxyType getProxyType() {
        return this.proxyType;
    }

    public final void setProxyType(@NotNull ProxyType proxyType) {
        Intrinsics.checkNotNullParameter((Object)((Object)proxyType), (String)"<set-?>");
        this.proxyType = proxyType;
    }

    @Nullable
    public final String getUser() {
        return this.user;
    }

    public final void setUser(@Nullable String string) {
        this.user = string;
    }

    @Nullable
    public final String getPwd() {
        return this.pwd;
    }

    public final void setPwd(@Nullable String string) {
        this.pwd = string;
    }

    @NotNull
    public final String getHostPort() {
        return this.host + ":" + this.port;
    }

    @NotNull
    public final String getSegment() {
        return StringsKt.substringBeforeLast$default((String)this.host, (String)".", null, (int)2, null);
    }

    @NotNull
    public final String getOutSegment() {
        return StringsKt.substringBeforeLast$default((String)this.outIp, (String)".", null, (int)2, null);
    }

    public final Instant getStartTime() {
        return this.startTime;
    }

    public final Duration getElapsedTime() {
        return Duration.between(this.startTime, Instant.now());
    }

    @NotNull
    public final String getDisplay() {
        return this.formatDisplay();
    }

    @NotNull
    public final String getMetadata() {
        return this.formatMetadata();
    }

    @NotNull
    public final Function2<URL, Proxy, Boolean> getNetworkTester() {
        return this.networkTester;
    }

    public final void setNetworkTester(@NotNull Function2<? super URL, ? super Proxy, Boolean> function2) {
        Intrinsics.checkNotNullParameter(function2, (String)"<set-?>");
        this.networkTester = function2;
    }

    @NotNull
    public final AtomicInteger getNumTests() {
        return this.numTests;
    }

    @NotNull
    public final AtomicInteger getNumConnectionLosses() {
        return this.numConnectionLosses;
    }

    @NotNull
    public final AtomicLong getAccumResponseMillis() {
        return this.accumResponseMillis;
    }

    @NotNull
    public final Instant getAvailableTime() {
        return this.availableTime;
    }

    public final void setAvailableTime(@NotNull Instant instant) {
        Intrinsics.checkNotNullParameter((Object)instant, (String)"<set-?>");
        this.availableTime = instant;
    }

    @NotNull
    public final AtomicInteger getNumFailedPages() {
        return this.numFailedPages;
    }

    @NotNull
    public final AtomicInteger getNumSuccessPages() {
        return this.numSuccessPages;
    }

    public final ConcurrentHashMultiset<String> getServedDomains() {
        return this.servedDomains;
    }

    @NotNull
    public final AtomicReference<Status> getStatus() {
        return this.status;
    }

    public final double getTestSpeed() {
        return (double)(this.accumResponseMillis.get() / (long)RangesKt.coerceAtLeast((int)this.numTests.get(), (int)1)) / 1000.0;
    }

    public final Instant getTtl() {
        Instant instant = this.declaredTTL;
        return instant == null ? this.availableTime.plus(PROXY_EXPIRED) : instant;
    }

    @Nullable
    public final Duration getTtlDuration() {
        Duration duration = Duration.between(Instant.now(), this.getTtl());
        boolean bl = false;
        boolean bl2 = false;
        Duration it = duration;
        boolean bl3 = false;
        return !it.isNegative() ? duration : null;
    }

    public final boolean isExpired() {
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
        return this.willExpireAt(instant);
    }

    public final boolean isRetired() {
        return this.status.get() == Status.RETIRED;
    }

    public final boolean isFree() {
        return this.status.get() == Status.FREE;
    }

    public final boolean isWorking() {
        return this.status.get() == Status.WORKING;
    }

    public final boolean isBanned() {
        return this.isRetired() && !this.isExpired();
    }

    public final boolean isFailed() {
        return this.numConnectionLosses.get() >= 3;
    }

    public final boolean isGone() {
        return this.isRetired() || this.isFailed();
    }

    @NotNull
    public final AtomicInteger getNumRunningTasks() {
        return this.numRunningTasks;
    }

    public final Instant getLastActiveTime() {
        return this.lastActiveTime;
    }

    public final void setLastActiveTime(Instant instant) {
        this.lastActiveTime = instant;
    }

    public final Duration getIdleTimeout() {
        return this.idleTimeout;
    }

    public final void setIdleTimeout(Duration duration) {
        this.idleTimeout = duration;
    }

    public final Duration getIdleTime() {
        return Duration.between(this.lastActiveTime, Instant.now());
    }

    public final boolean isIdle() {
        return this.numRunningTasks.get() == 0 && this.getIdleTime().compareTo(this.idleTimeout) > 0;
    }

    public final boolean willExpireAt(@NotNull Instant instant) {
        Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
        return this.getTtl().compareTo(instant) < 0;
    }

    public final boolean willExpireAfter(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        return this.getTtl().compareTo(Instant.now().plus(duration)) < 0;
    }

    public final void setFree() {
        this.status.set(Status.FREE);
    }

    public final void startWork() {
        this.status.set(Status.WORKING);
    }

    public final void retire() {
        this.status.set(Status.RETIRED);
    }

    public final void refresh() {
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
        this.lastActiveTime = this.availableTime = instant;
    }

    public final boolean test() {
        URL uRL;
        if (this.lastTarget != null) {
            uRL = new URL(this.lastTarget);
        } else {
            Collection collection = this.testUrls;
            boolean bl = false;
            uRL = (URL)CollectionsKt.random((Collection)collection, (Random)((Random)Random.Default));
        }
        URL target = uRL;
        boolean available = ProxyEntry.test$default(this, target, null, 2, null);
        if (!(available || this.isGone() || Intrinsics.areEqual((Object)target, (Object)this.defaultTestUrl))) {
            available = ProxyEntry.test$default(this, this.defaultTestUrl, null, 2, null);
            if (available) {
                Object[] objectArray = new Object[]{this.getDisplay(), this.getMetadata(), target.getHost()};
                log.warn("Target unreachable via {} | {} | {}", objectArray);
            } else if (!this.isGone()) {
                Object[] objectArray = new Object[]{this.getDisplay(), this.getMetadata(), target.getHost()};
                log.warn("Proxy connection lost {} | {} | {}", objectArray);
            }
        }
        return available;
    }

    public final boolean test(@NotNull URL target, @NotNull Duration timeout) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        boolean available = NetUtil.testTcpNetwork(this.host, this.port, timeout);
        if (available) {
            InetSocketAddress addr = new InetSocketAddress(this.host, this.port);
            Proxy proxy = new Proxy(Proxy.Type.HTTP, addr);
            long start2 = System.currentTimeMillis();
            available = (Boolean)this.networkTester.invoke((Object)target, (Object)proxy);
            long end = System.currentTimeMillis();
            this.numTests.incrementAndGet();
            this.accumResponseMillis.addAndGet(end - start2);
        }
        if (!available) {
            this.numConnectionLosses.incrementAndGet();
            if (this.isGone()) {
                log.warn("Proxy is gone after {} tests | {}", (Object)this.numTests, (Object)this);
            } else {
                log.info("Proxy is not available | " + this);
            }
        } else {
            this.numConnectionLosses.set(0);
            this.refresh();
        }
        return available;
    }

    public static /* synthetic */ boolean test$default(ProxyEntry proxyEntry, URL uRL, Duration duration, int n, Object object) {
        if ((n & 2) != 0) {
            Duration duration2 = Duration.ofSeconds(5L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(5)");
            duration = duration2;
        }
        return proxyEntry.test(uRL, duration);
    }

    @NotNull
    public final String serialize() {
        String ttlStr = this.declaredTTL != null ? ", ttl:" + this.declaredTTL : "";
        return this.host + ":" + this.port + " at:" + this.availableTime + ttlStr + ", " + this.getMetadata();
    }

    public int hashCode() {
        return 31 * this.proxyType.hashCode() + this.getHostPort().hashCode();
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof ProxyEntry && ((ProxyEntry)other).proxyType == this.proxyType && Intrinsics.areEqual((Object)((ProxyEntry)other).host, (Object)this.host) && ((ProxyEntry)other).port == this.port && Intrinsics.areEqual((Object)((ProxyEntry)other).outIp, (Object)this.outIp);
    }

    @NotNull
    public String toString() {
        return this.getDisplay() + META_DELIMITER + this.getMetadata();
    }

    @Override
    public int compareTo(@NotNull ProxyEntry other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int c = this.outIp.compareTo(other.outIp);
        if (c == 0) {
            c = this.getHostPort().compareTo(other.getHostPort());
        }
        return c;
    }

    private final String formatDisplay() {
        String string;
        Duration duration;
        String ban = this.isBanned() ? "[banned] " : "";
        Duration duration2 = this.getTtlDuration();
        String ttlStr = duration2 == null ? "0s" : ((duration = duration2.truncatedTo(ChronoUnit.SECONDS)) == null ? "0s" : ((string = DateTimesKt.readable(duration)) == null ? "0s" : string));
        return ban + "[" + this.getHostPort() + " => " + this.outIp + "](" + this.numFailedPages + "/" + this.numSuccessPages + "/" + ttlStr + ")";
    }

    private final String formatMetadata() {
        int nPages = this.numSuccessPages.get() + this.numFailedPages.get();
        return "st:" + this.status.get().ordinal() + " pg:" + nPages + ", spd:" + this.getTestSpeed() + ", tt:" + this.numTests + ", ftt:" + this.numConnectionLosses + ", fpg:" + this.numFailedPages;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$mapNotNullTo$iv;
        Companion = new Companion(null);
        log = LoggerFactory.getLogger(ProxyEntry.class);
        instanceSequence = new AtomicInteger();
        PROXY_EXPIRED = Duration.ofSeconds(60L);
        MISSING_PROXY_DEAD_TIME = Duration.ofHours(1L);
        DEFAULT_TEST_URL = new URL("https://www.baidu.com");
        boolean bl = false;
        TEST_URLS = new ArrayList();
        Iterable iterable = ResourceLoader.INSTANCE.readAllLines(PROXY_TEST_WEB_SITES_FILE);
        Collection destination$iv = TEST_URLS;
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            URL uRL;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl2 = false;
            String it = (String)element$iv;
            boolean bl3 = false;
            if (UrlUtils.getURLOrNull(it) == null) continue;
            boolean bl4 = false;
            boolean bl5 = false;
            URL it$iv = uRL;
            boolean bl6 = false;
            destination$iv.add(it$iv);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lai/platon/pulsar/common/proxy/ProxyEntry$Status;", "", "(Ljava/lang/String;I)V", "FREE", "WORKING", "RETIRED", "EXPIRED", "GONE", "pulsar-common"})
    public static final class Status
    extends Enum<Status> {
        public static final /* enum */ Status FREE = new Status();
        public static final /* enum */ Status WORKING = new Status();
        public static final /* enum */ Status RETIRED = new Status();
        public static final /* enum */ Status EXPIRED = new Status();
        public static final /* enum */ Status GONE = new Status();
        private static final /* synthetic */ Status[] $VALUES;

        public static Status[] values() {
            return (Status[])$VALUES.clone();
        }

        public static Status valueOf(String value) {
            return Enum.valueOf(Status.class, value);
        }

        static {
            $VALUES = statusArray = new Status[]{Status.FREE, Status.WORKING, Status.RETIRED, Status.EXPIRED, Status.GONE};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0005j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lai/platon/pulsar/common/proxy/ProxyEntry$BanState;", "", "(Ljava/lang/String;I)V", "isBanned", "", "()Z", "isOK", "OK", "SEGMENT", "HOST", "OTHER", "pulsar-common"})
    public static final class BanState
    extends Enum<BanState> {
        public static final /* enum */ BanState OK = new BanState();
        public static final /* enum */ BanState SEGMENT = new BanState();
        public static final /* enum */ BanState HOST = new BanState();
        public static final /* enum */ BanState OTHER = new BanState();
        private static final /* synthetic */ BanState[] $VALUES;

        public final boolean isOK() {
            return this == OK;
        }

        public final boolean isBanned() {
            return !this.isOK();
        }

        public static BanState[] values() {
            return (BanState[])$VALUES.clone();
        }

        public static BanState valueOf(String value) {
            return Enum.valueOf(BanState.class, value);
        }

        static {
            $VALUES = banStateArray = new BanState[]{BanState.OK, BanState.SEGMENT, BanState.HOST, BanState.OTHER};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\n \r*\u0004\u0018\u00010\u00170\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lai/platon/pulsar/common/proxy/ProxyEntry$Companion;", "", "()V", "DEFAULT_PROXY_SERVER_PORT", "", "DEFAULT_TEST_URL", "Ljava/net/URL;", "getDEFAULT_TEST_URL", "()Ljava/net/URL;", "META_DELIMITER", "", "MISSING_PROXY_DEAD_TIME", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "PROXY_EXPIRED", "PROXY_TEST_WEB_SITES_FILE", "TEST_URLS", "", "getTEST_URLS", "()Ljava/util/List;", "instanceSequence", "Ljava/util/concurrent/atomic/AtomicInteger;", "log", "Lorg/slf4j/Logger;", "parse", "Lai/platon/pulsar/common/proxy/ProxyEntry;", "str", "pulsar-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final URL getDEFAULT_TEST_URL() {
            return DEFAULT_TEST_URL;
        }

        @NotNull
        public final List<URL> getTEST_URLS() {
            return TEST_URLS;
        }

        @Nullable
        public final ProxyEntry parse(@NotNull String str) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            String ipPort = StringsKt.substringBefore$default((String)str, (String)ProxyEntry.META_DELIMITER, null, (int)2, null);
            if (!Strings.isIpPortLike(ipPort)) {
                log.warn("Malformed ip port - {}", (Object)str);
                return null;
            }
            int pos = StringsKt.lastIndexOf$default((CharSequence)ipPort, (char)':', (int)0, (boolean)false, (int)6, null);
            if (pos != -1) {
                String string = ipPort;
                int n = 0;
                int n2 = 0;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(n, pos);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String host = string3;
                String string4 = ipPort;
                n2 = pos + 1;
                boolean bl = false;
                String string5 = string4;
                if (string5 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string6 = string5.substring(n2);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
                int port = NumberUtils.toInt((String)string6, (int)80);
                Instant availableTime = null;
                Instant ttl = null;
                String[] stringArray = new String[]{", "};
                List parts = StringsKt.split$default((CharSequence)StringsKt.substringAfter$default((String)str, (String)ProxyEntry.META_DELIMITER, null, (int)2, null), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                Iterable $this$forEach$iv = parts;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String item = (String)element$iv;
                    boolean bl2 = false;
                    try {
                        boolean bl3;
                        int n3;
                        String string7;
                        if (StringsKt.startsWith$default((String)item, (String)"at:", (boolean)false, (int)2, null)) {
                            string7 = item;
                            n3 = "at:".length();
                            bl3 = false;
                            String string8 = string7;
                            if (string8 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                            }
                            String string9 = string8.substring(n3);
                            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"(this as java.lang.String).substring(startIndex)");
                            string7 = string9;
                            n3 = 0;
                            String string10 = string7;
                            if (string10 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                            }
                            availableTime = Instant.parse(((Object)StringsKt.trimEnd((CharSequence)string10)).toString());
                            continue;
                        }
                        if (!StringsKt.startsWith$default((String)item, (String)"ttl:", (boolean)false, (int)2, null)) continue;
                        string7 = item;
                        n3 = "ttl:".length();
                        bl3 = false;
                        String string11 = string7;
                        if (string11 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string12 = string11.substring(n3);
                        Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"(this as java.lang.String).substring(startIndex)");
                        string7 = string12;
                        n3 = 0;
                        String string13 = string7;
                        if (string13 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                        }
                        ttl = Instant.parse(((Object)StringsKt.trimEnd((CharSequence)string13)).toString());
                    }
                    catch (Throwable e) {
                        log.warn("Ignore malformed proxy metadata <{}>", (Object)item);
                    }
                }
                ProxyEntry proxyEntry = new ProxyEntry(host, port, null, 0, ttl, null, null, null, false, null, null, null, 4076, null);
                Instant instant = availableTime;
                if (instant != null) {
                    Iterator iterator = instant;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    Iterator it = iterator;
                    boolean bl6 = false;
                    proxyEntry.setAvailableTime((Instant)((Object)it));
                }
                return proxyEntry;
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

