/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common;

import ai.platon.pulsar.common.AppContext;
import ai.platon.pulsar.common.Frequency;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMutableMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010'\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 7*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00050\u0003:\u00017B\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u00052\u0006\u0010\u001a\u001a\u00020\u0004J-\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u00052\u0006\u0010\u001a\u001a\u00020\u00042\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u001c\"\u00028\u0000\u00a2\u0006\u0002\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0004H\u0016J\u0016\u0010!\u001a\u00020\u001f2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u0016J\u001b\u0010#\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010$\u001a\u00028\u0000\u00a2\u0006\u0002\u0010%J\u0019\u0010&\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00052\u0006\u0010 \u001a\u00020\u0004H\u0096\u0002J\b\u0010'\u001a\u00020\u001fH\u0016J\u0006\u0010(\u001a\u00020\u0018J&\u0010)\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00052\u0006\u0010 \u001a\u00020\u00042\f\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u0016J$\u0010*\u001a\u00020\u00182\u001a\u0010+\u001a\u0016\u0012\u0006\b\u0001\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050,H\u0016J\u0018\u0010-\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00052\u0006\u0010 \u001a\u00020\u0004H\u0016J\u000e\u0010.\u001a\u00020\u00102\u0006\u0010/\u001a\u000200J\u000e\u00101\u001a\u00020\u00102\u0006\u0010/\u001a\u000200J\u0006\u00102\u001a\u00020\u0018J\u000e\u00103\u001a\u00020\u00182\u0006\u00104\u001a\u000205J\b\u00106\u001a\u00020\u0004H\u0016R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\b\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\n0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R \u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00068"}, d2={"Lai/platon/pulsar/common/FrequencyManager;", "T", "", "", "", "Lai/platon/pulsar/common/Frequency;", "()V", "counters", "entries", "", "", "getEntries", "()Ljava/util/Set;", "keys", "getKeys", "size", "", "getSize", "()I", "values", "", "getValues", "()Ljava/util/Collection;", "clear", "", "computeIfAbsent", "name", "elements", "", "(Ljava/lang/String;[Ljava/lang/Comparable;)Lai/platon/pulsar/common/Frequency;", "containsKey", "", "key", "containsValue", "value", "count", "term", "(Ljava/lang/String;Ljava/lang/Comparable;)I", "get", "isEmpty", "load", "put", "putAll", "m", "", "remove", "removeLessThen", "appearance", "", "removeMoreThen", "save", "saveTo", "directory", "Ljava/nio/file/Path;", "toString", "Companion", "pulsar-common"})
public final class FrequencyManager<T extends Comparable<? super T>>
implements Map<String, Frequency<T>>,
KMutableMap {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, Frequency<T>> counters;
    @NotNull
    private static final Logger LOG;

    public FrequencyManager() {
        boolean bl = false;
        this.counters = new LinkedHashMap();
    }

    @NotNull
    public final Frequency<T> computeIfAbsent(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Frequency frequency = this.counters.computeIfAbsent(name, FrequencyManager::computeIfAbsent$lambda-0);
        Intrinsics.checkNotNullExpressionValue((Object)frequency, (String)"counters.computeIfAbsent(name) { Frequency(it) }");
        return frequency;
    }

    @NotNull
    public final Frequency<T> computeIfAbsent(@NotNull String name, T ... elements) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Frequency frequency = this.counters.computeIfAbsent(name, FrequencyManager::computeIfAbsent$lambda-1);
        Intrinsics.checkNotNullExpressionValue((Object)frequency, (String)"counters.computeIfAbsent(name) { Frequency(it) }");
        boolean bl = false;
        boolean bl2 = false;
        Frequency it = frequency;
        boolean bl3 = false;
        CollectionsKt.addAll((Collection)it, (Object[])elements);
        return frequency;
    }

    public final int count(@NotNull String name, @NotNull T term) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(term, (String)"term");
        Frequency<T> counter = this.counters.get(name);
        return counter != null ? counter.count(term) : 0;
    }

    public int getSize() {
        return this.counters.size();
    }

    @NotNull
    public Set<String> getKeys() {
        return this.counters.keySet();
    }

    @NotNull
    public Collection<Frequency<T>> getValues() {
        return this.counters.values();
    }

    @NotNull
    public Set<Map.Entry<String, Frequency<T>>> getEntries() {
        return this.counters.entrySet();
    }

    @Override
    public boolean isEmpty() {
        return this.counters.isEmpty();
    }

    public boolean containsKey(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.counters.containsKey(key);
    }

    public boolean containsValue(@NotNull Frequency<T> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return this.counters.containsValue(value);
    }

    @Nullable
    public Frequency<T> get(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.counters.get(key);
    }

    @Override
    @Nullable
    public Frequency<T> put(@NotNull String key, @NotNull Frequency<T> value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return this.counters.put(key, value);
    }

    @Nullable
    public Frequency<T> remove(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.counters.remove(key);
    }

    @Override
    public void putAll(@NotNull Map<? extends String, ? extends Frequency<T>> m) {
        Intrinsics.checkNotNullParameter(m, (String)"m");
        this.counters.putAll(m);
    }

    @Override
    public void clear() {
        this.counters.clear();
    }

    public final int removeMoreThen(double appearance) {
        int removed = 0;
        for (Frequency<T> counter : this.counters.values()) {
            removed += counter.trimEnd(appearance);
        }
        if (removed > 0) {
            LOG.debug("Removed " + removed + " items more then " + appearance + " appearance");
        }
        return removed;
    }

    public final int removeLessThen(double appearance) {
        int removed = 0;
        for (Frequency<T> counter : this.counters.values()) {
            removed += counter.trimStart(appearance);
        }
        if (removed > 0) {
            LOG.debug("Removed " + removed + " items more then " + appearance + " appearance");
        }
        return removed;
    }

    public final void saveTo(@NotNull Path directory) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        String[] stringArray = new String[]{".metadata"};
        Path metadata = Paths.get(((Object)directory).toString(), stringArray);
        Files.createDirectories(metadata.getParent(), new FileAttribute[0]);
        for (Frequency frequency : this.counters.values()) {
            String[] stringArray2 = new String[]{frequency.getName()};
            Path destFile = Paths.get(((Object)directory).toString(), stringArray2);
            Intrinsics.checkNotNullExpressionValue((Object)destFile, (String)"destFile");
            frequency.exportTo(destFile);
        }
    }

    public final void save() {
        Path path = AppContext.INSTANCE.getAPP_TMP_DIR();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"AppContext.APP_TMP_DIR");
        this.saveTo(path);
    }

    public final void load() {
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Frequency<T> counter : this.counters.values()) {
            sb.append(counter.getName()).append('\n').append(counter.toString()).append('\n');
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    private static final Frequency computeIfAbsent$lambda-0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new Frequency(it);
    }

    private static final Frequency computeIfAbsent$lambda-1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new Frequency(it);
    }

    static {
        Logger logger = LoggerFactory.getLogger(FrequencyManager.class);
        Intrinsics.checkNotNull((Object)logger);
        LOG = logger;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lai/platon/pulsar/common/FrequencyManager$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "getLOG", "()Lorg/slf4j/Logger;", "pulsar-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

