/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b0\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\b2\u0006\u0010;\u001a\u00020\u0005H\u0002J\u000e\u0010<\u001a\u00020\u00052\u0006\u0010:\u001a\u00020\bR\u001e\u0010\u0003\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00040\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lai/platon/pulsar/common/ResourceStatus;", "", "()V", "REASON_PHRASES", "", "", "[[Ljava/lang/String;", "SC_ACCEPTED", "", "SC_BAD_GATEWAY", "SC_BAD_REQUEST", "SC_CONFLICT", "SC_CONTINUE", "SC_CREATED", "SC_EXPECTATION_FAILED", "SC_FAILED_DEPENDENCY", "SC_FORBIDDEN", "SC_GATEWAY_TIMEOUT", "SC_GONE", "SC_HTTP_VERSION_NOT_SUPPORTED", "SC_INSUFFICIENT_SPACE_ON_RESOURCE", "SC_INSUFFICIENT_STORAGE", "SC_INTERNAL_SERVER_ERROR", "SC_LENGTH_REQUIRED", "SC_LOCKED", "SC_METHOD_FAILURE", "SC_METHOD_NOT_ALLOWED", "SC_MOVED_PERMANENTLY", "SC_MOVED_TEMPORARILY", "SC_MULTIPLE_CHOICES", "SC_MULTI_STATUS", "SC_NON_AUTHORITATIVE_INFORMATION", "SC_NOT_ACCEPTABLE", "SC_NOT_FOUND", "SC_NOT_IMPLEMENTED", "SC_NOT_MODIFIED", "SC_NO_CONTENT", "SC_OK", "SC_PARTIAL_CONTENT", "SC_PAYMENT_REQUIRED", "SC_PRECONDITION_FAILED", "SC_PROCESSING", "SC_PROXY_AUTHENTICATION_REQUIRED", "SC_REQUESTED_RANGE_NOT_SATISFIABLE", "SC_REQUEST_TIMEOUT", "SC_REQUEST_TOO_LONG", "SC_REQUEST_URI_TOO_LONG", "SC_RESET_CONTENT", "SC_SEE_OTHER", "SC_SERVICE_UNAVAILABLE", "SC_SWITCHING_PROTOCOLS", "SC_TEMPORARY_REDIRECT", "SC_UNAUTHORIZED", "SC_UNPROCESSABLE_ENTITY", "SC_UNSUPPORTED_MEDIA_TYPE", "SC_USE_PROXY", "addStatusCodeMap", "", "statusCode", "reasonPhrase", "getStatusText", "pulsar-common"})
public final class ResourceStatus {
    @NotNull
    public static final ResourceStatus INSTANCE = new ResourceStatus();
    @NotNull
    private static final String[][] REASON_PHRASES;
    public static final int SC_CONTINUE = 100;
    public static final int SC_SWITCHING_PROTOCOLS = 101;
    public static final int SC_PROCESSING = 102;
    public static final int SC_OK = 200;
    public static final int SC_CREATED = 201;
    public static final int SC_ACCEPTED = 202;
    public static final int SC_NON_AUTHORITATIVE_INFORMATION = 203;
    public static final int SC_NO_CONTENT = 204;
    public static final int SC_RESET_CONTENT = 205;
    public static final int SC_PARTIAL_CONTENT = 206;
    public static final int SC_MULTI_STATUS = 207;
    public static final int SC_MULTIPLE_CHOICES = 300;
    public static final int SC_MOVED_PERMANENTLY = 301;
    public static final int SC_MOVED_TEMPORARILY = 302;
    public static final int SC_SEE_OTHER = 303;
    public static final int SC_NOT_MODIFIED = 304;
    public static final int SC_USE_PROXY = 305;
    public static final int SC_TEMPORARY_REDIRECT = 307;
    public static final int SC_BAD_REQUEST = 400;
    public static final int SC_UNAUTHORIZED = 401;
    public static final int SC_PAYMENT_REQUIRED = 402;
    public static final int SC_FORBIDDEN = 403;
    public static final int SC_NOT_FOUND = 404;
    public static final int SC_METHOD_NOT_ALLOWED = 405;
    public static final int SC_NOT_ACCEPTABLE = 406;
    public static final int SC_PROXY_AUTHENTICATION_REQUIRED = 407;
    public static final int SC_REQUEST_TIMEOUT = 408;
    public static final int SC_CONFLICT = 409;
    public static final int SC_GONE = 410;
    public static final int SC_LENGTH_REQUIRED = 411;
    public static final int SC_PRECONDITION_FAILED = 412;
    public static final int SC_REQUEST_TOO_LONG = 413;
    public static final int SC_REQUEST_URI_TOO_LONG = 414;
    public static final int SC_UNSUPPORTED_MEDIA_TYPE = 415;
    public static final int SC_REQUESTED_RANGE_NOT_SATISFIABLE = 416;
    public static final int SC_EXPECTATION_FAILED = 417;
    public static final int SC_INSUFFICIENT_SPACE_ON_RESOURCE = 419;
    public static final int SC_METHOD_FAILURE = 420;
    public static final int SC_UNPROCESSABLE_ENTITY = 422;
    public static final int SC_LOCKED = 423;
    public static final int SC_FAILED_DEPENDENCY = 424;
    public static final int SC_INTERNAL_SERVER_ERROR = 500;
    public static final int SC_NOT_IMPLEMENTED = 501;
    public static final int SC_BAD_GATEWAY = 502;
    public static final int SC_SERVICE_UNAVAILABLE = 503;
    public static final int SC_GATEWAY_TIMEOUT = 504;
    public static final int SC_HTTP_VERSION_NOT_SUPPORTED = 505;
    public static final int SC_INSUFFICIENT_STORAGE = 507;

    private ResourceStatus() {
    }

    @NotNull
    public final String getStatusText(int statusCode) {
        if (statusCode < 0) {
            throw new IllegalArgumentException("status code may not be negative");
        }
        int classIndex = statusCode / 100;
        int codeIndex = statusCode - classIndex * 100;
        if (classIndex >= 1 && classIndex <= ((Object[])REASON_PHRASES).length - 1 && codeIndex >= 0 && codeIndex <= REASON_PHRASES[classIndex].length - 1) {
            String string = REASON_PHRASES[classIndex][codeIndex];
            Intrinsics.checkNotNull((Object)string);
            return string;
        }
        return "unknown";
    }

    private final void addStatusCodeMap(int statusCode, String reasonPhrase) {
        int classIndex = statusCode / 100;
        ResourceStatus.REASON_PHRASES[classIndex][statusCode - classIndex * 100] = reasonPhrase;
    }

    static {
        String[][] stringArrayArray = new String[][]{new String[0], new String[3], new String[8], new String[8], new String[25], new String[8]};
        REASON_PHRASES = stringArrayArray;
        INSTANCE.addStatusCodeMap(200, "OK");
        INSTANCE.addStatusCodeMap(201, "Created");
        INSTANCE.addStatusCodeMap(202, "Accepted");
        INSTANCE.addStatusCodeMap(204, "No Content");
        INSTANCE.addStatusCodeMap(301, "Moved Permanently");
        INSTANCE.addStatusCodeMap(302, "Moved Temporarily");
        INSTANCE.addStatusCodeMap(304, "Not Modified");
        INSTANCE.addStatusCodeMap(400, "Bad Request");
        INSTANCE.addStatusCodeMap(401, "Unauthorized");
        INSTANCE.addStatusCodeMap(403, "Forbidden");
        INSTANCE.addStatusCodeMap(404, "Not Found");
        INSTANCE.addStatusCodeMap(500, "Internal Server Error");
        INSTANCE.addStatusCodeMap(501, "Not Implemented");
        INSTANCE.addStatusCodeMap(502, "Bad Gateway");
        INSTANCE.addStatusCodeMap(503, "Service Unavailable");
        INSTANCE.addStatusCodeMap(100, "Continue");
        INSTANCE.addStatusCodeMap(307, "Temporary Redirect");
        INSTANCE.addStatusCodeMap(405, "Method Not Allowed");
        INSTANCE.addStatusCodeMap(409, "Conflict");
        INSTANCE.addStatusCodeMap(412, "Precondition Failed");
        INSTANCE.addStatusCodeMap(413, "Request Too Long");
        INSTANCE.addStatusCodeMap(414, "Request-URI Too Long");
        INSTANCE.addStatusCodeMap(415, "Unsupported Media Type");
        INSTANCE.addStatusCodeMap(300, "Multiple Choices");
        INSTANCE.addStatusCodeMap(303, "See Other");
        INSTANCE.addStatusCodeMap(305, "Use Proxy");
        INSTANCE.addStatusCodeMap(402, "Payment Required");
        INSTANCE.addStatusCodeMap(406, "Not Acceptable");
        INSTANCE.addStatusCodeMap(407, "Proxy Authentication Required");
        INSTANCE.addStatusCodeMap(408, "Request Timeout");
        INSTANCE.addStatusCodeMap(101, "Switching Protocols");
        INSTANCE.addStatusCodeMap(203, "Non Authoritative Information");
        INSTANCE.addStatusCodeMap(205, "Reset Content");
        INSTANCE.addStatusCodeMap(206, "Partial Content");
        INSTANCE.addStatusCodeMap(504, "Gateway Timeout");
        INSTANCE.addStatusCodeMap(505, "Http Version Not Supported");
        INSTANCE.addStatusCodeMap(410, "Gone");
        INSTANCE.addStatusCodeMap(411, "Length Required");
        INSTANCE.addStatusCodeMap(416, "Requested Range Not Satisfiable");
        INSTANCE.addStatusCodeMap(417, "Expectation Failed");
        INSTANCE.addStatusCodeMap(102, "Processing");
        INSTANCE.addStatusCodeMap(207, "Multi-Status");
        INSTANCE.addStatusCodeMap(422, "Unprocessable Entity");
        INSTANCE.addStatusCodeMap(419, "Insufficient Space On Resource");
        INSTANCE.addStatusCodeMap(420, "Method Failure");
        INSTANCE.addStatusCodeMap(423, "Locked");
        INSTANCE.addStatusCodeMap(507, "Insufficient Storage");
        INSTANCE.addStatusCodeMap(424, "Failed Dependency");
    }
}

