/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.concurrent;

import ai.platon.pulsar.common.concurrent.ConcurrencyKt;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.time.Duration;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 ,2\u00020\u0001:\u0001,B-\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010!\u001a\u00020\"H\u0016J\u0006\u0010#\u001a\u00020\"J\u0016\u0010#\u001a\u00020\"2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u0003J$\u0010#\u001a\u00020\"2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u00032\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\"0&J\u0018\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016J \u0010#\u001a\u00020\"2\u0006\u0010\u0002\u001a\u00020'2\u0006\u0010$\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016J(\u0010#\u001a\u00020\"2\u0006\u0010\u0002\u001a\u00020'2\u0006\u0010$\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010%\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020\"H&R\u001c\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0016\u001a\n \u0018*\u0004\u0018\u00010\u00170\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0019\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001aX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0013\"\u0004\b \u0010\u0015\u00a8\u0006-"}, d2={"Lai/platon/pulsar/common/concurrent/ScheduledMonitor;", "Ljava/lang/AutoCloseable;", "initialDelay", "Ljava/time/Duration;", "watchInterval", "executor", "Ljava/util/concurrent/ScheduledExecutorService;", "autoClose", "", "(Ljava/time/Duration;Ljava/time/Duration;Ljava/util/concurrent/ScheduledExecutorService;Z)V", "getAutoClose$annotations", "()V", "getAutoClose", "()Z", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getExecutor", "()Ljava/util/concurrent/ScheduledExecutorService;", "getInitialDelay", "()Ljava/time/Duration;", "setInitialDelay", "(Ljava/time/Duration;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "scheduledFuture", "Ljava/util/concurrent/ScheduledFuture;", "getScheduledFuture", "()Ljava/util/concurrent/ScheduledFuture;", "setScheduledFuture", "(Ljava/util/concurrent/ScheduledFuture;)V", "getWatchInterval", "setWatchInterval", "close", "", "start", "period", "runnable", "Lkotlin/Function0;", "", "unit", "Ljava/util/concurrent/TimeUnit;", "Ljava/lang/Runnable;", "watch", "Companion", "pulsar-common"})
public abstract class ScheduledMonitor
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Duration initialDelay;
    @NotNull
    private Duration watchInterval;
    @NotNull
    private final ScheduledExecutorService executor;
    private final boolean autoClose;
    private final Logger logger;
    @NotNull
    private final AtomicBoolean closed;
    @Nullable
    private ScheduledFuture<?> scheduledFuture;

    public ScheduledMonitor(@NotNull Duration initialDelay, @NotNull Duration watchInterval, @NotNull ScheduledExecutorService executor, boolean autoClose) {
        Intrinsics.checkNotNullParameter((Object)initialDelay, (String)"initialDelay");
        Intrinsics.checkNotNullParameter((Object)watchInterval, (String)"watchInterval");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this.initialDelay = initialDelay;
        this.watchInterval = watchInterval;
        this.executor = executor;
        this.autoClose = autoClose;
        this.logger = LoggerFactory.getLogger(ScheduledMonitor.class);
        this.closed = new AtomicBoolean();
    }

    public /* synthetic */ ScheduledMonitor(Duration duration, Duration duration2, ScheduledExecutorService scheduledExecutorService, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        Duration duration3;
        if ((n & 1) != 0) {
            duration3 = Duration.ofMinutes(5L);
            Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"ofMinutes(5)");
            duration = duration3;
        }
        if ((n & 2) != 0) {
            duration3 = Duration.ofSeconds(30L);
            Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"ofSeconds(30)");
            duration2 = duration3;
        }
        if ((n & 4) != 0) {
            scheduledExecutorService = ScheduledMonitor.Companion.createDefaultExecutor();
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        this(duration, duration2, scheduledExecutorService, bl);
    }

    @NotNull
    public final Duration getInitialDelay() {
        return this.initialDelay;
    }

    public final void setInitialDelay(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"<set-?>");
        this.initialDelay = duration;
    }

    @NotNull
    public final Duration getWatchInterval() {
        return this.watchInterval;
    }

    public final void setWatchInterval(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"<set-?>");
        this.watchInterval = duration;
    }

    @NotNull
    public final ScheduledExecutorService getExecutor() {
        return this.executor;
    }

    public final boolean getAutoClose() {
        return this.autoClose;
    }

    @Deprecated(message="Not used")
    public static /* synthetic */ void getAutoClose$annotations() {
    }

    @Nullable
    protected final ScheduledFuture<?> getScheduledFuture() {
        return this.scheduledFuture;
    }

    protected final void setScheduledFuture(@Nullable ScheduledFuture<?> scheduledFuture) {
        this.scheduledFuture = scheduledFuture;
    }

    public final void start(@NotNull Duration initialDelay, @NotNull Duration period, @NotNull Function0<Unit> runnable) {
        Intrinsics.checkNotNullParameter((Object)initialDelay, (String)"initialDelay");
        Intrinsics.checkNotNullParameter((Object)period, (String)"period");
        Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
        this.start(initialDelay.getSeconds(), period.getSeconds(), TimeUnit.SECONDS, () -> ScheduledMonitor.start$lambda-0(runnable));
    }

    public final void start(@NotNull Duration initialDelay, @NotNull Duration period) {
        Intrinsics.checkNotNullParameter((Object)initialDelay, (String)"initialDelay");
        Intrinsics.checkNotNullParameter((Object)period, (String)"period");
        this.start(initialDelay.getSeconds(), period.getSeconds(), TimeUnit.SECONDS, () -> ScheduledMonitor.start$lambda-1(this));
    }

    public void start(long period, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        this.start(period, period, unit);
    }

    public synchronized void start(long initialDelay, long period, @NotNull TimeUnit unit, @NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        boolean bl = this.scheduledFuture == null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Scheduled monitor is already started | " + this.getClass().getSimpleName();
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.scheduledFuture = this.executor.scheduleAtFixedRate(runnable, initialDelay, period, unit);
        this.logger.info("Scheduled monitor is started | {}", (Object)this.getClass().getSimpleName());
    }

    public synchronized void start(long initialDelay, long period, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        this.start(initialDelay, period, unit, () -> ScheduledMonitor.start$lambda-3(this));
    }

    public final void start() {
        this.start(this.initialDelay, this.watchInterval, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ ScheduledMonitor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.watch();
            }
        }));
    }

    public abstract void watch();

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.logger.info("Closing scheduled monitor | " + this);
            String name = this.getClass().getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
            ConcurrencyKt.stopExecution(name, this.executor, (Future)this.scheduledFuture, true);
        }
    }

    private static final void start$lambda-0(Function0 $runnable) {
        Intrinsics.checkNotNullParameter((Object)$runnable, (String)"$runnable");
        $runnable.invoke();
    }

    private static final void start$lambda-1(ScheduledMonitor this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.watch();
    }

    private static final void start$lambda-3(ScheduledMonitor this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            this$0.watch();
        }
        catch (Throwable e) {
            this$0.logger.error("Exception thrown from {} report. Exception was suppressed.", (Object)this$0.getClass().getSimpleName(), (Object)e);
        }
    }

    public ScheduledMonitor() {
        this(null, null, null, false, 15, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002\u00a8\u0006\u0005"}, d2={"Lai/platon/pulsar/common/concurrent/ScheduledMonitor$Companion;", "", "()V", "createDefaultExecutor", "Ljava/util/concurrent/ScheduledExecutorService;", "pulsar-common"})
    public static final class Companion {
        private Companion() {
        }

        private final ScheduledExecutorService createDefaultExecutor() {
            ThreadFactory factory = new ThreadFactoryBuilder().setNameFormat("em-%d").build();
            ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(factory);
            Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"newSingleThreadScheduledExecutor(factory)");
            return scheduledExecutorService;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

