/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.geometric;

import ai.platon.pulsar.common.geometric.AlignType;
import ai.platon.pulsar.common.geometric.GeoIntPoint;
import java.awt.Point;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\r\u0010\u0011\u001a\u00020\u0001*\u00020\u0007H\u0086\u0002\u001a\r\u0010\u0011\u001a\u00020\u0001*\u00020\u0002H\u0086\u0002\u001a\r\u0010\u0012\u001a\u00020\u0001*\u00020\u0007H\u0086\u0002\u001a\r\u0010\u0012\u001a\u00020\u0001*\u00020\u0002H\u0086\u0002\u001a\r\u0010\u0013\u001a\u00020\u0001*\u00020\u0002H\u0086\u0002\u001a\r\u0010\u0014\u001a\u00020\u0001*\u00020\u0002H\u0086\u0002\u001a\u0012\u0010\u0015\u001a\u00020\u0016*\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0002\u001a\u001c\u0010\u0018\u001a\u00020\u0019*\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u00022\b\b\u0002\u0010\u001b\u001a\u00020\u0016\u001a\n\u0010\u001c\u001a\u00020\u001d*\u00020\u0007\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\n\"\u0015\u0010\u000b\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\n\"\u0015\u0010\r\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0004\"\u0015\u0010\u000f\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0004\u00a8\u0006\u001e"}, d2={"area", "", "Ljava/awt/Rectangle;", "getArea", "(Ljava/awt/Rectangle;)I", "str", "", "Ljava/awt/Point;", "getStr", "(Ljava/awt/Point;)Ljava/lang/String;", "(Ljava/awt/Rectangle;)Ljava/lang/String;", "str2", "getStr2", "x2", "getX2", "y2", "getY2", "component1", "component2", "component3", "component4", "sim", "", "rect", "testAlignment", "Lai/platon/pulsar/common/geometric/AlignType;", "r", "bias", "toIntPoint", "Lai/platon/pulsar/common/geometric/GeoIntPoint;", "pulsar-common"})
public final class GeometricsKt {
    public static final int component1(@NotNull Point $this$component1) {
        Intrinsics.checkNotNullParameter((Object)$this$component1, (String)"<this>");
        return $this$component1.x;
    }

    public static final int component2(@NotNull Point $this$component2) {
        Intrinsics.checkNotNullParameter((Object)$this$component2, (String)"<this>");
        return $this$component2.y;
    }

    @NotNull
    public static final GeoIntPoint toIntPoint(@NotNull Point $this$toIntPoint) {
        Intrinsics.checkNotNullParameter((Object)$this$toIntPoint, (String)"<this>");
        return new GeoIntPoint($this$toIntPoint.x, $this$toIntPoint.y);
    }

    @NotNull
    public static final String getStr(@NotNull Point $this$str) {
        Intrinsics.checkNotNullParameter((Object)$this$str, (String)"<this>");
        return "[" + $this$str.x + " " + $this$str.y + "]";
    }

    public static final int getX2(@NotNull Rectangle $this$x2) {
        Intrinsics.checkNotNullParameter((Object)$this$x2, (String)"<this>");
        return $this$x2.x + $this$x2.width;
    }

    public static final int getY2(@NotNull Rectangle $this$y2) {
        Intrinsics.checkNotNullParameter((Object)$this$y2, (String)"<this>");
        return $this$y2.y + $this$y2.height;
    }

    public static final int component1(@NotNull Rectangle $this$component1) {
        Intrinsics.checkNotNullParameter((Object)$this$component1, (String)"<this>");
        return $this$component1.x;
    }

    public static final int component2(@NotNull Rectangle $this$component2) {
        Intrinsics.checkNotNullParameter((Object)$this$component2, (String)"<this>");
        return $this$component2.y;
    }

    public static final int component3(@NotNull Rectangle $this$component3) {
        Intrinsics.checkNotNullParameter((Object)$this$component3, (String)"<this>");
        return $this$component3.width;
    }

    public static final int component4(@NotNull Rectangle $this$component4) {
        Intrinsics.checkNotNullParameter((Object)$this$component4, (String)"<this>");
        return $this$component4.height;
    }

    public static final double sim(@NotNull Rectangle $this$sim, @NotNull Rectangle rect) {
        Intrinsics.checkNotNullParameter((Object)$this$sim, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        Rectangle overlap = $this$sim.intersection(rect);
        if (overlap.isEmpty()) {
            return 0.0;
        }
        Intrinsics.checkNotNullExpressionValue((Object)overlap, (String)"overlap");
        int a = GeometricsKt.getArea(overlap);
        int b = Math.max(GeometricsKt.getArea($this$sim), GeometricsKt.getArea(rect));
        return 1.0 * (double)a / (double)b;
    }

    public static final int getArea(@NotNull Rectangle $this$area) {
        Intrinsics.checkNotNullParameter((Object)$this$area, (String)"<this>");
        return $this$area.isEmpty() ? 0 : $this$area.width * $this$area.height;
    }

    @NotNull
    public static final String getStr(@NotNull Rectangle $this$str) {
        Intrinsics.checkNotNullParameter((Object)$this$str, (String)"<this>");
        return "[" + $this$str.x + " " + $this$str.y + " " + $this$str.width + " " + $this$str.height + "]";
    }

    @NotNull
    public static final String getStr2(@NotNull Rectangle $this$str2) {
        Intrinsics.checkNotNullParameter((Object)$this$str2, (String)"<this>");
        return "{x:" + $this$str2.x + " y:" + $this$str2.y + " w:" + $this$str2.width + " h:" + $this$str2.height + "}";
    }

    @NotNull
    public static final AlignType testAlignment(@NotNull Rectangle $this$testAlignment, @NotNull Rectangle r, double bias) {
        Intrinsics.checkNotNullParameter((Object)$this$testAlignment, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        double b = Math.min(bias, 1.0);
        return (double)Math.abs($this$testAlignment.x - r.x) <= b * (double)$this$testAlignment.width ? AlignType.LEFT : (Math.abs($this$testAlignment.getCenterX() - r.getCenterX()) <= b * (double)$this$testAlignment.width ? AlignType.V_CENTER : ((double)Math.abs(GeometricsKt.getX2($this$testAlignment) - GeometricsKt.getX2(r)) <= b * (double)$this$testAlignment.width ? AlignType.RIGHT : ((double)Math.abs($this$testAlignment.y - r.y) <= b * (double)$this$testAlignment.height ? AlignType.TOP : (Math.abs($this$testAlignment.getCenterY() - r.getCenterY()) <= b * (double)$this$testAlignment.height ? AlignType.H_CENTER : ((double)Math.abs(GeometricsKt.getY2($this$testAlignment) - GeometricsKt.getY2(r)) <= b * (double)$this$testAlignment.height ? AlignType.BOTTOM : AlignType.NONE)))));
    }

    public static /* synthetic */ AlignType testAlignment$default(Rectangle rectangle, Rectangle rectangle2, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = 0.2;
        }
        return GeometricsKt.testAlignment(rectangle, rectangle2, d);
    }
}

