/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class Histogram<E> {
    private Map<E, HistogramEntry> map = new HashMap<E, HistogramEntry>();
    private float totalValue = 0.0f;
    private int totalCount = 0;

    public void add(E x) {
        this.add(x, 1.0f);
    }

    public void add(E x, float value) {
        if (this.map.containsKey(x)) {
            HistogramEntry entry = this.map.get(x);
            entry.value += value;
            ++entry.count;
        } else {
            HistogramEntry entry = new HistogramEntry();
            entry.value = value;
            entry.count = 1;
            this.map.put(x, entry);
        }
        this.totalValue += value;
        ++this.totalCount;
    }

    public Set<E> getKeys() {
        return this.map.keySet();
    }

    public float getValue(E x) {
        return this.map.get(x).value;
    }

    public int getCount(E x) {
        return this.map.get(x).count;
    }

    public void add(Histogram<E> other) {
        for (E x : other.getKeys()) {
            this.add(x, other.getValue(x));
        }
    }

    public Histogram<E> normalize() {
        Histogram<E> normalized = new Histogram<E>();
        Set<E> keys = this.getKeys();
        for (E x : keys) {
            normalized.add(x, this.getValue(x) / this.totalValue);
        }
        return normalized;
    }

    public List<E> sortInverseByValue() {
        Vector<Map.Entry<E, HistogramEntry>> list = new Vector<Map.Entry<E, HistogramEntry>>(this.map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<E, HistogramEntry>>(){

            @Override
            public int compare(Map.Entry<E, HistogramEntry> entry, Map.Entry<E, HistogramEntry> entry1) {
                return entry.getValue().equals(entry1.getValue()) ? 0 : (entry.getValue().value < entry1.getValue().value ? 1 : -1);
            }
        });
        Vector list2 = new Vector();
        for (Map.Entry entry : list) {
            list2.add(entry.getKey());
        }
        return list2;
    }

    public List<E> sortByValue() {
        Vector<Map.Entry<E, HistogramEntry>> list = new Vector<Map.Entry<E, HistogramEntry>>(this.map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<E, HistogramEntry>>(){

            @Override
            public int compare(Map.Entry<E, HistogramEntry> entry, Map.Entry<E, HistogramEntry> entry1) {
                return entry.getValue().equals(entry1.getValue()) ? 0 : (entry.getValue().value > entry1.getValue().value ? 1 : -1);
            }
        });
        Vector list2 = new Vector();
        for (Map.Entry entry : list) {
            list2.add(entry.getKey());
        }
        return list2;
    }

    public String toString(List<E> items) {
        StringBuilder strBuilder = new StringBuilder();
        for (E item : items) {
            strBuilder.append(this.map.get(item).value).append(",").append(item).append("\n");
        }
        return strBuilder.toString();
    }

    class HistogramEntry {
        float value;
        int count;

        HistogramEntry() {
        }
    }
}

