/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.time.Duration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006J\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0006J\u001e\u0010\u0011\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004\u00a8\u0006\u0013"}, d2={"Lai/platon/pulsar/common/Ping;", "", "()V", "getCheckResult", "", "line", "", "getTimes", "", "ping", "", "ipAddress", "pingTimes", "timeout", "Ljava/time/Duration;", "ping02", "", "pingNeedTime", "timeOut", "pulsar-common"})
public final class Ping {
    @NotNull
    public static final Ping INSTANCE = new Ping();

    private Ping() {
    }

    public final boolean ping(@NotNull String ipAddress) {
        Intrinsics.checkNotNullParameter((Object)ipAddress, (String)"ipAddress");
        int timeOut = 3000;
        return InetAddress.getByName(ipAddress).isReachable(timeOut);
    }

    public final void ping02(@NotNull String ipAddress) {
        Intrinsics.checkNotNullParameter((Object)ipAddress, (String)"ipAddress");
        try {
            Process pro = Runtime.getRuntime().exec("ping " + ipAddress);
            BufferedReader buf = new BufferedReader(new InputStreamReader(pro.getInputStream()));
            String line = buf.readLine();
            while (line != null) {
                boolean bl = false;
                System.out.println((Object)line);
                line = buf.readLine();
            }
        }
        catch (Exception ex) {
            String string = ex.getMessage();
            boolean bl = false;
            System.out.println((Object)string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean ping(@NotNull String ipAddress, int pingTimes, @NotNull Duration timeout) {
        Intrinsics.checkNotNullParameter((Object)ipAddress, (String)"ipAddress");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        reader = null;
        r = Runtime.getRuntime();
        pingCommand = SystemUtils.IS_OS_WINDOWS != false ? "ping " + ipAddress + " /n " + pingTimes + " /w " + timeout.toMillis() : "ping -c " + pingTimes + " -w " + timeout.getSeconds() + " " + ipAddress;
        try {
            block16: {
                var7_7 = false;
                System.out.println((Object)pingCommand);
                var8_11 = r.exec(pingCommand);
                if (var8_11 != null) break block16;
                var9_15 = false;
                ** try [egrp 1[TRYBLOCK] [0 : 83->91)] { 
lbl15:
                // 1 sources

                ** GOTO lbl-1000
            }
            p = var8_11;
            reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            connectedCount = 0;
            line = reader.readLine();
            while (line != null) {
                var10_22 = false;
                System.out.println((Object)line);
                var10_21 = line;
                connectedCount += this.getCheckResult(var10_21);
                line = reader.readLine();
            }
            var10_23 = connectedCount == pingTimes;
            ** try [egrp 3[TRYBLOCK] [1 : 193->206)] { 
lbl30:
            // 1 sources

            ** GOTO lbl-1000
        }
        catch (Exception ex) {
            ex.printStackTrace();
            connectedCount = false;
            return connectedCount;
        }
lbl-1000:
        // 1 sources

        {
            var10_19 = reader;
            return var9_15;
        }
lbl40:
        // 1 sources

        catch (IOException e) {
            e.printStackTrace();
        }
        return var9_15;
lbl-1000:
        // 1 sources

        {
            var11_24 = reader;
            var11_24.close();
            return var10_23;
        }
lbl46:
        // 1 sources

        catch (IOException e) {
            e.printStackTrace();
        }
        return var10_23;
        finally {
            try {
                line = reader;
                if (line != null) {
                    line.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final float pingNeedTime(@NotNull String ipAddress, int pingTimes, int timeOut) {
        Intrinsics.checkNotNullParameter((Object)ipAddress, (String)"ipAddress");
        reader = null;
        time = 10000.0f;
        r = Runtime.getRuntime();
        pingCommand = SystemUtils.IS_OS_WINDOWS != false ? "ping " + ipAddress + " -n " + pingTimes + " -w " + timeOut : "ping -c " + pingTimes + " -w " + timeOut / 1000 + " " + ipAddress;
        try {
            block17: {
                var9_8 = r.exec(pingCommand);
                if (var9_8 != null) break block17;
                var10_12 = time;
                ** try [egrp 1[TRYBLOCK] [0 : 69->77)] { 
lbl13:
                // 1 sources

                ** GOTO lbl-1000
            }
            p = var9_8;
            reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            connectedCount = 0;
            timeTotal = 0.0f;
            spendTime = 0.0f;
            line = reader.readLine();
            while (line != null) {
                var13_23 = line;
                spendTime = this.getTimes(var13_23);
                if (spendTime > 0.0f) {
                    timeTotal += spendTime;
                    var13_24 = connectedCount;
                    connectedCount = var13_24 + 1;
                }
                line = reader.readLine();
            }
            var13_25 = timeTotal / (float)connectedCount;
            ** try [egrp 3[TRYBLOCK] [1 : 190->203)] { 
lbl32:
            // 1 sources

            ** GOTO lbl-1000
        }
        catch (Exception ex) {
            ex.printStackTrace();
            connectedCount = time;
            return connectedCount;
        }
lbl-1000:
        // 1 sources

        {
            var11_16 = reader;
            return var10_12;
        }
lbl42:
        // 1 sources

        catch (IOException e) {
            e.printStackTrace();
        }
        return var10_12;
lbl-1000:
        // 1 sources

        {
            var14_26 = reader;
            var14_26.close();
            return var13_25;
        }
lbl48:
        // 1 sources

        catch (IOException e) {
            e.printStackTrace();
        }
        return var13_25;
        finally {
            try {
                timeTotal = reader;
                if (timeTotal != null) {
                    timeTotal.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public final float getTimes(@NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        if (this.getCheckResult(line) == 0) {
            return 0.0f;
        }
        Pattern pattern = SystemUtils.IS_OS_WINDOWS ? Pattern.compile("(\\d+)ms") : Pattern.compile("(\\d+.?\\d+)\\s+ms");
        Matcher matcher = pattern.matcher(line);
        if (matcher.find()) {
            String string = matcher.group();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"matcher.group()");
            string = StringsKt.substringBefore$default((String)string, (String)"ms", null, (int)2, null);
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String str = ((Object)StringsKt.trim((CharSequence)string2)).toString();
            return NumberUtils.toFloat((String)str);
        }
        return 10000.0f;
    }

    private final int getCheckResult(String line) {
        Pattern pattern = SystemUtils.IS_OS_WINDOWS ? Pattern.compile("(\\d+ms)(\\s+)(TTL=\\d+)", 2) : Pattern.compile("(ttl=\\d+)(\\s+)(.+)=(\\d+.?\\d+ ms)", 2);
        Matcher matcher = pattern.matcher(line);
        if (matcher.find()) {
            return 1;
        }
        return 0;
    }
}

