/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common;

import ai.platon.pulsar.common.AppPaths;
import ai.platon.pulsar.common.FileCommand;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\n2\b\b\u0002\u0010\u0011\u001a\u00020\u00042\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0007J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u000bR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u0005*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lai/platon/pulsar/common/FileCommand;", "", "()V", "CHECK_INTERVAL", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "COMMAND_FILE", "Ljava/nio/file/Path;", "LAST_CHECK_TIME", "", "", "", "log", "Lorg/slf4j/Logger;", "check", "", "command", "checkInterval", "action", "Lkotlin/Function0;", "", "pulsar-common"})
public final class FileCommand {
    @NotNull
    public static final FileCommand INSTANCE = new FileCommand();
    private static final Logger log = LoggerFactory.getLogger(FileCommand.class);
    private static final Path COMMAND_FILE = AppPaths.INSTANCE.getPATH_LOCAL_COMMAND();
    private static final Duration CHECK_INTERVAL = Duration.ofSeconds(15L);
    @NotNull
    private static final Map<String, Long> LAST_CHECK_TIME = new HashMap();

    private FileCommand() {
    }

    public final boolean check(@NotNull String command, long checkInterval) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Duration duration = Duration.ofSeconds(checkInterval);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(checkInterval)");
        return FileCommand.check$default(this, command, duration, null, 4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    public final boolean check(@NotNull String command, @NotNull Duration checkInterval, @NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)checkInterval, (String)"checkInterval");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        if (!Files.exists(COMMAND_FILE, new LinkOption[0])) {
            return false;
        }
        boolean exist = false;
        try {
            Class<FileCommand> clazz = FileCommand.class;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (clazz) {
                boolean bl3 = false;
                long modifiedTime = COMMAND_FILE.toFile().lastModified();
                long lastCheckTime = ((Number)LAST_CHECK_TIME.getOrDefault(command, 0L)).longValue();
                long now = System.currentTimeMillis();
                if (lastCheckTime <= modifiedTime && now - lastCheckTime >= checkInterval.toMillis()) {
                    Map<String, Long> map = LAST_CHECK_TIME;
                    Long l = now;
                    boolean bl4 = false;
                    map.put(command, l);
                    List<String> lines = Files.readAllLines(COMMAND_FILE);
                    exist = lines.stream().anyMatch(arg_0 -> FileCommand.check$lambda-1$lambda-0(command, arg_0));
                    if (exist) {
                        if (!StringUtils.containsIgnoreCase((CharSequence)command, (CharSequence)" -perm")) {
                            lines.remove(command);
                            Files.write(COMMAND_FILE, (Iterable<? extends CharSequence>)lines, new OpenOption[0]);
                        }
                        action.invoke();
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        catch (IOException e) {
            log.error(e.toString());
        }
        return exist;
    }

    public static /* synthetic */ boolean check$default(FileCommand fileCommand, String string, Duration duration, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            Duration duration2 = CHECK_INTERVAL;
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"CHECK_INTERVAL");
            duration = duration2;
        }
        if ((n & 4) != 0) {
            function0 = check.1.INSTANCE;
        }
        return fileCommand.check(string, duration, (Function0<Unit>)function0);
    }

    @JvmOverloads
    public final boolean check(@NotNull String command, @NotNull Duration checkInterval) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)checkInterval, (String)"checkInterval");
        return FileCommand.check$default(this, command, checkInterval, null, 4, null);
    }

    @JvmOverloads
    public final boolean check(@NotNull String command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        return FileCommand.check$default(this, command, null, null, 6, null);
    }

    private static final boolean check$lambda-1$lambda-0(String $command, String line) {
        Intrinsics.checkNotNullParameter((Object)$command, (String)"$command");
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        return StringsKt.contains$default((CharSequence)line, (CharSequence)$command, (boolean)false, (int)2, null);
    }
}

