/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common;

public enum FuzzyProbability {
    STRICTLY_NOT(0.0, 0.5),
    UNSURE(0.5, 0.6),
    MAYBE(0.6, 0.8),
    VERY_LIKELY(0.8, 0.95),
    MUST_BE(0.95, 1.0),
    CERTAINLY(1.0, 1.01);

    private final double floor;
    private final double ceiling;

    private FuzzyProbability(double floor, double ceiling) {
        this.floor = floor;
        this.ceiling = ceiling;
    }

    public double floor() {
        return this.floor;
    }

    public double ceiling() {
        return this.ceiling;
    }

    public static FuzzyProbability of(double sim) {
        if (sim < 0.5) {
            return STRICTLY_NOT;
        }
        if (sim < 0.6) {
            return UNSURE;
        }
        if (sim < 0.8) {
            return MAYBE;
        }
        if (sim < 0.95) {
            return VERY_LIKELY;
        }
        if (sim < 1.0) {
            return MUST_BE;
        }
        return CERTAINLY;
    }

    public static boolean maybe(FuzzyProbability p) {
        return p.ordinal() >= MAYBE.ordinal();
    }

    public static boolean veryLikely(FuzzyProbability p) {
        return p.ordinal() >= VERY_LIKELY.ordinal();
    }

    public static boolean mustBe(FuzzyProbability p) {
        return p.ordinal() >= MUST_BE.ordinal();
    }

    public static boolean certainly(FuzzyProbability p) {
        return p.ordinal() >= CERTAINLY.ordinal();
    }

    public static boolean strictlyNot(double sim) {
        return sim < FuzzyProbability.STRICTLY_NOT.ceiling;
    }

    public static boolean maybe(double sim) {
        return sim >= FuzzyProbability.MAYBE.floor;
    }

    public static boolean veryLikely(double sim) {
        return sim >= FuzzyProbability.VERY_LIKELY.floor;
    }

    public static boolean mustBe(double sim) {
        return sim >= FuzzyProbability.MUST_BE.floor;
    }

    public static boolean certainly(double sim) {
        return sim >= FuzzyProbability.CERTAINLY.floor;
    }
}

