/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common;

import ai.platon.pulsar.common.ExceptionsKt;
import java.util.Arrays;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.reflect.KClass;
import org.apache.commons.lang3.RandomStringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\u001a3\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0016\u0010\u0006\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\b0\u0007\"\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\t\u001a\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\b\u001a\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u0005\u001a\u001e\u0010\n\u001a\u00020\u000b\"\b\b\u0000\u0010\u000e*\u00020\b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0010\u001a&\u0010\n\u001a\u00020\u000b\"\b\b\u0000\u0010\u000e*\u00020\b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00102\u0006\u0010\r\u001a\u00020\u0005\u001a\u0006\u0010\u0011\u001a\u00020\u000b\u001a\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\bH\u0007\u001a\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\b\u001a3\u0010\u0014\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u00052\u0016\u0010\u0006\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\b0\u0007\"\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\u0015\u001a;\u0010\u0014\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0016\u0010\u0006\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\b0\u0007\"\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\u0016\u001a\u0016\u0010\u0017\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003\u001a;\u0010\u0017\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0016\u0010\u0006\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\b0\u0007\"\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\u0016\u001a\u0016\u0010\u0018\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003\u001a=\u0010\u0018\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0016\u0010\u0006\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\b0\u0007\"\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\u0016\u001a\u0016\u0010\u0019\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003\u001a;\u0010\u0019\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0016\u0010\u0006\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\b0\u0007\"\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\u0016\u00a8\u0006\u001a"}, d2={"catastrophicError", "", "t", "", "message", "", "args", "", "", "(Ljava/lang/Throwable;Ljava/lang/String;[Ljava/lang/Object;)V", "getLogger", "Lorg/slf4j/Logger;", "target", "postfix", "T", "clazz", "Lkotlin/reflect/KClass;", "getRandomLogger", "getTracer", "getTracerOrNull", "warn", "(Ljava/lang/Object;Ljava/lang/String;[Ljava/lang/Object;)V", "(Ljava/lang/Object;Ljava/lang/Throwable;Ljava/lang/String;[Ljava/lang/Object;)V", "warnForClose", "warnInterruptible", "warnUnexpected", "pulsar-common"})
@SourceDebugExtension(value={"SMAP\nLogs.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Logs.kt\nai/platon/pulsar/common/LogsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,182:1\n1#2:183\n*E\n"})
public final class LogsKt {
    @NotNull
    public static final <T> Logger getLogger(@NotNull KClass<T> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        return LogsKt.getLogger(clazz, "");
    }

    @NotNull
    public static final <T> Logger getLogger(@NotNull KClass<T> clazz, @NotNull String postfix) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)postfix, (String)"postfix");
        Logger logger = LoggerFactory.getLogger((String)(JvmClassMappingKt.getJavaClass(clazz).getName() + postfix));
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        return logger;
    }

    @NotNull
    public static final Logger getLogger(@NotNull Object target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return LogsKt.getLogger(target, "");
    }

    @NotNull
    public static final Logger getLogger(@NotNull Object target, @NotNull String postfix) {
        Logger logger;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)postfix, (String)"postfix");
        Object object = target;
        if (object instanceof Logger) {
            logger = (Logger)target;
        } else if (object instanceof KClass) {
            Logger logger2 = LoggerFactory.getLogger((String)(JvmClassMappingKt.getJavaClass((KClass)((KClass)target)).getName() + postfix));
            logger = logger2;
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        } else if (object instanceof Class) {
            Logger logger3 = LoggerFactory.getLogger((String)(((Class)target).getName() + postfix));
            logger = logger3;
            Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"getLogger(...)");
        } else if (object instanceof String) {
            Logger logger4 = LoggerFactory.getLogger((String)(target + postfix));
            logger = logger4;
            Intrinsics.checkNotNullExpressionValue((Object)logger4, (String)"getLogger(...)");
        } else {
            Logger logger5 = LoggerFactory.getLogger((String)(target.getClass().getName() + postfix));
            logger = logger5;
            Intrinsics.checkNotNullExpressionValue((Object)logger5, (String)"getLogger(...)");
        }
        return logger;
    }

    @Deprecated(message="Use getTracerOrNull(target) instead", replaceWith=@ReplaceWith(expression="getTracerOrNull(target)", imports={}))
    @Nullable
    public static final Logger getTracer(@NotNull Object target) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (target instanceof Logger) {
            Object object2 = target;
            Logger it = (Logger)object2;
            boolean bl = false;
            object = (Logger)(it.isTraceEnabled() ? object2 : null);
        } else {
            Logger logger;
            Logger it = logger = LogsKt.getLogger(target);
            boolean bl = false;
            object = it.isTraceEnabled() ? logger : null;
        }
        return object;
    }

    @Nullable
    public static final Logger getTracerOrNull(@NotNull Object target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return LogsKt.getTracer(target);
    }

    @NotNull
    public static final Logger getRandomLogger() {
        Logger logger = LoggerFactory.getLogger((String)RandomStringUtils.randomAlphabetic((int)8));
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        return logger;
    }

    public static final void catastrophicError(@NotNull Throwable t, @NotNull String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        System.err.println("Logging system crashed.");
        System.err.println("Failed to log warning message: " + message);
        t.printStackTrace();
    }

    public static final void warn(@NotNull Object target, @NotNull String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        LogsKt.getLogger(target).warn(message, Arrays.copyOf(args, args.length));
    }

    public static final void warn(@NotNull Object target, @NotNull Throwable t, @NotNull String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Logger logger = LogsKt.getLogger(target);
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.add((Object)t);
        spreadBuilder.addSpread((Object)args);
        logger.warn(message, spreadBuilder.toArray(new Object[spreadBuilder.size()]));
    }

    public static final void warnInterruptible(@NotNull Object target, @NotNull Throwable t) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        LogsKt.warnInterruptible(target, t, ExceptionsKt.stringify$default(t, null, null, 3, null), new Object[0]);
    }

    public static final void warnInterruptible(@NotNull Object target, @NotNull Throwable t, @Nullable String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        String string = message;
        if (string == null) {
            string = "";
        }
        String message1 = string;
        try {
            LogsKt.getLogger(target).warn(message1, Arrays.copyOf(args, args.length));
        }
        catch (Throwable t2) {
            LogsKt.catastrophicError(t2, message1, Arrays.copyOf(args, args.length));
        }
        if (t instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    public static final void warnUnexpected(@NotNull Object target, @NotNull Throwable t) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        LogsKt.warnUnexpected(target, t, ExceptionsKt.stringify$default(t, null, null, 3, null), new Object[0]);
    }

    public static final void warnUnexpected(@NotNull Object target, @NotNull Throwable t, @NotNull String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        try {
            Logger logger = LogsKt.getLogger(target);
            String message1 = "The exception is unexpected, it's best managed within custom code, such as event handlers.";
            logger.warn(message1 + "\n" + message, Arrays.copyOf(args, args.length));
        }
        catch (Throwable t2) {
            LogsKt.catastrophicError(t2, message, Arrays.copyOf(args, args.length));
        }
        if (t instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    public static final void warnForClose(@NotNull Object target, @NotNull Throwable t) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        LogsKt.warnForClose(target, t, ExceptionsKt.stringify$default(t, null, null, 3, null), new Object[0]);
    }

    public static final void warnForClose(@NotNull Object target, @NotNull Throwable t, @NotNull String message, Object ... args) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            Logger logger = null;
            try {
                logger = LogsKt.getLogger(target);
                logger.warn(message, Arrays.copyOf(args, args.length));
            }
            catch (Throwable t2) {
                LogsKt.catastrophicError(t2, message, Arrays.copyOf(args, args.length));
            }
            if (!(t instanceof InterruptedException)) break block4;
            Thread.currentThread().interrupt();
            String message2 = "\n                 * <p><em>Implementers of AutoClosable interface are strongly advised\n                 * to not have the {@code close} method throw {@link\n                 * InterruptedException}.</em>\n                 *\n                 * This exception interacts with a thread's interrupted status,\n                 * and runtime misbehavior is likely to occur if an {@code\n                 * InterruptedException} is {@linkplain Throwable#addSuppressed\n                 * suppressed}.\n                 *\n                 * More generally, if it would cause problems for an\n                 * exception to be suppressed, the {@code AutoCloseable.close}\n                 * method should not throw it.\n        ";
            Logger logger2 = logger;
            if (logger2 != null) {
                logger2.warn(message2);
            }
            Logger logger3 = logger;
            if (logger3 != null) {
                logger3.warn(ExceptionsKt.stringify$default(t, null, null, 3, null));
            }
        }
    }
}

