/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.browser;

import com.google.common.collect.Iterators;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.concurrent.ConcurrentSkipListSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0016"}, d2={"Lai/platon/pulsar/common/browser/ContextGroup;", "", "group", "", "(Ljava/lang/String;)V", "getGroup", "()Ljava/lang/String;", "iterator", "Lai/platon/pulsar/common/browser/ContextGroup$PathIterator;", "getIterator", "()Lai/platon/pulsar/common/browser/ContextGroup$PathIterator;", "paths", "Ljava/util/concurrent/ConcurrentSkipListSet;", "Ljava/nio/file/Path;", "size", "", "getSize", "()I", "add", "", "path", "PathIterator", "pulsar-common"})
public final class ContextGroup {
    @NotNull
    private final String group;
    @NotNull
    private final ConcurrentSkipListSet<Path> paths;
    @NotNull
    private final PathIterator iterator;

    public ContextGroup(@NotNull String group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        this.group = group;
        this.paths = new ConcurrentSkipListSet();
        this.iterator = new PathIterator((Iterable<? extends Path>)this.paths);
    }

    @NotNull
    public final String getGroup() {
        return this.group;
    }

    public final int getSize() {
        return this.paths.size();
    }

    @NotNull
    public final PathIterator getIterator() {
        return this.iterator;
    }

    public final void add(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.paths.add(path);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010)\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\nH\u0096\u0002J\t\u0010\u000b\u001a\u00020\u0002H\u0096\u0002R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\u0002 \b*\b\u0012\u0004\u0012\u00020\u00020\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lai/platon/pulsar/common/browser/ContextGroup$PathIterator;", "", "Ljava/nio/file/Path;", "paths", "", "(Ljava/lang/Iterable;)V", "iterator", "", "kotlin.jvm.PlatformType", "hasNext", "", "next", "pulsar-common"})
    public static final class PathIterator
    implements Iterator<Path>,
    KMappedMarker {
        @NotNull
        private final Iterable<Path> paths;
        @NotNull
        private final Iterator<Path> iterator;

        public PathIterator(@NotNull Iterable<? extends Path> paths) {
            Intrinsics.checkNotNullParameter(paths, (String)"paths");
            this.paths = paths;
            Iterator iterator = Iterators.cycle(this.paths);
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"cycle(...)");
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.paths.iterator().hasNext();
        }

        @Override
        @NotNull
        public Path next() {
            Path path = this.iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"next(...)");
            return path;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }
}

