/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.http;

import ai.platon.pulsar.common.http.HttpStatusCode;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\bI\b\u0086\u0081\u0002\u0018\u0000 X2\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002:\u0002XYB\u001f\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0011H\u0016J\b\u0010\u0014\u001a\u00020\u0011H\u0016J\b\u0010\u0015\u001a\u00020\u0011H\u0016J\b\u0010\u0016\u001a\u00020\u0011H\u0016J\u0006\u0010\u0005\u001a\u00020\u0006J\b\u0010\u0017\u001a\u00020\bH\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fj\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001fj\u0002\b j\u0002\b!j\u0002\b\"j\u0002\b#j\u0002\b$j\u0002\b%j\u0002\b&j\u0002\b'j\u0002\b(j\u0002\b)j\u0002\b*j\u0002\b+j\u0002\b,j\u0002\b-j\u0002\b.j\u0002\b/j\u0002\b0j\u0002\b1j\u0002\b2j\u0002\b3j\u0002\b4j\u0002\b5j\u0002\b6j\u0002\b7j\u0002\b8j\u0002\b9j\u0002\b:j\u0002\b;j\u0002\b<j\u0002\b=j\u0002\b>j\u0002\b?j\u0002\b@j\u0002\bAj\u0002\bBj\u0002\bCj\u0002\bDj\u0002\bEj\u0002\bFj\u0002\bGj\u0002\bHj\u0002\bIj\u0002\bJj\u0002\bKj\u0002\bLj\u0002\bMj\u0002\bNj\u0002\bOj\u0002\bPj\u0002\bQj\u0002\bRj\u0002\bSj\u0002\bTj\u0002\bUj\u0002\bVj\u0002\bW\u00a8\u0006Z"}, d2={"Lai/platon/pulsar/common/http/HttpStatus;", "", "Lai/platon/pulsar/common/http/HttpStatusCode;", "value", "", "series", "Lai/platon/pulsar/common/http/HttpStatus$Series;", "reasonPhrase", "", "(Ljava/lang/String;IILai/platon/pulsar/common/http/HttpStatus$Series;Ljava/lang/String;)V", "getReasonPhrase", "()Ljava/lang/String;", "getSeries", "()Lai/platon/pulsar/common/http/HttpStatus$Series;", "getValue", "()I", "is1xxInformational", "", "is2xxSuccessful", "is3xxRedirection", "is4xxClientError", "is5xxServerError", "isError", "toString", "CONTINUE", "SWITCHING_PROTOCOLS", "PROCESSING", "EARLY_HINTS", "CHECKPOINT", "OK", "CREATED", "ACCEPTED", "NON_AUTHORITATIVE_INFORMATION", "NO_CONTENT", "RESET_CONTENT", "PARTIAL_CONTENT", "MULTI_STATUS", "ALREADY_REPORTED", "IM_USED", "MULTIPLE_CHOICES", "MOVED_PERMANENTLY", "FOUND", "MOVED_TEMPORARILY", "SEE_OTHER", "NOT_MODIFIED", "USE_PROXY", "TEMPORARY_REDIRECT", "PERMANENT_REDIRECT", "BAD_REQUEST", "UNAUTHORIZED", "PAYMENT_REQUIRED", "FORBIDDEN", "NOT_FOUND", "METHOD_NOT_ALLOWED", "NOT_ACCEPTABLE", "PROXY_AUTHENTICATION_REQUIRED", "REQUEST_TIMEOUT", "CONFLICT", "GONE", "LENGTH_REQUIRED", "PRECONDITION_FAILED", "PAYLOAD_TOO_LARGE", "REQUEST_ENTITY_TOO_LARGE", "URI_TOO_LONG", "REQUEST_URI_TOO_LONG", "UNSUPPORTED_MEDIA_TYPE", "REQUESTED_RANGE_NOT_SATISFIABLE", "EXPECTATION_FAILED", "I_AM_A_TEAPOT", "FAILED_DEPENDENCY", "TOO_EARLY", "UPGRADE_REQUIRED", "PRECONDITION_REQUIRED", "TOO_MANY_REQUESTS", "REQUEST_HEADER_FIELDS_TOO_LARGE", "UNAVAILABLE_FOR_LEGAL_REASONS", "INTERNAL_SERVER_ERROR", "NOT_IMPLEMENTED", "BAD_GATEWAY", "SERVICE_UNAVAILABLE", "GATEWAY_TIMEOUT", "HTTP_VERSION_NOT_SUPPORTED", "VARIANT_ALSO_NEGOTIATES", "INSUFFICIENT_STORAGE", "LOOP_DETECTED", "BANDWIDTH_LIMIT_EXCEEDED", "NOT_EXTENDED", "NETWORK_AUTHENTICATION_REQUIRED", "Companion", "Series", "pulsar-common"})
public final class HttpStatus
extends Enum<HttpStatus>
implements HttpStatusCode {
    @NotNull
    public static final Companion Companion;
    private final int value;
    @NotNull
    private final Series series;
    @NotNull
    private final String reasonPhrase;
    @NotNull
    private static final HttpStatus[] VALUES;
    public static final /* enum */ HttpStatus CONTINUE;
    public static final /* enum */ HttpStatus SWITCHING_PROTOCOLS;
    public static final /* enum */ HttpStatus PROCESSING;
    public static final /* enum */ HttpStatus EARLY_HINTS;
    @Deprecated(message="in favor of {@link #EARLY_HINTS} which will be returned from {@code HttpStatus.valueOf(103)}")
    public static final /* enum */ HttpStatus CHECKPOINT;
    public static final /* enum */ HttpStatus OK;
    public static final /* enum */ HttpStatus CREATED;
    public static final /* enum */ HttpStatus ACCEPTED;
    public static final /* enum */ HttpStatus NON_AUTHORITATIVE_INFORMATION;
    public static final /* enum */ HttpStatus NO_CONTENT;
    public static final /* enum */ HttpStatus RESET_CONTENT;
    public static final /* enum */ HttpStatus PARTIAL_CONTENT;
    public static final /* enum */ HttpStatus MULTI_STATUS;
    public static final /* enum */ HttpStatus ALREADY_REPORTED;
    public static final /* enum */ HttpStatus IM_USED;
    public static final /* enum */ HttpStatus MULTIPLE_CHOICES;
    public static final /* enum */ HttpStatus MOVED_PERMANENTLY;
    public static final /* enum */ HttpStatus FOUND;
    @Deprecated(message="in favor of {@link #FOUND} which will be returned from {@code HttpStatus.valueOf(302)}")
    public static final /* enum */ HttpStatus MOVED_TEMPORARILY;
    public static final /* enum */ HttpStatus SEE_OTHER;
    public static final /* enum */ HttpStatus NOT_MODIFIED;
    @Deprecated(message="due to security concerns regarding in-band configuration of a proxy")
    public static final /* enum */ HttpStatus USE_PROXY;
    public static final /* enum */ HttpStatus TEMPORARY_REDIRECT;
    public static final /* enum */ HttpStatus PERMANENT_REDIRECT;
    public static final /* enum */ HttpStatus BAD_REQUEST;
    public static final /* enum */ HttpStatus UNAUTHORIZED;
    public static final /* enum */ HttpStatus PAYMENT_REQUIRED;
    public static final /* enum */ HttpStatus FORBIDDEN;
    public static final /* enum */ HttpStatus NOT_FOUND;
    public static final /* enum */ HttpStatus METHOD_NOT_ALLOWED;
    public static final /* enum */ HttpStatus NOT_ACCEPTABLE;
    public static final /* enum */ HttpStatus PROXY_AUTHENTICATION_REQUIRED;
    public static final /* enum */ HttpStatus REQUEST_TIMEOUT;
    public static final /* enum */ HttpStatus CONFLICT;
    public static final /* enum */ HttpStatus GONE;
    public static final /* enum */ HttpStatus LENGTH_REQUIRED;
    public static final /* enum */ HttpStatus PRECONDITION_FAILED;
    public static final /* enum */ HttpStatus PAYLOAD_TOO_LARGE;
    @Deprecated(message="in favor of {@link #PAYLOAD_TOO_LARGE} which will be\n\t  returned from {@code HttpStatus.valueOf(413)}")
    public static final /* enum */ HttpStatus REQUEST_ENTITY_TOO_LARGE;
    public static final /* enum */ HttpStatus URI_TOO_LONG;
    @Deprecated(message="in favor of {@link #URI_TOO_LONG} which will be returned from {@code HttpStatus.valueOf(414)}")
    public static final /* enum */ HttpStatus REQUEST_URI_TOO_LONG;
    public static final /* enum */ HttpStatus UNSUPPORTED_MEDIA_TYPE;
    public static final /* enum */ HttpStatus REQUESTED_RANGE_NOT_SATISFIABLE;
    public static final /* enum */ HttpStatus EXPECTATION_FAILED;
    public static final /* enum */ HttpStatus I_AM_A_TEAPOT;
    public static final /* enum */ HttpStatus FAILED_DEPENDENCY;
    public static final /* enum */ HttpStatus TOO_EARLY;
    public static final /* enum */ HttpStatus UPGRADE_REQUIRED;
    public static final /* enum */ HttpStatus PRECONDITION_REQUIRED;
    public static final /* enum */ HttpStatus TOO_MANY_REQUESTS;
    public static final /* enum */ HttpStatus REQUEST_HEADER_FIELDS_TOO_LARGE;
    public static final /* enum */ HttpStatus UNAVAILABLE_FOR_LEGAL_REASONS;
    public static final /* enum */ HttpStatus INTERNAL_SERVER_ERROR;
    public static final /* enum */ HttpStatus NOT_IMPLEMENTED;
    public static final /* enum */ HttpStatus BAD_GATEWAY;
    public static final /* enum */ HttpStatus SERVICE_UNAVAILABLE;
    public static final /* enum */ HttpStatus GATEWAY_TIMEOUT;
    public static final /* enum */ HttpStatus HTTP_VERSION_NOT_SUPPORTED;
    public static final /* enum */ HttpStatus VARIANT_ALSO_NEGOTIATES;
    public static final /* enum */ HttpStatus INSUFFICIENT_STORAGE;
    public static final /* enum */ HttpStatus LOOP_DETECTED;
    public static final /* enum */ HttpStatus BANDWIDTH_LIMIT_EXCEEDED;
    public static final /* enum */ HttpStatus NOT_EXTENDED;
    public static final /* enum */ HttpStatus NETWORK_AUTHENTICATION_REQUIRED;
    private static final /* synthetic */ HttpStatus[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private HttpStatus(int value, Series series, String reasonPhrase) {
        this.value = value;
        this.series = series;
        this.reasonPhrase = reasonPhrase;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @NotNull
    public final Series getSeries() {
        return this.series;
    }

    @NotNull
    public final String getReasonPhrase() {
        return this.reasonPhrase;
    }

    @NotNull
    public final Series series() {
        return this.series;
    }

    @Override
    public boolean is1xxInformational() {
        return this.series() == Series.INFORMATIONAL;
    }

    @Override
    public boolean is2xxSuccessful() {
        return this.series() == Series.SUCCESSFUL;
    }

    @Override
    public boolean is3xxRedirection() {
        return this.series() == Series.REDIRECTION;
    }

    @Override
    public boolean is4xxClientError() {
        return this.series() == Series.CLIENT_ERROR;
    }

    @Override
    public boolean is5xxServerError() {
        return this.series() == Series.SERVER_ERROR;
    }

    @Override
    public boolean isError() {
        return this.is4xxClientError() || this.is5xxServerError();
    }

    @NotNull
    public String toString() {
        return this.getValue() + " " + this.name();
    }

    @Override
    public boolean isSameCodeAs(@NotNull HttpStatusCode other) {
        return HttpStatusCode.DefaultImpls.isSameCodeAs(this, other);
    }

    @Override
    @NotNull
    public HttpStatusCode valueOf(int code) {
        return HttpStatusCode.DefaultImpls.valueOf(this, code);
    }

    public static HttpStatus[] values() {
        return (HttpStatus[])$VALUES.clone();
    }

    public static HttpStatus valueOf(String value) {
        return Enum.valueOf(HttpStatus.class, value);
    }

    @NotNull
    public static EnumEntries<HttpStatus> getEntries() {
        return $ENTRIES;
    }

    static {
        CONTINUE = new HttpStatus(100, Series.INFORMATIONAL, "Continue");
        SWITCHING_PROTOCOLS = new HttpStatus(101, Series.INFORMATIONAL, "Switching Protocols");
        PROCESSING = new HttpStatus(102, Series.INFORMATIONAL, "Processing");
        EARLY_HINTS = new HttpStatus(103, Series.INFORMATIONAL, "Early Hints");
        CHECKPOINT = new HttpStatus(103, Series.INFORMATIONAL, "Checkpoint");
        OK = new HttpStatus(200, Series.SUCCESSFUL, "OK");
        CREATED = new HttpStatus(201, Series.SUCCESSFUL, "Created");
        ACCEPTED = new HttpStatus(202, Series.SUCCESSFUL, "Accepted");
        NON_AUTHORITATIVE_INFORMATION = new HttpStatus(203, Series.SUCCESSFUL, "Non-Authoritative Information");
        NO_CONTENT = new HttpStatus(204, Series.SUCCESSFUL, "No Content");
        RESET_CONTENT = new HttpStatus(205, Series.SUCCESSFUL, "Reset Content");
        PARTIAL_CONTENT = new HttpStatus(206, Series.SUCCESSFUL, "Partial Content");
        MULTI_STATUS = new HttpStatus(207, Series.SUCCESSFUL, "Multi-Status");
        ALREADY_REPORTED = new HttpStatus(208, Series.SUCCESSFUL, "Already Reported");
        IM_USED = new HttpStatus(226, Series.SUCCESSFUL, "IM Used");
        MULTIPLE_CHOICES = new HttpStatus(300, Series.REDIRECTION, "Multiple Choices");
        MOVED_PERMANENTLY = new HttpStatus(301, Series.REDIRECTION, "Moved Permanently");
        FOUND = new HttpStatus(302, Series.REDIRECTION, "Found");
        MOVED_TEMPORARILY = new HttpStatus(302, Series.REDIRECTION, "Moved Temporarily");
        SEE_OTHER = new HttpStatus(303, Series.REDIRECTION, "See Other");
        NOT_MODIFIED = new HttpStatus(304, Series.REDIRECTION, "Not Modified");
        USE_PROXY = new HttpStatus(305, Series.REDIRECTION, "Use Proxy");
        TEMPORARY_REDIRECT = new HttpStatus(307, Series.REDIRECTION, "Temporary Redirect");
        PERMANENT_REDIRECT = new HttpStatus(308, Series.REDIRECTION, "Permanent Redirect");
        BAD_REQUEST = new HttpStatus(400, Series.CLIENT_ERROR, "Bad Request");
        UNAUTHORIZED = new HttpStatus(401, Series.CLIENT_ERROR, "Unauthorized");
        PAYMENT_REQUIRED = new HttpStatus(402, Series.CLIENT_ERROR, "Payment Required");
        FORBIDDEN = new HttpStatus(403, Series.CLIENT_ERROR, "Forbidden");
        NOT_FOUND = new HttpStatus(404, Series.CLIENT_ERROR, "Not Found");
        METHOD_NOT_ALLOWED = new HttpStatus(405, Series.CLIENT_ERROR, "Method Not Allowed");
        NOT_ACCEPTABLE = new HttpStatus(406, Series.CLIENT_ERROR, "Not Acceptable");
        PROXY_AUTHENTICATION_REQUIRED = new HttpStatus(407, Series.CLIENT_ERROR, "Proxy Authentication Required");
        REQUEST_TIMEOUT = new HttpStatus(408, Series.CLIENT_ERROR, "Request Timeout");
        CONFLICT = new HttpStatus(409, Series.CLIENT_ERROR, "Conflict");
        GONE = new HttpStatus(410, Series.CLIENT_ERROR, "Gone");
        LENGTH_REQUIRED = new HttpStatus(411, Series.CLIENT_ERROR, "Length Required");
        PRECONDITION_FAILED = new HttpStatus(412, Series.CLIENT_ERROR, "Precondition Failed");
        PAYLOAD_TOO_LARGE = new HttpStatus(413, Series.CLIENT_ERROR, "Payload Too Large");
        REQUEST_ENTITY_TOO_LARGE = new HttpStatus(413, Series.CLIENT_ERROR, "Request Entity Too Large");
        URI_TOO_LONG = new HttpStatus(414, Series.CLIENT_ERROR, "URI Too Long");
        REQUEST_URI_TOO_LONG = new HttpStatus(414, Series.CLIENT_ERROR, "Request-URI Too Long");
        UNSUPPORTED_MEDIA_TYPE = new HttpStatus(415, Series.CLIENT_ERROR, "Unsupported Media Type");
        REQUESTED_RANGE_NOT_SATISFIABLE = new HttpStatus(416, Series.CLIENT_ERROR, "Requested range not satisfiable");
        EXPECTATION_FAILED = new HttpStatus(417, Series.CLIENT_ERROR, "Expectation Failed");
        I_AM_A_TEAPOT = new HttpStatus(418, Series.CLIENT_ERROR, "I'm a teapot");
        FAILED_DEPENDENCY = new HttpStatus(424, Series.CLIENT_ERROR, "Failed Dependency");
        TOO_EARLY = new HttpStatus(425, Series.CLIENT_ERROR, "Too Early");
        UPGRADE_REQUIRED = new HttpStatus(426, Series.CLIENT_ERROR, "Upgrade Required");
        PRECONDITION_REQUIRED = new HttpStatus(428, Series.CLIENT_ERROR, "Precondition Required");
        TOO_MANY_REQUESTS = new HttpStatus(429, Series.CLIENT_ERROR, "Too Many Requests");
        REQUEST_HEADER_FIELDS_TOO_LARGE = new HttpStatus(431, Series.CLIENT_ERROR, "Request Header Fields Too Large");
        UNAVAILABLE_FOR_LEGAL_REASONS = new HttpStatus(451, Series.CLIENT_ERROR, "Unavailable For Legal Reasons");
        INTERNAL_SERVER_ERROR = new HttpStatus(500, Series.SERVER_ERROR, "Internal Server Error");
        NOT_IMPLEMENTED = new HttpStatus(501, Series.SERVER_ERROR, "Not Implemented");
        BAD_GATEWAY = new HttpStatus(502, Series.SERVER_ERROR, "Bad Gateway");
        SERVICE_UNAVAILABLE = new HttpStatus(503, Series.SERVER_ERROR, "Service Unavailable");
        GATEWAY_TIMEOUT = new HttpStatus(504, Series.SERVER_ERROR, "Gateway Timeout");
        HTTP_VERSION_NOT_SUPPORTED = new HttpStatus(505, Series.SERVER_ERROR, "HTTP Version not supported");
        VARIANT_ALSO_NEGOTIATES = new HttpStatus(506, Series.SERVER_ERROR, "Variant Also Negotiates");
        INSUFFICIENT_STORAGE = new HttpStatus(507, Series.SERVER_ERROR, "Insufficient Storage");
        LOOP_DETECTED = new HttpStatus(508, Series.SERVER_ERROR, "Loop Detected");
        BANDWIDTH_LIMIT_EXCEEDED = new HttpStatus(509, Series.SERVER_ERROR, "Bandwidth Limit Exceeded");
        NOT_EXTENDED = new HttpStatus(510, Series.SERVER_ERROR, "Not Extended");
        NETWORK_AUTHENTICATION_REQUIRED = new HttpStatus(511, Series.SERVER_ERROR, "Network Authentication Required");
        $VALUES = httpStatusArray = new HttpStatus[]{HttpStatus.CONTINUE, HttpStatus.SWITCHING_PROTOCOLS, HttpStatus.PROCESSING, HttpStatus.EARLY_HINTS, HttpStatus.CHECKPOINT, HttpStatus.OK, HttpStatus.CREATED, HttpStatus.ACCEPTED, HttpStatus.NON_AUTHORITATIVE_INFORMATION, HttpStatus.NO_CONTENT, HttpStatus.RESET_CONTENT, HttpStatus.PARTIAL_CONTENT, HttpStatus.MULTI_STATUS, HttpStatus.ALREADY_REPORTED, HttpStatus.IM_USED, HttpStatus.MULTIPLE_CHOICES, HttpStatus.MOVED_PERMANENTLY, HttpStatus.FOUND, HttpStatus.MOVED_TEMPORARILY, HttpStatus.SEE_OTHER, HttpStatus.NOT_MODIFIED, HttpStatus.USE_PROXY, HttpStatus.TEMPORARY_REDIRECT, HttpStatus.PERMANENT_REDIRECT, HttpStatus.BAD_REQUEST, HttpStatus.UNAUTHORIZED, HttpStatus.PAYMENT_REQUIRED, HttpStatus.FORBIDDEN, HttpStatus.NOT_FOUND, HttpStatus.METHOD_NOT_ALLOWED, HttpStatus.NOT_ACCEPTABLE, HttpStatus.PROXY_AUTHENTICATION_REQUIRED, HttpStatus.REQUEST_TIMEOUT, HttpStatus.CONFLICT, HttpStatus.GONE, HttpStatus.LENGTH_REQUIRED, HttpStatus.PRECONDITION_FAILED, HttpStatus.PAYLOAD_TOO_LARGE, HttpStatus.REQUEST_ENTITY_TOO_LARGE, HttpStatus.URI_TOO_LONG, HttpStatus.REQUEST_URI_TOO_LONG, HttpStatus.UNSUPPORTED_MEDIA_TYPE, HttpStatus.REQUESTED_RANGE_NOT_SATISFIABLE, HttpStatus.EXPECTATION_FAILED, HttpStatus.I_AM_A_TEAPOT, HttpStatus.FAILED_DEPENDENCY, HttpStatus.TOO_EARLY, HttpStatus.UPGRADE_REQUIRED, HttpStatus.PRECONDITION_REQUIRED, HttpStatus.TOO_MANY_REQUESTS, HttpStatus.REQUEST_HEADER_FIELDS_TOO_LARGE, HttpStatus.UNAVAILABLE_FOR_LEGAL_REASONS, HttpStatus.INTERNAL_SERVER_ERROR, HttpStatus.NOT_IMPLEMENTED, HttpStatus.BAD_GATEWAY, HttpStatus.SERVICE_UNAVAILABLE, HttpStatus.GATEWAY_TIMEOUT, HttpStatus.HTTP_VERSION_NOT_SUPPORTED, HttpStatus.VARIANT_ALSO_NEGOTIATES, HttpStatus.INSUFFICIENT_STORAGE, HttpStatus.LOOP_DETECTED, HttpStatus.BANDWIDTH_LIMIT_EXCEEDED, HttpStatus.NOT_EXTENDED, HttpStatus.NETWORK_AUTHENTICATION_REQUIRED};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
        VALUES = HttpStatus.values();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\tH\u0007J\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tR\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lai/platon/pulsar/common/http/HttpStatus$Companion;", "", "()V", "VALUES", "", "Lai/platon/pulsar/common/http/HttpStatus;", "[Lai/platon/pulsar/common/http/HttpStatus;", "resolve", "statusCode", "", "valueOf", "pulsar-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HttpStatus valueOf(int statusCode) {
            HttpStatus httpStatus = this.resolve(statusCode);
            if (httpStatus == null) {
                throw new IllegalArgumentException("No matching constant for [" + statusCode + "]");
            }
            return httpStatus;
        }

        @org.springframework.lang.Nullable
        @Nullable
        public final HttpStatus resolve(int statusCode) {
            for (HttpStatus status : VALUES) {
                if (status.getValue() != statusCode) continue;
                return status;
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u0000 \n2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\nB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0002\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\u000b"}, d2={"Lai/platon/pulsar/common/http/HttpStatus$Series;", "", "value", "", "(Ljava/lang/String;II)V", "INFORMATIONAL", "SUCCESSFUL", "REDIRECTION", "CLIENT_ERROR", "SERVER_ERROR", "Companion", "pulsar-common"})
    public static final class Series
    extends Enum<Series> {
        @NotNull
        public static final Companion Companion;
        private final int value;
        public static final /* enum */ Series INFORMATIONAL;
        public static final /* enum */ Series SUCCESSFUL;
        public static final /* enum */ Series REDIRECTION;
        public static final /* enum */ Series CLIENT_ERROR;
        public static final /* enum */ Series SERVER_ERROR;
        private static final /* synthetic */ Series[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Series(int value) {
            this.value = value;
        }

        public final int value() {
            return this.value;
        }

        public static Series[] values() {
            return (Series[])$VALUES.clone();
        }

        public static Series valueOf(String value) {
            return Enum.valueOf(Series.class, value);
        }

        @NotNull
        public static EnumEntries<Series> getEntries() {
            return $ENTRIES;
        }

        static {
            INFORMATIONAL = new Series(1);
            SUCCESSFUL = new Series(2);
            REDIRECTION = new Series(3);
            CLIENT_ERROR = new Series(4);
            SERVER_ERROR = new Series(5);
            $VALUES = seriesArray = new Series[]{Series.INFORMATIONAL, Series.SUCCESSFUL, Series.REDIRECTION, Series.CLIENT_ERROR, Series.SERVER_ERROR};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0007J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\n"}, d2={"Lai/platon/pulsar/common/http/HttpStatus$Series$Companion;", "", "()V", "resolve", "Lai/platon/pulsar/common/http/HttpStatus$Series;", "statusCode", "", "valueOf", "status", "Lai/platon/pulsar/common/http/HttpStatus;", "pulsar-common"})
        public static final class Companion {
            private Companion() {
            }

            @Deprecated(message="as of 5.3, in favor of invoking {@link HttpStatus#series()} directly")
            @NotNull
            public final Series valueOf(@NotNull HttpStatus status) {
                Intrinsics.checkNotNullParameter((Object)status, (String)"status");
                return status.getSeries();
            }

            @NotNull
            public final Series valueOf(int statusCode) {
                Series series = this.resolve(statusCode);
                if (series == null) {
                    throw new IllegalArgumentException("No matching constant for [" + statusCode + "]");
                }
                return series;
            }

            @org.springframework.lang.Nullable
            @Nullable
            public final Series resolve(int statusCode) {
                int seriesCode = statusCode / 100;
                for (Series series : Series.values()) {
                    if (series.value != seriesCode) continue;
                    return series;
                }
                return null;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

