/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.proxy;

import ai.platon.pulsar.common.AppContext;
import ai.platon.pulsar.common.AppFiles;
import ai.platon.pulsar.common.AppPaths;
import ai.platon.pulsar.common.FileCommand;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.proxy.NoProxyException;
import ai.platon.pulsar.common.proxy.ProxyEntry;
import ai.platon.pulsar.common.proxy.ProxyPool;
import ai.platon.pulsar.common.proxy.ProxyPoolManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\b\b\u0016\u0018\u0000 H2\u00020\u0001:\u0001HB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u00109\u001a\u00020:H\u0016J<\u0010;\u001a\u0002H<\"\u0004\b\u0000\u0010<2\b\u0010=\u001a\u0004\u0018\u00010\n2\u001c\u0010>\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002H<0@\u0012\u0006\u0012\u0004\u0018\u00010A0?H\u0096@\u00a2\u0006\u0002\u0010BJ<\u0010C\u001a\u0002H<\"\u0004\b\u0000\u0010<2\b\u0010=\u001a\u0004\u0018\u00010\n2\u001c\u0010>\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002H<0@\u0012\u0006\u0012\u0004\u0018\u00010A0?H\u0082@\u00a2\u0006\u0002\u0010BJ\u0018\u0010D\u001a\u00020:2\u0006\u0010E\u001a\u00020\n2\u0006\u0010F\u001a\u00020\u0019H\u0016J\b\u0010G\u001a\u00020,H\u0016R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\"\u0010\u0014\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0013\"\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001aR\u0011\u0010\u001c\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001aR\u0014\u0010\u001d\u001a\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001aR\u0014\u0010\u001e\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001aR\"\u0010\u001f\u001a\n \u0011*\u0004\u0018\u00010 0 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020&\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u001a\u0010+\u001a\u00020,X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u001a\u00101\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\u001a\"\u0004\b3\u00104R\u0017\u00105\u001a\b\u0012\u0004\u0012\u00020\n06\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108\u00a8\u0006I"}, d2={"Lai/platon/pulsar/common/proxy/ProxyPoolManager;", "Ljava/lang/AutoCloseable;", "proxyPool", "Lai/platon/pulsar/common/proxy/ProxyPool;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/common/proxy/ProxyPool;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "activeProxyEntries", "Ljava/util/concurrent/ConcurrentSkipListMap;", "Ljava/nio/file/Path;", "Lai/platon/pulsar/common/proxy/ProxyEntry;", "getActiveProxyEntries", "()Ljava/util/concurrent/ConcurrentSkipListMap;", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "idleTime", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "getIdleTime", "()Ljava/time/Duration;", "idleTimeout", "getIdleTimeout", "setIdleTimeout", "(Ljava/time/Duration;)V", "isActive", "", "()Z", "isDisabled", "isEnabled", "isForceIdle", "isIdle", "lastActiveTime", "Ljava/time/Instant;", "getLastActiveTime", "()Ljava/time/Instant;", "setLastActiveTime", "(Ljava/time/Instant;)V", "numRunningTasks", "Ljava/util/concurrent/atomic/AtomicInteger;", "getNumRunningTasks", "()Ljava/util/concurrent/atomic/AtomicInteger;", "getProxyPool", "()Lai/platon/pulsar/common/proxy/ProxyPool;", "statusString", "", "getStatusString", "()Ljava/lang/String;", "setStatusString", "(Ljava/lang/String;)V", "verbose", "getVerbose", "setVerbose", "(Z)V", "workingProxyEntries", "Ljava/util/concurrent/ConcurrentSkipListSet;", "getWorkingProxyEntries", "()Ljava/util/concurrent/ConcurrentSkipListSet;", "close", "", "runWith", "R", "proxyEntry", "task", "Lkotlin/Function1;", "Lkotlin/coroutines/Continuation;", "", "(Lai/platon/pulsar/common/proxy/ProxyEntry;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "runWith0", "takeOff", "excludedProxy", "ban", "toString", "Companion", "pulsar-common"})
@SourceDebugExtension(value={"SMAP\nProxyPoolManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProxyPoolManager.kt\nai/platon/pulsar/common/proxy/ProxyPoolManager\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,190:1\n11065#2:191\n11400#2,3:192\n1549#3:195\n1620#3,3:196\n*S KotlinDebug\n*F\n+ 1 ProxyPoolManager.kt\nai/platon/pulsar/common/proxy/ProxyPoolManager\n*L\n96#1:191\n96#1:192,3\n97#1:195\n97#1:196,3\n*E\n"})
public class ProxyPoolManager
implements AutoCloseable {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final ProxyPool proxyPool;
    @NotNull
    private final ImmutableConfig conf;
    private Instant lastActiveTime;
    private Duration idleTimeout;
    @NotNull
    private final AtomicInteger numRunningTasks;
    @NotNull
    private String statusString;
    private boolean verbose;
    @NotNull
    private final ConcurrentSkipListMap<Path, ProxyEntry> activeProxyEntries;
    @NotNull
    private final ConcurrentSkipListSet<ProxyEntry> workingProxyEntries;
    @NotNull
    private final AtomicBoolean closed;
    @NotNull
    private static final String PROXY_PROVIDER_FILE_NAME = "proxy.providers.txt";
    @NotNull
    private static final List<Path> DEFAULT_PROXY_PROVIDER_FILES;
    private static final Duration PROXY_FILE_WATCH_INTERVAL;
    private static Instant providerDirLastWatchTime;
    private static long numEnabledProviderFiles;

    public ProxyPoolManager(@NotNull ProxyPool proxyPool, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)proxyPool, (String)"proxyPool");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.proxyPool = proxyPool;
        this.conf = conf;
        this.lastActiveTime = Instant.EPOCH;
        Duration duration = Duration.ofMinutes(10L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMinutes(...)");
        this.idleTimeout = this.conf.getDuration("proxy.idle.timeout", duration);
        this.numRunningTasks = new AtomicInteger();
        this.statusString = "";
        this.activeProxyEntries = new ConcurrentSkipListMap();
        this.workingProxyEntries = new ConcurrentSkipListSet();
        this.closed = new AtomicBoolean();
    }

    @NotNull
    public final ProxyPool getProxyPool() {
        return this.proxyPool;
    }

    private final boolean isForceIdle() {
        return FileCommand.INSTANCE.check("IPS-force-idle", 15L);
    }

    public final Instant getLastActiveTime() {
        return this.lastActiveTime;
    }

    public final void setLastActiveTime(Instant instant) {
        this.lastActiveTime = instant;
    }

    public final Duration getIdleTimeout() {
        return this.idleTimeout;
    }

    public final void setIdleTimeout(Duration duration) {
        this.idleTimeout = duration;
    }

    public final Duration getIdleTime() {
        return Duration.between(this.lastActiveTime, Instant.now());
    }

    public boolean isIdle() {
        return this.numRunningTasks.get() == 0 && this.getIdleTime().compareTo(this.idleTimeout) > 0 || this.isForceIdle();
    }

    @NotNull
    public final AtomicInteger getNumRunningTasks() {
        return this.numRunningTasks;
    }

    @NotNull
    public final String getStatusString() {
        return this.statusString;
    }

    public final void setStatusString(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.statusString = string;
    }

    public final boolean getVerbose() {
        return this.verbose;
    }

    public final void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    @NotNull
    public final ConcurrentSkipListMap<Path, ProxyEntry> getActiveProxyEntries() {
        return this.activeProxyEntries;
    }

    @NotNull
    public final ConcurrentSkipListSet<ProxyEntry> getWorkingProxyEntries() {
        return this.workingProxyEntries;
    }

    public final boolean isEnabled() {
        return Companion.isProxyEnabled(this.conf);
    }

    public final boolean isDisabled() {
        return !this.isEnabled();
    }

    public final boolean isActive() {
        return !this.closed.get();
    }

    @Nullable
    public <R> Object runWith(@Nullable ProxyEntry proxyEntry, @NotNull Function1<? super Continuation<? super R>, ? extends Object> task, @NotNull Continuation<? super R> $completion) throws NoProxyException {
        return ProxyPoolManager.runWith$suspendImpl(this, proxyEntry, task, $completion);
    }

    static /* synthetic */ <R> Object runWith$suspendImpl(ProxyPoolManager $this, ProxyEntry proxyEntry, Function1<? super Continuation<? super R>, ? extends Object> task, Continuation<? super R> $completion) throws NoProxyException {
        if ($this.isDisabled()) {
            return task.invoke($completion);
        }
        return $this.runWith0(proxyEntry, task, $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final <R> Object runWith0(ProxyEntry var1_1, Function1<? super Continuation<? super R>, ? extends Object> var2_2, Continuation<? super R> var3_3) throws NoProxyException {
        if (!(var3_3 instanceof runWith0.1)) ** GOTO lbl-1000
        var10_4 = var3_3;
        if ((var10_4.label & -2147483648) != 0) {
            var10_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ ProxyPoolManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ProxyPoolManager.access$runWith0(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var11_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.lastActiveTime = Instant.now();
                v0 = proxyEntry;
                if (v0 != null) {
                    var4_7 = v0;
                    it = var4_7;
                    $i$a$-also-ProxyPoolManager$runWith0$2 = false;
                    it.setLastActiveTime(this.lastActiveTime);
                    this.workingProxyEntries.add(it);
                }
                this.numRunningTasks.incrementAndGet();
                $continuation.L$0 = this;
                $continuation.L$1 = proxyEntry;
                $continuation.label = 1;
                v1 = task.invoke($continuation);
                ** if (v1 != var11_6) goto lbl33
lbl32:
                // 1 sources

                return var11_6;
lbl33:
                // 1 sources

                ** GOTO lbl41
            }
            case 1: {
                proxyEntry = (ProxyEntry)$continuation.L$1;
                this = (ProxyPoolManager)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl41:
                    // 2 sources

                    var4_7 = v1;
                }
                catch (Throwable var5_9) {
                    throw var5_9;
                }
                finally {
                    this.lastActiveTime = Instant.now();
                    v2 = proxyEntry;
                    if (v2 != null) {
                        it = var5_8 = v2;
                        $i$a$-also-ProxyPoolManager$runWith0$3 = false;
                        it.setLastActiveTime(this.lastActiveTime);
                        this.workingProxyEntries.remove(it);
                    }
                    this.numRunningTasks.decrementAndGet();
                }
                return var4_7;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public void takeOff(@NotNull ProxyEntry excludedProxy, boolean ban) {
        Intrinsics.checkNotNullParameter((Object)excludedProxy, (String)"excludedProxy");
    }

    @NotNull
    public String toString() {
        return this.statusString;
    }

    @Override
    public void close() {
    }

    public static final /* synthetic */ Object access$runWith0(ProxyPoolManager $this, ProxyEntry proxyEntry, Function1 task, Continuation $completion) {
        return $this.runWith0(proxyEntry, task, $completion);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        Collection collection;
        Object $this$mapTo$iv$iv;
        Companion = new Companion(null);
        String[] stringArray = new String[]{AppContext.INSTANCE.getUSER_HOME(), AppContext.INSTANCE.getTMP_DIR()};
        Object $this$map$iv = stringArray;
        boolean $i$f$map = false;
        String[] stringArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((String[])$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (Path item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            void var8_10 = item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Paths.get((String)it, new String[0]));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Path item$iv$iv;
            Object item$iv$iv2 = iterator.next();
            item$iv$iv = (Path)item$iv$iv2;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.resolve(PROXY_PROVIDER_FILE_NAME));
        }
        DEFAULT_PROXY_PROVIDER_FILES = (List)var3_3;
        PROXY_FILE_WATCH_INTERVAL = Duration.ofSeconds(30L);
        providerDirLastWatchTime = Instant.EPOCH;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000f\u001a\u00020\u0000J\u0006\u0010\u0010\u001a\u00020\u0000J\u0006\u0010\u0011\u001a\u00020\u0000J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0005J\u0006\u0010\u0014\u001a\u00020\u0000J\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \u0006*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u0006*\u0004\u0018\u00010\u000e0\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lai/platon/pulsar/common/proxy/ProxyPoolManager$Companion;", "", "()V", "DEFAULT_PROXY_PROVIDER_FILES", "", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "PROXY_FILE_WATCH_INTERVAL", "Ljava/time/Duration;", "PROXY_PROVIDER_FILE_NAME", "", "numEnabledProviderFiles", "", "providerDirLastWatchTime", "Ljava/time/Instant;", "disableProviders", "disableProxy", "enableDefaultProviders", "enableProvider", "providerPath", "enableProxy", "hasEnabledProvider", "", "isProxyEnabled", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "pulsar-common"})
    @SourceDebugExtension(value={"SMAP\nProxyPoolManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProxyPoolManager.kt\nai/platon/pulsar/common/proxy/ProxyPoolManager$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,190:1\n1603#2,9:191\n1855#2:200\n1856#2:203\n1612#2:204\n1855#2,2:205\n1603#2,9:207\n1855#2:216\n1856#2:218\n1612#2:219\n1855#2,2:220\n1#3:201\n1#3:202\n1#3:217\n*S KotlinDebug\n*F\n+ 1 ProxyPoolManager.kt\nai/platon/pulsar/common/proxy/ProxyPoolManager$Companion\n*L\n157#1:191,9\n157#1:200\n157#1:203\n157#1:204\n157#1:205,2\n160#1:207,9\n160#1:216\n160#1:218\n160#1:219\n160#1:220,2\n157#1:202\n160#1:217\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isProxyEnabled(@NotNull ImmutableConfig conf) {
            block15: {
                String useProxy;
                Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
                String string = useProxy = conf.get("use_proxy");
                if (string == null) break block15;
                int n = -1;
                switch (string.hashCode()) {
                    case 3521: {
                        if (string.equals("no")) {
                            n = 1;
                        }
                        break;
                    }
                    case 119527: {
                        if (string.equals("yes")) {
                            n = 2;
                        }
                        break;
                    }
                    case 3569038: {
                        if (string.equals("true")) {
                            n = 2;
                        }
                        break;
                    }
                    case 97196323: {
                        if (string.equals("false")) {
                            n = 1;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 2: {
                        return true;
                    }
                    case 1: {
                        return false;
                    }
                }
            }
            if (conf.getBoolean("proxy.enable.default.providers", false)) {
                this.enableDefaultProviders();
            }
            return this.hasEnabledProvider();
        }

        public final synchronized boolean hasEnabledProvider() throws IOException {
            Instant now = Instant.now();
            if (Duration.between(providerDirLastWatchTime, now).compareTo(PROXY_FILE_WATCH_INTERVAL) > 0) {
                long l;
                providerDirLastWatchTime = now;
                try {
                    l = Files.list(AppPaths.INSTANCE.getENABLED_PROVIDER_DIR()).filter(arg_0 -> Companion.hasEnabledProvider$lambda$0(hasEnabledProvider.1.INSTANCE, arg_0)).count();
                }
                catch (Throwable e) {
                    l = 0L;
                }
                numEnabledProviderFiles = l;
            }
            return numEnabledProviderFiles > 0L;
        }

        @NotNull
        public final Companion enableProxy() {
            System.setProperty("use_proxy", "yes");
            return this;
        }

        @NotNull
        public final Companion disableProxy() {
            System.setProperty("use_proxy", "no");
            return this;
        }

        @NotNull
        public final synchronized Companion enableDefaultProviders() throws IOException {
            boolean bl;
            Path it$iv$iv;
            Path it;
            Path path;
            Path it2;
            boolean bl2;
            Object element$iv$iv;
            Object element$iv$iv$iv;
            Iterable $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = DEFAULT_PROXY_PROVIDER_FILES;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                element$iv$iv = element$iv$iv$iv = iterator.next();
                bl2 = false;
                it2 = (Path)element$iv$iv;
                boolean bl3 = false;
                it = path = it2;
                boolean bl4 = false;
                if ((Files.exists(it, new LinkOption[0]) ? path : null) == null) continue;
                it$iv$iv = it$iv$iv;
                bl = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                Path it3 = (Path)element$iv;
                boolean bl5 = false;
                FileUtils.copyFileToDirectory((File)it3.toFile(), (File)AppPaths.INSTANCE.getAVAILABLE_PROVIDER_DIR().toFile());
            }
            Path path2 = AppPaths.INSTANCE.getAVAILABLE_PROVIDER_DIR();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"<get-AVAILABLE_PROVIDER_DIR>(...)");
            $this$mapNotNull$iv = path2;
            $i$f$mapNotNull = false;
            $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            $i$f$forEach = false;
            iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                element$iv$iv = element$iv$iv$iv = iterator.next();
                bl2 = false;
                it2 = (Path)element$iv$iv;
                boolean bl6 = false;
                it = path = it2;
                boolean bl7 = false;
                if ((Files.exists(it, new LinkOption[0]) ? path : null) == null) continue;
                it$iv$iv = it$iv$iv;
                bl = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$forEach$iv = (List)destination$iv$iv;
            $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                Path it4 = (Path)element$iv;
                boolean bl8 = false;
                Companion.enableProvider(it4);
            }
            return this;
        }

        @NotNull
        public final synchronized Companion enableProvider(@NotNull Path providerPath) throws IOException {
            Intrinsics.checkNotNullParameter((Object)providerPath, (String)"providerPath");
            Path filename = providerPath.getFileName();
            Path target = AppPaths.INSTANCE.getENABLED_PROVIDER_DIR().resolve(filename);
            Files.deleteIfExists(target);
            Intrinsics.checkNotNull((Object)target);
            if (AppFiles.INSTANCE.supportSymbolicLink(target)) {
                Files.createSymbolicLink(target, providerPath, new FileAttribute[0]);
            } else {
                Files.copy(providerPath, target, new CopyOption[0]);
            }
            return this;
        }

        @NotNull
        public final synchronized Companion disableProviders() throws IOException {
            Files.list(AppPaths.INSTANCE.getENABLED_PROVIDER_DIR()).filter(arg_0 -> Companion.disableProviders$lambda$7(disableProviders.1.INSTANCE, arg_0)).forEach(arg_0 -> Companion.disableProviders$lambda$8(disableProviders.2.INSTANCE, arg_0));
            return this;
        }

        private static final boolean hasEnabledProvider$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final boolean disableProviders$lambda$7(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final void disableProviders$lambda$8(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

