/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.urls;

import ai.platon.pulsar.common.DateTimes;
import ai.platon.pulsar.common.options.OptionUtils;
import ai.platon.pulsar.common.urls.ComparableUrlAware;
import ai.platon.pulsar.common.urls.UrlAware;
import ai.platon.pulsar.common.urls.UrlUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0081\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\n\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\f\u001a\u00020\u0003\u0012\b\b\u0002\u0010\r\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0010J\u0011\u0010@\u001a\u00020\u00062\u0006\u0010A\u001a\u00020BH\u0096\u0002J\u0013\u0010C\u001a\u00020&2\b\u0010A\u001a\u0004\u0018\u00010DH\u0096\u0002J\b\u0010E\u001a\u00020\u0006H\u0016J\b\u0010F\u001a\u00020\u0003H\u0016J\u0018\u0010G\u001a\u00060Hj\u0002`I2\n\u0010J\u001a\u00060Hj\u0002`IH\u0016J\b\u0010K\u001a\u00020\u0003H\u0016R\u001c\u0010\b\u001a\u0004\u0018\u00010\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0012R\u001a\u0010\f\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0012\"\u0004\b\u0018\u0010\u0014R\u0014\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u000f\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010\r\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0012\"\u0004\b\"\u0010\u0014R\u001c\u0010\t\u001a\u0004\u0018\u00010\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0012\"\u0004\b$\u0010\u0014R\u0014\u0010%\u001a\u00020&8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010'R\u0014\u0010(\u001a\u00020&X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010'R\u0014\u0010)\u001a\u00020&8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010'R\u0014\u0010*\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u0012R\u001a\u0010\u000b\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u0012\"\u0004\b-\u0010\u0014R\u001a\u0010\u000e\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\u001e\"\u0004\b/\u0010 R\u001a\u0010\u0005\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\u001e\"\u0004\b1\u0010 R\u001a\u0010\n\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\u001e\"\u0004\b3\u0010 R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u0010\u0012\"\u0004\b5\u0010\u0014R\u001a\u0010\u0004\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010\u0012\"\u0004\b7\u0010\u0014R\u0014\u00108\u001a\u0002098VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010;R\u0016\u0010<\u001a\u0004\u0018\u0001098VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b=\u0010;R\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010\u0012\"\u0004\b?\u0010\u0014\u00a8\u0006L"}, d2={"Lai/platon/pulsar/common/urls/AbstractUrl;", "Lai/platon/pulsar/common/urls/ComparableUrlAware;", "url", "", "text", "order", "", "referrer", "args", "href", "priority", "lang", "country", "district", "nMaxRetry", "depth", "(Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;II)V", "getArgs", "()Ljava/lang/String;", "setArgs", "(Ljava/lang/String;)V", "configuredUrl", "getConfiguredUrl", "getCountry", "setCountry", "deadline", "Ljava/time/Instant;", "getDeadline", "()Ljava/time/Instant;", "getDepth", "()I", "setDepth", "(I)V", "getDistrict", "setDistrict", "getHref", "setHref", "isNil", "", "()Z", "isPersistable", "isStandard", "label", "getLabel", "getLang", "setLang", "getNMaxRetry", "setNMaxRetry", "getOrder", "setOrder", "getPriority", "setPriority", "getReferrer", "setReferrer", "getText", "setText", "toURL", "Ljava/net/URL;", "getToURL", "()Ljava/net/URL;", "toURLOrNull", "getToURLOrNull", "getUrl", "setUrl", "compareTo", "other", "Lai/platon/pulsar/common/urls/UrlAware;", "equals", "", "hashCode", "serialize", "serializeTo", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "sb", "toString", "pulsar-common"})
@SourceDebugExtension(value={"SMAP\nAbstractUrls.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractUrls.kt\nai/platon/pulsar/common/urls/AbstractUrl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,142:1\n1#2:143\n*E\n"})
public abstract class AbstractUrl
implements ComparableUrlAware {
    @NotNull
    private String url;
    @NotNull
    private String text;
    private int order;
    @Nullable
    private String referrer;
    @Nullable
    private String args;
    @Nullable
    private String href;
    private int priority;
    @NotNull
    private String lang;
    @NotNull
    private String country;
    @NotNull
    private String district;
    private int nMaxRetry;
    private int depth;
    private final boolean isPersistable;

    public AbstractUrl(@NotNull String url, @NotNull String text, int order, @Nullable String referrer, @Nullable String args, @Nullable String href, int priority, @NotNull String lang, @NotNull String country, @NotNull String district, int nMaxRetry, int depth) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)lang, (String)"lang");
        Intrinsics.checkNotNullParameter((Object)country, (String)"country");
        Intrinsics.checkNotNullParameter((Object)district, (String)"district");
        this.url = url;
        this.text = text;
        this.order = order;
        this.referrer = referrer;
        this.args = args;
        this.href = href;
        this.priority = priority;
        this.lang = lang;
        this.country = country;
        this.district = district;
        this.nMaxRetry = nMaxRetry;
        this.depth = depth;
        this.isPersistable = true;
    }

    public /* synthetic */ AbstractUrl(String string, String string2, int n, String string3, String string4, String string5, int n2, String string6, String string7, String string8, int n3, int n4, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n5 & 2) != 0) {
            string2 = "";
        }
        if ((n5 & 4) != 0) {
            n = 0;
        }
        if ((n5 & 8) != 0) {
            string3 = null;
        }
        if ((n5 & 0x10) != 0) {
            string4 = null;
        }
        if ((n5 & 0x20) != 0) {
            string5 = null;
        }
        if ((n5 & 0x40) != 0) {
            n2 = 0;
        }
        if ((n5 & 0x80) != 0) {
            string6 = "*";
        }
        if ((n5 & 0x100) != 0) {
            string7 = "*";
        }
        if ((n5 & 0x200) != 0) {
            string8 = "*";
        }
        if ((n5 & 0x400) != 0) {
            n3 = 3;
        }
        if ((n5 & 0x800) != 0) {
            n4 = 0;
        }
        this(string, string2, n, string3, string4, string5, n2, string6, string7, string8, n3, n4);
    }

    @Override
    @NotNull
    public String getUrl() {
        return this.url;
    }

    @Override
    public void setUrl(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.url = string;
    }

    @Override
    @NotNull
    public String getText() {
        return this.text;
    }

    @Override
    public void setText(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.text = string;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(int n) {
        this.order = n;
    }

    @Override
    @Nullable
    public String getReferrer() {
        return this.referrer;
    }

    @Override
    public void setReferrer(@Nullable String string) {
        this.referrer = string;
    }

    @Override
    @Nullable
    public String getArgs() {
        return this.args;
    }

    @Override
    public void setArgs(@Nullable String string) {
        this.args = string;
    }

    @Override
    @Nullable
    public String getHref() {
        return this.href;
    }

    @Override
    public void setHref(@Nullable String string) {
        this.href = string;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int n) {
        this.priority = n;
    }

    @Override
    @NotNull
    public String getLang() {
        return this.lang;
    }

    public void setLang(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.lang = string;
    }

    @Override
    @NotNull
    public String getCountry() {
        return this.country;
    }

    public void setCountry(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.country = string;
    }

    @Override
    @NotNull
    public String getDistrict() {
        return this.district;
    }

    public void setDistrict(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.district = string;
    }

    @Override
    public int getNMaxRetry() {
        return this.nMaxRetry;
    }

    public void setNMaxRetry(int n) {
        this.nMaxRetry = n;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int n) {
        this.depth = n;
    }

    @Override
    @NotNull
    public String getConfiguredUrl() {
        return UrlUtils.mergeUrlArgs(this.getUrl(), this.getArgs());
    }

    @Override
    public boolean isStandard() {
        return UrlUtils.isStandard(this.getUrl());
    }

    @Override
    @NotNull
    public URL getToURL() throws MalformedURLException {
        return new URL(this.getUrl());
    }

    @Override
    @Nullable
    public URL getToURLOrNull() {
        return UrlUtils.getURLOrNull(this.getUrl());
    }

    @Override
    public boolean isNil() {
        return Intrinsics.areEqual((Object)this.getUrl(), (Object)"http://internal.pulsar.platon.ai/nil");
    }

    @Override
    public boolean isPersistable() {
        return this.isPersistable;
    }

    @Override
    @NotNull
    public String getLabel() {
        Object[] objectArray = new String[]{"-l", "-label", "--label"};
        String string = OptionUtils.INSTANCE.findOption(this.getArgs(), CollectionsKt.listOf((Object[])objectArray));
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Override
    @NotNull
    public Instant getDeadline() {
        String deadTime;
        Instant instant;
        Object[] objectArray = new String[]{"-deadline", "-deadTime", "--dead-time"};
        String string = OptionUtils.INSTANCE.findOption(this.getArgs(), CollectionsKt.listOf((Object[])objectArray));
        if (string == null) {
            string = "";
        }
        if ((instant = DateTimes.parseBestInstantOrNull(deadTime = string)) == null) {
            Instant instant2 = DateTimes.INSTANCE.getDoomsday();
            instant = instant2;
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"<get-doomsday>(...)");
        }
        return instant;
    }

    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        Object object = other;
        return object instanceof String ? Intrinsics.areEqual((Object)this.getUrl(), (Object)other) : (object instanceof URL ? Intrinsics.areEqual((Object)this.getUrl(), (Object)((URL)other).toString()) : (object instanceof UrlAware ? Intrinsics.areEqual((Object)this.getUrl(), (Object)((UrlAware)other).getUrl()) : false));
    }

    @Override
    public int compareTo(@NotNull UrlAware other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.getUrl().compareTo(other.getUrl());
    }

    public int hashCode() {
        return this.getUrl().hashCode();
    }

    @NotNull
    public String toString() {
        return this.getUrl();
    }

    @NotNull
    public String serialize() {
        String string = this.serializeTo(new StringBuilder()).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public StringBuilder serializeTo(@NotNull StringBuilder sb) {
        block11: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)sb, (String)"sb");
            sb.append(this.getUrl());
            String string = this.getArgs();
            if (string != null) {
                String string2;
                String it = string2 = string;
                boolean bl = false;
                Object object2 = object = !StringsKt.isBlank((CharSequence)it) ? string2 : null;
                if (object != null && (string2 = StringsKt.replace$default((String)object, (String)"\"", (String)"\\\"", (boolean)false, (int)4, null)) != null) {
                    String it2 = string2;
                    boolean bl2 = false;
                    sb.append(" -args ").append(it2);
                }
            }
            object = this.getText();
            String it = object;
            boolean bl = false;
            Object object3 = !(((CharSequence)it).length() == 0) ? object : null;
            if (object3 != null) {
                it = object3;
                boolean bl3 = false;
                sb.append(" -text ").append(it);
            }
            object = this.getOrder();
            int it2 = ((Number)object).intValue();
            boolean bl4 = false;
            Object object4 = !(it2 == 0) ? object : null;
            if (object4 != null) {
                it2 = ((Number)object4).intValue();
                boolean bl5 = false;
                sb.append(" -order ").append(it2);
            }
            String string3 = this.getHref();
            if (string3 != null) {
                it = string3;
                boolean bl6 = false;
                sb.append(" -href ").append(it);
            }
            String string4 = this.getReferrer();
            if (string4 != null) {
                it = string4;
                boolean bl7 = false;
                sb.append(" -referrer ").append(it);
            }
            object = this.getPriority();
            int it3 = ((Number)object).intValue();
            boolean bl8 = false;
            Object object5 = it3 != 0 ? object : null;
            if (object5 != null) {
                it3 = ((Number)object5).intValue();
                boolean bl9 = false;
                sb.append(" -priority ").append(it3);
            }
            Object it4 = object = this.getLang();
            boolean bl10 = false;
            Object object6 = !Intrinsics.areEqual((Object)it4, (Object)"*") ? object : null;
            if (object6 != null) {
                it4 = object6;
                boolean bl11 = false;
                sb.append(" -lang ").append((String)it4);
            }
            it4 = object = this.getCountry();
            boolean bl12 = false;
            Object object7 = !Intrinsics.areEqual((Object)it4, (Object)"*") ? object : null;
            if (object7 != null) {
                it4 = object7;
                boolean bl13 = false;
                sb.append(" -country ").append((String)it4);
            }
            it4 = object = this.getDistrict();
            boolean bl14 = false;
            Object object8 = !Intrinsics.areEqual((Object)it4, (Object)"*") ? object : null;
            if (object8 != null) {
                it4 = object8;
                boolean bl15 = false;
                sb.append(" -district ").append((String)it4);
            }
            object = this.getNMaxRetry();
            int it5 = ((Number)object).intValue();
            boolean bl16 = false;
            Object object9 = it5 != 3 ? object : null;
            if (object9 != null) {
                it5 = ((Number)object9).intValue();
                boolean bl17 = false;
                sb.append(" -nMaxRetry ").append(it5);
            }
            object = this.getDepth();
            it5 = ((Number)object).intValue();
            boolean bl18 = false;
            Object object10 = !(it5 == 0) ? object : null;
            if (object10 == null) break block11;
            it5 = ((Number)object10).intValue();
            boolean bl19 = false;
            sb.append(" -depth ").append(it5);
        }
        return sb;
    }
}

