/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common;

import ai.platon.pulsar.common.Runtimes;
import ai.platon.pulsar.common.measure.ByteUnit;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.FileStore;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.DelayKt;
import org.apache.commons.lang3.SystemUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0016\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u000bJ\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\t0\u001a2\u0006\u0010\u001b\u001a\u00020\tJ\u000e\u0010\u001c\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012J\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\t0\u001a2\u0006\u0010\u001e\u001a\u00020\tJ\u001e\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u000bH\u0086@\u00a2\u0006\u0002\u0010#J\u0010\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020&H\u0002J\f\u0010'\u001a\b\u0012\u0004\u0012\u00020!0\u001aJ\u0010\u0010(\u001a\u00020!2\u0006\u0010%\u001a\u00020&H\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lai/platon/pulsar/common/Runtimes;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "checkIfProcessRunning", "", "pattern", "", "countSystemProcess", "", "deleteBrokenSymbolicLinks", "", "symbolicLink", "Ljava/nio/file/Path;", "destroyChildProcess", "process", "Ljava/lang/ProcessHandle;", "destroyProcess", "Ljava/lang/Process;", "shutdownWaitTime", "Ljava/time/Duration;", "destroyProcessForcibly", "pid", "exec", "", "name", "formatProcessInfo", "locateBinary", "executable", "randomDelay", "timeMillis", "", "delta", "(JILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "totalSpaceOr0", "store", "Ljava/nio/file/FileStore;", "unallocatedDiskSpaces", "unallocatedSpaceOr0", "pulsar-common"})
@SourceDebugExtension(value={"SMAP\nRuntimes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Runtimes.kt\nai/platon/pulsar/common/Runtimes\n+ 2 ReadWrite.kt\nkotlin/io/TextStreamsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,203:1\n52#2:204\n1#3:205\n1#3:220\n1774#4,4:206\n766#4:210\n857#4,2:211\n1549#4:213\n1620#4,3:214\n766#4:217\n857#4,2:218\n*S KotlinDebug\n*F\n+ 1 Runtimes.kt\nai/platon/pulsar/common/Runtimes\n*L\n26#1:204\n26#1:205\n57#1:206,4\n131#1:210\n131#1:211,2\n132#1:213\n132#1:214,3\n133#1:217\n133#1:218,2\n*E\n"})
public final class Runtimes {
    @NotNull
    public static final Runtimes INSTANCE = new Runtimes();
    private static final Logger logger = LoggerFactory.getLogger(Runtimes.class);

    private Runtimes() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<String> exec(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        try {
            List list2;
            Process process = Runtime.getRuntime().exec(name);
            InputStream inputStream = process.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
            InputStream inputStream2 = inputStream;
            Charset charset = Charsets.UTF_8;
            Closeable closeable = new InputStreamReader(inputStream2, charset);
            int n = 8192;
            Reader $this$useLines$iv = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n);
            boolean $i$f$useLines = false;
            closeable = $this$useLines$iv;
            n = 8192;
            closeable = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n);
            Throwable throwable = null;
            try {
                BufferedReader it$iv = (BufferedReader)closeable;
                boolean bl = false;
                Sequence it = TextStreamsKt.lineSequence((BufferedReader)it$iv);
                boolean bl2 = false;
                list2 = SequencesKt.toList((Sequence)it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return list2;
        }
        catch (Exception err) {
            err.printStackTrace();
            return CollectionsKt.emptyList();
        }
    }

    @NotNull
    public final List<String> locateBinary(@NotNull String executable) {
        Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
        String command = SystemUtils.IS_OS_WINDOWS ? "where " + executable : (SystemUtils.IS_OS_LINUX ? "whereis " + executable : "whereis " + executable);
        return SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.flatMapIterable((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.exec(command)), (Function1)locateBinary.1.INSTANCE), (Function1)((Function1)new Function1<String, Boolean>(executable){
            final /* synthetic */ String $executable;
            {
                this.$executable = $executable;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return StringsKt.contains$default((CharSequence)it, (CharSequence)this.$executable, (boolean)false, (int)2, null);
            }
        })), (Function1)locateBinary.3.INSTANCE), (Function1)locateBinary.4.INSTANCE));
    }

    public final int countSystemProcess(@NotNull String pattern) {
        int n;
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        String command = SystemUtils.IS_OS_WINDOWS ? "tasklist /NH" : (SystemUtils.IS_OS_LINUX ? "ps -ef" : "ps -ef");
        Iterable $this$count$iv = this.exec(command);
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                CharSequence charSequence = it;
                if (!new Regex(pattern).containsMatchIn(charSequence) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        return n;
    }

    public final boolean checkIfProcessRunning(@NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        return this.countSystemProcess(pattern) > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void destroyProcess(@NotNull Process process, @NotNull Duration shutdownWaitTime) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        Intrinsics.checkNotNullParameter((Object)shutdownWaitTime, (String)"shutdownWaitTime");
        ProcessHandle processHandle = process.toHandle();
        Intrinsics.checkNotNullExpressionValue((Object)processHandle, (String)"toHandle(...)");
        String info = this.formatProcessInfo(processHandle);
        process.children().forEach(arg_0 -> Runtimes.destroyProcess$lambda$2(destroyProcess.1.INSTANCE, arg_0));
        process.destroy();
        try {
            if (!process.waitFor(shutdownWaitTime.getSeconds(), TimeUnit.SECONDS)) {
                process.destroyForcibly();
                process.waitFor(shutdownWaitTime.getSeconds(), TimeUnit.SECONDS);
            }
            logger.info("Exit | {}", (Object)info);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            process.destroyForcibly();
            throw e;
        }
    }

    public final void destroyProcessForcibly(int pid) {
        if (pid <= 0) {
            return;
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            this.exec("taskkill /F /PID " + pid);
        } else if (SystemUtils.IS_OS_LINUX) {
            this.exec("kill -9 " + pid);
        } else {
            this.exec("kill -9 " + pid);
        }
    }

    @NotNull
    public final String formatProcessInfo(@NotNull ProcessHandle process) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        ProcessHandle.Info info = process.info();
        String user = info.user().orElse("");
        long pid = process.pid();
        Object object2 = process.parent().orElseGet(Runtimes::formatProcessInfo$lambda$3);
        if (object2 == null || (object2 = Long.valueOf(object2.pid()).toString()) == null) {
            object2 = "?";
        }
        Object ppid = object2;
        Instant startTime = info.startInstant().orElse(null);
        Optional<Duration> optional = info.totalCpuDuration();
        Duration cpuDuration = optional != null ? (Duration)optional.orElse(null) : null;
        String cmdLine = info.commandLine().orElseGet(Runtimes::formatProcessInfo$lambda$4);
        String string = "%-8s %-6d %-6s %-25s %-10s %s";
        Object[] objectArray = new Object[6];
        objectArray[0] = user;
        objectArray[1] = pid;
        objectArray[2] = ppid;
        Object object3 = startTime;
        if (object3 == null) {
            object3 = objectArray[3] = "";
        }
        if ((object = cpuDuration) == null) {
            object = "";
        }
        objectArray[4] = object;
        objectArray[5] = cmdLine;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    public final void deleteBrokenSymbolicLinks(@NotNull Path symbolicLink) {
        Intrinsics.checkNotNullParameter((Object)symbolicLink, (String)"symbolicLink");
        if (SystemUtils.IS_OS_WINDOWS) {
            Files.deleteIfExists(symbolicLink);
        } else if (SystemUtils.IS_OS_LINUX) {
            this.exec("find -L " + symbolicLink + " -type l -delete");
        }
    }

    @Nullable
    public final Object randomDelay(long timeMillis, int delta, @NotNull Continuation<? super Unit> $completion) {
        Object object = DelayKt.delay((long)(timeMillis + (long)Random.Default.nextInt(delta)), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @NotNull
    public final List<Long> unallocatedDiskSpaces() {
        List list2;
        try {
            Iterable $this$mapTo$iv$iv;
            FileStore it;
            Iterable $this$filterTo$iv$iv;
            Iterable iterable = FileSystems.getDefault().getFileStores();
            Intrinsics.checkNotNullExpressionValue(iterable, (String)"getFileStores(...)");
            Iterable $this$filter$iv = iterable;
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (FileStore)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!(ByteUnit.BYTE.toGB(INSTANCE.totalSpaceOr0(it)) > 20.0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (FileStore)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(INSTANCE.unallocatedSpaceOr0(it));
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                long it2 = ((Number)element$iv$iv).longValue();
                boolean bl = false;
                if (!(it2 > 0L)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        }
        catch (Throwable e) {
            return CollectionsKt.emptyList();
        }
        return list2;
    }

    private final long totalSpaceOr0(FileStore store) {
        Object object;
        Object object2 = store;
        try {
            FileStore $this$totalSpaceOr0_u24lambda_u248 = object2;
            boolean bl = false;
            object = Result.constructor-impl((Object)$this$totalSpaceOr0_u24lambda_u248.getTotalSpace());
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        Long l = (Long)(Result.isFailure-impl((Object)object2) ? null : object2);
        return l != null ? l : 0L;
    }

    private final long unallocatedSpaceOr0(FileStore store) {
        Object object;
        Object object2 = store;
        try {
            FileStore $this$unallocatedSpaceOr0_u24lambda_u249 = object2;
            boolean bl = false;
            object = Result.constructor-impl((Object)$this$unallocatedSpaceOr0_u24lambda_u249.getUnallocatedSpace());
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        Long l = (Long)(Result.isFailure-impl((Object)object2) ? null : object2);
        return l != null ? l : 0L;
    }

    private final void destroyChildProcess(ProcessHandle process) {
        process.children().forEach(arg_0 -> Runtimes.destroyChildProcess$lambda$10(destroyChildProcess.1.INSTANCE, arg_0));
        String info = this.formatProcessInfo(process);
        process.destroy();
        if (process.isAlive()) {
            process.destroyForcibly();
        }
        logger.debug("Exit | {}", (Object)info);
    }

    private static final void destroyProcess$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final ProcessHandle formatProcessInfo$lambda$3() {
        return null;
    }

    private static final String formatProcessInfo$lambda$4() {
        return "";
    }

    private static final void destroyChildProcess$lambda$10(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$destroyChildProcess(Runtimes $this, ProcessHandle process) {
        $this.destroyChildProcess(process);
    }
}

