/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.browser;

import ai.platon.pulsar.common.AppPaths;
import ai.platon.pulsar.common.DateTimes;
import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.browser.BrowserFiles;
import ai.platon.pulsar.common.browser.ContextGroup;
import ai.platon.pulsar.common.browser.Fingerprint;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.Instant;
import java.time.MonthDay;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u0007J\u000e\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0007J$\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u00042\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010 H\u0002J$\u0010!\u001a\u00020\r2\b\b\u0002\u0010\"\u001a\u00020\u00042\b\b\u0002\u0010#\u001a\u00020$2\b\b\u0002\u0010%\u001a\u00020\u0016J(\u0010&\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020$2\u0006\u0010'\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 H\u0002J\u001c\u0010(\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\u00042\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010 H\u0002J\u0010\u0010)\u001a\u00020\r2\b\b\u0002\u0010\"\u001a\u00020\u0004J\u0010\u0010*\u001a\u00020\r2\b\b\u0002\u0010#\u001a\u00020$J \u0010+\u001a\u00020\u00142\u0006\u0010,\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0016\u0010-\u001a\u00020\u00142\u0006\u0010,\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u0007J/\u0010.\u001a\u0002H/\"\u0004\b\u0000\u0010/2\u0006\u00100\u001a\u00020\r2\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u0002H/02H\u0002\u00a2\u0006\u0002\u00103R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lai/platon/pulsar/common/browser/BrowserFiles;", "", "()V", "CONTEXT_DIR_PREFIX", "", "PID_FILE_NAME", "TEMPORARY_UDD_EXPIRY", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "getTEMPORARY_UDD_EXPIRY", "()Ljava/time/Duration;", "cleanedUserDataDirs", "Ljava/util/concurrent/ConcurrentSkipListSet;", "Ljava/nio/file/Path;", "contextGroups", "Ljava/util/concurrent/ConcurrentHashMap;", "Lai/platon/pulsar/common/browser/ContextGroup;", "logger", "Lorg/slf4j/Logger;", "cleanOldestContextTmpDirs", "", "recentNToKeep", "", "cleanUpContextDir", "path", "expiry", "cleanUpContextTmpDir", "computeContextCount", "", "baseDir", "prefix", "channel", "Ljava/nio/channels/FileChannel;", "computeNextSequentialContextDir", "group", "fingerprint", "Lai/platon/pulsar/common/browser/Fingerprint;", "maxAgents", "computeNextSequentialContextDir0", "maxContexts", "computeRandomContextDir0", "computeRandomTmpContextDir", "computeTestContextDir", "deleteTemporaryUserDataDir0", "userDataDir", "deleteTemporaryUserDataDirWithLock", "runWithFileLock", "T", "lockFile", "supplier", "Lkotlin/Function1;", "(Ljava/nio/file/Path;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "pulsar-common"})
@SourceDebugExtension(value={"SMAP\nBrowserFiles.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BrowserFiles.kt\nai/platon/pulsar/common/browser/BrowserFiles\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,265:1\n1054#2:266\n1855#2,2:267\n1#3:269\n*S KotlinDebug\n*F\n+ 1 BrowserFiles.kt\nai/platon/pulsar/common/browser/BrowserFiles\n*L\n98#1:266\n100#1:267,2\n*E\n"})
public final class BrowserFiles {
    @NotNull
    public static final BrowserFiles INSTANCE = new BrowserFiles();
    @NotNull
    private static final Logger logger = LogsKt.getLogger(INSTANCE);
    @NotNull
    public static final String CONTEXT_DIR_PREFIX = "cx.";
    @NotNull
    public static final String PID_FILE_NAME = "launcher.pid";
    private static final Duration TEMPORARY_UDD_EXPIRY = Duration.ofHours(12L);
    @NotNull
    private static final ConcurrentHashMap<String, ContextGroup> contextGroups = new ConcurrentHashMap();
    @NotNull
    private static final ConcurrentSkipListSet<Path> cleanedUserDataDirs = new ConcurrentSkipListSet();

    private BrowserFiles() {
    }

    public final Duration getTEMPORARY_UDD_EXPIRY() {
        return TEMPORARY_UDD_EXPIRY;
    }

    @NotNull
    public final synchronized Path computeTestContextDir(@NotNull Fingerprint fingerprint) throws IOException {
        Intrinsics.checkNotNullParameter((Object)fingerprint, (String)"fingerprint");
        Path lockFile = AppPaths.INSTANCE.getBROWSER_TMP_DIR_LOCK();
        Intrinsics.checkNotNull((Object)lockFile);
        return (Path)this.runWithFileLock(lockFile, (Function1)new Function1<FileChannel, Path>(fingerprint){
            final /* synthetic */ Fingerprint $fingerprint;
            {
                this.$fingerprint = $fingerprint;
                super(1);
            }

            @NotNull
            public final Path invoke(@NotNull FileChannel channel) {
                Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
                return BrowserFiles.access$computeNextSequentialContextDir0(BrowserFiles.INSTANCE, "test", this.$fingerprint, 5, channel);
            }
        });
    }

    public static /* synthetic */ Path computeTestContextDir$default(BrowserFiles browserFiles, Fingerprint fingerprint, int n, Object object) throws IOException {
        if ((n & 1) != 0) {
            fingerprint = Fingerprint.Companion.getDEFAULT();
        }
        return browserFiles.computeTestContextDir(fingerprint);
    }

    @NotNull
    public final synchronized Path computeNextSequentialContextDir(@NotNull String group, @NotNull Fingerprint fingerprint, int maxAgents) throws IOException {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)fingerprint, (String)"fingerprint");
        Path lockFile = AppPaths.INSTANCE.getCONTEXT_GROUP_BASE_DIR().resolve("contex.group.lock");
        if (!Files.exists(lockFile, new LinkOption[0])) {
            Files.createFile(lockFile, new FileAttribute[0]);
        }
        Intrinsics.checkNotNull((Object)lockFile);
        return (Path)this.runWithFileLock(lockFile, (Function1)new Function1<FileChannel, Path>(group, fingerprint, maxAgents){
            final /* synthetic */ String $group;
            final /* synthetic */ Fingerprint $fingerprint;
            final /* synthetic */ int $maxAgents;
            {
                this.$group = $group;
                this.$fingerprint = $fingerprint;
                this.$maxAgents = $maxAgents;
                super(1);
            }

            @NotNull
            public final Path invoke(@NotNull FileChannel channel) {
                Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
                return BrowserFiles.access$computeNextSequentialContextDir0(BrowserFiles.INSTANCE, this.$group, this.$fingerprint, this.$maxAgents, channel);
            }
        });
    }

    public static /* synthetic */ Path computeNextSequentialContextDir$default(BrowserFiles browserFiles, String string, Fingerprint fingerprint, int n, int n2, Object object) throws IOException {
        if ((n2 & 1) != 0) {
            string = "default";
        }
        if ((n2 & 2) != 0) {
            fingerprint = Fingerprint.Companion.getDEFAULT();
        }
        if ((n2 & 4) != 0) {
            n = 10;
        }
        return browserFiles.computeNextSequentialContextDir(string, fingerprint, n);
    }

    @NotNull
    public final synchronized Path computeRandomTmpContextDir(@NotNull String group) throws IOException {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Path lockFile = AppPaths.INSTANCE.getBROWSER_TMP_DIR_LOCK();
        return BrowserFiles.computeRandomContextDir0$default(this, group, null, 2, null);
    }

    public static /* synthetic */ Path computeRandomTmpContextDir$default(BrowserFiles browserFiles, String string, int n, Object object) throws IOException {
        if ((n & 1) != 0) {
            string = "default";
        }
        return browserFiles.computeRandomTmpContextDir(string);
    }

    public final void cleanOldestContextTmpDirs(int recentNToKeep) throws IOException {
        List<Object> list2 = Files.walk(AppPaths.INSTANCE.getCONTEXT_TMP_DIR(), 3, new FileVisitOption[0]).filter(arg_0 -> BrowserFiles.cleanOldestContextTmpDirs$lambda$0(cleanOldestContextTmpDirs.1.INSTANCE, arg_0)).filter(arg_0 -> BrowserFiles.cleanOldestContextTmpDirs$lambda$1(cleanOldestContextTmpDirs.2.INSTANCE, arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"toList(...)");
        Iterable $this$sortedByDescending$iv = CollectionsKt.toSet((Iterable)list2);
        boolean $i$f$sortedByDescending = false;
        Iterable $this$forEach$iv = CollectionsKt.drop((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Path it = (Path)b;
                boolean bl = false;
                Comparable comparable = Files.getLastModifiedTime(it, new LinkOption[0]);
                it = (Path)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Files.getLastModifiedTime(it, new LinkOption[0]));
            }
        }), (int)recentNToKeep);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Path it = (Path)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            Duration duration = Duration.ofSeconds(30L);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
            INSTANCE.cleanUpContextDir(it, duration);
        }
    }

    public static /* synthetic */ void cleanOldestContextTmpDirs$default(BrowserFiles browserFiles, int n, int n2, Object object) throws IOException {
        if ((n2 & 1) != 0) {
            n = 20;
        }
        browserFiles.cleanOldestContextTmpDirs(n);
    }

    public final void cleanUpContextTmpDir(@NotNull Duration expiry) throws IOException {
        Intrinsics.checkNotNullParameter((Object)expiry, (String)"expiry");
        Files.walk(AppPaths.INSTANCE.getCONTEXT_TMP_DIR(), 3, new FileVisitOption[0]).filter(arg_0 -> BrowserFiles.cleanUpContextTmpDir$lambda$4(cleanUpContextTmpDir.1.INSTANCE, arg_0)).filter(arg_0 -> BrowserFiles.cleanUpContextTmpDir$lambda$5(cleanUpContextTmpDir.2.INSTANCE, arg_0)).forEach(arg_0 -> BrowserFiles.cleanUpContextTmpDir$lambda$6((Function1)new Function1<Path, Unit>(expiry){
            final /* synthetic */ Duration $expiry;
            {
                this.$expiry = $expiry;
                super(1);
            }

            public final void invoke(Path path) {
                Intrinsics.checkNotNull((Object)path);
                BrowserFiles.INSTANCE.cleanUpContextDir(path, this.$expiry);
            }
        }, arg_0));
        BrowserFiles.cleanOldestContextTmpDirs$default(this, 0, 1, null);
    }

    public final void cleanUpContextDir(@NotNull Path path, @NotNull Duration expiry) throws IOException {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)expiry, (String)"expiry");
        if (!StringsKt.startsWith$default((String)((Object)path.getFileName()).toString(), (String)CONTEXT_DIR_PREFIX, (boolean)false, (int)2, null)) {
            logger.info("Not a context directory | {}", (Object)path);
            return;
        }
        Path path2 = path.resolve(PID_FILE_NAME);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        Path path3 = path2;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(path3, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return;
        }
        Path path4 = path.resolve("pulsar_chrome");
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"resolve(...)");
        this.deleteTemporaryUserDataDirWithLock(path4, expiry);
    }

    public final synchronized void deleteTemporaryUserDataDirWithLock(@NotNull Path userDataDir, @NotNull Duration expiry) throws IOException {
        Intrinsics.checkNotNullParameter((Object)userDataDir, (String)"userDataDir");
        Intrinsics.checkNotNullParameter((Object)expiry, (String)"expiry");
        Path lockFile = AppPaths.INSTANCE.getBROWSER_TMP_DIR_LOCK();
        Intrinsics.checkNotNull((Object)lockFile);
        this.runWithFileLock(lockFile, (Function1)new Function1<FileChannel, Unit>(userDataDir, expiry){
            final /* synthetic */ Path $userDataDir;
            final /* synthetic */ Duration $expiry;
            {
                this.$userDataDir = $userDataDir;
                this.$expiry = $expiry;
                super(1);
            }

            public final void invoke(@NotNull FileChannel channel) {
                Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
                BrowserFiles.access$deleteTemporaryUserDataDir0(BrowserFiles.INSTANCE, this.$userDataDir, this.$expiry, channel);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized <T> T runWithFileLock(Path lockFile, Function1<? super FileChannel, ? extends T> supplier) throws IOException {
        Object object = new OpenOption[]{StandardOpenOption.APPEND};
        FileChannel channel = FileChannel.open(lockFile, object);
        object = channel;
        Throwable throwable = null;
        try {
            FileLock fileLock;
            Object object2;
            FileChannel it = (FileChannel)object;
            boolean bl = false;
            FileLock lock = it.tryLock();
            try {
                Intrinsics.checkNotNull((Object)it);
                object2 = supplier.invoke((Object)it);
                fileLock = lock;
            }
            catch (Throwable throwable2) {
                try {
                    FileLock fileLock2 = lock;
                    if (fileLock2 != null) {
                        fileLock2.release();
                    }
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            if (fileLock != null) {
                fileLock.release();
            }
            Object object3 = object2;
            return (T)object3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    private final void deleteTemporaryUserDataDir0(Path userDataDir, Duration expiry, FileChannel channel) throws IOException {
        if (!channel.isOpen()) {
            boolean $i$a$-require-BrowserFiles$deleteTemporaryUserDataDir0$22 = false;
            String $i$a$-require-BrowserFiles$deleteTemporaryUserDataDir0$22 = "The lock file channel is closed";
            throw new IllegalArgumentException($i$a$-require-BrowserFiles$deleteTemporaryUserDataDir0$22.toString());
        }
        Path dirToDelete = userDataDir;
        if (!Files.exists(dirToDelete, new LinkOption[0])) {
            return;
        }
        boolean cleanedUp = cleanedUserDataDirs.contains(dirToDelete);
        if (cleanedUp) {
            return;
        }
        boolean isTemporary = dirToDelete.startsWith(AppPaths.INSTANCE.getCONTEXT_TMP_DIR());
        if (!isTemporary) {
            return;
        }
        Instant lastModifiedTime = Files.getLastModifiedTime(dirToDelete, new LinkOption[0]).toInstant();
        Intrinsics.checkNotNull((Object)lastModifiedTime);
        boolean isExpired = DateTimes.INSTANCE.isExpired(lastModifiedTime, expiry);
        if (!isExpired) {
            return;
        }
        boolean hasSiblingPidFile = Files.exists(dirToDelete.resolveSibling(PID_FILE_NAME), new LinkOption[0]);
        if (!hasSiblingPidFile) {
            return;
        }
        FileUtils.deleteQuietly((File)dirToDelete.toFile());
        if (Files.exists(dirToDelete, new LinkOption[0])) {
            logger.error("Browser data dir not deleted | {}", (Object)dirToDelete);
        } else {
            cleanedUserDataDirs.add(dirToDelete);
        }
    }

    private final Path computeNextSequentialContextDir0(String group, Fingerprint fingerprint, int maxContexts, FileChannel channel) throws IOException {
        if (!channel.isOpen()) {
            boolean $i$a$-require-BrowserFiles$computeNextSequentialContextDir0$22 = false;
            String $i$a$-require-BrowserFiles$computeNextSequentialContextDir0$22 = "The lock file channel is closed";
            throw new IllegalArgumentException($i$a$-require-BrowserFiles$computeNextSequentialContextDir0$22.toString());
        }
        String prefix = CONTEXT_DIR_PREFIX;
        Path groupBaseDir = AppPaths.INSTANCE.getCONTEXT_GROUP_BASE_DIR().resolve(group).resolve(fingerprint.getBrowserType().name());
        Files.createDirectories(groupBaseDir, new FileAttribute[0]);
        ContextGroup contextGroup2 = contextGroups.computeIfAbsent(group, arg_0 -> BrowserFiles.computeNextSequentialContextDir0$lambda$10((Function1)new Function1<String, ContextGroup>(group){
            final /* synthetic */ String $group;
            {
                this.$group = $group;
                super(1);
            }

            @NotNull
            public final ContextGroup invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return new ContextGroup(this.$group);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)contextGroup2, (String)"computeIfAbsent(...)");
        ContextGroup contextGroup3 = contextGroup2;
        Files.list(groupBaseDir).filter(arg_0 -> BrowserFiles.computeNextSequentialContextDir0$lambda$11((Function1)new Function1<Path, Boolean>(prefix){
            final /* synthetic */ String $prefix;
            {
                this.$prefix = $prefix;
                super(1);
            }

            @NotNull
            public final Boolean invoke(Path it) {
                return Files.isDirectory(it, new LinkOption[0]) && StringsKt.startsWith$default((String)((Object)it.getFileName()).toString(), (String)this.$prefix, (boolean)false, (int)2, null);
            }
        }, arg_0)).forEach(arg_0 -> BrowserFiles.computeNextSequentialContextDir0$lambda$12((Function1)new Function1<Path, Unit>(contextGroup3){
            final /* synthetic */ ContextGroup $contextGroup;
            {
                this.$contextGroup = $contextGroup;
                super(1);
            }

            public final void invoke(Path it) {
                Intrinsics.checkNotNull((Object)it);
                this.$contextGroup.add(it);
            }
        }, arg_0));
        if (contextGroup3.getSize() >= maxContexts) {
            return contextGroup3.getIterator().next();
        }
        Intrinsics.checkNotNull((Object)groupBaseDir);
        long contextCount = this.computeContextCount(groupBaseDir, prefix, channel);
        String string = "%s%s";
        Object[] objectArray = new Object[]{prefix, contextCount};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        String fileName = string2;
        Path path = groupBaseDir.resolve(fileName);
        Files.createDirectories(path, new FileAttribute[0]);
        Intrinsics.checkNotNull((Object)path);
        return path;
    }

    private final Path computeRandomContextDir0(String group, FileChannel channel) throws IOException {
        if (channel != null && !channel.isOpen()) {
            boolean $i$a$-require-BrowserFiles$computeRandomContextDir0$22 = false;
            String $i$a$-require-BrowserFiles$computeRandomContextDir0$22 = "The lock file channel is closed";
            throw new IllegalArgumentException($i$a$-require-BrowserFiles$computeRandomContextDir0$22.toString());
        }
        String prefix = CONTEXT_DIR_PREFIX;
        MonthDay monthDay = MonthDay.now();
        int monthValue = monthDay.getMonthValue();
        int dayOfMonth = monthDay.getDayOfMonth();
        Path baseDir = AppPaths.INSTANCE.getCONTEXT_TMP_DIR().resolve(String.valueOf(monthValue));
        Files.createDirectories(baseDir, new FileAttribute[0]);
        String rand = RandomStringUtils.randomAlphanumeric((int)5);
        Intrinsics.checkNotNull((Object)baseDir);
        long contextCount = this.computeContextCount(baseDir, prefix, channel);
        String string = "%s%02d%02d%s%s";
        Object[] objectArray = new Object[]{prefix, monthValue, dayOfMonth, rand, contextCount};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        String fileName = string2;
        Path path = baseDir.resolve(group).resolve(fileName);
        Files.createDirectories(baseDir, new FileAttribute[0]);
        Intrinsics.checkNotNull((Object)path);
        return path;
    }

    static /* synthetic */ Path computeRandomContextDir0$default(BrowserFiles browserFiles, String string, FileChannel fileChannel, int n, Object object) throws IOException {
        if ((n & 2) != 0) {
            fileChannel = null;
        }
        return browserFiles.computeRandomContextDir0(string, fileChannel);
    }

    private final long computeContextCount(Path baseDir, String prefix, FileChannel channel) {
        if (channel != null && !channel.isOpen()) {
            boolean bl = false;
            String string = "The lock file channel is closed";
            throw new IllegalArgumentException(string.toString());
        }
        return 1L + Files.list(baseDir).filter(arg_0 -> BrowserFiles.computeContextCount$lambda$15(computeContextCount.2.INSTANCE, arg_0)).filter(arg_0 -> BrowserFiles.computeContextCount$lambda$16((Function1)new Function1<Path, Boolean>(prefix){
            final /* synthetic */ String $prefix;
            {
                this.$prefix = $prefix;
                super(1);
            }

            @NotNull
            public final Boolean invoke(Path it) {
                return StringsKt.contains$default((CharSequence)((Object)it).toString(), (CharSequence)this.$prefix, (boolean)false, (int)2, null);
            }
        }, arg_0)).count();
    }

    static /* synthetic */ long computeContextCount$default(BrowserFiles browserFiles, Path path, String string, FileChannel fileChannel, int n, Object object) {
        if ((n & 4) != 0) {
            fileChannel = null;
        }
        return browserFiles.computeContextCount(path, string, fileChannel);
    }

    private static final boolean cleanOldestContextTmpDirs$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean cleanOldestContextTmpDirs$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean cleanUpContextTmpDir$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean cleanUpContextTmpDir$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void cleanUpContextTmpDir$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final ContextGroup computeNextSequentialContextDir0$lambda$10(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ContextGroup)$tmp0.invoke(p0);
    }

    private static final boolean computeNextSequentialContextDir0$lambda$11(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void computeNextSequentialContextDir0$lambda$12(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final boolean computeContextCount$lambda$15(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean computeContextCount$lambda$16(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Path access$computeNextSequentialContextDir0(BrowserFiles $this, String group, Fingerprint fingerprint, int maxContexts, FileChannel channel) {
        return $this.computeNextSequentialContextDir0(group, fingerprint, maxContexts, channel);
    }

    public static final /* synthetic */ ConcurrentSkipListSet access$getCleanedUserDataDirs$p() {
        return cleanedUserDataDirs;
    }

    public static final /* synthetic */ void access$deleteTemporaryUserDataDir0(BrowserFiles $this, Path userDataDir, Duration expiry, FileChannel channel) {
        $this.deleteTemporaryUserDataDir0(userDataDir, expiry, channel);
    }
}

