/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.collect;

import ai.platon.pulsar.common.Priority13;
import ai.platon.pulsar.common.collect.AbstractUrlPool;
import ai.platon.pulsar.common.collect.ConcurrentUrlCache;
import ai.platon.pulsar.common.collect.DelayUrl;
import ai.platon.pulsar.common.collect.UrlCache;
import ai.platon.pulsar.common.collect.UrlPool;
import ai.platon.pulsar.common.config.ImmutableConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.DelayQueue;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.collections4.queue.SynchronizedQueue;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR \u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0019"}, d2={"Lai/platon/pulsar/common/collect/ConcurrentUrlPool;", "Lai/platon/pulsar/common/collect/AbstractUrlPool;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/common/config/ImmutableConfig;)V", "delayCache", "Ljava/util/Queue;", "Lai/platon/pulsar/common/collect/DelayUrl;", "getDelayCache", "()Ljava/util/Queue;", "orderedCaches", "Ljava/util/concurrent/ConcurrentSkipListMap;", "", "Lai/platon/pulsar/common/collect/UrlCache;", "getOrderedCaches", "()Ljava/util/concurrent/ConcurrentSkipListMap;", "realTimeCache", "getRealTimeCache", "()Lai/platon/pulsar/common/collect/UrlCache;", "unorderedCaches", "", "getUnorderedCaches", "()Ljava/util/List;", "initialize", "", "pulsar-common"})
@SourceDebugExtension(value={"SMAP\nUrlPool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UrlPool.kt\nai/platon/pulsar/common/collect/ConcurrentUrlPool\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,285:1\n1855#2,2:286\n*S KotlinDebug\n*F\n+ 1 UrlPool.kt\nai/platon/pulsar/common/collect/ConcurrentUrlPool\n*L\n261#1:286,2\n*E\n"})
public class ConcurrentUrlPool
extends AbstractUrlPool {
    @NotNull
    private final UrlCache realTimeCache;
    @NotNull
    private final Queue<DelayUrl> delayCache;
    @NotNull
    private final ConcurrentSkipListMap<Integer, UrlCache> orderedCaches;
    @NotNull
    private final List<UrlCache> unorderedCaches;

    public ConcurrentUrlPool(@NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        super(conf);
        this.realTimeCache = new ConcurrentUrlCache("realtime", UrlPool.Companion.getREAL_TIME_PRIORITY());
        SynchronizedQueue synchronizedQueue = SynchronizedQueue.synchronizedQueue((Queue)new DelayQueue());
        Intrinsics.checkNotNullExpressionValue((Object)synchronizedQueue, (String)"synchronizedQueue(...)");
        this.delayCache = (Queue)synchronizedQueue;
        this.orderedCaches = new ConcurrentSkipListMap();
        List list2 = Collections.synchronizedList(new ArrayList());
        Intrinsics.checkNotNullExpressionValue(list2, (String)"synchronizedList(...)");
        this.unorderedCaches = list2;
    }

    @Override
    @NotNull
    public UrlCache getRealTimeCache() {
        return this.realTimeCache;
    }

    @Override
    @NotNull
    public Queue<DelayUrl> getDelayCache() {
        return this.delayCache;
    }

    @NotNull
    public ConcurrentSkipListMap<Integer, UrlCache> getOrderedCaches() {
        return this.orderedCaches;
    }

    @Override
    @NotNull
    public List<UrlCache> getUnorderedCaches() {
        return this.unorderedCaches;
    }

    @Override
    public void initialize() {
        if (this.getInitialized().compareAndSet(false, true)) {
            Iterable $this$forEach$iv = (Iterable)EntriesMappings.entries$0;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Priority13 it = (Priority13)((Object)element$iv);
                boolean bl = false;
                this.getOrderedCaches().put(it.getValue(), new ConcurrentUrlCache(it.name(), it.getValue()));
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<Priority13> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])Priority13.values());
        }
    }
}

