/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.config;

import ai.platon.pulsar.common.SParser;
import ai.platon.pulsar.common.config.KConfiguration;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.env.PropertyResolverExtensionsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010%\n\u0002\u0010$\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B+\b\u0016\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0002\u0010\bB\u000f\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010%\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001e\u001a\u00020\u0003H\u0096\u0002J\u0019\u0010%\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u0003H\u0096\u0002J\u0016\u0010'\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u0005J\u001e\u0010(\u001a\u0006\u0012\u0002\b\u00030)2\u0006\u0010\u001e\u001a\u00020\u00032\n\u0010&\u001a\u0006\u0012\u0002\b\u00030)J:\u0010(\u001a\n\u0012\u0006\b\u0001\u0012\u0002H*0)\"\u0004\b\u0000\u0010*2\u0006\u0010\u001e\u001a\u00020\u00032\u000e\u0010&\u001a\n\u0012\u0006\b\u0001\u0012\u0002H*0)2\f\u0010+\u001a\b\u0012\u0004\u0012\u0002H*0)J\u000e\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0003J\u0016\u0010/\u001a\n \u0018*\u0004\u0018\u000100002\u0006\u0010.\u001a\u00020\u0003J\u0016\u00101\u001a\u0002022\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010&\u001a\u000202J\u0016\u00103\u001a\n \u0018*\u0004\u0018\u000104042\u0006\u0010\u001e\u001a\u00020\u0003J\u001e\u00103\u001a\n \u0018*\u0004\u0018\u000104042\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010&\u001a\u000204J5\u00105\u001a\n \u0018*\u0004\u0018\u0001H6H6\"\u0010\b\u0000\u00106*\n\u0012\u0004\u0012\u0002H6\u0018\u0001072\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010&\u001a\u0002H6\u00a2\u0006\u0002\u00108J\u0016\u00109\u001a\u00020:2\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010&\u001a\u00020:J\u001e\u0010;\u001a\n \u0018*\u0004\u0018\u00010<0<2\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010&\u001a\u00020<J\u0016\u0010=\u001a\u00020>2\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010&\u001a\u00020>J\u0016\u0010?\u001a\n \u0018*\u0004\u0018\u00010@0@2\u0006\u0010\u001e\u001a\u00020\u0003JN\u0010A\u001aB\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u00030\u0003\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u00030\u0003 \u0018* \u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u00030\u0003\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u00030\u0003\u0018\u00010C0B2\u0006\u0010\u001e\u001a\u00020\u0003J\u0016\u0010D\u001a\u00020E2\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010&\u001a\u00020EJ\u001e\u0010F\u001a\n \u0018*\u0004\u0018\u00010G0G2\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010H\u001a\u00020GJ\u0010\u0010I\u001a\u0004\u0018\u00010G2\u0006\u0010\u001e\u001a\u00020\u0003J\u0016\u0010J\u001a\n \u0018*\u0004\u0018\u00010K0K2\u0006\u0010.\u001a\u00020\u0003J2\u0010L\u001a&\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u00030\u0003 \u0018*\u0012\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u00030\u0003\u0018\u00010N0M2\u0006\u0010\u001e\u001a\u00020\u0003J7\u0010O\u001a&\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u00030\u0003 \u0018*\u0012\u0012\u000e\b\u0001\u0012\n \u0018*\u0004\u0018\u00010\u00030\u00030P0P2\u0006\u0010\u001e\u001a\u00020\u0003\u00a2\u0006\u0002\u0010QJM\u0010O\u001a(\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u00030\u0003 \u0018*\u0014\u0012\u000e\b\u0001\u0012\n \u0018*\u0004\u0018\u00010\u00030\u0003\u0018\u00010P0P2\u0006\u0010\u001e\u001a\u00020\u00032\u0012\u0010&\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030P\"\u00020\u0003\u00a2\u0006\u0002\u0010RJ2\u0010S\u001a&\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u00030\u0003 \u0018*\u0012\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u00030\u0003\u0018\u00010N0M2\u0006\u0010\u001e\u001a\u00020\u0003J9\u0010T\u001a(\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u00030\u0003 \u0018*\u0014\u0012\u000e\b\u0001\u0012\n \u0018*\u0004\u0018\u00010\u00030\u0003\u0018\u00010P0P2\u0006\u0010\u001e\u001a\u00020\u0003\u00a2\u0006\u0002\u0010QJ-\u0010T\u001a\b\u0012\u0004\u0012\u00020\u00030P2\u0006\u0010\u001e\u001a\u00020\u00032\u0012\u0010&\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030P\"\u00020\u0003\u00a2\u0006\u0002\u0010RJ\u0016\u0010U\u001a\u00020>2\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010&\u001a\u00020>J\u0016\u0010V\u001a\u00020E2\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010&\u001a\u00020EJ\u0010\u0010W\u001a\u00020X2\u0006\u0010\u001e\u001a\u00020\u0003H\u0002J\u0006\u0010Y\u001a\u00020>J\b\u0010Z\u001a\u00020\u0003H\u0016J\u0006\u0010[\u001a\u00020\nR\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\n \u0018*\u0004\u0018\u00010\u00170\u0017X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u001d\"\u0004\b \u0010!R\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001dR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030$X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\\"}, d2={"Lai/platon/pulsar/common/config/AbstractConfiguration;", "", "profile", "", "loadDefaults", "", "resources", "", "(Ljava/lang/String;ZLjava/lang/Iterable;)V", "conf", "Lai/platon/pulsar/common/config/KConfiguration;", "(Lai/platon/pulsar/common/config/KConfiguration;)V", "getConf", "()Lai/platon/pulsar/common/config/KConfiguration;", "environment", "Lorg/springframework/core/env/Environment;", "getEnvironment", "()Lorg/springframework/core/env/Environment;", "setEnvironment", "(Lorg/springframework/core/env/Environment;)V", "isDistributedFs", "()Z", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLogger", "()Lorg/slf4j/Logger;", "mode", "getMode", "()Ljava/lang/String;", "name", "getName", "setName", "(Ljava/lang/String;)V", "<set-?>", "getProfile", "Ljava/util/LinkedHashSet;", "get", "defaultValue", "getBoolean", "getClass", "Ljava/lang/Class;", "U", "xface", "getConfResourceAsInputStream", "Ljava/io/InputStream;", "resource", "getConfResourceAsReader", "Ljava/io/Reader;", "getDouble", "", "getDuration", "Ljava/time/Duration;", "getEnum", "T", "", "(Ljava/lang/String;Ljava/lang/Enum;)Ljava/lang/Enum;", "getFloat", "", "getInstant", "Ljava/time/Instant;", "getInt", "", "getInts", "", "getKvs", "", "", "getLong", "", "getPath", "Ljava/nio/file/Path;", "elsePath", "getPathOrNull", "getResource", "Ljava/net/URL;", "getStringCollection", "", "", "getStrings", "", "(Ljava/lang/String;)[Ljava/lang/String;", "(Ljava/lang/String;[Ljava/lang/String;)[Ljava/lang/String;", "getTrimmedStringCollection", "getTrimmedStrings", "getUint", "getUlong", "p", "Lai/platon/pulsar/common/SParser;", "size", "toString", "unbox", "pulsar-common"})
public abstract class AbstractConfiguration {
    private final Logger logger;
    @NotNull
    private final LinkedHashSet<String> resources;
    @NotNull
    private String name;
    @NotNull
    private String profile;
    @NotNull
    private final KConfiguration conf;
    @Nullable
    private Environment environment;

    protected final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final void setName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.name = string;
    }

    @NotNull
    public final String getProfile() {
        return this.profile;
    }

    @NotNull
    public final String getMode() {
        return this.isDistributedFs() ? "cluster" : "local";
    }

    @NotNull
    protected final KConfiguration getConf() {
        return this.conf;
    }

    @Nullable
    public final Environment getEnvironment() {
        return this.environment;
    }

    public final void setEnvironment(@Nullable Environment environment) {
        this.environment = environment;
    }

    public AbstractConfiguration(@NotNull String profile, boolean loadDefaults, @NotNull Iterable<String> resources) {
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        Intrinsics.checkNotNullParameter(resources, (String)"resources");
        this.logger = LoggerFactory.getLogger(AbstractConfiguration.class);
        this.resources = new LinkedHashSet();
        this.name = "Configuration#" + this.hashCode();
        this.profile = "";
        this.conf = new KConfiguration(profile, null, resources, loadDefaults, 2, null);
    }

    public /* synthetic */ AbstractConfiguration(String string, boolean bl, Iterable iterable, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            String string2 = System.getProperty("profile", "");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProperty(...)");
            string = string2;
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            iterable = KConfiguration.Companion.getDEFAULT_RESOURCES();
        }
        this(string, bl, iterable);
    }

    public AbstractConfiguration(@NotNull KConfiguration conf) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.logger = LoggerFactory.getLogger(AbstractConfiguration.class);
        this.resources = new LinkedHashSet();
        this.name = "Configuration#" + this.hashCode();
        this.profile = "";
        this.conf = new KConfiguration(conf);
    }

    private final boolean isDistributedFs() {
        String string = this.get("fs.defaultFS");
        return string != null ? StringsKt.startsWith$default((String)string, (String)"hdfs", (boolean)false, (int)2, null) : false;
    }

    @NotNull
    public final KConfiguration unbox() {
        return this.conf;
    }

    public final int size() {
        return this.conf.size();
    }

    @Nullable
    public String get(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string = System.getenv(name);
        if (string == null && (string = System.getProperty(name)) == null) {
            Environment environment = this.environment;
            string = environment != null ? PropertyResolverExtensionsKt.get((PropertyResolver)((PropertyResolver)environment), (String)name) : null;
            if (string == null) {
                string = this.conf.get(name);
            }
        }
        return string;
    }

    @NotNull
    public String get(@NotNull String name, @NotNull String defaultValue) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
        String string = this.get(name);
        if (string == null) {
            string = defaultValue;
        }
        return string;
    }

    public final int getInt(@NotNull String name, int defaultValue) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.p(name).getInt(defaultValue);
    }

    public final int[] getInts(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.p(name).getInts();
    }

    public final long getLong(@NotNull String name, long defaultValue) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.p(name).getLong(defaultValue);
    }

    public final float getFloat(@NotNull String name, float defaultValue) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.p(name).getFloat(defaultValue);
    }

    public final double getDouble(@NotNull String name, double defaultValue) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.p(name).getDouble(defaultValue);
    }

    public final boolean getBoolean(@NotNull String name, boolean defaultValue) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.p(name).getBoolean(defaultValue);
    }

    public final <T extends Enum<T>> T getEnum(@NotNull String name, T defaultValue) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.p(name).getEnum(defaultValue);
    }

    public final Collection<String> getStringCollection(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.p(name).getStringCollection();
    }

    @NotNull
    public final String[] getStrings(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String[] stringArray = this.p(name).getStrings();
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    public final String[] getStrings(@NotNull String name, String ... defaultValue) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
        return this.p(name).getStrings(Arrays.copyOf(defaultValue, defaultValue.length));
    }

    public final Collection<String> getTrimmedStringCollection(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.p(name).getTrimmedStringCollection();
    }

    public final String[] getTrimmedStrings(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.p(name).getTrimmedStrings();
    }

    @NotNull
    public final String[] getTrimmedStrings(@NotNull String name, String ... defaultValue) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
        String[] stringArray = this.p(name).getTrimmedStrings(Arrays.copyOf(defaultValue, defaultValue.length));
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getTrimmedStrings(...)");
        return stringArray;
    }

    public final int getUint(@NotNull String name, int defaultValue) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        int value = this.getInt(name, defaultValue);
        if (value < 0) {
            value = defaultValue;
        }
        return value;
    }

    public final long getUlong(@NotNull String name, long defaultValue) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        long value = this.getLong(name, defaultValue);
        if (value < 0L) {
            value = defaultValue;
        }
        return value;
    }

    public final Duration getDuration(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.p(name).getDuration();
    }

    public final Duration getDuration(@NotNull String name, @NotNull Duration defaultValue) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
        return this.p(name).getDuration(defaultValue);
    }

    public final Instant getInstant(@NotNull String name, @NotNull Instant defaultValue) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
        return this.p(name).getInstant(defaultValue);
    }

    public final Path getPath(@NotNull String name, @NotNull Path elsePath) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)elsePath, (String)"elsePath");
        return this.p(name).getPath(elsePath);
    }

    @Nullable
    public final Path getPathOrNull(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.p(name).getPathOrNull();
    }

    public final Map<String, String> getKvs(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.p(name).getKvs();
    }

    @NotNull
    public final InputStream getConfResourceAsInputStream(@NotNull String resource) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        InputStream inputStream = SParser.wrap(resource).getResourceAsInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getResourceAsInputStream(...)");
        return inputStream;
    }

    public final Reader getConfResourceAsReader(@NotNull String resource) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        return SParser.wrap(resource).getResourceAsReader();
    }

    public final URL getResource(@NotNull String resource) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        return SParser.wrap(resource).getResource();
    }

    @NotNull
    public final Class<?> getClass(@NotNull String name, @NotNull Class<?> defaultValue) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(defaultValue, (String)"defaultValue");
        Class<?> clazz = this.p(name).getClass(defaultValue);
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"getClass(...)");
        return clazz;
    }

    @NotNull
    public final <U> Class<? extends U> getClass(@NotNull String name, @NotNull Class<? extends U> defaultValue, @NotNull Class<U> xface) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(defaultValue, (String)"defaultValue");
        Intrinsics.checkNotNullParameter(xface, (String)"xface");
        Class<? extends U> clazz = this.p(name).getClass(defaultValue, xface);
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"getClass(...)");
        return clazz;
    }

    private final SParser p(String name) {
        return new SParser(this.get(name));
    }

    @NotNull
    public String toString() {
        return "profile: <" + this.profile + "> | " + this.conf;
    }
}

