/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.urls;

import ai.platon.pulsar.common.urls.AbstractUrl;
import ai.platon.pulsar.common.urls.HyperlinkDatum;
import ai.platon.pulsar.common.urls.UrlAware;
import ai.platon.pulsar.common.urls.UrlUtils;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\bB\u000f\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bB\u0081\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\f\u001a\u00020\u0003\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u0013\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0014\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0015\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0016\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u0017\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0018J\u0006\u0010\u0019\u001a\u00020\nJ\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0003H\u0016J\u0018\u0010\u001d\u001a\u00060\u001ej\u0002`\u001f2\n\u0010 \u001a\u00060\u001ej\u0002`\u001fH\u0016J\u0006\u0010!\u001a\u00020\n\u00a8\u0006#"}, d2={"Lai/platon/pulsar/common/urls/Hyperlink;", "Lai/platon/pulsar/common/urls/AbstractUrl;", "url", "", "(Ljava/lang/String;)V", "Lai/platon/pulsar/common/urls/UrlAware;", "(Lai/platon/pulsar/common/urls/UrlAware;)V", "link", "(Lai/platon/pulsar/common/urls/Hyperlink;)V", "datum", "Lai/platon/pulsar/common/urls/HyperlinkDatum;", "(Lai/platon/pulsar/common/urls/HyperlinkDatum;)V", "text", "order", "", "referrer", "args", "href", "priority", "lang", "country", "district", "nMaxRetry", "depth", "(Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;II)V", "data", "isDefault", "", "fieldName", "serializeTo", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "sb", "toDatum", "Companion", "pulsar-common"})
public class Hyperlink
extends AbstractUrl {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<String> EXPECTED_FIELDS;
    @NotNull
    private static final Hyperlink EXAMPLE;

    public Hyperlink(@NotNull String url, @NotNull String text, int order, @Nullable String referrer, @Nullable String args, @Nullable String href, int priority, @NotNull String lang, @NotNull String country, @NotNull String district, int nMaxRetry, int depth) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)lang, (String)"lang");
        Intrinsics.checkNotNullParameter((Object)country, (String)"country");
        Intrinsics.checkNotNullParameter((Object)district, (String)"district");
        super(url, text, order, referrer, args, href, priority, lang, country, district, nMaxRetry, depth);
    }

    public /* synthetic */ Hyperlink(String string, String string2, int n, String string3, String string4, String string5, int n2, String string6, String string7, String string8, int n3, int n4, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n5 & 2) != 0) {
            string2 = "";
        }
        if ((n5 & 4) != 0) {
            n = 0;
        }
        if ((n5 & 8) != 0) {
            string3 = null;
        }
        if ((n5 & 0x10) != 0) {
            string4 = null;
        }
        if ((n5 & 0x20) != 0) {
            string5 = null;
        }
        if ((n5 & 0x40) != 0) {
            n2 = 0;
        }
        if ((n5 & 0x80) != 0) {
            string6 = "*";
        }
        if ((n5 & 0x100) != 0) {
            string7 = "*";
        }
        if ((n5 & 0x200) != 0) {
            string8 = "*";
        }
        if ((n5 & 0x400) != 0) {
            n3 = 3;
        }
        if ((n5 & 0x800) != 0) {
            n4 = 0;
        }
        this(string, string2, n, string3, string4, string5, n2, string6, string7, string8, n3, n4);
    }

    public Hyperlink(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this(url, "", 0, null, null, null, 0, null, null, null, 0, 0, 4088, null);
    }

    public Hyperlink(@NotNull UrlAware url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this(url.getUrl(), "", 0, url.getReferrer(), url.getArgs(), url.getHref(), url.getPriority(), url.getLang(), url.getCountry(), url.getDistrict(), url.getNMaxRetry(), url.getDepth());
    }

    public Hyperlink(@NotNull Hyperlink link) {
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        this(link.getUrl(), link.getText(), link.getOrder(), link.getReferrer(), link.getArgs(), link.getHref(), link.getPriority(), link.getLang(), link.getCountry(), link.getDistrict(), link.getNMaxRetry(), link.getDepth());
    }

    public Hyperlink(@NotNull HyperlinkDatum datum) {
        Intrinsics.checkNotNullParameter((Object)datum, (String)"datum");
        this(datum.getUrl(), datum.getText(), datum.getOrder(), datum.getReferrer(), datum.getArgs(), datum.getHref(), datum.getPriority(), datum.getLang(), datum.getCountry(), datum.getDistrict(), datum.getNMaxRetry(), datum.getDepth());
    }

    @NotNull
    public final HyperlinkDatum data() {
        return this.toDatum();
    }

    @NotNull
    public final HyperlinkDatum toDatum() {
        return new HyperlinkDatum(this.getUrl(), this.getText(), this.getOrder(), this.getReferrer(), this.getArgs(), this.getHref(), false, this.getPriority(), this.getLang(), this.getCountry(), this.getDistrict(), this.getNMaxRetry(), this.getDepth(), 64, null);
    }

    @Override
    @NotNull
    public StringBuilder serializeTo(@NotNull StringBuilder sb) {
        Intrinsics.checkNotNullParameter((Object)sb, (String)"sb");
        sb.append(this.getUrl());
        if (!this.isDefault("text")) {
            sb.append(" -text " + this.getText());
        }
        if (!this.isDefault("order")) {
            sb.append(" -order " + this.getOrder());
        }
        if (!this.isDefault("referrer")) {
            sb.append(" -referrer " + this.getReferrer());
        }
        if (!this.isDefault("args")) {
            sb.append(" -args " + this.getArgs());
        }
        if (!this.isDefault("href")) {
            sb.append(" -href " + this.getHref());
        }
        if (!this.isDefault("priority")) {
            sb.append(" -priority " + this.getPriority());
        }
        if (!this.isDefault("lang")) {
            sb.append(" -lang " + this.getLang());
        }
        if (!this.isDefault("country")) {
            sb.append(" -country " + this.getCountry());
        }
        if (!this.isDefault("district")) {
            sb.append(" -district " + this.getDistrict());
        }
        if (!this.isDefault("nMaxRetry")) {
            sb.append(" -nMaxRetry " + this.getNMaxRetry());
        }
        if (!this.isDefault("depth")) {
            sb.append(" -depth " + this.getDepth());
        }
        return sb;
    }

    public boolean isDefault(@NotNull String fieldName) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        return switch (fieldName) {
            case "url" -> Intrinsics.areEqual((Object)this.getUrl(), (Object)EXAMPLE.getUrl());
            case "text" -> Intrinsics.areEqual((Object)this.getText(), (Object)EXAMPLE.getText());
            case "order" -> {
                if (this.getOrder() == EXAMPLE.getOrder()) {
                    yield true;
                }
                yield false;
            }
            case "referrer" -> Intrinsics.areEqual((Object)this.getReferrer(), (Object)EXAMPLE.getReferrer());
            case "args" -> Intrinsics.areEqual((Object)this.getArgs(), (Object)EXAMPLE.getArgs());
            case "href" -> Intrinsics.areEqual((Object)this.getHref(), (Object)EXAMPLE.getHref());
            case "priority" -> {
                if (this.getPriority() == EXAMPLE.getPriority()) {
                    yield true;
                }
                yield false;
            }
            case "lang" -> Intrinsics.areEqual((Object)this.getLang(), (Object)EXAMPLE.getLang());
            case "country" -> Intrinsics.areEqual((Object)this.getCountry(), (Object)EXAMPLE.getCountry());
            case "district" -> Intrinsics.areEqual((Object)this.getDistrict(), (Object)EXAMPLE.getDistrict());
            case "nMaxRetry" -> {
                if (this.getNMaxRetry() == EXAMPLE.getNMaxRetry()) {
                    yield true;
                }
                yield false;
            }
            case "depth" -> {
                if (this.getDepth() == EXAMPLE.getDepth()) {
                    yield true;
                }
                yield false;
            }
            default -> throw new IllegalArgumentException("Unknown field name: " + fieldName);
        };
    }

    static {
        Object[] objectArray = new String[]{"url", "text", "order", "referrer", "args", "href", "priority", "lang", "country", "district", "nMaxRetry", "depth"};
        EXPECTED_FIELDS = CollectionsKt.listOf((Object[])objectArray);
        EXAMPLE = new Hyperlink("http://example.com");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00042\b\u0010\r\u001a\u0004\u0018\u00010\tJ\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lai/platon/pulsar/common/urls/Hyperlink$Companion;", "", "()V", "EXAMPLE", "Lai/platon/pulsar/common/urls/Hyperlink;", "getEXAMPLE", "()Lai/platon/pulsar/common/urls/Hyperlink;", "EXPECTED_FIELDS", "", "", "getEXPECTED_FIELDS", "()Ljava/util/List;", "create", "url", "parse", "linkText", "pulsar-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getEXPECTED_FIELDS() {
            return EXPECTED_FIELDS;
        }

        @NotNull
        public final Hyperlink getEXAMPLE() {
            return EXAMPLE;
        }

        @Nullable
        public final Hyperlink create(@Nullable String url) {
            return url == null ? null : (!UrlUtils.isStandard(url) ? null : new Hyperlink(url));
        }

        @NotNull
        public final Hyperlink parse(@NotNull String linkText) {
            Intrinsics.checkNotNullParameter((Object)linkText, (String)"linkText");
            String url = "";
            String text = this.getEXAMPLE().getText();
            String args = this.getEXAMPLE().getArgs();
            String href = this.getEXAMPLE().getHref();
            String referrer = this.getEXAMPLE().getReferrer();
            int order = this.getEXAMPLE().getOrder();
            int priority = this.getEXAMPLE().getPriority();
            String lang = this.getEXAMPLE().getLang();
            String country = this.getEXAMPLE().getCountry();
            String district = this.getEXAMPLE().getDistrict();
            int nMaxRetry = this.getEXAMPLE().getNMaxRetry();
            int depth = this.getEXAMPLE().getDepth();
            CharSequence charSequence = linkText;
            Object object = new Regex("\\s+");
            int n = 0;
            List parts = object.split(charSequence, n);
            url = (String)parts.get(0);
            block26: for (int i = 0; i < parts.size() - 1; ++i) {
                switch ((String)parts.get(i)) {
                    case "-text": {
                        text = (String)parts.get(i + 1);
                        continue block26;
                    }
                    case "-args": {
                        args = (String)parts.get(i + 1);
                        continue block26;
                    }
                    case "-href": {
                        href = (String)parts.get(i + 1);
                        continue block26;
                    }
                    case "-referrer": {
                        referrer = (String)parts.get(i + 1);
                        continue block26;
                    }
                    case "-order": {
                        Integer n2 = StringsKt.toIntOrNull((String)((String)parts.get(i + 1)));
                        order = n2 != null ? n2 : order;
                        continue block26;
                    }
                    case "-priority": {
                        Integer n3 = StringsKt.toIntOrNull((String)((String)parts.get(i + 1)));
                        priority = n3 != null ? n3 : priority;
                        continue block26;
                    }
                    case "-lang": {
                        lang = (String)parts.get(i + 1);
                        continue block26;
                    }
                    case "-country": {
                        country = (String)parts.get(i + 1);
                        continue block26;
                    }
                    case "-district": {
                        district = (String)parts.get(i + 1);
                        continue block26;
                    }
                    case "-nMaxRetry": {
                        Integer n4 = StringsKt.toIntOrNull((String)((String)parts.get(i + 1)));
                        nMaxRetry = n4 != null ? n4 : nMaxRetry;
                        continue block26;
                    }
                    case "-depth": {
                        Integer n5 = StringsKt.toIntOrNull((String)((String)parts.get(i + 1)));
                        depth = n5 != null ? n5 : depth;
                    }
                }
            }
            return new Hyperlink(url, text, order, referrer, args, href, priority, lang, country, district, nMaxRetry, depth);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

