/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common;

import com.google.common.base.Predicates;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t\u001a\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\t\u001a \u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\r\"\u0004\b\u0000\u0010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0010\u00a8\u0006\u0011"}, d2={"alwaysFalse", "", "alwaysTrue", "sleep", "", "duration", "Ljava/time/Duration;", "sleepMillis", "millis", "", "sleepSeconds", "seconds", "usfLazy", "Lkotlin/Lazy;", "T", "initializer", "Lkotlin/Function0;", "pulsar-common"})
public final class LangKt {
    @NotNull
    public static final <T> Lazy<T> usfLazy(@NotNull Function0<? extends T> initializer) {
        Intrinsics.checkNotNullParameter(initializer, (String)"initializer");
        return LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, initializer);
    }

    public static final void sleepSeconds(long seconds) {
        try {
            TimeUnit.SECONDS.sleep(seconds);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static final void sleepMillis(long millis) {
        try {
            TimeUnit.MILLISECONDS.sleep(millis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static final void sleep(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        try {
            Thread.sleep(duration.toMillis());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static final boolean alwaysFalse() {
        return Predicates.alwaysFalse().apply((Object)false);
    }

    public static final boolean alwaysTrue() {
        return Predicates.alwaysTrue().apply((Object)true);
    }
}

