/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common;

import ai.platon.pulsar.common.config.ImmutableConfig;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetUtil {
    private static final Logger log = LoggerFactory.getLogger(NetUtil.class);
    public static Duration CONNECTION_TIMEOUT = Duration.ofSeconds(3L);
    public static Duration PROXY_CONNECTION_TIMEOUT = Duration.ofSeconds(3L);
    public static final Pattern IP_PORT_PATTERN = Pattern.compile("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}(:\\d+)?");

    public static boolean testNetwork(String host, int port) {
        return NetUtil.testTcpNetwork(host, port);
    }

    public static boolean testHttpNetwork(URL url) {
        return NetUtil.testHttpNetwork(url, null);
    }

    public static boolean testHttpNetwork(URL url, Proxy proxy) {
        boolean reachable = false;
        try {
            HttpURLConnection con = proxy != null ? (HttpURLConnection)url.openConnection(proxy) : (HttpURLConnection)url.openConnection();
            con.setConnectTimeout((int)PROXY_CONNECTION_TIMEOUT.toMillis());
            con.connect();
            if (proxy != null) {
                log.debug("Proxy is available {} for {}", (Object)proxy, (Object)url);
            }
            reachable = true;
            con.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return reachable;
    }

    public static boolean testHttpNetwork(String host, int port) {
        if (host.isBlank()) {
            return false;
        }
        try {
            URL url = new URL("http", host, port, "/");
            return NetUtil.testHttpNetwork(url);
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
    }

    public static boolean testTcpNetwork(String host, int port) {
        return NetUtil.testTcpNetwork(host, port, CONNECTION_TIMEOUT);
    }

    public static boolean testTcpNetwork(String host, int port, Duration timeout) {
        if (host.isBlank()) {
            return false;
        }
        boolean reachable = false;
        Socket socket = new Socket();
        try {
            socket.connect(new InetSocketAddress(host, port), (int)timeout.toMillis());
            reachable = socket.isConnected();
            socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return reachable;
    }

    public static String getAgentString(String agentName) {
        return agentName;
    }

    public static String getAgentString(String agentName, String agentVersion, String agentDesc, String agentURL, String agentEmail) {
        if (agentName == null || agentName.trim().length() == 0) {
            log.error("No User-Agent string set (http.agent.name)!");
        }
        StringBuilder buf = new StringBuilder();
        buf.append(agentName);
        if (agentVersion != null) {
            buf.append("/");
            buf.append(agentVersion);
        }
        if (agentDesc != null && agentDesc.length() != 0 || agentEmail != null && agentEmail.length() != 0 || agentURL != null && agentURL.length() != 0) {
            buf.append(" (");
            if (agentDesc != null && agentDesc.length() != 0) {
                buf.append(agentDesc);
                if (agentURL != null || agentEmail != null) {
                    buf.append("; ");
                }
            }
            if (agentURL != null && agentURL.length() != 0) {
                buf.append(agentURL);
                if (agentEmail != null) {
                    buf.append("; ");
                }
            }
            if (agentEmail != null && agentEmail.length() != 0) {
                buf.append(agentEmail);
            }
            buf.append(")");
        }
        return buf.toString();
    }

    public static String getChromeUserAgent(String mozilla, String appleWebKit, String chrome, String safari) {
        return String.format("Mozilla/%s (X11; Linux x86_64) AppleWebKit/%s (KHTML, like Gecko) Chrome/%s Safari/%s", mozilla, appleWebKit, chrome, safari);
    }

    public static String getHostname() {
        try {
            return String.valueOf(InetAddress.getLocalHost());
        }
        catch (UnknownHostException uhe) {
            return String.valueOf(uhe);
        }
    }

    public static String gethostOfIP(String ipPort) {
        if (null == ipPort || !IP_PORT_PATTERN.matcher(ipPort).matches()) {
            return null;
        }
        try {
            int colonIdx = ipPort.indexOf(58);
            String ip = -1 == colonIdx ? ipPort : ipPort.substring(0, ipPort.indexOf(58));
            return InetAddress.getByName(ip).getHostName();
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    public static boolean isMaster(ImmutableConfig conf) {
        String master = conf.get("pulsar.master.host", "localhost");
        return master.equals("localhost") || master.equals(NetUtil.getHostname());
    }

    public static URL getMasterURL(ImmutableConfig conf, String path) throws MalformedURLException {
        String host = conf.get("pulsar.master.host", "localhost");
        int port = conf.getInt("pulsar.master.port", 8182);
        return new URL("http", host, port, path);
    }

    public static String getMasterUrl(ImmutableConfig conf) {
        String host = conf.get("pulsar.master.host");
        int port = conf.getInt("pulsar.master.port", 8182);
        return "http://" + host + ":" + port;
    }

    public static boolean isExternalLink(String sourceUrl, String destUrl) {
        try {
            String toHost = new URL(destUrl).getHost().toLowerCase();
            String fromHost = new URL(sourceUrl).getHost().toLowerCase();
            return !toHost.equals(fromHost);
        }
        catch (MalformedURLException malformedURLException) {
            return true;
        }
    }
}

