/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common;

import ai.platon.pulsar.common.ProcessLauncher;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bJ\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lai/platon/pulsar/common/ProcessLauncher;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "launch", "Ljava/lang/Process;", "executable", "", "args", "", "waitFor", "process", "pulsar-common"})
@SourceDebugExtension(value={"SMAP\nRuntimes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Runtimes.kt\nai/platon/pulsar/common/ProcessLauncher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,229:1\n1#2:230\n*E\n"})
public final class ProcessLauncher {
    @NotNull
    public static final ProcessLauncher INSTANCE = new ProcessLauncher();
    private static final Logger log = LoggerFactory.getLogger(ProcessLauncher.class);

    private ProcessLauncher() {
    }

    @NotNull
    public final Process launch(@NotNull String executable, @NotNull List<String> args) throws IOException {
        List list2;
        Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        List $this$launch_u24lambda_u240 = list2 = (List)new ArrayList();
        boolean bl = false;
        $this$launch_u24lambda_u240.add(executable);
        $this$launch_u24lambda_u240.addAll((Collection)args);
        List command = list2;
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).command(command).redirectErrorStream(true).redirectOutput(ProcessBuilder.Redirect.PIPE);
        List<String> list3 = processBuilder.command();
        Intrinsics.checkNotNullExpressionValue(list3, (String)"command(...)");
        log.info("Launching process:\n{}", (Object)CollectionsKt.joinToString$default((Iterable)list3, (CharSequence)" ", null, null, (int)0, null, (Function1)launch.1.INSTANCE, (int)30, null));
        Process process = processBuilder.start();
        Intrinsics.checkNotNullExpressionValue((Object)process, (String)"start(...)");
        return process;
    }

    @NotNull
    public final String waitFor(@NotNull Process process) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        StringBuilder processOutput = new StringBuilder();
        Thread readLineThread = new Thread(() -> ProcessLauncher.waitFor$lambda$3(process, processOutput));
        readLineThread.start();
        try {
            readLineThread.join(Duration.ofMinutes(1L).toMillis());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        String string = processOutput.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void waitFor$lambda$3(Process $process, StringBuilder $processOutput) {
        Intrinsics.checkNotNullParameter((Object)$process, (String)"$process");
        Intrinsics.checkNotNullParameter((Object)$processOutput, (String)"$processOutput");
        Closeable closeable = new BufferedReader(new InputStreamReader($process.getInputStream()));
        Throwable throwable = null;
        try {
            BufferedReader reader = (BufferedReader)closeable;
            boolean bl = false;
            String line = null;
            while (true) {
                String string;
                String it = string = reader.readLine();
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                line = it;
                if (string == null) break;
                StringBuilder stringBuilder = $processOutput.append(line);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append(...)");
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

