/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.concurrent;

import ai.platon.pulsar.common.concurrent.ConcurrencyKt;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.time.Duration;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 )2\u00020\u0001:\u0001)B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u001fH&J\u0006\u0010!\u001a\u00020\u001fJ\u0016\u0010!\u001a\u00020\u001f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u0003J$\u0010!\u001a\u00020\u001f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u00032\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001f0$J\u0018\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J \u0010!\u001a\u00020\u001f2\u0006\u0010\u0002\u001a\u00020%2\u0006\u0010\"\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J(\u0010!\u001a\u00020\u001f2\u0006\u0010\u0002\u001a\u00020%2\u0006\u0010\"\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010#\u001a\u00020(H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\r\"\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014R\u0016\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0018\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0019X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u0006*"}, d2={"Lai/platon/pulsar/common/concurrent/GracefulScheduledExecutor;", "Ljava/lang/AutoCloseable;", "initialDelay", "Ljava/time/Duration;", "interval", "executor", "Ljava/util/concurrent/ScheduledExecutorService;", "(Ljava/time/Duration;Ljava/time/Duration;Ljava/util/concurrent/ScheduledExecutorService;)V", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getExecutor", "()Ljava/util/concurrent/ScheduledExecutorService;", "getInitialDelay", "()Ljava/time/Duration;", "setInitialDelay", "(Ljava/time/Duration;)V", "getInterval", "setInterval", "isClosed", "", "()Z", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "scheduledFuture", "Ljava/util/concurrent/ScheduledFuture;", "getScheduledFuture", "()Ljava/util/concurrent/ScheduledFuture;", "setScheduledFuture", "(Ljava/util/concurrent/ScheduledFuture;)V", "close", "", "run", "start", "period", "runnable", "Lkotlin/Function0;", "", "unit", "Ljava/util/concurrent/TimeUnit;", "Ljava/lang/Runnable;", "Companion", "pulsar-common"})
@SourceDebugExtension(value={"SMAP\nGracefulScheduledExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GracefulScheduledExecutor.kt\nai/platon/pulsar/common/concurrent/GracefulScheduledExecutor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,106:1\n1#2:107\n*E\n"})
public abstract class GracefulScheduledExecutor
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Duration initialDelay;
    @NotNull
    private Duration interval;
    @NotNull
    private final ScheduledExecutorService executor;
    private final Logger logger;
    @NotNull
    private final AtomicBoolean closed;
    @Nullable
    private ScheduledFuture<?> scheduledFuture;

    public GracefulScheduledExecutor(@NotNull Duration initialDelay, @NotNull Duration interval, @NotNull ScheduledExecutorService executor) {
        Intrinsics.checkNotNullParameter((Object)initialDelay, (String)"initialDelay");
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this.initialDelay = initialDelay;
        this.interval = interval;
        this.executor = executor;
        this.logger = LoggerFactory.getLogger(GracefulScheduledExecutor.class);
        this.closed = new AtomicBoolean();
    }

    public /* synthetic */ GracefulScheduledExecutor(Duration duration, Duration duration2, ScheduledExecutorService scheduledExecutorService, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            Duration duration3 = Duration.ofMinutes(1L);
            Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"ofMinutes(...)");
            duration = duration3;
        }
        if ((n & 2) != 0) {
            Duration duration4 = Duration.ofSeconds(10L);
            Intrinsics.checkNotNullExpressionValue((Object)duration4, (String)"ofSeconds(...)");
            duration2 = duration4;
        }
        if ((n & 4) != 0) {
            scheduledExecutorService = GracefulScheduledExecutor.Companion.createDefaultExecutor();
        }
        this(duration, duration2, scheduledExecutorService);
    }

    @NotNull
    public final Duration getInitialDelay() {
        return this.initialDelay;
    }

    public final void setInitialDelay(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"<set-?>");
        this.initialDelay = duration;
    }

    @NotNull
    public final Duration getInterval() {
        return this.interval;
    }

    public final void setInterval(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"<set-?>");
        this.interval = duration;
    }

    @NotNull
    public final ScheduledExecutorService getExecutor() {
        return this.executor;
    }

    @Nullable
    protected final ScheduledFuture<?> getScheduledFuture() {
        return this.scheduledFuture;
    }

    protected final void setScheduledFuture(@Nullable ScheduledFuture<?> scheduledFuture) {
        this.scheduledFuture = scheduledFuture;
    }

    public final boolean isClosed() {
        return this.closed.get();
    }

    public final void start(@NotNull Duration initialDelay, @NotNull Duration period, @NotNull Function0<Unit> runnable) {
        Intrinsics.checkNotNullParameter((Object)initialDelay, (String)"initialDelay");
        Intrinsics.checkNotNullParameter((Object)period, (String)"period");
        Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
        this.start(initialDelay.getSeconds(), period.getSeconds(), TimeUnit.SECONDS, () -> GracefulScheduledExecutor.start$lambda$0(runnable));
    }

    public final void start(@NotNull Duration initialDelay, @NotNull Duration period) {
        Intrinsics.checkNotNullParameter((Object)initialDelay, (String)"initialDelay");
        Intrinsics.checkNotNullParameter((Object)period, (String)"period");
        this.start(initialDelay.getSeconds(), period.getSeconds(), TimeUnit.SECONDS, () -> GracefulScheduledExecutor.start$lambda$1(this));
    }

    public void start(long period, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        this.start(period, period, unit);
    }

    public synchronized void start(long initialDelay, long period, @NotNull TimeUnit unit, @NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        if (!(this.scheduledFuture == null)) {
            boolean bl = false;
            String string = "Scheduled monitor is already started | " + this.getClass().getSimpleName();
            throw new IllegalArgumentException(string.toString());
        }
        this.scheduledFuture = this.executor.scheduleAtFixedRate(runnable, initialDelay, period, unit);
        this.logger.info("Scheduled monitor is started | {}", (Object)this.getClass().getSimpleName());
    }

    public synchronized void start(long initialDelay, long period, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        this.start(initialDelay, period, unit, () -> GracefulScheduledExecutor.start$lambda$3(this));
    }

    public final void start() {
        this.start(this.initialDelay, this.interval, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ GracefulScheduledExecutor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.run();
            }
        }));
    }

    public abstract void run();

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.logger.info("Closing scheduled monitor | " + this);
            String name = this.getClass().getSimpleName();
            Intrinsics.checkNotNull((Object)name);
            ConcurrencyKt.stopExecution(name, this.executor, (Future)this.scheduledFuture, true);
        }
    }

    private static final void start$lambda$0(Function0 $runnable) {
        Intrinsics.checkNotNullParameter((Object)$runnable, (String)"$runnable");
        $runnable.invoke();
    }

    private static final void start$lambda$1(GracefulScheduledExecutor this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.run();
    }

    private static final void start$lambda$3(GracefulScheduledExecutor this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            this$0.run();
        }
        catch (Throwable e) {
            this$0.logger.error("Exception thrown from {} report. Exception was suppressed.", (Object)this$0.getClass().getSimpleName(), (Object)e);
        }
    }

    public GracefulScheduledExecutor() {
        this(null, null, null, 7, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002\u00a8\u0006\u0005"}, d2={"Lai/platon/pulsar/common/concurrent/GracefulScheduledExecutor$Companion;", "", "()V", "createDefaultExecutor", "Ljava/util/concurrent/ScheduledExecutorService;", "pulsar-common"})
    public static final class Companion {
        private Companion() {
        }

        private final ScheduledExecutorService createDefaultExecutor() {
            ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("em-%d").build();
            Intrinsics.checkNotNullExpressionValue((Object)threadFactory, (String)"build(...)");
            ThreadFactory factory = threadFactory;
            ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor(factory);
            Intrinsics.checkNotNull((Object)service);
            return service;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

