/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common;

import ai.platon.pulsar.common.DirectoryExtractor;
import ai.platon.pulsar.common.UrlExtractor;
import java.io.BufferedReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\"\n\u0000\b\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Lai/platon/pulsar/common/DirectoryExtractor;", "Lai/platon/pulsar/common/UrlExtractor;", "baseDir", "Ljava/nio/file/Path;", "filter", "Lkotlin/Function1;", "", "", "(Ljava/nio/file/Path;Lkotlin/jvm/functions/Function1;)V", "getBaseDir", "()Ljava/nio/file/Path;", "getFilter", "()Lkotlin/jvm/functions/Function1;", "extract", "", "pulsar-common"})
public final class DirectoryExtractor
extends UrlExtractor {
    @NotNull
    private final Path baseDir;
    @NotNull
    private final Function1<String, Boolean> filter;

    public DirectoryExtractor(@NotNull Path baseDir, @NotNull Function1<? super String, Boolean> filter) {
        Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        this.baseDir = baseDir;
        this.filter = filter;
    }

    public /* synthetic */ DirectoryExtractor(Path path, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function1 = 1.INSTANCE;
        }
        this(path, (Function1<? super String, Boolean>)function1);
    }

    @NotNull
    public final Path getBaseDir() {
        return this.baseDir;
    }

    @NotNull
    public final Function1<String, Boolean> getFilter() {
        return this.filter;
    }

    @NotNull
    public final Set<String> extract() {
        if (!Files.exists(this.baseDir, new LinkOption[0])) {
            return SetsKt.emptySet();
        }
        Set urls = new LinkedHashSet();
        Files.list(this.baseDir).filter(arg_0 -> DirectoryExtractor.extract$lambda$0(extract.1.INSTANCE, arg_0)).forEach(arg_0 -> DirectoryExtractor.extract$lambda$1((Function1)new Function1<Path, Unit>(this, (Set<String>)urls){
            final /* synthetic */ DirectoryExtractor this$0;
            final /* synthetic */ Set<String> $urls;
            {
                this.this$0 = $receiver;
                this.$urls = $urls;
                super(1);
            }

            public final void invoke(Path path) {
                BufferedReader bufferedReader = Files.newBufferedReader(path);
                Intrinsics.checkNotNullExpressionValue((Object)bufferedReader, (String)"newBufferedReader(...)");
                TextStreamsKt.forEachLine((Reader)bufferedReader, (Function1)((Function1)new Function1<String, Unit>(this.this$0, this.$urls){
                    final /* synthetic */ DirectoryExtractor this$0;
                    final /* synthetic */ Set<String> $urls;
                    {
                        this.this$0 = $receiver;
                        this.$urls = $urls;
                        super(1);
                    }

                    public final void invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        this.this$0.extractTo(it, this.$urls, this.this$0.getFilter());
                    }
                }));
            }
        }, arg_0));
        return urls;
    }

    private static final boolean extract$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void extract$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

