/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.math.geometric;

import ai.platon.pulsar.common.math.geometric.GeometricsKt;
import java.awt.Rectangle;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006J4\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\n2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a8\u0006\u000e"}, d2={"Lai/platon/pulsar/common/math/geometric/GeometricUtils;", "", "()V", "findMaxRectangle", "Ljava/awt/Rectangle;", "rectangles", "", "isEmpty", "", "x1", "", "x2", "y1", "y2", "pulsar-common"})
public final class GeometricUtils {
    @NotNull
    public static final GeometricUtils INSTANCE = new GeometricUtils();

    private GeometricUtils() {
    }

    @Nullable
    public final Rectangle findMaxRectangle(@NotNull List<? extends Rectangle> rectangles) {
        Intrinsics.checkNotNullParameter(rectangles, (String)"rectangles");
        Set xCoords = new LinkedHashSet();
        Set yCoords = new LinkedHashSet();
        for (Rectangle rectangle : rectangles) {
            xCoords.add(rectangle.x);
            xCoords.add(GeometricsKt.getX2(rectangle));
            yCoords.add(rectangle.y);
            yCoords.add(GeometricsKt.getY2(rectangle));
        }
        List xSorted = CollectionsKt.sorted((Iterable)xCoords);
        List list2 = CollectionsKt.sorted((Iterable)yCoords);
        int maxArea = 0;
        Rectangle maxRect = null;
        int n = xSorted.size() - 1;
        for (int i = 0; i < n; ++i) {
            int n2 = list2.size() - 1;
            for (int j = 0; j < n2; ++j) {
                int area;
                int y2;
                int y1;
                int x2;
                int x1 = ((Number)xSorted.get(i)).intValue();
                if (!this.isEmpty(x1, x2 = ((Number)xSorted.get(i + 1)).intValue(), y1 = ((Number)list2.get(j)).intValue(), y2 = ((Number)list2.get(j + 1)).intValue(), rectangles) || (area = (x2 - x1) * (y2 - y1)) <= maxArea) continue;
                maxArea = area;
                maxRect = new Rectangle(x1, x2, y1, y2);
            }
        }
        return maxRect;
    }

    public final boolean isEmpty(int x1, int x2, int y1, int y2, @NotNull List<? extends Rectangle> rectangles) {
        Intrinsics.checkNotNullParameter(rectangles, (String)"rectangles");
        for (Rectangle rectangle : rectangles) {
            if (x2 <= rectangle.x || x1 >= GeometricsKt.getX2(rectangle) || y2 <= rectangle.y || y1 >= GeometricsKt.getY2(rectangle)) continue;
            return false;
        }
        return true;
    }
}

